/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.misc;

import java.util.Comparator;
import java.util.Optional;
import lotr.common.data.AlignmentDataModule;
import lotr.common.fac.AlignmentBonus;
import lotr.common.fac.AlignmentBonusMap;
import lotr.common.fac.Faction;
import lotr.common.init.LOTREntities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;

public class AlignmentBonusEntity
extends Entity {
    private AlignmentBonus bonusSource;
    private Faction mainFaction;
    private float prevMainAlignment;
    private AlignmentBonusMap factionBonusMap;
    private float conquestBonus;
    private int particleAge = 0;
    private int particlePrevAge = 0;
    private int particleMaxAge;

    public AlignmentBonusEntity(EntityType<? extends AlignmentBonusEntity> type, World w) {
        super(type, w);
    }

    public static int getNextSafeEntityIdForBonusSpawn(ServerWorld world) {
        AlignmentBonusEntity entity = new AlignmentBonusEntity((EntityType<? extends AlignmentBonusEntity>)((EntityType)LOTREntities.ALIGNMENT_BONUS.get()), (World)world);
        return entity.func_145782_y();
    }

    public static AlignmentBonusEntity createBonusEntityForClientSpawn(World world, int entityId, AlignmentBonus bonusSource, Faction mainFaction, float prevMainAlignment, AlignmentBonusMap factionBonusMap, float conquestBonus, Vector3d pos) {
        if (!world.field_72995_K) {
            throw new IllegalArgumentException("Alignment bonus entities cannot be spawned on the server side!");
        }
        AlignmentBonusEntity entity = new AlignmentBonusEntity((EntityType<? extends AlignmentBonusEntity>)((EntityType)LOTREntities.ALIGNMENT_BONUS.get()), world);
        entity.func_145769_d(entityId);
        entity.bonusSource = bonusSource;
        entity.mainFaction = mainFaction;
        entity.prevMainAlignment = prevMainAlignment;
        entity.factionBonusMap = factionBonusMap;
        entity.conquestBonus = conquestBonus;
        entity.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        entity.calcMaxAge();
        return entity;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private void calcMaxAge() {
        float mostSignificantBonus = 0.0f;
        for (Faction fac : this.factionBonusMap.getChangedFactions()) {
            float bonus = Math.abs(((Float)this.factionBonusMap.get(fac)).floatValue());
            if (!(bonus > mostSignificantBonus)) continue;
            mostSignificantBonus = bonus;
        }
        float conq = Math.abs(this.conquestBonus);
        if (conq > mostSignificantBonus) {
            mostSignificantBonus = conq;
        }
        this.particleMaxAge = 80;
        int extra = (int)(Math.min(1.0f, mostSignificantBonus / 50.0f) * 220.0f);
        this.particleMaxAge += extra;
    }

    public boolean shouldDisplayConquestBonus(AlignmentDataModule alignData) {
        Faction currentViewedFaction = alignData.getCurrentViewedFaction();
        if (this.conquestBonus > 0.0f && alignData.isPledgedTo(currentViewedFaction)) {
            return true;
        }
        return this.conquestBonus < 0.0f && (currentViewedFaction == this.mainFaction || alignData.isPledgedTo(currentViewedFaction));
    }

    public Faction getFactionToDisplay(AlignmentDataModule alignData) {
        if (!this.factionBonusMap.isEmpty()) {
            Faction currentViewedFaction = alignData.getCurrentViewedFaction();
            if (this.factionBonusMap.containsKey(currentViewedFaction)) {
                return currentViewedFaction;
            }
            if (this.factionBonusMap.size() == 1 && this.mainFaction.isPlayableAlignmentFaction()) {
                return this.mainFaction;
            }
            if (this.mainFaction.isPlayableAlignmentFaction() && this.prevMainAlignment >= 0.0f && ((Float)this.factionBonusMap.get(this.mainFaction)).floatValue() < 0.0f) {
                return this.mainFaction;
            }
            Optional<Faction> highestFactionWithBonus = this.factionBonusMap.keySet().stream().filter(Faction::isPlayableAlignmentFaction).filter(fac -> ((Float)this.factionBonusMap.get(fac)).floatValue() > 0.0f).sorted(Comparator.comparingDouble(fac -> alignData.getAlignment((Faction)fac)).reversed()).findFirst();
            if (highestFactionWithBonus.isPresent()) {
                return highestFactionWithBonus.get();
            }
            if (this.mainFaction.isPlayableAlignmentFaction() && ((Float)this.factionBonusMap.get(this.mainFaction)).floatValue() < 0.0f) {
                return this.mainFaction;
            }
            Optional<Faction> highestFactionWithPenalty = this.factionBonusMap.keySet().stream().filter(Faction::isPlayableAlignmentFaction).filter(fac -> ((Float)this.factionBonusMap.get(fac)).floatValue() < 0.0f).sorted(Comparator.comparingDouble(fac -> alignData.getAlignment((Faction)fac)).reversed()).findFirst();
            if (highestFactionWithPenalty.isPresent()) {
                return highestFactionWithPenalty.get();
            }
        }
        return null;
    }

    public float getAlignmentBonusFor(Faction faction) {
        return this.factionBonusMap.getOrDefault(faction, Float.valueOf(0.0f)).floatValue();
    }

    public float getConquestBonus() {
        return this.conquestBonus;
    }

    public ITextComponent getBonusDisplayText() {
        return this.bonusSource.name;
    }

    public boolean shouldShowBonusText(boolean showAlign, boolean showConquest) {
        return showAlign || showConquest && !this.bonusSource.isKillByHiredUnit;
    }

    public float getBonusAgeF(float f) {
        return ((float)this.particlePrevAge + (float)(this.particleAge - this.particlePrevAge) * f) / (float)this.particleMaxAge;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT nbt) {
    }

    protected void func_213281_b(CompoundNBT nbt) {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.particlePrevAge = this.particleAge++;
        if (this.particleAge >= this.particleMaxAge) {
            this.func_241204_bJ_();
        }
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_190530_aW() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }
}

