/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.entity.npc.NPCEntity;
import lotr.common.entity.npc.ai.AttackGoalsHolder;
import lotr.common.entity.npc.ai.StandardAttackModeUpdaters;
import lotr.common.entity.npc.ai.goal.FriendlyNPCConversationGoal;
import lotr.common.entity.npc.ai.goal.NPCDrinkGoal;
import lotr.common.entity.npc.ai.goal.NPCEatGoal;
import lotr.common.entity.npc.ai.goal.NPCMeleeAttackGoal;
import lotr.common.entity.npc.ai.goal.NPCRangedAttackGoal;
import lotr.common.entity.npc.ai.goal.StargazingGoal;
import lotr.common.entity.npc.ai.goal.TalkToCurrentGoal;
import lotr.common.entity.npc.ai.goal.WatchSunriseSunsetGoal;
import lotr.common.entity.npc.data.NPCFoodPool;
import lotr.common.entity.npc.data.NPCFoodPools;
import lotr.common.init.LOTRAttributes;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.World;

public abstract class ElfEntity
extends NPCEntity {
    public ElfEntity(EntityType<? extends ElfEntity> type, World w) {
        super(type, w);
        this.getNPCCombatUpdater().setAttackModeUpdater(StandardAttackModeUpdaters.meleeRangedSwitching());
        this.spawnRequiresSurfaceBlock = true;
    }

    public static AttributeModifierMap.MutableAttribute regAttrs() {
        return NPCEntity.registerBaseNPCAttributes().func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233821_d_, 0.2).func_233815_a_((Attribute)LOTRAttributes.NPC_RANGED_INACCURACY.get(), 0.5);
    }

    @Override
    protected void addNPCAI() {
        super.addNPCAI();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.addAttackGoal(2);
        this.field_70714_bg.func_75776_a(4, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new TalkToCurrentGoal(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new FriendlyNPCConversationGoal(this, 0.001f));
        this.field_70714_bg.func_75776_a(7, (Goal)new WatchSunriseSunsetGoal((MobEntity)this, 0.01f));
        this.field_70714_bg.func_75776_a(8, (Goal)new StargazingGoal((MobEntity)this, 4.0E-4f));
        this.field_70714_bg.func_75776_a(9, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(10, (Goal)new NPCEatGoal(this, this.getEatPool(), 12000));
        this.field_70714_bg.func_75776_a(10, (Goal)new NPCDrinkGoal(this, this.getDrinkPool(), 8000));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookAtGoal((MobEntity)this, NPCEntity.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(12, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(13, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    @Override
    protected void initialiseAttackGoals(AttackGoalsHolder holder) {
        holder.setMeleeAttackGoal(this.createElfMeleeAttackGoal());
        holder.setRangedAttackGoal(this.createElfRangedAttackGoal());
    }

    protected Goal createElfRangedAttackGoal() {
        return new NPCRangedAttackGoal<ElfEntity>(this, 1.25, 20, 16.0f);
    }

    protected Goal createElfMeleeAttackGoal() {
        return new NPCMeleeAttackGoal(this, 1.4);
    }

    @Override
    protected void addNPCTargetingAI() {
        this.addAggressiveTargetingGoals();
    }

    protected NPCFoodPool getEatPool() {
        return NPCFoodPools.ELF;
    }

    protected NPCFoodPool getDrinkPool() {
        return NPCFoodPools.ELF_DRINK;
    }
}

