/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import java.util.function.BiPredicate;
import java.util.function.Predicate;
import lotr.common.data.LOTRLevelData;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.fac.AlignmentPredicate;
import lotr.common.fac.AlignmentPredicates;
import lotr.common.fac.EntityFactionHelper;
import lotr.common.fac.Faction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;

public class NPCPredicates {
    public static Predicate<LivingEntity> selectByFaction(Faction fac) {
        return entity -> entity.func_70089_S() && EntityFactionHelper.getFaction((Entity)entity) == fac;
    }

    public static Predicate<LivingEntity> selectForLocalAreaOfInfluence(Faction fac) {
        return NPCPredicates.selectByFaction(fac).and(entity -> {
            if (entity instanceof NPCEntity) {
                return ((NPCEntity)((Object)entity)).generatesLocalAreaOfInfluence();
            }
            return true;
        });
    }

    public static Predicate<MobEntity> selectAngerableByKill(Faction killedFaction, LivingEntity killerResponsible) {
        return entity -> entity.func_70089_S() && EntityFactionHelper.getFaction((Entity)entity).isGoodRelation(killedFaction);
    }

    public static Predicate<LivingEntity> selectFriends(NPCEntity theEntity) {
        return NPCPredicates.selectPlayersOrOthers(theEntity, AlignmentPredicates.POSITIVE, Faction::isGoodRelation).and(e -> e != theEntity.func_70638_az());
    }

    public static Predicate<LivingEntity> selectFoes(NPCEntity theEntity) {
        return NPCPredicates.selectPlayersOrOthers(theEntity, AlignmentPredicates.NEGATIVE, Faction::isBadRelation).or(e -> e == theEntity.func_70638_az());
    }

    private static Predicate<LivingEntity> selectPlayersOrOthers(NPCEntity theEntity, AlignmentPredicate playerTest, BiPredicate<Faction, Faction> npcFactionTest) {
        Faction entityFaction = EntityFactionHelper.getFaction((Entity)theEntity);
        return otherEntity -> {
            if (otherEntity != theEntity && otherEntity.func_70089_S()) {
                if (otherEntity instanceof PlayerEntity) {
                    PlayerEntity player = (PlayerEntity)otherEntity;
                    return LOTRLevelData.getSidedData(player).getAlignmentData().hasAlignment(entityFaction, playerTest);
                }
                Faction otherFaction = EntityFactionHelper.getFaction((Entity)otherEntity);
                return npcFactionTest.test(otherFaction, entityFaction);
            }
            return false;
        };
    }
}

