/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.entity.npc.NPCEntity;
import lotr.common.entity.npc.ai.AttackGoalsHolder;
import lotr.common.entity.npc.ai.StandardAttackModeUpdaters;
import lotr.common.entity.npc.ai.goal.FriendlyNPCConversationGoal;
import lotr.common.entity.npc.ai.goal.NPCDrinkGoal;
import lotr.common.entity.npc.ai.goal.NPCEatGoal;
import lotr.common.entity.npc.ai.goal.TalkToCurrentGoal;
import lotr.common.entity.npc.data.NPCFoodPools;
import lotr.common.entity.npc.data.NPCNameGenerator;
import lotr.common.entity.npc.data.NPCNameGenerators;
import lotr.common.init.LOTRSoundEvents;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public abstract class OrcEntity
extends NPCEntity {
    public OrcEntity(EntityType<? extends OrcEntity> type, World w) {
        super(type, w);
        this.getNPCCombatUpdater().setAttackModeUpdater(StandardAttackModeUpdaters.meleeOnlyOrcWithBomb());
        this.spawnRequiresDarkness = true;
    }

    @Override
    protected NPCNameGenerator getNameGenerator() {
        return NPCNameGenerators.ORC;
    }

    public static AttributeModifierMap.MutableAttribute regAttrs() {
        return NPCEntity.registerBaseNPCAttributes().func_233815_a_(Attributes.field_233818_a_, 18.0).func_233815_a_(Attributes.field_233821_d_, 0.2);
    }

    @Override
    protected void addNPCAI() {
        super.addNPCAI();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.addAttackGoal(4);
        this.field_70714_bg.func_75776_a(6, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(7, (Goal)new TalkToCurrentGoal(this));
        this.field_70714_bg.func_75776_a(8, (Goal)new FriendlyNPCConversationGoal(this, 2.0E-4f));
        this.field_70714_bg.func_75776_a(9, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(10, (Goal)new NPCEatGoal(this, NPCFoodPools.ORC, 6000));
        this.field_70714_bg.func_75776_a(10, (Goal)new NPCDrinkGoal(this, NPCFoodPools.ORC_DRINK, 6000));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f, 0.05f));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookAtGoal((MobEntity)this, NPCEntity.class, 5.0f, 0.05f));
        this.field_70714_bg.func_75776_a(12, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(13, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    @Override
    protected void initialiseAttackGoals(AttackGoalsHolder holder) {
        holder.setMeleeAttackGoal(this.createOrcAttackGoal());
    }

    protected abstract Goal createOrcAttackGoal();

    @Override
    protected void addNPCTargetingAI() {
        int target = this.addAggressiveTargetingGoals();
    }

    protected SoundEvent func_184639_G() {
        return LOTRSoundEvents.ORC_AEUGH;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return LOTRSoundEvents.ORC_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return LOTRSoundEvents.ORC_DEATH;
    }
}

