/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.entity.npc.ManEntity;
import lotr.common.entity.npc.SpawnEquipmentTable;
import lotr.common.entity.npc.ai.goal.NPCMeleeAttackGoal;
import lotr.common.entity.npc.data.NPCFoodPool;
import lotr.common.entity.npc.data.NPCFoodPools;
import lotr.common.entity.npc.data.NPCNameGenerator;
import lotr.common.entity.npc.data.NPCNameGenerators;
import lotr.common.init.LOTRItems;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class UmbarManEntity
extends ManEntity {
    private static final SpawnEquipmentTable WEAPONS = SpawnEquipmentTable.of(LOTRItems.UMBAR_DAGGER);

    public UmbarManEntity(EntityType<? extends UmbarManEntity> type, World w) {
        super((EntityType<? extends ManEntity>)type, w);
    }

    @Override
    protected NPCNameGenerator getNameGenerator() {
        return NPCNameGenerators.UMBAR;
    }

    @Override
    protected ITextComponent formatNPCName(ITextComponent npcName, ITextComponent typeName) {
        return new TranslationTextComponent("entityname.lotr.umbar_man", new Object[]{npcName, typeName});
    }

    @Override
    protected Goal createAttackGoal() {
        return new NPCMeleeAttackGoal(this, 1.5);
    }

    @Override
    protected void addNPCTargetingAI() {
        this.addNonAggressiveTargetingGoals();
    }

    @Override
    protected NPCFoodPool getEatPool() {
        return NPCFoodPools.COAST_SOUTHRON;
    }

    @Override
    protected NPCFoodPool getDrinkPool() {
        return NPCFoodPools.COAST_SOUTHRON_DRINK;
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld sw, DifficultyInstance diff, SpawnReason reason, ILivingEntityData spawnData, CompoundNBT dataTag) {
        spawnData = super.func_213386_a(sw, diff, reason, spawnData, dataTag);
        this.npcItemsInv.setMeleeWeapon(WEAPONS.getRandomItem(this.field_70146_Z));
        this.npcItemsInv.clearIdleItem();
        return spawnData;
    }
}

