/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc.ai;

import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.init.LOTRParticles;
import lotr.common.network.LOTRPacketHandler;
import lotr.common.network.SPacketNPCTalkAnimations;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class NPCTalkAnimations {
    private final NPCEntity npc;
    private boolean isTalking;
    private TalkAction talkAction;
    private float actionSlow;
    private int actionTime;
    private boolean doGestureMain;
    private boolean doGestureOff;
    private int timeUntilGesture;
    private int actionTick = 0;
    private int totalTalkingTime = 0;
    private float headYaw;
    private float headPitch;
    private float prevHeadYaw;
    private float prevHeadPitch;
    private int gestureMainTime;
    private int gestureMainTick;
    private int prevGestureMainTick;
    private int gestureOffTime;
    private int gestureOffTick;
    private int prevGestureOffTick;
    private int timeSinceParticle = 0;
    private boolean spawnedFirstParticle;
    private boolean sendData = true;

    public NPCTalkAnimations(NPCEntity npc) {
        this.npc = npc;
    }

    public void startTalking() {
        this.isTalking = true;
        this.talkAction = null;
        this.totalTalkingTime = 0;
        this.timeUntilGesture = this.getRandomTimeUntilGesture();
        this.markDirty();
    }

    public void stopTalking() {
        this.isTalking = false;
        this.talkAction = null;
        this.totalTalkingTime = 0;
        this.timeUntilGesture = 0;
        this.markDirty();
    }

    private int getRandomTimeUntilGesture() {
        return 20 + this.npc.func_70681_au().nextInt(180);
    }

    public float getHeadYawRadians(float f) {
        return this.prevHeadYaw + (this.headYaw - this.prevHeadYaw) * f;
    }

    public float getHeadPitchRadians(float f) {
        return this.prevHeadPitch + (this.headPitch - this.prevHeadPitch) * f;
    }

    private void startClientGestureMain() {
        if (this.gestureMainTime <= 0) {
            this.gestureMainTime = this.getRandomGestureDuration();
        }
    }

    private void startClientGestureOff() {
        if (this.gestureOffTime <= 0) {
            this.gestureOffTime = this.getRandomGestureDuration();
        }
    }

    private void startClientGestureBoth() {
        if (this.gestureMainTime <= 0 && this.gestureOffTime <= 0) {
            this.gestureMainTime = this.gestureOffTime = this.getRandomGestureDuration();
        } else {
            this.startClientGestureMain();
            this.startClientGestureOff();
        }
    }

    private final int getRandomGestureDuration() {
        return 10 + this.npc.func_70681_au().nextInt(30);
    }

    public float getMainhandGestureAmount(float f) {
        if (this.gestureMainTime > 0) {
            float gesture = (float)this.prevGestureMainTick + (float)(this.gestureMainTick - this.prevGestureMainTick) * f;
            return MathHelper.func_76126_a((float)(gesture / (float)this.gestureMainTime * (float)Math.PI));
        }
        return 0.0f;
    }

    public float getOffhandGestureAmount(float f) {
        if (this.gestureOffTime > 0) {
            float gesture = (float)this.prevGestureOffTick + (float)(this.gestureOffTick - this.prevGestureOffTick) * f;
            return MathHelper.func_76126_a((float)(gesture / (float)this.gestureOffTime * (float)Math.PI));
        }
        return 0.0f;
    }

    public void updateAnimation() {
        this.npc.field_70170_p.func_217381_Z().func_76320_a("NPCTalkAnimations#updateAnimation");
        Random rand = this.npc.func_70681_au();
        if (!this.npc.field_70170_p.field_72995_K) {
            if (this.isTalking) {
                ++this.totalTalkingTime;
                if (this.talkAction == null) {
                    if (this.totalTalkingTime < 10 || rand.nextInt(30) == 0) {
                        this.talkAction = TalkAction.getRandomAction(rand);
                        if (this.talkAction == TalkAction.TALKING) {
                            this.actionTime = 40 + rand.nextInt(60);
                            this.actionSlow = 1.0f;
                        } else if (this.talkAction == TalkAction.LOOKING_AROUND) {
                            this.actionTime = 60 + rand.nextInt(60);
                            this.actionSlow = 1.0f;
                        } else if (this.talkAction == TalkAction.SHAKING_HEAD) {
                            this.actionTime = 100 + rand.nextInt(60);
                            this.actionSlow = 1.0f;
                        } else if (this.talkAction == TalkAction.LOOKING_UP) {
                            this.actionTime = 30 + rand.nextInt(50);
                            this.actionSlow = 1.0f;
                        }
                        this.markDirty();
                    }
                } else {
                    ++this.actionTick;
                }
                if (this.talkAction != null) {
                    if (this.actionTick >= this.actionTime) {
                        this.talkAction = null;
                        this.actionTick = 0;
                        this.actionTime = 0;
                        this.markDirty();
                    } else if (this.talkAction == TalkAction.TALKING && this.actionTick % 20 == 0) {
                        this.actionSlow = 0.7f + rand.nextFloat() * 1.5f;
                        this.markDirty();
                    }
                }
                --this.timeUntilGesture;
                if (this.timeUntilGesture <= 0) {
                    if (rand.nextFloat() < 0.1f) {
                        this.doGestureOff = true;
                        this.doGestureMain = true;
                    } else if (rand.nextInt(3) == 0) {
                        this.doGestureOff = true;
                    } else {
                        this.doGestureMain = true;
                    }
                    this.timeUntilGesture = this.getRandomTimeUntilGesture();
                    this.markDirty();
                }
            } else {
                this.totalTalkingTime = 0;
                this.timeUntilGesture = 0;
            }
            if (this.sendData) {
                this.sendDataToAllWatchers();
                this.sendData = false;
                this.doGestureOff = false;
                this.doGestureMain = false;
            }
        } else {
            this.prevHeadYaw = this.headYaw;
            this.prevHeadPitch = this.headPitch;
            if (this.isTalking) {
                ++this.totalTalkingTime;
                if (this.talkAction != null) {
                    ++this.actionTick;
                    if (this.talkAction == TalkAction.TALKING) {
                        float slow = this.actionSlow * 2.0f;
                        this.headYaw = MathHelper.func_76126_a((float)((float)this.actionTick / slow)) * (float)Math.toRadians(10.0);
                        this.headPitch = (MathHelper.func_76126_a((float)((float)this.actionTick / slow * 2.0f)) + 1.0f) / 2.0f * (float)Math.toRadians(-20.0);
                    } else if (this.talkAction == TalkAction.SHAKING_HEAD) {
                        this.actionSlow += 0.01f;
                        this.headYaw = MathHelper.func_76126_a((float)((float)this.actionTick / this.actionSlow)) * (float)Math.toRadians(30.0);
                        this.headPitch += (float)Math.toRadians(0.4);
                    } else if (this.talkAction == TalkAction.LOOKING_AROUND) {
                        float slow = this.actionSlow * 16.0f;
                        this.headYaw = MathHelper.func_76126_a((float)((float)this.actionTick / slow)) * (float)Math.toRadians(50.0);
                        this.headPitch = (MathHelper.func_76126_a((float)((float)this.actionTick / slow * 2.0f)) + 1.0f) / 2.0f * (float)Math.toRadians(-15.0);
                    } else if (this.talkAction == TalkAction.LOOKING_UP) {
                        this.headYaw = 0.0f;
                        this.headPitch = (float)Math.toRadians(-20.0);
                    }
                } else {
                    this.actionTick = 0;
                    this.headYaw = 0.0f;
                    this.headPitch = MathHelper.func_76126_a((float)((float)this.totalTalkingTime * 0.07f)) * (float)Math.toRadians(5.0);
                }
            } else {
                this.headPitch = 0.0f;
                this.headYaw = 0.0f;
                this.actionTick = 0;
                this.totalTalkingTime = 0;
            }
            this.prevGestureMainTick = this.gestureMainTick++;
            this.prevGestureOffTick = this.gestureOffTick;
            if (this.gestureMainTime > 0 && this.prevGestureMainTick >= this.gestureMainTime) {
                this.gestureMainTick = 0;
                this.prevGestureMainTick = 0;
                this.gestureMainTime = 0;
            }
            if (this.gestureOffTime > 0) {
                ++this.gestureOffTick;
                if (this.prevGestureOffTick > this.gestureOffTime) {
                    this.gestureOffTick = 0;
                    this.prevGestureOffTick = 0;
                    this.gestureOffTime = 0;
                }
            }
            if (this.isTalking) {
                ++this.timeSinceParticle;
                if (!this.spawnedFirstParticle && this.timeSinceParticle > 20 || this.timeSinceParticle > 30 + rand.nextInt(150)) {
                    this.spawnParticle(rand);
                    this.timeSinceParticle = 0;
                    this.spawnedFirstParticle = true;
                }
            } else {
                this.timeSinceParticle = 0;
                this.spawnedFirstParticle = false;
            }
        }
        this.npc.field_70170_p.func_217381_Z().func_76319_b();
    }

    private void markDirty() {
        if (!this.npc.field_70170_p.field_72995_K) {
            this.sendData = true;
        }
    }

    public void sendData(ServerPlayerEntity player) {
        SPacketNPCTalkAnimations packet = new SPacketNPCTalkAnimations(this);
        LOTRPacketHandler.sendTo(packet, player);
    }

    private void sendDataToAllWatchers() {
        SPacketNPCTalkAnimations packet = new SPacketNPCTalkAnimations(this);
        LOTRPacketHandler.sendToAllTrackingEntity(packet, (Entity)this.npc);
    }

    public void write(PacketBuffer buf) {
        buf.func_150787_b(this.npc.func_145782_y());
        buf.writeBoolean(this.isTalking);
        buf.writeByte(this.talkAction != null ? this.talkAction.ordinal() : -1);
        buf.writeFloat(this.actionSlow);
        buf.writeBoolean(this.doGestureMain);
        buf.writeBoolean(this.doGestureOff);
    }

    public static void read(PacketBuffer buf, World world) {
        int entityId = buf.func_150792_a();
        Entity entity = world.func_73045_a(entityId);
        if (entity instanceof NPCEntity) {
            NPCEntity npc = (NPCEntity)entity;
            NPCTalkAnimations talkAnim = npc.getTalkAnimations();
            talkAnim.isTalking = buf.readBoolean();
            byte actionId = buf.readByte();
            talkAnim.talkAction = actionId >= 0 ? TalkAction.forId(actionId) : null;
            talkAnim.actionSlow = buf.readFloat();
            boolean doGestureMain = buf.readBoolean();
            boolean doGestureOff = buf.readBoolean();
            if (doGestureMain && doGestureOff) {
                talkAnim.startClientGestureBoth();
            } else {
                if (doGestureMain) {
                    talkAnim.startClientGestureMain();
                }
                if (doGestureOff) {
                    talkAnim.startClientGestureOff();
                }
            }
        }
    }

    private void spawnParticle(Random rand) {
        Vector3d eyePos = this.npc.func_174824_e(1.0f);
        Vector3d look = this.npc.func_70676_i(1.0f);
        double dx = look.func_82615_a() - eyePos.func_82615_a();
        double dz = look.func_82616_c() - eyePos.func_82616_c();
        float sideFovAngle = (float)Math.toRadians(MathHelper.func_82716_a((Random)rand, (double)45.0, (double)90.0) * (double)(rand.nextBoolean() ? -1 : 1));
        Vector3d sideLook = look.func_178785_b(sideFovAngle);
        double nx = sideLook.field_72450_a;
        double nz = sideLook.field_72449_c;
        double r = MathHelper.func_82716_a((Random)rand, (double)0.25, (double)0.5);
        double px = eyePos.func_82615_a() + r * nx;
        double py = eyePos.func_82617_b() + MathHelper.func_82716_a((Random)rand, (double)-0.2, (double)0.2);
        double pz = eyePos.func_82616_c() + r * nz;
        this.npc.field_70170_p.func_195594_a(this.getSpeechParticle(rand), px, py, pz, nx * 0.03, 0.05, nz * 0.03);
    }

    private IParticleData getSpeechParticle(Random rand) {
        float f = rand.nextFloat();
        if (f < 0.1f) {
            return (IParticleData)LOTRParticles.NPC_QUESTION.get();
        }
        if (f < 0.2f) {
            return (IParticleData)LOTRParticles.NPC_EXCLAMATION.get();
        }
        return (IParticleData)LOTRParticles.NPC_SPEECH.get();
    }

    public static enum TalkAction {
        TALKING(1.0f),
        SHAKING_HEAD(0.1f),
        LOOKING_AROUND(0.3f),
        LOOKING_UP(0.4f);

        private final float weight;
        private static final float totalWeight;

        private TalkAction(float w) {
            this.weight = w;
        }

        public static TalkAction getRandomAction(Random rand) {
            float f = rand.nextFloat() * totalWeight;
            TalkAction chosen = null;
            for (TalkAction action : TalkAction.values()) {
                if (!((f -= action.weight) <= 0.0f)) continue;
                chosen = action;
                break;
            }
            return chosen;
        }

        public static TalkAction forId(int i) {
            return TalkAction.values()[MathHelper.func_76125_a((int)i, (int)0, (int)(TalkAction.values().length - 1))];
        }

        static {
            totalWeight = (float)Stream.of(TalkAction.values()).collect(Collectors.summingDouble(action -> action.weight)).doubleValue();
        }
    }
}

