/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc.ai;

import java.util.function.Predicate;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.fac.EntityFactionHelper;
import lotr.common.fac.Faction;
import lotr.common.fac.FactionPointers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;

public class NPCTargetSelector
implements Predicate<LivingEntity> {
    private NPCEntity owner;

    public NPCTargetSelector(NPCEntity entity) {
        this.owner = entity;
    }

    @Override
    public boolean test(LivingEntity target) {
        Faction ownerFaction = this.owner.getFaction();
        if (FactionPointers.HOSTILE.matches(ownerFaction) && (target.getClass().isAssignableFrom(((Object)((Object)this.owner)).getClass()) || ((Object)((Object)this.owner)).getClass().isAssignableFrom(target.getClass()))) {
            return false;
        }
        if (target.func_70089_S()) {
            if (target instanceof NPCEntity && !((NPCEntity)target).canBeFreelyTargetedBy((LivingEntity)this.owner)) {
                return false;
            }
            if (!ownerFaction.approvesCivilianKills() && target instanceof NPCEntity && ((NPCEntity)target).isCivilianNPC()) {
                return false;
            }
            Faction targetFaction = EntityFactionHelper.getFaction((Entity)target);
            if (ownerFaction.isBadRelation(targetFaction)) {
                return true;
            }
            if (ownerFaction.isNeutral(targetFaction)) {
                // empty if block
            }
        }
        return false;
    }
}

