/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc.ai.goal;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Stream;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.entity.npc.NPCPredicates;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;

public class NPCMeleeAttackGoal
extends Goal {
    private final NPCEntity theEntity;
    private final World world;
    private final Random rand;
    private final double speedTowardsTarget;
    private final boolean longMemory;
    private Path initialPath;
    private int rePathDelay;
    private long lastCheckTime;
    private int weaponAccountedSwingCooldown;
    private MeleeMode meleeMode;
    private int decideMeleeModeTimer = 0;
    private static final int MELEE_MODE_DECISION_INTERVAL = 5;
    private int timeSinceDifferentMeleeMode = 0;
    private float cachedFriendsToFoesRatio;
    private long lastFriendsToFoesCacheTime = 0L;
    private int ongoingShieldingTime = 0;
    private int timeUntilCanShield = 0;
    private static final UUID DEFENDING_CLOSE_HALT_ID = UUID.fromString("c95298e0-93a9-4965-9189-52c9c151fb33");
    private static final AttributeModifier DEFENDING_CLOSE_HALT = new AttributeModifier(DEFENDING_CLOSE_HALT_ID, "Halt when defending close", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);

    public NPCMeleeAttackGoal(NPCEntity entity, double speed) {
        this(entity, speed, true);
    }

    private NPCMeleeAttackGoal(NPCEntity entity, double speed, boolean longMem) {
        this.theEntity = entity;
        this.world = this.theEntity.field_70170_p;
        this.rand = this.theEntity.func_70681_au();
        this.speedTowardsTarget = speed;
        this.longMemory = longMem;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        long time = this.theEntity.field_70170_p.func_82737_E();
        if (time - this.lastCheckTime < 20L) {
            return false;
        }
        this.lastCheckTime = time;
        LivingEntity target = this.theEntity.func_70638_az();
        if (target == null || !target.func_70089_S()) {
            return false;
        }
        this.initialPath = this.theEntity.func_70661_as().func_75494_a((Entity)target, 0);
        return this.initialPath != null || this.getAttackReachSq(target) >= this.theEntity.func_70092_e(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
    }

    public boolean func_75253_b() {
        LivingEntity target = this.theEntity.func_70638_az();
        if (target == null || !target.func_70089_S()) {
            return false;
        }
        if (!this.longMemory) {
            return !this.theEntity.func_70661_as().func_75500_f();
        }
        if (target instanceof PlayerEntity) {
            PlayerEntity playerTarget = (PlayerEntity)target;
            return !playerTarget.func_175149_v() && !playerTarget.func_184812_l_();
        }
        return true;
    }

    public void func_75249_e() {
        this.theEntity.func_70661_as().func_75484_a(this.initialPath, this.speedTowardsTarget);
        this.theEntity.func_213395_q(true);
        this.rePathDelay = 0;
        this.weaponAccountedSwingCooldown = 0;
        this.updateMeleeMode(this.decideMeleeMode());
        this.decideMeleeModeTimer = 5;
        this.ongoingShieldingTime = 0;
        this.timeUntilCanShield = 0;
    }

    private void updateMeleeMode(MeleeMode newMode) {
        if (newMode != this.meleeMode) {
            this.meleeMode = newMode;
            this.timeSinceDifferentMeleeMode = 0;
            if (this.meleeMode == MeleeMode.DEFENSIVE) {
                this.getShieldingHand().ifPresent(arg_0 -> ((NPCEntity)this.theEntity).func_184598_c(arg_0));
            } else {
                this.theEntity.func_184597_cx();
            }
        }
    }

    private MeleeMode decideMeleeMode() {
        this.world.func_217381_Z().func_76320_a("decideNewMeleeMode");
        MeleeMode decision = this.doDecideMeleeMode();
        this.world.func_217381_Z().func_76319_b();
        return decision;
    }

    private MeleeMode doDecideMeleeMode() {
        if (this.ongoingShieldingTime > 80 + this.rand.nextInt(50)) {
            this.ongoingShieldingTime = 0;
            this.timeUntilCanShield = 80 + this.rand.nextInt(60);
            return MeleeMode.AGGRESSIVE;
        }
        if (this.timeUntilCanShield > 0) {
            return MeleeMode.AGGRESSIVE;
        }
        if (this.canUseShield()) {
            LivingEntity target = this.theEntity.func_70638_az();
            float attackReadiness = 1.0f;
            if (!this.isInRangeToAttack(target)) {
                int ticksSinceAttacked = this.theEntity.getNPCCombatUpdater().getTicksSinceAttacked();
                float recentAttackedPriority = 1.0f - (float)ticksSinceAttacked / 100.0f;
                recentAttackedPriority = MathHelper.func_76131_a((float)recentAttackedPriority, (float)0.0f, (float)1.0f);
                attackReadiness -= recentAttackedPriority * 2.0f;
            } else {
                attackReadiness += 0.5f;
            }
            float health = this.theEntity.func_110143_aJ() / Math.max(this.theEntity.func_110138_aP(), 0.001f);
            float lowHealthPriority = 1.0f - health / 0.4f;
            lowHealthPriority = MathHelper.func_76131_a((float)lowHealthPriority, (float)0.0f, (float)1.0f);
            attackReadiness -= lowHealthPriority * 0.33f;
            this.world.func_217381_Z().func_76320_a("getNearbyFoesToFriendsRatio");
            float foesFriendsRatio = this.getNearbyFoesToFriendsRatio();
            this.world.func_217381_Z().func_76319_b();
            attackReadiness = foesFriendsRatio > 1.0f ? (attackReadiness -= Math.min(foesFriendsRatio, 2.0f) * 0.33f) : (attackReadiness += 1.0f / foesFriendsRatio * 0.25f);
            if (target.func_184585_cz()) {
                attackReadiness -= 0.3f;
            }
            if (attackReadiness >= 0.9f) {
                return MeleeMode.AGGRESSIVE;
            }
            if (attackReadiness <= 0.1f) {
                return MeleeMode.DEFENSIVE;
            }
            if (this.meleeMode == null || this.timeSinceDifferentMeleeMode >= 40) {
                return this.rand.nextFloat() < attackReadiness ? MeleeMode.AGGRESSIVE : MeleeMode.DEFENSIVE;
            }
            return this.meleeMode;
        }
        return MeleeMode.AGGRESSIVE;
    }

    private Optional<Hand> getShieldingHand() {
        return Stream.of(Hand.values()).filter(hand -> this.theEntity.func_184586_b((Hand)hand).isShield((LivingEntity)this.theEntity)).findFirst();
    }

    private boolean canUseShield() {
        return this.getShieldingHand().isPresent() && !this.theEntity.getNPCCombatUpdater().isShieldDisabled();
    }

    private float getNearbyFoesToFriendsRatio() {
        long gameTime = this.world.func_82737_E();
        if (gameTime - this.lastFriendsToFoesCacheTime > 10L) {
            HashSet<NPCEntity> friends = new HashSet<NPCEntity>();
            HashSet<LivingEntity> foes = new HashSet<LivingEntity>();
            friends.add(this.theEntity);
            foes.add(this.theEntity.func_70638_az());
            double nearbyRange = 8.0;
            AxisAlignedBB checkBox = this.theEntity.func_174813_aQ().func_186662_g(nearbyRange);
            friends.addAll(this.theEntity.field_70170_p.func_225316_b(LivingEntity.class, checkBox, NPCPredicates.selectFriends(this.theEntity)));
            foes.addAll(this.theEntity.field_70170_p.func_225316_b(LivingEntity.class, checkBox, NPCPredicates.selectFoes(this.theEntity)));
            friends.removeAll(foes);
            this.cachedFriendsToFoesRatio = (float)foes.size() / (float)friends.size();
            this.lastFriendsToFoesCacheTime = gameTime;
        }
        return this.cachedFriendsToFoesRatio;
    }

    public void func_75246_d() {
        if (this.meleeMode == MeleeMode.DEFENSIVE && !this.canUseShield()) {
            this.updateMeleeMode(MeleeMode.AGGRESSIVE);
        }
        this.ongoingShieldingTime = this.theEntity.func_184585_cz() ? ++this.ongoingShieldingTime : 0;
        this.timeUntilCanShield = Math.max(this.timeUntilCanShield - 1, 0);
        ++this.timeSinceDifferentMeleeMode;
        if (this.decideMeleeModeTimer > 0) {
            --this.decideMeleeModeTimer;
        } else {
            this.updateMeleeMode(this.decideMeleeMode());
        }
        this.baseMeleeTick();
        this.updateHaltIfDefendingClose();
    }

    private void baseMeleeTick() {
        LivingEntity target = this.theEntity.func_70638_az();
        this.theEntity.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
        double dSq = this.theEntity.func_70092_e(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
        this.rePathDelay = Math.max(this.rePathDelay - 1, 0);
        if ((this.longMemory || this.theEntity.func_70635_at().func_75522_a((Entity)target)) && this.rePathDelay <= 0) {
            this.rePathDelay = 4 + this.rand.nextInt(7);
            if (dSq > 1024.0) {
                this.rePathDelay += 10;
            } else if (dSq > 256.0) {
                this.rePathDelay += 5;
            }
            if (this.theEntity.func_70661_as().func_75500_f() && !this.isInRangeToAttack(target)) {
                this.theEntity.func_70661_as().func_75484_a(this.theEntity.func_70661_as().func_75494_a((Entity)target, 0), this.speedTowardsTarget);
            } else if (!this.theEntity.func_70661_as().func_75497_a((Entity)target, this.speedTowardsTarget)) {
                this.rePathDelay += 15;
            }
        }
        this.weaponAccountedSwingCooldown = Math.max(this.weaponAccountedSwingCooldown - 1, 0);
        this.checkAndPerformAttack(target, dSq);
    }

    private void updateHaltIfDefendingClose() {
        double defendingHaltRange;
        double dSq;
        ModifiableAttributeInstance attrib = this.theEntity.func_110148_a(Attributes.field_233821_d_);
        attrib.func_188479_b(DEFENDING_CLOSE_HALT_ID);
        if (this.meleeMode == MeleeMode.DEFENSIVE && (dSq = this.theEntity.func_70068_e((Entity)this.theEntity.func_70638_az())) < (defendingHaltRange = 2.0) * defendingHaltRange) {
            attrib.func_233767_b_(DEFENDING_CLOSE_HALT);
        }
    }

    protected void checkAndPerformAttack(LivingEntity target, double distToEnemySq) {
        if (this.meleeMode == MeleeMode.AGGRESSIVE && this.isInRangeToAttack(target, distToEnemySq) && this.weaponAccountedSwingCooldown <= 0) {
            this.resetSwingCooldown();
            this.theEntity.func_184609_a(Hand.MAIN_HAND);
            this.theEntity.func_70652_k((Entity)target);
        }
    }

    private boolean isInRangeToAttack(LivingEntity target, double distToEnemySq) {
        double reachSq = this.getAttackReachSq(target);
        return distToEnemySq <= reachSq;
    }

    protected double getAttackReachSq(LivingEntity target) {
        double fullReach = this.theEntity.func_233637_b_((Attribute)ForgeMod.REACH_DISTANCE.get());
        return fullReach * fullReach;
    }

    private boolean isInRangeToAttack(LivingEntity target) {
        return this.isInRangeToAttack(target, this.theEntity.func_70068_e((Entity)target));
    }

    protected void resetSwingCooldown() {
        this.weaponAccountedSwingCooldown = this.getWeaponMeleeCooldown();
    }

    private int getWeaponMeleeCooldown() {
        return this.theEntity.getAttackCooldownTicks();
    }

    public void func_75251_c() {
        LivingEntity target = this.theEntity.func_70638_az();
        if (!EntityPredicates.field_188444_d.test(target)) {
            this.theEntity.func_70624_b(null);
        }
        this.theEntity.func_213395_q(false);
        this.theEntity.func_70661_as().func_75499_g();
        this.updateMeleeMode(null);
        this.decideMeleeModeTimer = 0;
        this.updateHaltIfDefendingClose();
        this.ongoingShieldingTime = 0;
        this.timeUntilCanShield = 0;
    }

    public static enum MeleeMode {
        AGGRESSIVE,
        DEFENSIVE;

    }
}

