/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc.ai.goal;

import lotr.common.entity.npc.ai.goal.SkyWatchingGoal;
import lotr.common.util.LOTRUtil;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class WatchSunriseSunsetGoal
extends SkyWatchingGoal {
    private Watching watching;
    private long lastWatchTime;
    private static final long MIN_WATCH_INTERVAL = LOTRUtil.secondsToTicks(20);

    public WatchSunriseSunsetGoal(MobEntity entity, float chance) {
        super(entity, chance);
    }

    @Override
    protected boolean shouldStartWatching() {
        if (this.getCurrentGameTime() - this.lastWatchTime < MIN_WATCH_INTERVAL) {
            return false;
        }
        if (this.canSeeSunset()) {
            this.watching = Watching.SUNSET;
            return true;
        }
        if (this.canSeeSunrise()) {
            this.watching = Watching.SUNRISE;
            return true;
        }
        return false;
    }

    private long getCurrentGameTime() {
        return this.world.func_82737_E();
    }

    private boolean canSeeSunrise() {
        return this.isSunrise() && this.canSeeSunProjectedPos();
    }

    private boolean canSeeSunset() {
        return this.isSunset() && this.canSeeSunProjectedPos();
    }

    private boolean isSunrise() {
        float sunCycle = this.world.func_242415_f(1.0f);
        return sunCycle > 0.729f && sunCycle < 0.76f;
    }

    private boolean isSunset() {
        float sunCycle = this.world.func_242415_f(1.0f);
        return sunCycle > 0.24f && sunCycle < 0.271f;
    }

    @Override
    protected Vector3d getCurrentWatchTarget() {
        return this.getSunProjectedPos();
    }

    private Vector3d getSunProjectedPos() {
        this.world.func_217381_Z().func_76320_a("getSunProjectedPos");
        Vector3d eyePos = this.entity.func_174824_e(1.0f);
        Vector3d sunNoonVector = new Vector3d(0.0, 100.0, 0.0);
        float sunAngleFromNoon = this.world.func_72929_e(1.0f);
        float cos = MathHelper.func_76134_b((float)(sunAngleFromNoon *= -1.0f));
        float sin = MathHelper.func_76126_a((float)sunAngleFromNoon);
        double x = sunNoonVector.field_72450_a * (double)cos + sunNoonVector.field_72448_b * (double)sin;
        double y = sunNoonVector.field_72448_b * (double)cos - sunNoonVector.field_72450_a * (double)sin;
        double z = sunNoonVector.field_72449_c;
        Vector3d sunVector = new Vector3d(x, y, z);
        Vector3d sunPos = eyePos.func_178787_e(sunVector);
        this.world.func_217381_Z().func_76319_b();
        return sunPos;
    }

    private boolean canSeeSunProjectedPos() {
        this.world.func_217381_Z().func_76320_a("canSeeSunProjectedPos");
        boolean canSee = this.canSeeSkyWatchTarget(this.getSunProjectedPos());
        this.world.func_217381_Z().func_76319_b();
        return canSee;
    }

    @Override
    protected boolean recheckShouldContinueWatching() {
        if (this.watching == Watching.SUNRISE) {
            return this.canSeeSunrise();
        }
        if (this.watching == Watching.SUNSET) {
            return this.canSeeSunset();
        }
        return false;
    }

    @Override
    protected int getWatchingDuration() {
        return LOTRUtil.secondsToTicks(5 + this.rand.nextInt(15));
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        this.watching = null;
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        this.lastWatchTime = this.getCurrentGameTime();
    }

    private static enum Watching {
        SUNRISE,
        SUNSET;

    }
}

