/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc.data;

import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lotr.common.LOTRLog;
import lotr.common.entity.npc.data.NameBank;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class NameBankManager
extends ReloadListener<Map<ResourceLocation, NameBank>> {
    public static final NameBankManager INSTANCE = new NameBankManager();
    private static final String NAME_BANK_DIR = "npcs/names";
    private static final String NAME_BANK_FILE_TYPE = ".txt";
    private static final NameBank MISSING_NAME_BANK = new NameBank(new ResourceLocation("lotr", "npcs/names/missing_name_bank"), (List<String>)ImmutableList.of((Object)"???"));
    private Map<ResourceLocation, NameBank> loadedNameBanks;

    protected Map<ResourceLocation, NameBank> prepare(IResourceManager resMgr, IProfiler profiler) {
        HashMap<ResourceLocation, NameBank> map = new HashMap<ResourceLocation, NameBank>();
        for (ResourceLocation res : resMgr.func_199003_a(NAME_BANK_DIR, filename -> filename.endsWith(NAME_BANK_FILE_TYPE))) {
            try {
                IResource resource = resMgr.func_199002_a(res);
                Throwable throwable = null;
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(resource.func_199027_b(), StandardCharsets.UTF_8));
                    Throwable throwable2 = null;
                    try {
                        List<String> names = reader.lines().map(String::trim).collect(Collectors.toList());
                        if (!names.isEmpty()) {
                            NameBank bank = new NameBank(res, names);
                            map.put(res, bank);
                            continue;
                        }
                        LOTRLog.error("Failed to load name bank %s - name list was empty", res);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable2 != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (resource == null) continue;
                    if (throwable != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    resource.close();
                }
            }
            catch (IOException e) {
                LOTRLog.error("Failed to load name bank %s from file", res);
                e.printStackTrace();
            }
        }
        return map;
    }

    protected void apply(Map<ResourceLocation, NameBank> map, IResourceManager resMgr, IProfiler profiler) {
        this.loadedNameBanks = map;
    }

    public NameBank fetchLoadedNameBank(ResourceLocation bankName) {
        if (this.loadedNameBanks.containsKey(bankName)) {
            return this.loadedNameBanks.get(bankName);
        }
        LOTRLog.warn("Failed to fetch name bank %s - not loaded", bankName);
        return MISSING_NAME_BANK;
    }

    public static ResourceLocation fullPath(String filename) {
        return new ResourceLocation("lotr", String.format("%s/%s%s", NAME_BANK_DIR, filename, NAME_BANK_FILE_TYPE));
    }
}

