/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.event;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import lotr.common.LOTRLog;
import lotr.common.block.FallenLeavesBlock;
import lotr.common.block.HangingWebBlock;
import lotr.common.block.PlateBlock;
import lotr.common.block.ReedsBlock;
import lotr.common.block.SnowPathBlock;
import lotr.common.block.ThatchBlock;
import lotr.common.block.ThatchSlabBlock;
import lotr.common.block.ThatchStairsBlock;
import lotr.common.block.VerticalOnlySlabBlock;
import lotr.common.block.WickerFenceBlock;
import lotr.common.block.WickerFenceGateBlock;
import lotr.common.block.trees.BirchTreeAlt;
import lotr.common.data.AlignmentDataModule;
import lotr.common.data.LOTRLevelData;
import lotr.common.data.LOTRPlayerData;
import lotr.common.data.MiscDataModule;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.entity.npc.NPCPredicates;
import lotr.common.entity.npc.data.NPCEntitySettingsManager;
import lotr.common.event.SpeechGarbler;
import lotr.common.event.TerrainProtections;
import lotr.common.fac.AlignmentBonus;
import lotr.common.fac.EntityFactionHelper;
import lotr.common.fac.Faction;
import lotr.common.fac.FactionPointers;
import lotr.common.fac.FactionSettingsManager;
import lotr.common.init.LOTRBiomes;
import lotr.common.init.LOTRDimensions;
import lotr.common.init.LOTRItems;
import lotr.common.init.LOTRTags;
import lotr.common.init.LOTRWorldTypes;
import lotr.common.item.IEmptyVesselItem;
import lotr.common.item.RedBookItem;
import lotr.common.item.VesselDrinkItem;
import lotr.common.item.VesselOperations;
import lotr.common.item.VesselType;
import lotr.common.network.LOTRPacketHandler;
import lotr.common.network.SPacketSetAttackTarget;
import lotr.common.time.LOTRDate;
import lotr.common.time.LOTRTime;
import lotr.common.util.LOTRUtil;
import lotr.common.world.RingPortalTeleporter;
import lotr.common.world.map.CustomWaypointStructureHandler;
import lotr.common.world.map.MapSettingsManager;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.TallGrassBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.horse.AbstractChestedHorseEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.inventory.container.HorseInventoryContainer;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShovelItem;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.FlowersFeature;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.PistonEvent;
import net.minecraftforge.event.world.SaplingGrowTreeEvent;
import net.minecraftforge.event.world.SleepFinishedTimeEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class LOTREventHandler {
    private final SpeechGarbler speechGarbler = new SpeechGarbler();

    public LOTREventHandler() {
        this.registerHandlers(this);
    }

    private void registerHandlers(Object ... handlers) {
        for (Object handler : handlers) {
            MinecraftForge.EVENT_BUS.register(handler);
        }
    }

    @SubscribeEvent
    public void getBurnTime(FurnaceFuelBurnTimeEvent event) {
        ItemStack itemstack = event.getItemStack();
        Item item = itemstack.func_77973_b();
        if (item.func_206844_a(LOTRTags.Items.WOODEN_FENCES)) {
            event.setBurnTime(300);
            return;
        }
        if (item.func_206844_a(LOTRTags.Items.WOODEN_FENCE_GATES)) {
            event.setBurnTime(300);
            return;
        }
        if (item.func_206844_a(LOTRTags.Items.WOODEN_BEAMS)) {
            event.setBurnTime(300);
            return;
        }
        if (item.func_206844_a(LOTRTags.Items.WOODEN_BEAM_SLABS)) {
            event.setBurnTime(150);
            return;
        }
        if (item.func_206844_a(LOTRTags.Items.LOG_SLABS)) {
            event.setBurnTime(150);
            return;
        }
        if (item.func_206844_a(LOTRTags.Items.LOG_STAIRS)) {
            event.setBurnTime(300);
            return;
        }
        if (item.func_206844_a(LOTRTags.Items.BRANCHES)) {
            event.setBurnTime(300);
            return;
        }
        if (item instanceof BlockItem) {
            Block block = ((BlockItem)item).func_179223_d();
            if (block instanceof ReedsBlock) {
                event.setBurnTime(100);
                return;
            }
            if (block instanceof ThatchBlock) {
                event.setBurnTime(100);
                return;
            }
            if (block instanceof ThatchSlabBlock) {
                event.setBurnTime(50);
                return;
            }
            if (block instanceof ThatchStairsBlock) {
                event.setBurnTime(67);
                return;
            }
            if (block instanceof WickerFenceBlock) {
                event.setBurnTime(100);
                return;
            }
            if (block instanceof WickerFenceGateBlock) {
                event.setBurnTime(100);
                return;
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            MiscDataModule miscData;
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            ServerWorld serverWorld = serverPlayer.func_71121_q();
            LOTRLevelData levelData = LOTRLevelData.serverInstance();
            MapSettingsManager.serverInstance().sendMapToPlayer(serverPlayer);
            FactionSettingsManager.serverInstance().sendFactionsToPlayer(serverPlayer);
            NPCEntitySettingsManager.serverInstance().sendEntitySettingsToPlayer(serverPlayer);
            if (LOTRWorldTypes.isInstantME(serverWorld) && LOTRDimensions.isDimension((World)serverWorld, (RegistryKey<World>)World.field_234918_g_) && !(miscData = levelData.getData((PlayerEntity)serverPlayer).getMiscData()).getInitialSpawnedIntoME()) {
                RingPortalTeleporter.transferEntity(serverWorld, (Entity)serverPlayer, Optional.empty(), false);
                miscData.setInitialSpawnedIntoME(true);
            }
            levelData.sendLoginPacket(serverPlayer);
            levelData.playerDataHandleLogin(serverPlayer);
            LOTRTime.sendLoginPacket(serverPlayer);
            LOTRDate.sendLoginPacket(serverPlayer);
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerEntity player = event.getPlayer();
        World world = player.field_70170_p;
        if (!world.field_72995_K && player.func_184187_bx() instanceof AbstractChestedHorseEntity) {
            AbstractChestedHorseEntity logoutHorse = (AbstractChestedHorseEntity)player.func_184187_bx();
            double checkRange = 64.0;
            List nearbyPlayers = world.func_217357_a(PlayerEntity.class, player.func_174813_aQ().func_72321_a(checkRange, checkRange, checkRange));
            for (PlayerEntity otherPlayer : nearbyPlayers) {
                HorseInventoryContainer horseInv;
                AbstractHorseEntity openHorse;
                if (otherPlayer == player || !(otherPlayer.field_71070_bA instanceof HorseInventoryContainer) || (openHorse = (AbstractHorseEntity)ObfuscationReflectionHelper.getPrivateValue(HorseInventoryContainer.class, (Object)(horseInv = (HorseInventoryContainer)otherPlayer.field_71070_bA), (String)"field_111242_f")) != logoutHorse) continue;
                otherPlayer.func_71053_j();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        PlayerEntity player = event.getPlayer();
        World world = event.getWorld();
        Hand hand = event.getHand();
        ItemStack heldItem = event.getItemStack();
        BlockPos pos = event.getPos();
        Direction side = event.getFace();
        if ((event instanceof PlayerInteractEvent.RightClickBlock || event instanceof PlayerInteractEvent.LeftClickBlock || event instanceof PlayerInteractEvent.RightClickItem) && TerrainProtections.isTerrainProtectedFromPlayerEdits(event)) {
            event.setCanceled(true);
            return;
        }
        if (event instanceof PlayerInteractEvent.RightClickBlock) {
            ActionResultType snowPathResult;
            SlabBlock itemSlabBlock;
            Block itemBlock;
            if (side != null && !player.func_175151_a(pos, side, heldItem)) {
                return;
            }
            BlockState state = world.func_180495_p(pos);
            BlockRayTraceResult hitVec = ((PlayerInteractEvent.RightClickBlock)event).getHitVec();
            if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof BlockItem && (itemBlock = Block.func_149634_a((Item)heldItem.func_77973_b())) instanceof SlabBlock && VerticalOnlySlabBlock.getVerticalSlabFor(itemSlabBlock = (SlabBlock)itemBlock) != null) {
                VerticalOnlySlabBlock vSlab = VerticalOnlySlabBlock.getVerticalSlabFor(itemSlabBlock);
                if (hitVec instanceof BlockRayTraceResult) {
                    ActionResultType blockInteractResult;
                    boolean sneakUsingItem;
                    BlockRayTraceResult blockRayTrace = hitVec;
                    boolean holdingAnyItem = true;
                    boolean bl = sneakUsingItem = player.func_226563_dT_() && holdingAnyItem && (!player.func_184614_ca().doesSneakBypassUse((IWorldReader)world, pos, player) || !player.func_184592_cb().doesSneakBypassUse((IWorldReader)world, pos, player));
                    if (!sneakUsingItem && (blockInteractResult = state.func_227031_a_(world, player, hand, blockRayTrace)).func_226246_a_()) {
                        event.setCancellationResult(blockInteractResult);
                        event.setCanceled(true);
                        return;
                    }
                    ActionResultType verticalPlaceResult = vSlab.placeVerticalOrVanilla(player, hand, heldItem, world, pos, side, blockRayTrace);
                    if (verticalPlaceResult != ActionResultType.PASS) {
                        event.setCancellationResult(verticalPlaceResult);
                        event.setCanceled(true);
                        return;
                    }
                }
            }
            if (heldItem.func_77973_b() instanceof ShovelItem && (snowPathResult = SnowPathBlock.makeSnowPath(world, pos, side, player, hand, heldItem)) != ActionResultType.PASS) {
                event.setCanceled(true);
                return;
            }
            if (!world.field_72995_K && hand == Hand.MAIN_HAND && state.func_177230_c() instanceof PlateBlock && player.func_226563_dT_() && ((PlateBlock)state.func_177230_c()).popOffOneItem(world, pos, player)) {
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public void onExplosionDetonate(ExplosionEvent.Detonate event) {
        Explosion explosion = event.getExplosion();
        World world = event.getWorld();
        if (!world.field_72995_K) {
            List explodingPositions = explosion.func_180343_e();
            explodingPositions.removeIf(pos -> TerrainProtections.isTerrainProtectedFromExplosion(world, pos));
        }
    }

    @SubscribeEvent
    public void onPistonMoveCheck(PistonEvent.Pre event) {
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ItemFrameEntity frame;
        BlockPos frameSupportPos;
        RedBookItem redBook;
        PlayerEntity player = event.getPlayer();
        World world = event.getWorld();
        ItemStack heldItem = event.getItemStack();
        Hand hand = event.getHand();
        Entity target = event.getTarget();
        if (heldItem.func_77973_b() instanceof RedBookItem && target instanceof ItemFrameEntity && (redBook = (RedBookItem)heldItem.func_77973_b()).createCustomWaypointStructure(world, frameSupportPos = CustomWaypointStructureHandler.getItemFrameSupportPos(frame = (ItemFrameEntity)target), player)) {
            event.setCanceled(true);
            return;
        }
        if (!player.field_71075_bZ.field_75098_d && VesselOperations.isItemEmptyVessel(heldItem) && IEmptyVesselItem.canMilk(target)) {
            VesselType vesselType = ((IEmptyVesselItem)heldItem.func_77973_b()).getVesselType();
            ItemStack milkDrink = new ItemStack((IItemProvider)LOTRItems.MILK_DRINK.get());
            VesselDrinkItem.setVessel(milkDrink, vesselType);
            player.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
            heldItem.func_190918_g(1);
            if (heldItem.func_190926_b()) {
                player.func_184611_a(hand, milkDrink);
            } else if (!player.field_71071_by.func_70441_a(milkDrink)) {
                player.func_71019_a(milkDrink, false);
            }
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.SUCCESS);
            return;
        }
    }

    @SubscribeEvent
    public void onBoneMealGrow(BonemealEvent event) {
        IGrowable grassAsGrowable;
        World world = event.getWorld();
        Random rand = world.field_73012_v;
        BlockState state = event.getBlock();
        BlockPos pos = event.getPos();
        if (LOTRDimensions.isModDimension(world) && state.func_177230_c() == Blocks.field_196658_i && (grassAsGrowable = (IGrowable)state.func_177230_c()).func_176473_a((IBlockReader)world, pos, state, world.field_72995_K)) {
            if (world instanceof ServerWorld && grassAsGrowable.func_180670_a(world, world.field_73012_v, pos, state)) {
                BlockPos above = pos.func_177984_a();
                int tries = 128;
                block0: for (int i = 0; i < tries; ++i) {
                    BlockPos plantPos = above;
                    int triesHere = 0;
                    while (true) {
                        if (triesHere >= i / 16) {
                            BlockState plant;
                            BlockState curBlock = world.func_180495_p(plantPos);
                            if (curBlock.func_177230_c() instanceof TallGrassBlock && rand.nextInt(10) == 0) {
                                ((IGrowable)curBlock.func_177230_c()).func_225535_a_((ServerWorld)world, rand, plantPos, curBlock);
                            }
                            if (!curBlock.isAir((IBlockReader)world, plantPos)) continue block0;
                            Biome biome = world.func_226691_t_(plantPos);
                            if (rand.nextInt(8) == 0) {
                                List flowerList = world.func_226691_t_(plantPos).func_242440_e().func_242496_b();
                                if (flowerList.isEmpty()) continue block0;
                                ConfiguredFeature configuredFeature = (ConfiguredFeature)flowerList.get(0);
                                plant = ((FlowersFeature)configuredFeature.func_242766_b()).func_225562_b_(rand, plantPos, configuredFeature.func_242767_c());
                            } else {
                                plant = LOTRBiomes.getWrapperFor(biome, (IWorld)world).getGrassForBonemeal(rand, plantPos);
                            }
                            if (!plant.func_196955_c((IWorldReader)world, plantPos)) continue block0;
                            world.func_180501_a(plantPos, plant, 3);
                            continue block0;
                        }
                        if (world.func_180495_p((plantPos = plantPos.func_177982_a(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).func_177977_b()).func_177230_c() != grassAsGrowable || world.func_180495_p(plantPos).func_235785_r_((IBlockReader)world, plantPos)) continue block0;
                        ++triesHere;
                    }
                }
            }
            event.setResult(Event.Result.ALLOW);
            return;
        }
    }

    @SubscribeEvent
    public void onSaplingGrow(SaplingGrowTreeEvent event) {
        IWorld world = event.getWorld();
        BlockPos pos = event.getPos();
        BlockState state = world.func_180495_p(pos);
        Random rand = event.getRand();
        if (state.func_177230_c() == Blocks.field_196676_v) {
            BirchTreeAlt altTree = new BirchTreeAlt();
            ServerWorld sWorld = (ServerWorld)world;
            altTree.func_230339_a_(sWorld, sWorld.func_72863_F().func_201711_g(), pos, state, rand);
            event.setResult(Event.Result.DENY);
            return;
        }
    }

    @SubscribeEvent
    public void onPlayerHarvestCheck(PlayerEvent.HarvestCheck event) {
        BlockState state = event.getTargetBlock();
        PlayerEntity player = event.getPlayer();
        ItemStack heldItem = player.func_184586_b(Hand.MAIN_HAND);
        if (state.func_177230_c() instanceof HangingWebBlock && !heldItem.func_190926_b() && heldItem.func_150998_b(Blocks.field_196553_aF.func_176223_P())) {
            event.setCanHarvest(true);
            return;
        }
    }

    @SubscribeEvent
    public void onBreakSpeedCheck(PlayerEvent.BreakSpeed event) {
        BlockState state = event.getState();
        PlayerEntity player = event.getPlayer();
        ItemStack heldItem = player.func_184586_b(Hand.MAIN_HAND);
        if (state.func_177230_c() instanceof HangingWebBlock && !heldItem.func_190926_b()) {
            this.adjustRelativeSpeedToMatch(event, Blocks.field_196553_aF);
            return;
        }
        if (state.func_177230_c() instanceof FallenLeavesBlock && !heldItem.func_190926_b()) {
            this.adjustRelativeSpeedToMatch(event, ((FallenLeavesBlock)state.func_177230_c()).getBaseLeafBlock());
            return;
        }
    }

    private void adjustRelativeSpeedToMatch(PlayerEvent.BreakSpeed event, Block desiredBlockSpeed) {
        ItemStack heldItem = event.getPlayer().func_184586_b(Hand.MAIN_HAND);
        float desiredBaseSpeed = heldItem.func_150997_a(desiredBlockSpeed.func_176223_P());
        float actualBaseSpeed = heldItem.func_150997_a(event.getState());
        float relativeSpeed = desiredBaseSpeed / actualBaseSpeed;
        event.setNewSpeed(event.getOriginalSpeed() * relativeSpeed);
    }

    @SubscribeEvent
    public void onSleepFinished(SleepFinishedTimeEvent event) {
        ServerWorld world = (ServerWorld)event.getWorld();
        if (!world.field_72995_K && LOTRDimensions.isModDimension((World)world)) {
            LOTRTime.advanceToMorning(world);
            if (world.func_82736_K().func_223586_b(GameRules.field_223617_t)) {
                ServerWorld overworld = world.func_73046_m().func_241755_D_();
                IServerWorldInfo overworldInfo = (IServerWorldInfo)overworld.func_72912_H();
                overworldInfo.func_76080_g(0);
                overworldInfo.func_76084_b(false);
                overworldInfo.func_76090_f(0);
                overworldInfo.func_76069_a(false);
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        SkeletonHorseEntity skeleHorse;
        Entity entity = event.getEntity();
        World world = event.getWorld();
        if (!world.field_72995_K && LOTRDimensions.isModDimension(world) && entity instanceof SkeletonHorseEntity && (skeleHorse = (SkeletonHorseEntity)entity).func_190690_dh()) {
            BlockPos pos = skeleHorse.func_233580_cy_();
            LOTRLog.info("Cancelled the spawn of a skeleton trap horse at %d %d %d", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onStartTrackingEntity(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        PlayerEntity player = event.getPlayer();
        if (!entity.field_70170_p.field_72995_K) {
            if (entity instanceof MobEntity) {
                LOTRPacketHandler.sendTo(new SPacketSetAttackTarget((MobEntity)entity), (ServerPlayerEntity)player);
            }
            if (entity instanceof NPCEntity) {
                ((NPCEntity)entity).onPlayerStartTrackingNPC((ServerPlayerEntity)player);
            }
        }
    }

    @SubscribeEvent
    public void onCanLivingConvert(LivingConversionEvent.Pre event) {
        LivingEntity entity = event.getEntityLiving();
        EntityType outcome = event.getOutcome();
        World world = entity.field_70170_p;
        if (LOTRDimensions.isModDimension(world) && entity instanceof PigEntity && outcome == EntityType.field_233592_ba_) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        if (!world.field_72995_K && entity instanceof FoxEntity && LOTRDimensions.isModDimension(world)) {
            FoxEntity fox = (FoxEntity)entity;
            String biomeCheckKey = String.format("%s:%s", "lotr", "FoxBiomeCheck");
            if (!fox.getPersistentData().func_74767_n(biomeCheckKey)) {
                FoxEntity.Type initialFoxType;
                FoxEntity.Type newFoxType = initialFoxType = fox.func_213471_dV();
                BlockPos entityPos = entity.func_233580_cy_();
                Biome biome = world.func_226691_t_(entity.func_233580_cy_());
                if (biome.func_225486_c(entityPos) < 0.15f) {
                    newFoxType = FoxEntity.Type.SNOW;
                }
                if (newFoxType != initialFoxType) {
                    try {
                        Method m_setVariantType = ObfuscationReflectionHelper.findMethod(FoxEntity.class, (String)"func_213474_a", (Class[])new Class[]{FoxEntity.Type.class});
                        LOTRUtil.unlockMethod(m_setVariantType);
                        m_setVariantType.invoke((Object)fox, newFoxType);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        LOTRLog.error("Error setting fox type based on biome");
                        e.printStackTrace();
                    }
                }
                fox.getPersistentData().func_74757_a(biomeCheckKey, true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        LivingEntity entity = event.getEntityLiving();
        LivingEntity target = event.getTarget();
        if (!entity.field_70170_p.field_72995_K && entity instanceof MobEntity) {
            LOTRPacketHandler.sendToAllTrackingEntity(new SPacketSetAttackTarget((MobEntity)entity), (Entity)entity);
        }
    }

    @SubscribeEvent
    public void onLivingAttacked(LivingAttackEvent event) {
        LivingEntity target = event.getEntityLiving();
        DamageSource source = event.getSource();
        LivingEntity attacker = source.func_76346_g() instanceof LivingEntity ? (LivingEntity)source.func_76346_g() : null;
        World world = target.field_70170_p;
        if (target instanceof AbstractHorseEntity && target.func_184188_bt().contains(attacker)) {
            event.setCanceled(true);
            return;
        }
        if (attacker != null && !EntityFactionHelper.canEntityCauseDamageToTarget(attacker, (Entity)target, true)) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onProjectileImpact(ProjectileImpactEvent event) {
        Entity entity = event.getEntity();
        RayTraceResult rayTrace = event.getRayTraceResult();
        World world = entity.field_70170_p;
        if (entity instanceof ProjectileEntity) {
            ProjectileEntity projectile = (ProjectileEntity)entity;
            Entity shooter = projectile.func_234616_v_();
            if (rayTrace.func_216346_c() == RayTraceResult.Type.ENTITY) {
                Entity hitEntity = ((EntityRayTraceResult)rayTrace).func_216348_a();
                if (shooter instanceof LivingEntity && !EntityFactionHelper.canEntityCauseDamageToTarget((LivingEntity)shooter, hitEntity, true)) {
                    event.setCanceled(true);
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        World world = entity.field_70170_p;
        if (!world.field_72995_K) {
            LivingEntity killer = source.func_76346_g() instanceof LivingEntity ? (LivingEntity)source.func_76346_g() : null;
            PlayerEntity playerResponsible = null;
            boolean creditHiredUnit = false;
            boolean byNearbyUnit = false;
            if (killer instanceof PlayerEntity) {
                playerResponsible = (PlayerEntity)killer;
            } else if (entity.func_94060_bK() instanceof PlayerEntity) {
                playerResponsible = (PlayerEntity)entity.func_94060_bK();
            } else if (killer instanceof NPCEntity) {
                NPCEntity nPCEntity = (NPCEntity)killer;
            }
            if (killer != null) {
                Faction entityFaction = EntityFactionHelper.getFaction((Entity)entity);
                boolean wasPlayerSelfDefenceAgainstAlliedUnit = false;
                if (playerResponsible != null) {
                    float bonus;
                    LOTRPlayerData playerData = LOTRLevelData.getSidedData(playerResponsible);
                    AlignmentDataModule alignData = playerData.getAlignmentData();
                    float prevAlignment = alignData.getAlignment(entityFaction);
                    List<Faction> forcedBonusFactions = null;
                    AlignmentBonus alignmentBonus = null;
                    if (!wasPlayerSelfDefenceAgainstAlliedUnit && (bonus = NPCEntitySettingsManager.getEntityTypeSettings((Entity)entity).getKillAlignmentBonus()) != 0.0f && (!creditHiredUnit || creditHiredUnit && byNearbyUnit)) {
                        alignmentBonus = AlignmentBonus.forEntityKill(bonus, entity.func_200600_R().func_212546_e(), creditHiredUnit, EntityFactionHelper.isCivilian((Entity)entity));
                    }
                    if (creditHiredUnit || wasPlayerSelfDefenceAgainstAlliedUnit) {
                        // empty if block
                    }
                    if (alignmentBonus != null && alignmentBonus.bonus != 0.0f) {
                        alignData.addAlignmentFromBonus((ServerPlayerEntity)playerResponsible, alignmentBonus, entityFaction, forcedBonusFactions, (Entity)entity);
                    }
                    if (!creditHiredUnit && entityFaction.isPlayableAlignmentFaction()) {
                        Faction pledgeFac;
                        playerData.getFactionStatsData().getFactionStats(entityFaction).addMemberKill();
                        entityFaction.getBonusesForKilling().forEach(enemyFac -> playerData.getFactionStatsData().getFactionStats((Faction)enemyFac).addEnemyKill());
                        if (playerResponsible.field_71075_bZ.field_75098_d || entityFaction.getAreasOfInfluence().isInAreaToRecordBountyKill(playerResponsible)) {
                            // empty if block
                        }
                        if ((pledgeFac = alignData.getPledgeFaction()) != null && (pledgeFac == entityFaction || pledgeFac.isAlly(entityFaction))) {
                            alignData.onPledgeKill(playerResponsible);
                        }
                    }
                }
                if (!wasPlayerSelfDefenceAgainstAlliedUnit && EntityPredicates.field_188444_d.test(killer) && !FactionPointers.UNALIGNED.matches(entityFaction)) {
                    int sentSpeeches = 0;
                    int maxSpeeches = 5;
                    double range = 8.0;
                    List nearbyAngerableNPCs = world.func_225316_b(MobEntity.class, entity.func_174813_aQ().func_186662_g(range), NPCPredicates.selectAngerableByKill(entityFaction, killer));
                    for (MobEntity angered : nearbyAngerableNPCs) {
                        if (angered.func_70638_az() != null) continue;
                        angered.func_70624_b(killer);
                        if (!(angered instanceof NPCEntity) || sentSpeeches >= maxSpeeches) continue;
                        NPCEntity nPCEntity = (NPCEntity)angered;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        ServerWorld sWorld;
        boolean isCompleteGameSave;
        IWorld world = event.getWorld();
        if (world instanceof ServerWorld && (isCompleteGameSave = LOTRDimensions.isDimension((World)(sWorld = (ServerWorld)world), (RegistryKey<World>)World.field_234918_g_))) {
            LOTRTime.save(sWorld);
        }
    }

    @SubscribeEvent
    public void onServerChat(ServerChatEvent event) {
        this.speechGarbler.handle(event);
    }
}

