/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.fac;

import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class AlignmentBonus {
    public final float bonus;
    public final ITextComponent name;
    public final boolean isKill;
    public final boolean isKillByHiredUnit;
    public final boolean isCivilianKill;
    public static final AlignmentBonus MARRIAGE_BONUS = AlignmentBonus.createSimpleBonus(5.0f, "lotr.alignment.marriage");
    public static final AlignmentBonus FANGORN_TREE_PENALTY = AlignmentBonus.createSimpleBonus(-1.0f, "lotr.alignment.cutFangornTree");
    public static final AlignmentBonus ROHAN_HORSE_PENALTY = AlignmentBonus.createSimpleBonus(-1.0f, "lotr.alignment.killRohanHorse");
    public static final AlignmentBonus VINEYARD_STEAL_PENALTY = AlignmentBonus.createSimpleBonus(-1.0f, "lotr.alignment.vineyardSteal");
    public static final AlignmentBonus PICKPOCKET_PENALTY = AlignmentBonus.createSimpleBonus(-1.0f, "lotr.alignment.pickpocket");

    private AlignmentBonus(float bonus, ITextComponent name, boolean isKill, boolean isKillByHiredUnit, boolean isCivilianKill) {
        this.bonus = bonus;
        this.name = name;
        this.isKill = isKill;
        this.isKillByHiredUnit = isKillByHiredUnit;
        this.isCivilianKill = isCivilianKill;
    }

    public void write(PacketBuffer buf) {
        buf.writeFloat(this.bonus);
        buf.func_179256_a(this.name);
        buf.writeBoolean(this.isKill);
        buf.writeBoolean(this.isKillByHiredUnit);
        buf.writeBoolean(this.isCivilianKill);
    }

    public static AlignmentBonus read(PacketBuffer buf) {
        return new AlignmentBonus(buf.readFloat(), buf.func_179258_d(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean());
    }

    public static float scaleKillPenalty(float penalty, float alignment) {
        if (alignment > 0.0f && penalty < 0.0f) {
            float factor = alignment / 50.0f;
            factor = MathHelper.func_76131_a((float)factor, (float)1.0f, (float)20.0f);
            penalty *= factor;
        }
        return penalty;
    }

    public static AlignmentBonus createSimpleBonus(float bonus, String name) {
        return new AlignmentBonus(bonus, (ITextComponent)new StringTextComponent(name), false, false, false);
    }

    public static AlignmentBonus createMiniquestBonus(float bonus) {
        return AlignmentBonus.createSimpleBonus(bonus, "lotr.alignment.miniQuest");
    }

    public static AlignmentBonus createPledgePenalty(float bonus) {
        return AlignmentBonus.createSimpleBonus(bonus, "lotr.alignment.breakPledge");
    }

    public static AlignmentBonus forEntityKill(float bonus, ITextComponent name, boolean byHiredUnit, boolean civilian) {
        return new AlignmentBonus(bonus, name, true, byHiredUnit, civilian);
    }
}

