/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.fac;

import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import lotr.common.LOTRLog;
import lotr.common.data.DataUtil;
import lotr.common.fac.Faction;
import lotr.common.fac.FactionSettings;
import net.minecraft.network.PacketBuffer;
import org.apache.commons.lang3.tuple.Pair;

public class AlignmentBonusMap
extends HashMap<Faction, Float> {
    public Set<Faction> getChangedFactions() {
        return this.keySet().stream().filter(f -> ((Float)this.get(f)).floatValue() != 0.0f).collect(Collectors.toSet());
    }

    public void write(PacketBuffer buf) {
        DataUtil.writeMapToBuffer(buf, this, (fac, align) -> {
            buf.func_150787_b(fac.getAssignedId());
            buf.writeFloat(align.floatValue());
        });
    }

    public static AlignmentBonusMap read(PacketBuffer buf, FactionSettings currentLoadedFactions) {
        return DataUtil.readNewMapFromBuffer(buf, AlignmentBonusMap::new, () -> {
            int facId = buf.func_150792_a();
            float align = buf.readFloat();
            Faction fac = currentLoadedFactions.getFactionByID(facId);
            if (fac != null) {
                return Pair.of((Object)fac, (Object)Float.valueOf(align));
            }
            LOTRLog.warn("Received nonexistent faction ID %d in alignment bonus packet", facId);
            return null;
        });
    }
}

