/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.fac;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lotr.common.LOTRLog;
import lotr.common.data.DataUtil;
import lotr.common.data.LOTRLevelData;
import lotr.common.data.LOTRPlayerData;
import lotr.common.fac.AreasOfInfluence;
import lotr.common.fac.DummyFactionRank;
import lotr.common.fac.FactionRank;
import lotr.common.fac.FactionRegion;
import lotr.common.fac.FactionRelation;
import lotr.common.fac.FactionSettings;
import lotr.common.fac.FactionType;
import lotr.common.fac.MapSquare;
import lotr.common.world.map.MapSettings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class Faction {
    private final FactionSettings factionSettings;
    private final ResourceLocation resourceName;
    private final int assignedId;
    private final String name;
    private final boolean translateName;
    private final String subtitle;
    private final boolean translateSubtitle;
    private final FactionRegion region;
    private final int ordering;
    private final int color;
    private final float[] colorComponents;
    private final MapSquare mapSquare;
    private final boolean isPlayableAlignmentFaction;
    private final Set<FactionType> types;
    private final boolean approvesCivilianKills;
    private List<FactionRank> ranksSortedAscending = new ArrayList<FactionRank>();
    private List<FactionRank> ranksSortedDescending = new ArrayList<FactionRank>();
    private Optional<FactionRank> pledgeRank;
    private AreasOfInfluence areasOfInfluence;

    public Faction(FactionSettings facSettings, ResourceLocation res, int id, String name, boolean translateName, String subtitle, boolean translateSubtitle, FactionRegion region, int ordering, int color, MapSquare mapSquare, boolean isPlayableAlignmentFaction, Set<FactionType> types, boolean civilianKills) {
        this.factionSettings = facSettings;
        this.resourceName = res;
        this.assignedId = id;
        this.name = name;
        this.translateName = translateName;
        this.subtitle = subtitle;
        this.translateSubtitle = translateSubtitle;
        this.region = region;
        this.ordering = ordering;
        this.color = color;
        this.colorComponents = new Color(color).getColorComponents(null);
        this.mapSquare = mapSquare;
        this.isPlayableAlignmentFaction = isPlayableAlignmentFaction;
        this.types = types;
        this.approvesCivilianKills = civilianKills;
    }

    public static Faction read(FactionSettings factionSettings, ResourceLocation resourceName, JsonObject json, int assignedId, MapSettings mapSettings) {
        if (json.size() == 0) {
            LOTRLog.info("Faction %s has an empty file - not loading it in this world", resourceName);
            return null;
        }
        JsonObject nameObj = json.get("name").getAsJsonObject();
        String name = nameObj.get("text").getAsString();
        boolean translateName = nameObj.get("translate").getAsBoolean();
        JsonObject subtitleObj = json.get("subtitle").getAsJsonObject();
        String subtitle = subtitleObj.get("text").getAsString();
        boolean translateSubtitle = subtitleObj.get("translate").getAsBoolean();
        String regionName = json.get("region").getAsString();
        FactionRegion region = factionSettings.getRegionByName(new ResourceLocation(regionName));
        if (region == null) {
            LOTRLog.warn("Faction %s has invalid region name %s - no such region exists", resourceName, regionName);
            return null;
        }
        int ordering = json.get("ordering").getAsInt();
        String hexColor = json.get("color").getAsString();
        int color = 0;
        try {
            color = Integer.parseInt(hexColor, 16);
        }
        catch (NumberFormatException e) {
            LOTRLog.warn("Faction %s has invalid color code %s - must be in hex color format (e.g. FFAA33)", resourceName, hexColor);
        }
        JsonObject mapSquareObj = json.get("map_square").getAsJsonObject();
        MapSquare mapSquare = MapSquare.read(mapSquareObj);
        boolean isPlayableAlignmentFaction = true;
        JsonArray typesArray = json.get("types").getAsJsonArray();
        HashSet<FactionType> types = new HashSet<FactionType>();
        for (JsonElement typeElement : typesArray) {
            String typeName = typeElement.getAsString();
            FactionType type = FactionType.forName(new ResourceLocation(typeName));
            if (type != null) {
                types.add(type);
                continue;
            }
            LOTRLog.warn("Faction %s includes invalid faction type name %s - no such type exists", resourceName, typeName);
        }
        boolean approvesCivilianKills = json.get("approves_civilian_kills").getAsBoolean();
        Faction faction = new Faction(factionSettings, resourceName, assignedId, name, translateName, subtitle, translateSubtitle, region, ordering, color, mapSquare, isPlayableAlignmentFaction, types, approvesCivilianKills);
        if (json.has("ranks")) {
            JsonArray ranksArray = json.get("ranks").getAsJsonArray();
            ArrayList<FactionRank> ranks = new ArrayList<FactionRank>();
            for (JsonElement rankElement : ranksArray) {
                JsonObject rankObj = rankElement.getAsJsonObject();
                FactionRank rank = FactionRank.read(faction, rankObj);
                if (rank == null) continue;
                ranks.add(rank);
            }
            if (ranks.stream().filter(FactionRank::isPledgeRank).count() > 1L) {
                LOTRLog.warn("Faction %s declares more than one pledge rank (%s) - only one is allowed. Ranks will not be loaded until this is fixed", faction.getName(), String.join((CharSequence)",", ranks.stream().filter(FactionRank::isPledgeRank).map(FactionRank::getBaseName).collect(Collectors.toList())));
            } else {
                faction.setRanks(ranks);
            }
        }
        JsonObject aoiObj = json.get("areas_of_influence").getAsJsonObject();
        AreasOfInfluence areasOfInfluence = AreasOfInfluence.read(faction, aoiObj, mapSettings);
        faction.setAreasOfInfluence(areasOfInfluence);
        return faction;
    }

    public static Faction read(FactionSettings factionSettings, MapSettings mapSettings, PacketBuffer buf) {
        ResourceLocation resourceName = buf.func_192575_l();
        int assignedId = buf.func_150792_a();
        String name = buf.func_218666_n();
        boolean translateName = buf.readBoolean();
        String subtitle = buf.func_218666_n();
        boolean translateSubtitle = buf.readBoolean();
        FactionRegion region = DataUtil.readNullableFromBuffer(buf, () -> {
            int regionId = buf.func_150792_a();
            FactionRegion readRegion = factionSettings.getRegionByID(regionId);
            if (readRegion == null) {
                LOTRLog.warn("Received faction %s from server with a nonexistent region ID (%d) - faction will not be loaded correctly clientside", resourceName, regionId);
            }
            return readRegion;
        });
        int ordering = buf.func_150792_a();
        int color = buf.readInt();
        MapSquare mapSquare = DataUtil.readNullableFromBuffer(buf, () -> MapSquare.read(buf));
        boolean isPlayableAlignmentFaction = buf.readBoolean();
        Set types = DataUtil.readNewCollectionFromBuffer(buf, HashSet::new, () -> {
            int typeId = buf.func_150792_a();
            FactionType type = FactionType.forNetworkID(typeId);
            if (type == null) {
                LOTRLog.warn("Received faction %s from server with a nonexistent faction type ID (%d)", resourceName, typeId);
            }
            return type;
        });
        boolean approvesCivilianKills = buf.readBoolean();
        Faction faction = new Faction(factionSettings, resourceName, assignedId, name, translateName, subtitle, translateSubtitle, region, ordering, color, mapSquare, isPlayableAlignmentFaction, types, approvesCivilianKills);
        List ranks = DataUtil.readNewCollectionFromBuffer(buf, ArrayList::new, () -> FactionRank.read(faction, buf));
        faction.setRanks(ranks);
        AreasOfInfluence areasOfInfluence = AreasOfInfluence.read(faction, buf, mapSettings);
        faction.setAreasOfInfluence(areasOfInfluence);
        return faction;
    }

    public void write(PacketBuffer buf) {
        buf.func_192572_a(this.resourceName);
        buf.func_150787_b(this.assignedId);
        buf.func_180714_a(this.name);
        buf.writeBoolean(this.translateName);
        buf.func_180714_a(this.subtitle);
        buf.writeBoolean(this.translateSubtitle);
        DataUtil.writeNullableToBuffer(buf, this.region, () -> buf.func_150787_b(this.region.getAssignedId()));
        buf.func_150787_b(this.ordering);
        buf.writeInt(this.color);
        DataUtil.writeNullableToBuffer(buf, this.mapSquare, MapSquare::write);
        buf.writeBoolean(this.isPlayableAlignmentFaction);
        DataUtil.writeCollectionToBuffer(buf, this.types, type -> buf.func_150787_b(type.networkID));
        buf.writeBoolean(this.approvesCivilianKills);
        DataUtil.writeCollectionToBuffer(buf, this.ranksSortedAscending, rank -> rank.write(buf));
        this.areasOfInfluence.write(buf);
    }

    public ResourceLocation getName() {
        return this.resourceName;
    }

    public int getAssignedId() {
        return this.assignedId;
    }

    public IFormattableTextComponent getDisplayName() {
        if (this.translateName) {
            return new TranslationTextComponent(this.name);
        }
        return new StringTextComponent(this.name);
    }

    public ITextComponent getDisplaySubtitle() {
        if (this.translateSubtitle) {
            return new TranslationTextComponent(this.subtitle);
        }
        return new StringTextComponent(this.subtitle);
    }

    public static ITextComponent getFactionOrUnknownDisplayName(Faction faction) {
        return faction != null ? faction.getDisplayName() : new TranslationTextComponent("faction.lotr.unknown");
    }

    public FactionRegion getRegion() {
        return this.region;
    }

    public int getNullableRegionOrdering() {
        return Optional.ofNullable(this.region).map(FactionRegion::getOrdering).orElse(-1);
    }

    public RegistryKey<World> getDimension() {
        if (this.region != null) {
            return this.region.getDimension();
        }
        return null;
    }

    public int getOrdering() {
        return this.ordering;
    }

    public int getColor() {
        return this.color;
    }

    public float[] getColorComponents() {
        return this.colorComponents;
    }

    public MapSquare getMapSquare() {
        return this.mapSquare;
    }

    public Set<FactionType> getTypes() {
        return this.types;
    }

    public boolean isOfAnyType(FactionType ... checkTypes) {
        return Stream.of(checkTypes).anyMatch(this.types::contains);
    }

    public boolean isPlayableAlignmentFaction() {
        return this.isPlayableAlignmentFaction;
    }

    public List<FactionRank> getRanksSortedAscending() {
        return this.ranksSortedAscending;
    }

    public void setRanks(List<FactionRank> ranks) {
        if (this.ranksSortedAscending != null && !this.ranksSortedAscending.isEmpty()) {
            throw new IllegalArgumentException("Cannot set " + this.name + " ranks - already set!");
        }
        this.ranksSortedAscending = new ArrayList<FactionRank>(ranks);
        this.ranksSortedDescending = new ArrayList<FactionRank>(ranks);
        Collections.sort(this.ranksSortedAscending, FactionRank.sortAscending());
        Collections.sort(this.ranksSortedDescending, FactionRank.sortDescending());
        this.pledgeRank = this.ranksSortedAscending.stream().filter(FactionRank::isPledgeRank).findFirst();
    }

    public FactionRank getRankFor(PlayerEntity player) {
        return this.getRankFor(LOTRLevelData.sidedInstance((IWorldReader)player.field_70170_p).getData(player));
    }

    public FactionRank getRankFor(LOTRPlayerData playerData) {
        return this.getRankFor(playerData.getAlignmentData().getAlignment(this));
    }

    public FactionRank getRankFor(float alignment) {
        return this.ranksSortedDescending.stream().filter(rank -> !rank.isDummyRank() && alignment >= rank.getAlignment()).findFirst().orElse(alignment >= 0.0f ? DummyFactionRank.NEUTRAL : DummyFactionRank.ENEMY);
    }

    public FactionRank getRankAbove(FactionRank curRank) {
        return this.getRankNAbove(curRank, 1);
    }

    public FactionRank getRankBelow(FactionRank curRank) {
        return this.getRankNBelow(curRank, 1);
    }

    public FactionRank getRankNAbove(FactionRank curRank, int n) {
        if (this.ranksSortedDescending.isEmpty() || curRank == null) {
            return DummyFactionRank.NEUTRAL;
        }
        int index = -1;
        if (curRank.isDummyRank()) {
            index = this.ranksSortedDescending.size();
        } else if (this.ranksSortedDescending.contains(curRank)) {
            index = this.ranksSortedDescending.indexOf(curRank);
        }
        if (index >= 0) {
            if ((index -= n) < 0) {
                return this.ranksSortedDescending.get(0);
            }
            if (index > this.ranksSortedDescending.size() - 1) {
                return DummyFactionRank.NEUTRAL;
            }
            return this.ranksSortedDescending.get(index);
        }
        return DummyFactionRank.NEUTRAL;
    }

    public FactionRank getRankNBelow(FactionRank curRank, int n) {
        return this.getRankNAbove(curRank, -n);
    }

    public FactionRank getFirstRank() {
        return !this.ranksSortedAscending.isEmpty() ? this.ranksSortedAscending.get(0) : DummyFactionRank.NEUTRAL;
    }

    public Optional<FactionRank> getPledgeRank() {
        return this.pledgeRank;
    }

    public float getPledgeAlignment() {
        return this.pledgeRank.map(FactionRank::getAlignment).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public boolean approvesCivilianKills() {
        return this.approvesCivilianKills;
    }

    public FactionRelation getRelation(Faction other) {
        return this.factionSettings.getRelations().getRelation(this, other);
    }

    public boolean isGoodRelation(Faction other) {
        FactionRelation relation = this.getRelation(other);
        return relation == FactionRelation.ALLY || relation == FactionRelation.FRIEND;
    }

    public boolean isAlly(Faction other) {
        return this.getRelation(other) == FactionRelation.ALLY;
    }

    public boolean isNeutral(Faction other) {
        return this.getRelation(other) == FactionRelation.NEUTRAL;
    }

    public boolean isBadRelation(Faction other) {
        FactionRelation relation = this.getRelation(other);
        return relation == FactionRelation.ENEMY || relation == FactionRelation.MORTAL_ENEMY;
    }

    public boolean isMortalEnemy(Faction other) {
        return this.getRelation(other) == FactionRelation.MORTAL_ENEMY;
    }

    public List<Faction> getOthersOfRelation(FactionRelation relation) {
        return this.factionSettings.streamFactionsExcept(this).filter(Faction::isPlayableAlignmentFaction).filter(faction -> this.getRelation((Faction)faction) == relation).collect(Collectors.toList());
    }

    public List<Faction> getBonusesForKilling() {
        return this.factionSettings.streamFactionsExcept(this).filter(this::isBadRelation).collect(Collectors.toList());
    }

    public List<Faction> getPenaltiesForKilling() {
        return this.factionSettings.streamFactions().filter(f -> f == this || this.isGoodRelation((Faction)f)).collect(Collectors.toList());
    }

    public List<Faction> getConquestBoostRelations() {
        return this.factionSettings.streamFactionsExcept(this).filter(Faction::isPlayableAlignmentFaction).filter(this::isAlly).collect(Collectors.toList());
    }

    public AreasOfInfluence getAreasOfInfluence() {
        return this.areasOfInfluence;
    }

    public void setAreasOfInfluence(AreasOfInfluence aoi) {
        if (this.areasOfInfluence != null) {
            throw new IllegalArgumentException("Cannot set " + this.name + " areas of influence - already set!");
        }
        this.areasOfInfluence = aoi;
    }
}

