/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.fac;

import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public enum FactionRelation {
    ALLY("ally"),
    FRIEND("friend"),
    NEUTRAL("neutral"),
    ENEMY("enemy"),
    MORTAL_ENEMY("mortal_enemy");

    public final String codeName;
    public final int networkID;

    private FactionRelation(String name) {
        this.codeName = name;
        this.networkID = this.ordinal();
    }

    public ITextComponent getDisplayName() {
        return new TranslationTextComponent(String.format("factionrelation.%s.%s", "lotr", this.codeName));
    }

    public static FactionRelation forName(String name) {
        for (FactionRelation relation : FactionRelation.values()) {
            if (!relation.codeName.equals(name)) continue;
            return relation;
        }
        return null;
    }

    public static FactionRelation forNetworkID(int id) {
        for (FactionRelation relation : FactionRelation.values()) {
            if (relation.networkID != id) continue;
            return relation;
        }
        return null;
    }
}

