/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.init;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lotr.common.init.PreRegisteredLOTRBiome;
import lotr.common.init.RegistryOrderHelper;
import lotr.common.world.biome.AndrastBiome;
import lotr.common.world.biome.AnduinHillsBiome;
import lotr.common.world.biome.AnduinValeBiome;
import lotr.common.world.biome.AnfalasBiome;
import lotr.common.world.biome.AngmarBiome;
import lotr.common.world.biome.AnorienBiome;
import lotr.common.world.biome.BlackrootValeBiome;
import lotr.common.world.biome.BlueMountainsBiome;
import lotr.common.world.biome.BreelandBiome;
import lotr.common.world.biome.BrownLandsBiome;
import lotr.common.world.biome.ChetwoodBiome;
import lotr.common.world.biome.ColdfellsBiome;
import lotr.common.world.biome.DagorladBiome;
import lotr.common.world.biome.DaleBiome;
import lotr.common.world.biome.DeadMarshesBiome;
import lotr.common.world.biome.DorEnErnilBiome;
import lotr.common.world.biome.DorwinionBiome;
import lotr.common.world.biome.DruwaithIaurBiome;
import lotr.common.world.biome.DunlandBiome;
import lotr.common.world.biome.EasternDesolationBiome;
import lotr.common.world.biome.EmynMuilBiome;
import lotr.common.world.biome.EnedwaithBiome;
import lotr.common.world.biome.EregionBiome;
import lotr.common.world.biome.EriadorBiome;
import lotr.common.world.biome.EthirAnduinBiome;
import lotr.common.world.biome.EttenmoorsBiome;
import lotr.common.world.biome.FangornBiome;
import lotr.common.world.biome.ForochelBiome;
import lotr.common.world.biome.ForodwaithBiome;
import lotr.common.world.biome.GladdenFieldsBiome;
import lotr.common.world.biome.GorgorothBiome;
import lotr.common.world.biome.GreyMountainsBiome;
import lotr.common.world.biome.HaradDesertBiome;
import lotr.common.world.biome.HarnennorBiome;
import lotr.common.world.biome.HarondorBiome;
import lotr.common.world.biome.IronHillsBiome;
import lotr.common.world.biome.IthilienBiome;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeWrapper;
import lotr.common.world.biome.LakeBiome;
import lotr.common.world.biome.LamedonBiome;
import lotr.common.world.biome.LebenninBiome;
import lotr.common.world.biome.LindonBiome;
import lotr.common.world.biome.LoneLandsBiome;
import lotr.common.world.biome.LongMarshesBiome;
import lotr.common.world.biome.LossarnachBiome;
import lotr.common.world.biome.LostladenBiome;
import lotr.common.world.biome.LothlorienBiome;
import lotr.common.world.biome.MERiverBiome;
import lotr.common.world.biome.MidgewaterBiome;
import lotr.common.world.biome.MirkwoodBiome;
import lotr.common.world.biome.MistyMountainsBiome;
import lotr.common.world.biome.MordorBiome;
import lotr.common.world.biome.MorgulValeBiome;
import lotr.common.world.biome.MouthsOfEntwashBiome;
import lotr.common.world.biome.NanCurunirBiome;
import lotr.common.world.biome.NindalfBiome;
import lotr.common.world.biome.NorthlandsBiome;
import lotr.common.world.biome.NurnBiome;
import lotr.common.world.biome.OldForestBiome;
import lotr.common.world.biome.PelargirBiome;
import lotr.common.world.biome.PinnathGelinBiome;
import lotr.common.world.biome.RivendellBiome;
import lotr.common.world.biome.RohanBiome;
import lotr.common.world.biome.SeaBiome;
import lotr.common.world.biome.ShireBiome;
import lotr.common.world.biome.ShireWoodlandsBiome;
import lotr.common.world.biome.SouthronCoastsBiome;
import lotr.common.world.biome.SwanfleetBiome;
import lotr.common.world.biome.TolfalasBiome;
import lotr.common.world.biome.TowerHillsBiome;
import lotr.common.world.biome.TrollshawsBiome;
import lotr.common.world.biome.UmbarBiome;
import lotr.common.world.biome.VanillaPlaceholderLOTRBiome;
import lotr.common.world.biome.WesternGondorBiome;
import lotr.common.world.biome.WhiteMountainsBiome;
import lotr.common.world.biome.WilderlandBiome;
import lotr.common.world.biome.WoodlandRealmBiome;
import lotr.common.world.biome.surface.MiddleEarthSurfaceBuilder;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class LOTRBiomes {
    public static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"lotr");
    public static final DeferredRegister<SurfaceBuilder<?>> SURFACE_BUILDERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SURFACE_BUILDERS, (String)"lotr");
    private static final List<PreRegisteredLOTRBiome> PRE_REGISTRY = new ArrayList<PreRegisteredLOTRBiome>();
    private static final List<LOTRBiomeBase> BIOME_WRAPPER_OBJECTS = new ArrayList<LOTRBiomeBase>();
    private static final Map<ResourceLocation, LOTRBiomeBase> BIOME_WRAPPER_OBJECTS_BY_NAME = new HashMap<ResourceLocation, LOTRBiomeBase>();
    public static final PreRegisteredLOTRBiome SHIRE = LOTRBiomes.prepare("shire", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new ShireBiome(true)));
    public static final PreRegisteredLOTRBiome MORDOR = LOTRBiomes.prepare("mordor", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new MordorBiome(true)));
    public static final PreRegisteredLOTRBiome ANORIEN = LOTRBiomes.prepare("anorien", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new AnorienBiome(true)));
    public static final PreRegisteredLOTRBiome ROHAN = LOTRBiomes.prepare("rohan", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new RohanBiome(true)));
    public static final PreRegisteredLOTRBiome MISTY_MOUNTAINS = LOTRBiomes.prepare("misty_mountains", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new MistyMountainsBiome(true)));
    public static final PreRegisteredLOTRBiome SHIRE_WOODLANDS = LOTRBiomes.prepare("shire_woodlands", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new ShireWoodlandsBiome(false)));
    public static final PreRegisteredLOTRBiome RIVER = LOTRBiomes.prepare("river", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new MERiverBiome(false)));
    public static final PreRegisteredLOTRBiome TROLLSHAWS = LOTRBiomes.prepare("trollshaws", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new TrollshawsBiome(true)));
    public static final PreRegisteredLOTRBiome BLUE_MOUNTAINS = LOTRBiomes.prepare("blue_mountains", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new BlueMountainsBiome(true)));
    public static final PreRegisteredLOTRBiome ERIADOR = LOTRBiomes.prepare("eriador", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new EriadorBiome(true)));
    public static final PreRegisteredLOTRBiome LONE_LANDS = LOTRBiomes.prepare("lone_lands", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new LoneLandsBiome(true)));
    public static final PreRegisteredLOTRBiome ITHILIEN = LOTRBiomes.prepare("ithilien", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new IthilienBiome(true)));
    public static final PreRegisteredLOTRBiome BROWN_LANDS = LOTRBiomes.prepare("brown_lands", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new BrownLandsBiome(true)));
    public static final PreRegisteredLOTRBiome LOTHLORIEN = LOTRBiomes.prepare("lothlorien", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new LothlorienBiome(true)));
    public static final PreRegisteredLOTRBiome IRON_HILLS = LOTRBiomes.prepare("iron_hills", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new IronHillsBiome(true)));
    public static final PreRegisteredLOTRBiome DUNLAND = LOTRBiomes.prepare("dunland", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new DunlandBiome(true)));
    public static final PreRegisteredLOTRBiome EMYN_MUIL = LOTRBiomes.prepare("emyn_muil", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new EmynMuilBiome(true)));
    public static final PreRegisteredLOTRBiome LINDON = LOTRBiomes.prepare("lindon", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new LindonBiome(true)));
    public static final PreRegisteredLOTRBiome SOUTHRON_COASTS = LOTRBiomes.prepare("southron_coasts", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new SouthronCoastsBiome(true)));
    public static final PreRegisteredLOTRBiome NAN_CURUNIR = LOTRBiomes.prepare("nan_curunir", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new NanCurunirBiome(true)));
    public static final PreRegisteredLOTRBiome FORODWAITH = LOTRBiomes.prepare("forodwaith", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new ForodwaithBiome(true)));
    public static final PreRegisteredLOTRBiome EREGION = LOTRBiomes.prepare("eregion", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new EregionBiome(true)));
    public static final PreRegisteredLOTRBiome MIRKWOOD = LOTRBiomes.prepare("mirkwood", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new MirkwoodBiome(true)));
    public static final PreRegisteredLOTRBiome GREY_MOUNTAINS = LOTRBiomes.prepare("grey_mountains", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new GreyMountainsBiome(true)));
    public static final PreRegisteredLOTRBiome WHITE_MOUNTAINS = LOTRBiomes.prepare("white_mountains", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new WhiteMountainsBiome(true)));
    public static final PreRegisteredLOTRBiome FANGORN = LOTRBiomes.prepare("fangorn", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new FangornBiome(true)));
    public static final PreRegisteredLOTRBiome WOODLAND_REALM = LOTRBiomes.prepare("woodland_realm", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new WoodlandRealmBiome(true)));
    public static final PreRegisteredLOTRBiome DALE = LOTRBiomes.prepare("dale", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new DaleBiome(true)));
    public static final PreRegisteredLOTRBiome ANGMAR = LOTRBiomes.prepare("angmar", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new AngmarBiome(true)));
    public static final PreRegisteredLOTRBiome HARONDOR = LOTRBiomes.prepare("harondor", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new HarondorBiome(true)));
    public static final PreRegisteredLOTRBiome ENEDWAITH = LOTRBiomes.prepare("enedwaith", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new EnedwaithBiome(true)));
    public static final PreRegisteredLOTRBiome VALES_OF_ANDUIN = LOTRBiomes.prepare("vales_of_anduin", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new AnduinValeBiome(true)));
    public static final PreRegisteredLOTRBiome ANDUIN_HILLS = LOTRBiomes.prepare("anduin_hills", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new AnduinHillsBiome(true)));
    public static final PreRegisteredLOTRBiome WILDERLAND = LOTRBiomes.prepare("wilderland", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new WilderlandBiome(true)));
    public static final PreRegisteredLOTRBiome OLD_FOREST = LOTRBiomes.prepare("old_forest", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new OldForestBiome(true)));
    public static final PreRegisteredLOTRBiome BREELAND = LOTRBiomes.prepare("breeland", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new BreelandBiome(true)));
    public static final PreRegisteredLOTRBiome CHETWOOD = LOTRBiomes.prepare("chetwood", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new ChetwoodBiome(true)));
    public static final PreRegisteredLOTRBiome MISTY_MOUNTAINS_FOOTHILLS = LOTRBiomes.prepare("misty_mountains_foothills", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new MistyMountainsBiome.Foothills(true)));
    public static final PreRegisteredLOTRBiome BLUE_MOUNTAINS_FOOTHILLS = LOTRBiomes.prepare("blue_mountains_foothills", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new BlueMountainsBiome.Foothills(true)));
    public static final PreRegisteredLOTRBiome GREY_MOUNTAINS_FOOTHILLS = LOTRBiomes.prepare("grey_mountains_foothills", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new GreyMountainsBiome.Foothills(true)));
    public static final PreRegisteredLOTRBiome WHITE_MOUNTAINS_FOOTHILLS = LOTRBiomes.prepare("white_mountains_foothills", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new WhiteMountainsBiome.Foothills(true)));
    public static final PreRegisteredLOTRBiome MORDOR_MOUNTAINS = LOTRBiomes.prepare("mordor_mountains", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new MordorBiome.Mountains(true)));
    public static final PreRegisteredLOTRBiome FORODWAITH_MOUNTAINS = LOTRBiomes.prepare("forodwaith_mountains", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new ForodwaithBiome.Mountains(true)));
    public static final PreRegisteredLOTRBiome ANGMAR_MOUNTAINS = LOTRBiomes.prepare("angmar_mountains", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new AngmarBiome.Mountains(true)));
    public static final PreRegisteredLOTRBiome NURN = LOTRBiomes.prepare("nurn", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new NurnBiome(true)));
    public static final PreRegisteredLOTRBiome UMBAR = LOTRBiomes.prepare("umbar", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new UmbarBiome(true)));
    public static final PreRegisteredLOTRBiome HARAD_DESERT = LOTRBiomes.prepare("harad_desert", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new HaradDesertBiome(true)));
    public static final PreRegisteredLOTRBiome LINDON_WOODLANDS = LOTRBiomes.prepare("lindon_woodlands", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new LindonBiome.Woodlands(true)));
    public static final PreRegisteredLOTRBiome ERIADOR_DOWNS = LOTRBiomes.prepare("eriador_downs", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new EriadorBiome.Downs(true)));
    public static final PreRegisteredLOTRBiome LONE_LANDS_HILLS = LOTRBiomes.prepare("lone_lands_hills", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new LoneLandsBiome.Hills(true)));
    public static final PreRegisteredLOTRBiome NORTHLANDS = LOTRBiomes.prepare("northlands", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new NorthlandsBiome(true)));
    public static final PreRegisteredLOTRBiome NORTHLANDS_FOREST = LOTRBiomes.prepare("northlands_forest", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new NorthlandsBiome.Forest(true)));
    public static final PreRegisteredLOTRBiome SEA = LOTRBiomes.prepare("sea", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new SeaBiome(false)));
    public static final PreRegisteredLOTRBiome ISLAND = LOTRBiomes.prepare("island", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new SeaBiome.Island(false)));
    public static final PreRegisteredLOTRBiome BEACH = LOTRBiomes.prepare("beach", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new SeaBiome.Beach(false)));
    public static final PreRegisteredLOTRBiome TOLFALAS = LOTRBiomes.prepare("tolfalas", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new TolfalasBiome(false)));
    public static final PreRegisteredLOTRBiome LAKE = LOTRBiomes.prepare("lake", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new LakeBiome(false)));
    public static final PreRegisteredLOTRBiome NURNEN = LOTRBiomes.prepare("nurnen", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new NurnBiome.Sea(false)));
    public static final PreRegisteredLOTRBiome DOR_EN_ERNIL = LOTRBiomes.prepare("dor_en_ernil", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new DorEnErnilBiome(true)));
    public static final PreRegisteredLOTRBiome EMYN_EN_ERNIL = LOTRBiomes.prepare("emyn_en_ernil", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new DorEnErnilBiome.Hills(true)));
    public static final PreRegisteredLOTRBiome WESTERN_ISLES = LOTRBiomes.prepare("western_isles", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new SeaBiome.WesternIsles(false)));
    public static final PreRegisteredLOTRBiome COLDFELLS = LOTRBiomes.prepare("coldfells", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new ColdfellsBiome(true)));
    public static final PreRegisteredLOTRBiome ETTENMOORS = LOTRBiomes.prepare("ettenmoors", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new EttenmoorsBiome(true)));
    public static final PreRegisteredLOTRBiome HARNENNOR = LOTRBiomes.prepare("harnennor", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new HarnennorBiome(true)));
    public static final PreRegisteredLOTRBiome DAGORLAD = LOTRBiomes.prepare("dagorlad", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new DagorladBiome(true)));
    public static final PreRegisteredLOTRBiome WHITE_BEACH = LOTRBiomes.prepare("white_beach", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new SeaBiome.WhiteBeach(false)));
    public static final PreRegisteredLOTRBiome DORWINION = LOTRBiomes.prepare("dorwinion", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new DorwinionBiome(true)));
    public static final PreRegisteredLOTRBiome EMYN_WINION = LOTRBiomes.prepare("emyn_winion", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new DorwinionBiome.Hills(true)));
    public static final PreRegisteredLOTRBiome WOLD = LOTRBiomes.prepare("wold", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new RohanBiome.Wold(true)));
    public static final PreRegisteredLOTRBiome MINHIRIATH = LOTRBiomes.prepare("minhiriath", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new EriadorBiome.Minhiriath(true)));
    public static final PreRegisteredLOTRBiome ERYN_VORN = LOTRBiomes.prepare("eryn_vorn", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new EriadorBiome.ErynVorn(true)));
    public static final PreRegisteredLOTRBiome DRUWAITH_IAUR = LOTRBiomes.prepare("druwaith_iaur", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new DruwaithIaurBiome(true)));
    public static final PreRegisteredLOTRBiome ANDRAST = LOTRBiomes.prepare("andrast", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new AndrastBiome(true)));
    public static final PreRegisteredLOTRBiome LOSSARNACH = LOTRBiomes.prepare("lossarnach", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new LossarnachBiome(true)));
    public static final PreRegisteredLOTRBiome LEBENNIN = LOTRBiomes.prepare("lebennin", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new LebenninBiome(true)));
    public static final PreRegisteredLOTRBiome PELARGIR = LOTRBiomes.prepare("pelargir", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new PelargirBiome(true)));
    public static final PreRegisteredLOTRBiome LAMEDON = LOTRBiomes.prepare("lamedon", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new LamedonBiome(true)));
    public static final PreRegisteredLOTRBiome LAMEDON_HILLS = LOTRBiomes.prepare("lamedon_hills", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new LamedonBiome.Hills(true)));
    public static final PreRegisteredLOTRBiome BLACKROOT_VALE = LOTRBiomes.prepare("blackroot_vale", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new BlackrootValeBiome(true)));
    public static final PreRegisteredLOTRBiome PINNATH_GELIN = LOTRBiomes.prepare("pinnath_gelin", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new PinnathGelinBiome(true)));
    public static final PreRegisteredLOTRBiome ANFALAS = LOTRBiomes.prepare("anfalas", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new AnfalasBiome(true)));
    public static final PreRegisteredLOTRBiome NORTHERN_WILDERLAND = LOTRBiomes.prepare("northern_wilderland", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new WilderlandBiome.Northern(true)));
    public static final PreRegisteredLOTRBiome NORTHERN_DALE = LOTRBiomes.prepare("northern_dale", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new DaleBiome.Northern(true)));
    public static final PreRegisteredLOTRBiome RIVENDELL = LOTRBiomes.prepare("rivendell", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new RivendellBiome(true)));
    public static final PreRegisteredLOTRBiome RIVENDELL_HILLS = LOTRBiomes.prepare("rivendell_hills", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new RivendellBiome.Hills(true)));
    public static final PreRegisteredLOTRBiome WESTERN_GONDOR = LOTRBiomes.prepare("western_gondor", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new WesternGondorBiome(true)));
    public static final PreRegisteredLOTRBiome SHIRE_MOORS = LOTRBiomes.prepare("shire_moors", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new ShireBiome.Moors(true)));
    public static final PreRegisteredLOTRBiome WHITE_DOWNS = LOTRBiomes.prepare("white_downs", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new ShireBiome.WhiteDowns(true)));
    public static final PreRegisteredLOTRBiome MIDGEWATER = LOTRBiomes.prepare("midgewater", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new MidgewaterBiome(true)));
    public static final PreRegisteredLOTRBiome SWANFLEET = LOTRBiomes.prepare("swanfleet", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new SwanfleetBiome(true)));
    public static final PreRegisteredLOTRBiome GLADDEN_FIELDS = LOTRBiomes.prepare("gladden_fields", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new GladdenFieldsBiome(true)));
    public static final PreRegisteredLOTRBiome LONG_MARSHES = LOTRBiomes.prepare("long_marshes", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new LongMarshesBiome(true)));
    public static final PreRegisteredLOTRBiome NINDALF = LOTRBiomes.prepare("nindalf", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new NindalfBiome(true)));
    public static final PreRegisteredLOTRBiome DEAD_MARSHES = LOTRBiomes.prepare("dead_marshes", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new DeadMarshesBiome(true)));
    public static final PreRegisteredLOTRBiome MOUTHS_OF_ENTWASH = LOTRBiomes.prepare("mouths_of_entwash", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new MouthsOfEntwashBiome(true)));
    public static final PreRegisteredLOTRBiome ETHIR_ANDUIN = LOTRBiomes.prepare("ethir_anduin", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new EthirAnduinBiome(true)));
    public static final PreRegisteredLOTRBiome SHIRE_MARSHES = LOTRBiomes.prepare("shire_marshes", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new ShireBiome.Marshes(true)));
    public static final PreRegisteredLOTRBiome NURN_MARSHES = LOTRBiomes.prepare("nurn_marshes", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new NurnBiome.Marshes(true)));
    public static final PreRegisteredLOTRBiome GORGOROTH = LOTRBiomes.prepare("gorgoroth", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new GorgorothBiome(true)));
    public static final PreRegisteredLOTRBiome FOROCHEL = LOTRBiomes.prepare("forochel", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new ForochelBiome(true)));
    public static final PreRegisteredLOTRBiome LOTHLORIEN_EAVES = LOTRBiomes.prepare("lothlorien_eaves", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new LothlorienBiome.Eaves(true)));
    public static final PreRegisteredLOTRBiome HARAD_HALF_DESERT = LOTRBiomes.prepare("harad_half_desert", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new HaradDesertBiome.HalfDesert(true)));
    public static final PreRegisteredLOTRBiome HARAD_DESERT_HILLS = LOTRBiomes.prepare("harad_desert_hills", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new HaradDesertBiome.Hills(true)));
    public static final PreRegisteredLOTRBiome LOSTLADEN = LOTRBiomes.prepare("lostladen", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new LostladenBiome(true)));
    public static final PreRegisteredLOTRBiome EASTERN_DESOLATION = LOTRBiomes.prepare("eastern_desolation", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new EasternDesolationBiome(true)));
    public static final PreRegisteredLOTRBiome NORTHERN_MIRKWOOD = LOTRBiomes.prepare("northern_mirkwood", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new MirkwoodBiome.Northern(true)));
    public static final PreRegisteredLOTRBiome MIRKWOOD_MOUNTAINS = LOTRBiomes.prepare("mirkwood_mountains", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new MirkwoodBiome.Mountains(true)));
    public static final PreRegisteredLOTRBiome MORGUL_VALE = LOTRBiomes.prepare("morgul_vale", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new MorgulValeBiome(true)));
    public static final PreRegisteredLOTRBiome DENSE_NORTHLANDS_FOREST = LOTRBiomes.prepare("dense_northlands_forest", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new NorthlandsBiome.DenseForest(false)));
    public static final PreRegisteredLOTRBiome SNOWY_NORTHLANDS = LOTRBiomes.prepare("snowy_northlands", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new NorthlandsBiome.SnowyNorthlands(true)));
    public static final PreRegisteredLOTRBiome SNOWY_NORTHLANDS_FOREST = LOTRBiomes.prepare("snowy_northlands_forest", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new NorthlandsBiome.SnowyForest(true)));
    public static final PreRegisteredLOTRBiome DENSE_SNOWY_NORTHLANDS_FOREST = LOTRBiomes.prepare("dense_snowy_northlands_forest", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new NorthlandsBiome.DenseSnowyForest(false)));
    public static final PreRegisteredLOTRBiome TOWER_HILLS = LOTRBiomes.prepare("tower_hills", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new TowerHillsBiome(true)));
    public static final PreRegisteredLOTRBiome SOUTHRON_COASTS_FOREST = LOTRBiomes.prepare("southron_coasts_forest", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new SouthronCoastsBiome.Forest(true)));
    public static final PreRegisteredLOTRBiome UMBAR_FOREST = LOTRBiomes.prepare("umbar_forest", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new UmbarBiome.Forest(true)));
    public static final PreRegisteredLOTRBiome UMBAR_HILLS = LOTRBiomes.prepare("umbar_hills", (NonNullSupplier<LOTRBiomeBase>)((NonNullSupplier)() -> new UmbarBiome.Hills(true)));
    public static final SurfaceBuilder<MiddleEarthSurfaceConfig> MIDDLE_EARTH_SURFACE = LOTRBiomes.preRegSurfaceBuilder("middle_earth", new MiddleEarthSurfaceBuilder(MiddleEarthSurfaceConfig.CODEC));

    public static void register() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        PRE_REGISTRY.forEach(preparedBiome -> {
            String name = preparedBiome.getName();
            ResourceLocation fullResName = preparedBiome.getRegistryName();
            LOTRBiomeBase lotrBiome = preparedBiome.initialiseAndReturnBiomeWrapper(fullResName);
            BIOME_WRAPPER_OBJECTS.add(lotrBiome);
            BIOME_WRAPPER_OBJECTS_BY_NAME.put(fullResName, lotrBiome);
            BIOMES.register(name, preparedBiome.supplyBiomeInitialiser());
        });
        BIOMES.register(bus);
        SURFACE_BUILDERS.register(bus);
    }

    private static PreRegisteredLOTRBiome prepare(String name, NonNullSupplier<LOTRBiomeBase> wrapperSupplier) {
        PreRegisteredLOTRBiome preparedBiome = new PreRegisteredLOTRBiome(name, wrapperSupplier);
        PRE_REGISTRY.add(preparedBiome);
        return preparedBiome;
    }

    public static List<Biome> listAllBiomesForProvider(Registry<Biome> lookupRegistry) {
        return BIOME_WRAPPER_OBJECTS.stream().map(wrapper -> (Biome)lookupRegistry.func_230516_a_(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)wrapper.getBiomeRegistryName()))).collect(Collectors.toList());
    }

    public static List<ResourceLocation> listBiomeNamesForClassicGen() {
        ArrayList biomes = new ArrayList();
        return BIOME_WRAPPER_OBJECTS.stream().filter(LOTRBiomeBase::isMajorBiome).map(LOTRBiomeBase::getBiomeRegistryName).collect(Collectors.toList());
    }

    public static ResourceLocation getBiomeRegistryName(Biome biome, IWorld world) {
        if (biome.getRegistryName() != null) {
            return biome.getRegistryName();
        }
        return LOTRBiomes.getBiomeRegistry(world).func_177774_c((Object)biome);
    }

    public static Biome getBiomeByRegistryName(ResourceLocation biomeName, IWorld world) {
        return (Biome)LOTRBiomes.getBiomeRegistry(world).func_82594_a(biomeName);
    }

    private static MutableRegistry<Biome> getBiomeRegistry(IWorld world) {
        return world.func_241828_r().func_243612_b(Registry.field_239720_u_);
    }

    public static ServerWorld getServerBiomeContextWorld() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return server != null ? server.func_241755_D_() : null;
    }

    public static int getBiomeID(PreRegisteredLOTRBiome preparedBiome, IWorld world) {
        return LOTRBiomes.getBiomeIDByRegistryName(preparedBiome.getRegistryName(), world);
    }

    public static int getBiomeID(LOTRBiomeWrapper biomeWrapper, IWorld world) {
        return LOTRBiomes.getBiomeIDByRegistryName(biomeWrapper.getBiomeRegistryName(), world);
    }

    public static int getBiomeIDByRegistryName(ResourceLocation biomeName, IWorld world) {
        MutableRegistry<Biome> reg = LOTRBiomes.getBiomeRegistry(world);
        return reg.func_148757_b(reg.func_82594_a(biomeName));
    }

    public static int getBiomeID(Biome biome, IWorld world) {
        return LOTRBiomes.getBiomeRegistry(world).func_148757_b((Object)biome);
    }

    public static Biome getBiomeByID(int biomeID, IWorld world) {
        return (Biome)LOTRBiomes.getBiomeRegistry(world).func_148745_a(biomeID);
    }

    public static boolean areBiomesEqual(Biome biome1, Biome biome2, IWorld world) {
        return LOTRBiomes.getBiomeRegistryName(biome1, world).equals((Object)LOTRBiomes.getBiomeRegistryName(biome2, world));
    }

    public static LOTRBiomeWrapper getWrapperFor(Biome biome, IWorld world) {
        ResourceLocation key = LOTRBiomes.getBiomeRegistryName(biome, world);
        if (BIOME_WRAPPER_OBJECTS_BY_NAME.containsKey(key)) {
            return BIOME_WRAPPER_OBJECTS_BY_NAME.get(key);
        }
        return VanillaPlaceholderLOTRBiome.makeWrapperFor(world, biome);
    }

    public static ITextComponent getBiomeDisplayName(Biome biome, IWorld world) {
        ResourceLocation key = LOTRBiomes.getBiomeRegistryName(biome, world);
        return new TranslationTextComponent(String.format("biome.%s.%s", key.func_110624_b(), key.func_110623_a()));
    }

    private static <SC extends ISurfaceBuilderConfig, S extends SurfaceBuilder<SC>> S preRegSurfaceBuilder(String name, S surfaceBuilder) {
        return (S)RegistryOrderHelper.preRegObject(SURFACE_BUILDERS, name, surfaceBuilder);
    }
}

