/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.init;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lotr.common.entity.VanillaEntitySpawnChanges;
import lotr.common.entity.animal.CaracalEntity;
import lotr.common.entity.item.FallingTreasureBlockEntity;
import lotr.common.entity.item.LOTRBoatEntity;
import lotr.common.entity.item.RingPortalEntity;
import lotr.common.entity.misc.AlignmentBonusEntity;
import lotr.common.entity.npc.AbstractMannishEntity;
import lotr.common.entity.npc.BlueDwarfArcherEntity;
import lotr.common.entity.npc.BlueDwarfEntity;
import lotr.common.entity.npc.BlueDwarfWarriorEntity;
import lotr.common.entity.npc.CoastSouthronArcherEntity;
import lotr.common.entity.npc.CoastSouthronEntity;
import lotr.common.entity.npc.CoastSouthronWarriorEntity;
import lotr.common.entity.npc.DaleBowmanEntity;
import lotr.common.entity.npc.DaleManEntity;
import lotr.common.entity.npc.DaleSoldierEntity;
import lotr.common.entity.npc.DunlendingBowmanEntity;
import lotr.common.entity.npc.DunlendingEntity;
import lotr.common.entity.npc.DunlendingWarriorEntity;
import lotr.common.entity.npc.DwarfArcherEntity;
import lotr.common.entity.npc.DwarfEntity;
import lotr.common.entity.npc.DwarfWarriorEntity;
import lotr.common.entity.npc.ElfEntity;
import lotr.common.entity.npc.GaladhrimElfEntity;
import lotr.common.entity.npc.GaladhrimWarriorEntity;
import lotr.common.entity.npc.GondorArcherEntity;
import lotr.common.entity.npc.GondorManEntity;
import lotr.common.entity.npc.GondorSoldierEntity;
import lotr.common.entity.npc.GundabadOrcArcherEntity;
import lotr.common.entity.npc.GundabadOrcEntity;
import lotr.common.entity.npc.HarnedhrimEntity;
import lotr.common.entity.npc.HarnennorArcherEntity;
import lotr.common.entity.npc.HarnennorWarriorEntity;
import lotr.common.entity.npc.HobbitEntity;
import lotr.common.entity.npc.LindonElfEntity;
import lotr.common.entity.npc.LindonWarriorEntity;
import lotr.common.entity.npc.MordorOrcArcherEntity;
import lotr.common.entity.npc.MordorOrcEntity;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.entity.npc.OrcEntity;
import lotr.common.entity.npc.RivendellElfEntity;
import lotr.common.entity.npc.RivendellWarriorEntity;
import lotr.common.entity.npc.RohanManEntity;
import lotr.common.entity.npc.RohirrimBowmanEntity;
import lotr.common.entity.npc.RohirrimWarriorEntity;
import lotr.common.entity.npc.UmbarArcherEntity;
import lotr.common.entity.npc.UmbarManEntity;
import lotr.common.entity.npc.UmbarSoldierEntity;
import lotr.common.entity.npc.UrukArcherEntity;
import lotr.common.entity.npc.UrukEntity;
import lotr.common.entity.projectile.SmokeRingEntity;
import lotr.common.entity.projectile.SpearEntity;
import lotr.common.entity.projectile.ThrownPlateEntity;
import lotr.common.init.LOTREntityClassifications;
import lotr.common.item.LOTRSpawnEggItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class LOTREntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"lotr");
    private static final Map<EntityType<? extends LivingEntity>, Supplier<AttributeModifierMap.MutableAttribute>> ENTITY_ATTRIBUTE_FACTORIES = new HashMap<EntityType<? extends LivingEntity>, Supplier<AttributeModifierMap.MutableAttribute>>();
    private static final Map<RegistryObject<? extends EntityType>, SpawnEggColors> DEFERRED_SPAWN_EGG_COLORS = new HashMap<RegistryObject<? extends EntityType>, SpawnEggColors>();
    public static final RegistryObject<EntityType<RingPortalEntity>> RING_PORTAL = LOTREntities.regEntity("ring_portal", RingPortalEntity::new, EntityClassification.MISC, 3.0f, 1.5f, 10, 3);
    public static final RegistryObject<EntityType<ThrownPlateEntity>> THROWN_PLATE = LOTREntities.regEntity("thrown_plate", ThrownPlateEntity::new, EntityClassification.MISC, 0.5f, 0.5f, 4, 10);
    public static final RegistryObject<EntityType<LOTRBoatEntity>> BOAT = LOTREntities.regEntity("boat", LOTRBoatEntity::new, EntityClassification.MISC, 1.375f, 0.5625f, 10, 3);
    public static final RegistryObject<EntityType<FallingTreasureBlockEntity>> FALLING_TREASURE_BLOCK = LOTREntities.regEntity("falling_treasure_block", FallingTreasureBlockEntity::new, EntityClassification.MISC, 0.98f, 0.98f, 10, 20);
    public static final RegistryObject<EntityType<SmokeRingEntity>> SMOKE_RING = LOTREntities.regEntity("smoke_ring", SmokeRingEntity::new, EntityClassification.MISC, 0.5f, 0.5f, 4, 10, EntityType.Builder::func_220320_c);
    public static final RegistryObject<EntityType<AlignmentBonusEntity>> ALIGNMENT_BONUS = LOTREntities.regClientsideEntity("alignment_bonus", AlignmentBonusEntity::new, EntityClassification.MISC, 0.5f, 0.5f);
    public static final RegistryObject<EntityType<SpearEntity>> SPEAR = LOTREntities.regEntity("spear", SpearEntity::new, EntityClassification.MISC, 0.5f, 0.5f, 4, 20);
    public static final RegistryObject<EntityType<HobbitEntity>> HOBBIT = LOTREntities.regNPC("hobbit", HobbitEntity::new, HobbitEntity::regAttrs, EntitySizeHolder.hobbitSize(), SpawnEggColors.egg(0xFF9F7F, 8010275));
    public static final RegistryObject<EntityType<MordorOrcEntity>> MORDOR_ORC = LOTREntities.regNPC("mordor_orc", MordorOrcEntity::new, MordorOrcEntity::regAttrs, EntitySizeHolder.orcSize(), SpawnEggColors.egg(0x332B22, 7042407));
    public static final RegistryObject<EntityType<GondorManEntity>> GONDOR_MAN = LOTREntities.regNPC("gondor_man", GondorManEntity::new, AbstractMannishEntity::regAttrs, EntitySizeHolder.manSize(), SpawnEggColors.egg(13547685, 5652538));
    public static final RegistryObject<EntityType<GaladhrimElfEntity>> GALADHRIM_ELF = LOTREntities.regNPC("galadhrim_elf", GaladhrimElfEntity::new, ElfEntity::regAttrs, EntitySizeHolder.elfSize(), SpawnEggColors.egg(9337185, 15920555));
    public static final RegistryObject<EntityType<GondorSoldierEntity>> GONDOR_SOLDIER = LOTREntities.regNPC("gondor_soldier", GondorSoldierEntity::new, GondorSoldierEntity::regAttrs, EntitySizeHolder.manSize(), SpawnEggColors.egg(5327948, 15063770));
    public static final RegistryObject<EntityType<DwarfEntity>> DWARF = LOTREntities.regNPC("dwarf", DwarfEntity::new, DwarfEntity::regAttrs, EntitySizeHolder.dwarfSize(), SpawnEggColors.egg(16353133, 15357472));
    public static final RegistryObject<EntityType<DwarfWarriorEntity>> DWARF_WARRIOR = LOTREntities.regNPC("dwarf_warrior", DwarfWarriorEntity::new, DwarfWarriorEntity::regAttrs, EntitySizeHolder.dwarfSize(), SpawnEggColors.egg(0x22282A, 7108730));
    public static final RegistryObject<EntityType<GaladhrimWarriorEntity>> GALADHRIM_WARRIOR = LOTREntities.regNPC("galadhrim_warrior", GaladhrimWarriorEntity::new, GaladhrimWarriorEntity::regAttrs, EntitySizeHolder.elfSize(), SpawnEggColors.egg(12697274, 15382870));
    public static final RegistryObject<EntityType<UrukEntity>> URUK = LOTREntities.regNPC("uruk", UrukEntity::new, UrukEntity::regAttrs, EntitySizeHolder.urukSize(), SpawnEggColors.egg(2369050, 5790015));
    public static final RegistryObject<EntityType<RohanManEntity>> ROHAN_MAN = LOTREntities.regNPC("rohan_man", RohanManEntity::new, AbstractMannishEntity::regAttrs, EntitySizeHolder.manSize(), SpawnEggColors.egg(16424833, 13406801));
    public static final RegistryObject<EntityType<RohirrimWarriorEntity>> ROHIRRIM_WARRIOR = LOTREntities.regNPC("rohirrim_warrior", RohirrimWarriorEntity::new, RohirrimWarriorEntity::regAttrs, EntitySizeHolder.manSize(), SpawnEggColors.egg(5524296, 13546384));
    public static final RegistryObject<EntityType<GundabadOrcEntity>> GUNDABAD_ORC = LOTREntities.regNPC("gundabad_orc", GundabadOrcEntity::new, OrcEntity::regAttrs, EntitySizeHolder.orcSize(), SpawnEggColors.egg(3352346, 8548435));
    public static final RegistryObject<EntityType<DaleManEntity>> DALE_MAN = LOTREntities.regNPC("dale_man", DaleManEntity::new, AbstractMannishEntity::regAttrs, EntitySizeHolder.manSize(), SpawnEggColors.egg(16755851, 5252113));
    public static final RegistryObject<EntityType<DaleSoldierEntity>> DALE_SOLDIER = LOTREntities.regNPC("dale_soldier", DaleSoldierEntity::new, AbstractMannishEntity::regAttrs, EntitySizeHolder.manSize(), SpawnEggColors.egg(12034458, 480127));
    public static final RegistryObject<EntityType<DunlendingEntity>> DUNLENDING = LOTREntities.regNPC("dunlending", DunlendingEntity::new, AbstractMannishEntity::regAttrs, EntitySizeHolder.manSize(), SpawnEggColors.egg(15897714, 3679258));
    public static final RegistryObject<EntityType<DunlendingWarriorEntity>> DUNLENDING_WARRIOR = LOTREntities.regNPC("dunlending_warrior", DunlendingWarriorEntity::new, AbstractMannishEntity::regAttrs, EntitySizeHolder.manSize(), SpawnEggColors.egg(5192753, 9337975));
    public static final RegistryObject<EntityType<LindonElfEntity>> LINDON_ELF = LOTREntities.regNPC("lindon_elf", LindonElfEntity::new, ElfEntity::regAttrs, EntitySizeHolder.elfSize(), SpawnEggColors.egg(16761223, 15721387));
    public static final RegistryObject<EntityType<LindonWarriorEntity>> LINDON_WARRIOR = LOTREntities.regNPC("lindon_warrior", LindonWarriorEntity::new, LindonWarriorEntity::regAttrs, EntitySizeHolder.elfSize(), SpawnEggColors.egg(0xE3E3E8, 7040410));
    public static final RegistryObject<EntityType<RivendellElfEntity>> RIVENDELL_ELF = LOTREntities.regNPC("rivendell_elf", RivendellElfEntity::new, ElfEntity::regAttrs, EntitySizeHolder.elfSize(), SpawnEggColors.egg(16761223, 15721387));
    public static final RegistryObject<EntityType<RivendellWarriorEntity>> RIVENDELL_WARRIOR = LOTREntities.regNPC("rivendell_warrior", RivendellWarriorEntity::new, RivendellWarriorEntity::regAttrs, EntitySizeHolder.elfSize(), SpawnEggColors.egg(14738662, 10723248));
    public static final RegistryObject<EntityType<CoastSouthronEntity>> COAST_SOUTHRON = LOTREntities.regNPC("coast_southron", CoastSouthronEntity::new, AbstractMannishEntity::regAttrs, EntitySizeHolder.manSize(), SpawnEggColors.egg(10779229, 0x2D2D2D));
    public static final RegistryObject<EntityType<CoastSouthronWarriorEntity>> COAST_SOUTHRON_WARRIOR = LOTREntities.regNPC("coast_southron_warrior", CoastSouthronWarriorEntity::new, CoastSouthronWarriorEntity::regAttrs, EntitySizeHolder.manSize(), SpawnEggColors.egg(0x212121, 0xB51B1B));
    public static final RegistryObject<EntityType<HarnedhrimEntity>> HARNEDHRIM = LOTREntities.regNPC("harnedhrim", HarnedhrimEntity::new, AbstractMannishEntity::regAttrs, EntitySizeHolder.manSize(), SpawnEggColors.egg(9854777, 1181187));
    public static final RegistryObject<EntityType<HarnennorWarriorEntity>> HARNENNOR_WARRIOR = LOTREntities.regNPC("harnennor_warrior", HarnennorWarriorEntity::new, HarnennorWarriorEntity::regAttrs, EntitySizeHolder.manSize(), SpawnEggColors.egg(0x6B1111, 14852422));
    public static final RegistryObject<EntityType<BlueDwarfEntity>> BLUE_MOUNTAINS_DWARF = LOTREntities.regNPC("blue_mountains_dwarf", BlueDwarfEntity::new, DwarfEntity::regAttrs, EntitySizeHolder.dwarfSize(), SpawnEggColors.egg(16353133, 15357472));
    public static final RegistryObject<EntityType<BlueDwarfWarriorEntity>> BLUE_MOUNTAINS_WARRIOR = LOTREntities.regNPC("blue_mountains_warrior", BlueDwarfWarriorEntity::new, BlueDwarfWarriorEntity::regAttrs, EntitySizeHolder.dwarfSize(), SpawnEggColors.egg(3161673, 6257551));
    public static final RegistryObject<EntityType<UmbarManEntity>> UMBAR_MAN = LOTREntities.regNPC("umbar_man", UmbarManEntity::new, AbstractMannishEntity::regAttrs, EntitySizeHolder.manSize(), SpawnEggColors.egg(10779229, 0x2D2D2D));
    public static final RegistryObject<EntityType<UmbarSoldierEntity>> UMBAR_SOLDIER = LOTREntities.regNPC("umbar_soldier", UmbarSoldierEntity::new, UmbarSoldierEntity::regAttrs, EntitySizeHolder.manSize(), SpawnEggColors.egg(0x2D2D28, 13540692));
    public static final RegistryObject<EntityType<GondorArcherEntity>> GONDOR_ARCHER = LOTREntities.regNPC("gondor_archer", GondorArcherEntity::new, GondorSoldierEntity::regAttrs, EntitySizeHolder.manSize(), SpawnEggColors.egg(5327948, 15063770));
    public static final RegistryObject<EntityType<RohirrimBowmanEntity>> ROHIRRIM_BOWMAN = LOTREntities.regNPC("rohirrim_bowman", RohirrimBowmanEntity::new, RohirrimWarriorEntity::regAttrs, EntitySizeHolder.manSize(), SpawnEggColors.egg(5524296, 13546384));
    public static final RegistryObject<EntityType<DaleBowmanEntity>> DALE_BOWMAN = LOTREntities.regNPC("dale_bowman", DaleBowmanEntity::new, AbstractMannishEntity::regAttrs, EntitySizeHolder.manSize(), SpawnEggColors.egg(12034458, 480127));
    public static final RegistryObject<EntityType<DunlendingBowmanEntity>> DUNLENDING_BOWMAN = LOTREntities.regNPC("dunlending_bowman", DunlendingBowmanEntity::new, AbstractMannishEntity::regAttrs, EntitySizeHolder.manSize(), SpawnEggColors.egg(5192753, 9337975));
    public static final RegistryObject<EntityType<CoastSouthronArcherEntity>> COAST_SOUTHRON_ARCHER = LOTREntities.regNPC("coast_southron_archer", CoastSouthronArcherEntity::new, CoastSouthronWarriorEntity::regAttrs, EntitySizeHolder.manSize(), SpawnEggColors.egg(0x212121, 0xB51B1B));
    public static final RegistryObject<EntityType<HarnennorArcherEntity>> HARNENNOR_ARCHER = LOTREntities.regNPC("harnennor_archer", HarnennorArcherEntity::new, HarnennorWarriorEntity::regAttrs, EntitySizeHolder.manSize(), SpawnEggColors.egg(0x6B1111, 14852422));
    public static final RegistryObject<EntityType<UmbarArcherEntity>> UMBAR_ARCHER = LOTREntities.regNPC("umbar_archer", UmbarArcherEntity::new, UmbarSoldierEntity::regAttrs, EntitySizeHolder.manSize(), SpawnEggColors.egg(0x2D2D28, 13540692));
    public static final RegistryObject<EntityType<MordorOrcArcherEntity>> MORDOR_ORC_ARCHER = LOTREntities.regNPC("mordor_orc_archer", MordorOrcArcherEntity::new, MordorOrcEntity::regAttrs, EntitySizeHolder.orcSize(), SpawnEggColors.egg(0x332B22, 7042407));
    public static final RegistryObject<EntityType<GundabadOrcArcherEntity>> GUNDABAD_ORC_ARCHER = LOTREntities.regNPC("gundabad_orc_archer", GundabadOrcArcherEntity::new, OrcEntity::regAttrs, EntitySizeHolder.orcSize(), SpawnEggColors.egg(3352346, 8548435));
    public static final RegistryObject<EntityType<UrukArcherEntity>> URUK_ARCHER = LOTREntities.regNPC("uruk_archer", UrukArcherEntity::new, UrukEntity::regAttrs, EntitySizeHolder.urukSize(), SpawnEggColors.egg(2369050, 5790015));
    public static final RegistryObject<EntityType<DwarfArcherEntity>> DWARF_ARCHER = LOTREntities.regNPC("dwarf_archer", DwarfArcherEntity::new, DwarfWarriorEntity::regAttrs, EntitySizeHolder.dwarfSize(), SpawnEggColors.egg(0x22282A, 7108730));
    public static final RegistryObject<EntityType<BlueDwarfArcherEntity>> BLUE_MOUNTAINS_ARCHER = LOTREntities.regNPC("blue_mountains_archer", BlueDwarfArcherEntity::new, BlueDwarfWarriorEntity::regAttrs, EntitySizeHolder.dwarfSize(), SpawnEggColors.egg(3161673, 6257551));
    public static final RegistryObject<EntityType<CaracalEntity>> CARACAL = LOTREntities.regAnimal("caracal", CaracalEntity::new, CaracalEntity::regAttrs, EntitySizeHolder.size(0.83f, 0.9f), 10, 3, SpawnEggColors.egg(13806980, 12093272));

    public static void register() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ENTITIES.register(bus);
        bus.addGenericListener(EntityType.class, VanillaEntitySpawnChanges::makeChanges);
        bus.addGenericListener(EntityType.class, LOTREntities::addEntitySpawnEggsToMap);
    }

    private static <T extends Entity> RegistryObject<EntityType<T>> regEntity(String key, EntityType.IFactory<T> factory, EntityClassification classif, float width, float height, Consumer<EntityType.Builder<T>> extraProps, Consumer<EntityType<T>> builtTypeConsumer) {
        return ENTITIES.register(key, () -> {
            EntityType.Builder builder = EntityType.Builder.func_220322_a((EntityType.IFactory)factory, (EntityClassification)classif).func_220321_a(width, height);
            extraProps.accept(builder);
            EntityType builtType = builder.func_206830_a(new ResourceLocation("lotr", key).toString());
            builtTypeConsumer.accept(builtType);
            return builtType;
        });
    }

    private static <T extends Entity> RegistryObject<EntityType<T>> regEntity(String key, EntityType.IFactory<T> factory, EntityClassification classif, float width, float height) {
        return LOTREntities.regEntity(key, factory, classif, width, height, builder -> {}, builtType -> {});
    }

    private static <T extends Entity> RegistryObject<EntityType<T>> regEntity(String key, EntityType.IFactory<T> factory, EntityClassification classif, float width, float height, int trackRange, int updateFreq) {
        return LOTREntities.regEntity(key, factory, classif, width, height, trackRange, updateFreq, builder -> {});
    }

    private static <T extends Entity> RegistryObject<EntityType<T>> regEntity(String key, EntityType.IFactory<T> factory, EntityClassification classif, float width, float height, int trackRange, int updateFreq, Consumer<EntityType.Builder<T>> extraProps) {
        return LOTREntities.regEntity(key, factory, classif, width, height, extraProps.andThen(builder -> {
            builder.setTrackingRange(trackRange);
            builder.setUpdateInterval(updateFreq);
        }), builtType -> {});
    }

    private static <T extends Entity> RegistryObject<EntityType<T>> regClientsideEntity(String key, EntityType.IFactory<T> factory, EntityClassification classif, float width, float height) {
        return LOTREntities.regEntity(key, factory, classif, width, height, builder -> builder.func_200706_c().func_200705_b(), builtType -> {});
    }

    private static <T extends MobEntity> RegistryObject<EntityType<T>> regLiving(String key, EntityType.IFactory<T> factory, Supplier<AttributeModifierMap.MutableAttribute> attribFactory, EntityClassification classif, EntitySizeHolder size, int trackRange, int updateFreq, boolean velUpdates, SpawnEggColors spawnEgg, EntitySpawnPlacementRegistry.PlacementType placementType, Heightmap.Type heightmapType, EntitySpawnPlacementRegistry.IPlacementPredicate<T> placementPredicate) {
        RegistryObject<EntityType<T>> regType = LOTREntities.regEntity(key, factory, classif, size.width, size.height, builder -> {
            builder.setTrackingRange(trackRange);
            builder.setUpdateInterval(updateFreq);
            builder.setShouldReceiveVelocityUpdates(velUpdates);
        }, builtType -> {
            ENTITY_ATTRIBUTE_FACTORIES.put((EntityType<? extends LivingEntity>)builtType, attribFactory);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)builtType, (EntitySpawnPlacementRegistry.PlacementType)placementType, (Heightmap.Type)heightmapType, (EntitySpawnPlacementRegistry.IPlacementPredicate)placementPredicate);
        });
        DEFERRED_SPAWN_EGG_COLORS.put(regType, spawnEgg);
        return regType;
    }

    private static <T extends NPCEntity> RegistryObject<EntityType<T>> regNPC(String key, EntityType.IFactory<T> factory, Supplier<AttributeModifierMap.MutableAttribute> attribFactory, EntitySizeHolder size, SpawnEggColors spawnEgg) {
        return LOTREntities.regLiving(key, factory, attribFactory, LOTREntityClassifications.NPC, size, 10, 3, true, spawnEgg, EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
    }

    private static <T extends AnimalEntity> RegistryObject<EntityType<T>> regAnimal(String key, EntityType.IFactory<T> factory, Supplier<AttributeModifierMap.MutableAttribute> attribFactory, EntitySizeHolder size, int trackRange, int updateFreq, SpawnEggColors spawnEgg) {
        return LOTREntities.regAnimal(key, factory, attribFactory, size, trackRange, updateFreq, spawnEgg, EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
    }

    private static <T extends AnimalEntity> RegistryObject<EntityType<T>> regAnimal(String key, EntityType.IFactory<T> factory, Supplier<AttributeModifierMap.MutableAttribute> attribFactory, EntitySizeHolder size, int trackRange, int updateFreq, SpawnEggColors spawnEgg, EntitySpawnPlacementRegistry.PlacementType placementType, Heightmap.Type heightmapType, EntitySpawnPlacementRegistry.IPlacementPredicate<T> placementPredicate) {
        return LOTREntities.regLiving(key, factory, attribFactory, EntityClassification.CREATURE, size, trackRange, updateFreq, true, spawnEgg, placementType, heightmapType, placementPredicate);
    }

    public static void registerEntityTypeAttributes(EntityAttributeCreationEvent event) {
        for (Map.Entry<EntityType<? extends LivingEntity>, Supplier<AttributeModifierMap.MutableAttribute>> entry : ENTITY_ATTRIBUTE_FACTORIES.entrySet()) {
            EntityType<? extends LivingEntity> type = entry.getKey();
            Supplier<AttributeModifierMap.MutableAttribute> attributeFactory = entry.getValue();
            event.put(type, attributeFactory.get().func_233813_a_());
        }
    }

    public static void createEntitySpawnEggs(RegistryEvent.Register<Item> event) {
        IForgeRegistry itemReg = event.getRegistry();
        if (itemReg != ForgeRegistries.ITEMS) {
            return;
        }
        DEFERRED_SPAWN_EGG_COLORS.entrySet().forEach(entry -> {
            RegistryObject regType = (RegistryObject)entry.getKey();
            SpawnEggColors colors = (SpawnEggColors)entry.getValue();
            ResourceLocation entityTypeName = regType.getId();
            ResourceLocation itemName = new ResourceLocation(entityTypeName.func_110624_b(), String.format("%s_spawn_egg", entityTypeName.func_110623_a()));
            Item spawnEggItem = (Item)new LOTRSpawnEggItem((Supplier<? extends EntityType>)regType, colors).setRegistryName(itemName);
            itemReg.register((IForgeRegistryEntry)spawnEggItem);
        });
    }

    private static void addEntitySpawnEggsToMap(RegistryEvent.Register<EntityType<?>> event) {
        if (event.getRegistry() != ForgeRegistries.ENTITIES) {
            return;
        }
        LOTRSpawnEggItem.afterEntityRegistry();
    }

    public static class SpawnEggColors {
        public final int primaryColor;
        public final int secondaryColor;

        public SpawnEggColors(int primary, int secondary) {
            this.primaryColor = primary;
            this.secondaryColor = secondary;
        }

        public static SpawnEggColors egg(int primary, int secondary) {
            return new SpawnEggColors(primary, secondary);
        }
    }

    public static class EntitySizeHolder {
        public final float width;
        public final float height;

        private EntitySizeHolder(float w, float h) {
            this.width = w;
            this.height = h;
        }

        public static EntitySizeHolder size(float w, float h) {
            return new EntitySizeHolder(w, h);
        }

        public static EntitySizeHolder hobbitSize() {
            return EntitySizeHolder.size(0.45f, 1.2f);
        }

        public static EntitySizeHolder manSize() {
            return EntitySizeHolder.size(0.6f, 1.8f);
        }

        public static EntitySizeHolder elfSize() {
            return EntitySizeHolder.manSize();
        }

        public static EntitySizeHolder dwarfSize() {
            return EntitySizeHolder.size(0.5f, 1.5f);
        }

        public static EntitySizeHolder orcSize() {
            return EntitySizeHolder.size(0.5f, 1.55f);
        }

        public static EntitySizeHolder urukSize() {
            return EntitySizeHolder.manSize();
        }
    }
}

