/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.init;

import java.util.Comparator;
import java.util.function.Supplier;
import lotr.common.init.LOTRBlocks;
import lotr.common.init.LOTREntities;
import lotr.common.init.LOTRItems;
import lotr.common.item.LOTRSpawnEggItem;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LOTRItemGroups {
    public static final ItemGroup BLOCKS = new LOTRItemGroup("blocks", () -> (Block)LOTRBlocks.GONDOR_BRICK.get());
    public static final ItemGroup UTIL = new LOTRItemGroup("util", () -> (Block)LOTRBlocks.DWARVEN_CRAFTING_TABLE.get());
    public static final ItemGroup DECO = new LOTRItemGroup("decorations", () -> (Block)LOTRBlocks.SIMBELMYNE.get());
    public static final ItemGroup MATERIALS = new LOTRItemGroup("materials", () -> (Item)LOTRItems.MITHRIL_INGOT.get());
    public static final ItemGroup MISC = new LOTRItemGroup("misc", () -> (Item)LOTRItems.GOLD_RING.get());
    public static final ItemGroup FOOD = new LOTRItemGroup("food", () -> (Item)LOTRItems.LEMBAS.get());
    public static final ItemGroup TOOLS = new LOTRItemGroup("tools", () -> (Item)LOTRItems.DWARVEN_PICKAXE.get());
    public static final ItemGroup COMBAT = new LOTRItemGroup("combat", () -> (Item)LOTRItems.GONDOR_SWORD.get());
    public static final ItemGroup STORY = new LOTRItemGroup("story", () -> (Item)LOTRItems.RED_BOOK.get());
    public static final ItemGroup SPAWNERS = new LOTRItemGroup("spawners", () -> LOTRSpawnEggItem.getModSpawnEgg((EntityType)LOTREntities.HOBBIT.get()));

    public static class LOTRItemGroup
    extends ItemGroup {
        private final Supplier<? extends IItemProvider> iconSup;

        public LOTRItemGroup(String s, Supplier<? extends IItemProvider> itemSup) {
            super("lotr." + s);
            this.iconSup = itemSup;
        }

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack func_78016_d() {
            return new ItemStack(this.iconSup.get());
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_78018_a(NonNullList<ItemStack> items) {
            super.func_78018_a(items);
            items.sort(Comparator.comparing(LOTRItems::getCreativeTabOrderForItem));
        }
    }
}

