/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.item;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import lotr.common.LOTRLog;
import lotr.common.entity.npc.OrcEntity;
import lotr.common.item.LOTRShieldItem;
import lotr.common.item.SmokingPipeItem;
import lotr.common.item.SpearItem;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.Items;
import net.minecraft.item.SwordItem;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryManager;

public class LOTRItemProperties {
    private static final List<PreparedItemProperty> preparedItemProperties = new ArrayList<PreparedItemProperty>();
    private static final List<PreparedGlobalProperty> preparedGlobalProperties = new ArrayList<PreparedGlobalProperty>();
    private static final PreparedGlobalProperty SNEAKING = PreparedGlobalProperty.prepare(new ResourceLocation("lotr", "sneaking"), (itemstack, world, entity) -> entity != null && entity.func_225608_bj_() ? 1.0f : 0.0f);
    public static final float ELVEN_GLOW_RANGE = 24.0f;
    private static final PreparedItemProperty ELVEN_GLOW = PreparedItemProperty.prepare(SwordItem.class, new ResourceLocation("lotr", "elven_glow"), (itemstack, world, entity) -> world != null && entity != null && !world.func_225316_b(OrcEntity.class, entity.func_174813_aQ().func_186662_g(24.0), EntityPredicates.field_212545_b).isEmpty() ? 1.0f : 0.0f);
    private static final PreparedItemProperty SMOKING_PIPE_COLOR = PreparedItemProperty.prepare(SmokingPipeItem.class, new ResourceLocation("lotr", "pipe_color"), (itemstack, world, entity) -> itemstack.func_77973_b() instanceof SmokingPipeItem ? (float)SmokingPipeItem.getSmokeColor(itemstack).func_196059_a() : 0.0f);
    private static final PreparedItemProperty SMOKING_PIPE_MAGIC = PreparedItemProperty.prepare(SmokingPipeItem.class, new ResourceLocation("lotr", "pipe_is_magic"), (itemstack, world, entity) -> itemstack.func_77973_b() instanceof SmokingPipeItem && SmokingPipeItem.isMagicSmoke(itemstack) ? 1.0f : 0.0f);
    private static final PreparedItemProperty REF_SHIELD_BLOCKING = PreparedItemProperty.copyFromVanillaItem(LOTRShieldItem.class, Items.field_185159_cQ, new ResourceLocation("blocking"));
    private static final PreparedItemProperty REF_SPEAR_PULLING = PreparedItemProperty.copyFromVanillaItem(SpearItem.class, Items.field_151031_f, new ResourceLocation("pulling"));

    public static void registerProperties() {
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            preparedItemProperties.stream().filter(prop -> prop.shouldApplyTo(item)).forEach(prop -> ItemModelsProperties.func_239418_a_((Item)item, (ResourceLocation)prop.key, (IItemPropertyGetter)prop.getter));
        }
        preparedItemProperties.clear();
        try {
            Method m_regGlobal = ObfuscationReflectionHelper.findMethod(ItemModelsProperties.class, (String)"func_239420_a_", (Class[])new Class[]{ResourceLocation.class, IItemPropertyGetter.class});
            for (PreparedProperty preparedProperty : preparedGlobalProperties) {
                m_regGlobal.invoke(null, preparedProperty.key, preparedProperty.getter);
            }
        }
        catch (Exception e) {
            LOTRLog.error("Error registering global item properties!");
            e.printStackTrace();
        }
        preparedGlobalProperties.clear();
    }

    private static final class PreparedGlobalProperty
    extends PreparedProperty {
        private PreparedGlobalProperty(ResourceLocation key, IItemPropertyGetter getter) {
            super(key, getter);
        }

        public static PreparedGlobalProperty prepare(ResourceLocation key, IItemPropertyGetter getter) {
            PreparedGlobalProperty prop = new PreparedGlobalProperty(key, getter);
            preparedGlobalProperties.add(prop);
            return prop;
        }
    }

    private static final class PreparedItemProperty
    extends PreparedProperty {
        public final Predicate<Item> isApplicable;

        private PreparedItemProperty(Predicate<Item> isApplicable, ResourceLocation key, IItemPropertyGetter getter) {
            super(key, getter);
            this.isApplicable = isApplicable;
        }

        public boolean shouldApplyTo(Item item) {
            return this.isApplicable.test(item);
        }

        public static PreparedItemProperty prepare(Predicate<Item> isApplicable, ResourceLocation key, IItemPropertyGetter getter) {
            PreparedItemProperty prop = new PreparedItemProperty(isApplicable, key, getter);
            preparedItemProperties.add(prop);
            return prop;
        }

        public static PreparedItemProperty prepare(Class<? extends Item> baseItemClass, ResourceLocation key, IItemPropertyGetter getter) {
            return PreparedItemProperty.prepare((Item item) -> baseItemClass.isAssignableFrom(item.getClass()), key, getter);
        }

        public static PreparedItemProperty copyFromVanillaItem(Class<? extends Item> baseItemClass, Item vanillaItem, ResourceLocation key) {
            IItemPropertyGetter copiedGetter = ItemModelsProperties.func_239417_a_((Item)PreparedItemProperty.getOriginalVanillaItemBeforeAnyRegistryReplacement(vanillaItem), (ResourceLocation)key);
            if (copiedGetter == null) {
                throw new IllegalArgumentException("Could not find item model property " + key + " to copy from vanilla item " + vanillaItem.getRegistryName());
            }
            return PreparedItemProperty.prepare(baseItemClass, key, copiedGetter);
        }

        private static Item getOriginalVanillaItemBeforeAnyRegistryReplacement(Item vanillaItem) {
            return (Item)RegistryManager.VANILLA.getRegistry(Item.class).getValue(vanillaItem.getRegistryName());
        }
    }

    private static abstract class PreparedProperty {
        public final ResourceLocation key;
        public final IItemPropertyGetter getter;

        protected PreparedProperty(ResourceLocation key, IItemPropertyGetter getter) {
            this.key = key;
            this.getter = getter;
        }
    }
}

