/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.item;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import lotr.common.LOTRLog;
import lotr.common.init.LOTREntities;
import lotr.common.init.LOTRItemGroups;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class LOTRSpawnEggItem
extends SpawnEggItem {
    private final Supplier<? extends EntityType> entityTypeSup;
    public static final Set<LOTRSpawnEggItem> ALL_MOD_SPAWN_EGGS = new HashSet<LOTRSpawnEggItem>();
    private static final Map<EntityType<?>, LOTRSpawnEggItem> POST_ENTITY_REGISTRY_SPAWN_EGGS = new HashMap();

    public LOTRSpawnEggItem(Supplier<? extends EntityType> regType, LOTREntities.SpawnEggColors colors) {
        super(null, colors.primaryColor, colors.secondaryColor, new Item.Properties().func_200916_a(LOTRItemGroups.SPAWNERS));
        this.entityTypeSup = regType;
        ALL_MOD_SPAWN_EGGS.add(this);
    }

    public static void afterEntityRegistry() {
        ALL_MOD_SPAWN_EGGS.forEach(spawnEgg -> {
            EntityType entityType = spawnEgg.entityTypeSup.get();
            POST_ENTITY_REGISTRY_SPAWN_EGGS.put((EntityType<?>)entityType, (LOTRSpawnEggItem)((Object)spawnEgg));
        });
        try {
            Map vanillaEggsMap = (Map)ObfuscationReflectionHelper.getPrivateValue(SpawnEggItem.class, null, (String)"field_195987_b");
            vanillaEggsMap.putAll(POST_ENTITY_REGISTRY_SPAWN_EGGS);
        }
        catch (Exception e) {
            LOTRLog.error("Exception adding mod spawn eggs to the vanilla map");
            e.printStackTrace();
        }
        try {
            Map dispenseBehaviorRegistry = (Map)ObfuscationReflectionHelper.getPrivateValue(DispenserBlock.class, null, (String)"field_149943_a");
            IDispenseItemBehavior vanillaSpawnEggDispense = (IDispenseItemBehavior)dispenseBehaviorRegistry.get(Items.field_196165_cw);
            ALL_MOD_SPAWN_EGGS.forEach(spawnEgg -> dispenseBehaviorRegistry.put(spawnEgg, vanillaSpawnEggDispense));
        }
        catch (Exception e) {
            LOTRLog.error("Exception adding mod spawn eggs' dispenser behaviour");
            e.printStackTrace();
        }
    }

    public static LOTRSpawnEggItem getModSpawnEgg(EntityType<?> type) {
        return POST_ENTITY_REGISTRY_SPAWN_EGGS.get(type);
    }

    public EntityType<?> func_208076_b(@Nullable CompoundNBT nbt) {
        EntityType superResult = super.func_208076_b(nbt);
        if (superResult == null) {
            return this.entityTypeSup.get();
        }
        return superResult;
    }
}

