/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.map;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lotr.common.LOTRLog;
import lotr.common.init.LOTRBiomes;
import lotr.common.resources.CombinableMappingsResource;
import lotr.common.util.LOTRUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;

public class BiomeMapColorTable
extends CombinableMappingsResource<Integer, ResourceLocation> {
    public BiomeMapColorTable(Map<Integer, ResourceLocation> colors, int loadOrder, int numCombinedFrom) {
        super(colors, loadOrder, numCombinedFrom);
    }

    public static BiomeMapColorTable read(ResourceLocation colorTableName, JsonObject json) {
        int loadOrder = json.get("load_order").getAsInt();
        HashMap<Integer, ResourceLocation> biomeColors = new HashMap<Integer, ResourceLocation>();
        JsonObject mappingsJson = json.get("biome_colors").getAsJsonObject();
        for (Map.Entry entry : mappingsJson.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            try {
                Object hexColors;
                ResourceLocation biomeName = new ResourceLocation(key);
                if (value.isJsonPrimitive()) {
                    hexColors = ImmutableSet.of((Object)value.getAsString());
                } else if (value.isJsonArray()) {
                    hexColors = new HashSet();
                    for (JsonElement elem : value.getAsJsonArray()) {
                        hexColors.add(elem.getAsString());
                    }
                } else {
                    LOTRLog.warn("Couldn't parse a biome color mappings line in table %s (key = %s, value = %s) - expected value to be either a hex string or an array of hex strings", colorTableName, key, value);
                    continue;
                }
                Iterator iterator = hexColors.iterator();
                while (iterator.hasNext()) {
                    String hexColor = (String)iterator.next();
                    int color = 0;
                    try {
                        color = Integer.parseInt(hexColor, 16);
                    }
                    catch (NumberFormatException e) {
                        LOTRLog.warn("Biome color mapping for %s has invalid color code %s - must be in hex color format (e.g. FFAA33)", biomeName, hexColor);
                    }
                    if (biomeColors.containsKey(color)) {
                        ResourceLocation alreadyMappedBiomeName = (ResourceLocation)biomeColors.get(color);
                        LOTRLog.warn("Biome %s is already mapped to color %s - mappings' colors must be unique!", alreadyMappedBiomeName, hexColor);
                        continue;
                    }
                    biomeColors.put(color, biomeName);
                }
            }
            catch (Exception e) {
                LOTRLog.warn("Couldn't parse a biome color mappings line in table %s: key = %s, value = %s", colorTableName, key, value);
                e.printStackTrace();
            }
        }
        return new BiomeMapColorTable((Map<Integer, ResourceLocation>)biomeColors, loadOrder, 0);
    }

    public static BiomeMapColorTable combine(List<BiomeMapColorTable> colorTables) {
        return BiomeMapColorTable.combine(colorTables, BiomeMapColorTable::new);
    }

    public static BiomeMapColorTable read(PacketBuffer buf) {
        HashMap<Integer, ResourceLocation> biomeColors = new HashMap<Integer, ResourceLocation>();
        int numColors = buf.func_150792_a();
        for (int i = 0; i < numColors; ++i) {
            int color = buf.readInt();
            ResourceLocation biomeName = buf.func_192575_l();
            biomeColors.put(color, biomeName);
        }
        int numCombinedFrom = buf.func_150792_a();
        return new BiomeMapColorTable((Map<Integer, ResourceLocation>)biomeColors, 0, numCombinedFrom);
    }

    public void write(PacketBuffer buf) {
        buf.func_150787_b(this.mappings.size());
        this.mappings.forEach((color, biomeName) -> {
            buf.writeInt(color.intValue());
            buf.func_192572_a(biomeName);
        });
        buf.func_150787_b(this.getNumCombinedFrom());
    }

    public Biome getBiome(int color, IWorld world) {
        ResourceLocation biomeName = (ResourceLocation)this.mappings.get(color);
        if (biomeName != null) {
            Biome biome = LOTRBiomes.getBiomeByRegistryName(biomeName, world);
            if (biome == null) {
                LOTRLog.error("Biome %s (mapped to map color %s) does not exist in the biome registry!", biomeName, LOTRUtil.toPaddedHexString(color));
            }
            return biome;
        }
        return null;
    }
}

