/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.network;

import java.util.function.Supplier;
import lotr.common.LOTRLog;
import lotr.common.data.LOTRLevelData;
import lotr.common.data.MapMarkerDataModule;
import lotr.common.util.UsernameHelper;
import lotr.common.world.map.MapMarker;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class CPacketDeleteMapMarker {
    private final int markerId;

    private CPacketDeleteMapMarker(int markerId) {
        this.markerId = markerId;
    }

    public CPacketDeleteMapMarker(MapMarker marker) {
        this(marker.getId());
    }

    public static void encode(CPacketDeleteMapMarker packet, PacketBuffer buf) {
        buf.func_150787_b(packet.markerId);
    }

    public static CPacketDeleteMapMarker decode(PacketBuffer buf) {
        int markerId = buf.func_150792_a();
        return new CPacketDeleteMapMarker(markerId);
    }

    public static void handle(CPacketDeleteMapMarker packet, Supplier<NetworkEvent.Context> context) {
        int markerId;
        ServerPlayerEntity player = context.get().getSender();
        MapMarkerDataModule markerData = LOTRLevelData.serverInstance().getData((PlayerEntity)player).getMapMarkerData();
        MapMarker marker = markerData.getMarkerById(markerId = packet.markerId);
        if (marker != null) {
            markerData.removeMarker(marker);
        } else {
            LOTRLog.warn("Player %s tried to delete map marker, but no marker for ID %d exists", UsernameHelper.getRawUsername((PlayerEntity)player), markerId);
        }
        context.get().setPacketHandled(true);
    }
}

