/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.network;

import java.util.function.Supplier;
import lotr.common.LOTRGameRules;
import lotr.common.LOTRLog;
import lotr.common.data.FastTravelDataModule;
import lotr.common.data.LOTRLevelData;
import lotr.common.data.LOTRPlayerData;
import lotr.common.init.LOTRWorldTypes;
import lotr.common.network.ByteArrayPacket;
import lotr.common.util.LOTRUtil;
import lotr.common.util.UsernameHelper;
import lotr.common.world.map.Waypoint;
import lotr.common.world.map.WaypointNetworkType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class CPacketFastTravel
extends ByteArrayPacket {
    private CPacketFastTravel(byte[] data) {
        super(data);
    }

    public CPacketFastTravel(Waypoint wp) {
        super((PacketBuffer buf) -> WaypointNetworkType.writeIdentification(buf, wp));
    }

    public static void encode(CPacketFastTravel packet, PacketBuffer buf) {
        CPacketFastTravel.encodeByteData(packet, buf);
    }

    public static CPacketFastTravel decode(PacketBuffer buf) {
        return CPacketFastTravel.decodeByteData(buf, CPacketFastTravel::new);
    }

    public static void handle(CPacketFastTravel packet, Supplier<NetworkEvent.Context> context) {
        ServerPlayerEntity player = context.get().getSender();
        ServerWorld world = player.func_71121_q();
        if (!world.func_82736_K().func_223586_b(LOTRGameRules.FAST_TRAVEL)) {
            LOTRUtil.sendMessage((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("chat.lotr.ft.disabled.gamerule"));
        } else if (!LOTRWorldTypes.hasMapFeatures(world)) {
            LOTRUtil.sendMessage((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("chat.lotr.ft.disabled.worldtype"));
        } else {
            LOTRPlayerData playerData = LOTRLevelData.serverInstance().getData((PlayerEntity)player);
            FastTravelDataModule ftData = playerData.getFastTravelData();
            PacketBuffer waypointData = packet.getBufferedByteData();
            Waypoint waypoint = WaypointNetworkType.readFromIdentification(waypointData, playerData);
            if (waypoint != null && waypoint.verifyFastTravellable(world, (PlayerEntity)player)) {
                if (waypoint.hasPlayerUnlocked((PlayerEntity)player)) {
                    if (ftData.getTimeSinceFT() < ftData.getWaypointFTTime(waypoint, (PlayerEntity)player)) {
                        player.func_71053_j();
                        LOTRUtil.sendMessage((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("chat.lotr.ft.moreTime", new Object[]{waypoint.getDisplayName()}));
                    } else {
                        boolean underAttack = ftData.isUnderAttack(player);
                        if (underAttack) {
                            player.func_71053_j();
                            LOTRUtil.sendMessage((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("chat.lotr.ft.underAttack"));
                        } else {
                            ftData.setTargetWaypoint(waypoint);
                        }
                    }
                } else {
                    LOTRLog.warn("Player %s tried to FT to a waypoint (%s, %s) that they haven't unlocked", UsernameHelper.getRawUsername((PlayerEntity)player), waypoint.getClass().getSimpleName(), waypoint.getRawName());
                }
            }
        }
        context.get().setPacketHandled(true);
    }
}

