/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.network;

import java.util.function.Supplier;
import lotr.common.data.FastTravelDataModule;
import lotr.common.data.LOTRLevelData;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class CPacketToggleShowWaypoints {
    private final boolean showMapWaypoints;
    private final boolean showCustomWaypoints;

    public CPacketToggleShowWaypoints(boolean mapWp, boolean customWp) {
        this.showMapWaypoints = mapWp;
        this.showCustomWaypoints = customWp;
    }

    public static void encode(CPacketToggleShowWaypoints packet, PacketBuffer buf) {
        buf.writeBoolean(packet.showMapWaypoints);
        buf.writeBoolean(packet.showCustomWaypoints);
    }

    public static CPacketToggleShowWaypoints decode(PacketBuffer buf) {
        boolean showMapWaypoints = buf.readBoolean();
        boolean showCustomWaypoints = buf.readBoolean();
        return new CPacketToggleShowWaypoints(showMapWaypoints, showCustomWaypoints);
    }

    public static void handle(CPacketToggleShowWaypoints packet, Supplier<NetworkEvent.Context> context) {
        ServerPlayerEntity player = context.get().getSender();
        FastTravelDataModule ftData = LOTRLevelData.serverInstance().getData((PlayerEntity)player).getFastTravelData();
        ftData.setShowMapWaypoints(packet.showMapWaypoints);
        ftData.setShowCustomWaypoints(packet.showCustomWaypoints);
        context.get().setPacketHandled(true);
    }
}

