/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.network;

import java.util.function.Supplier;
import lotr.common.LOTRLog;
import lotr.common.data.FastTravelDataModule;
import lotr.common.data.LOTRLevelData;
import lotr.common.item.RedBookItem;
import lotr.common.tileentity.CustomWaypointMarkerTileEntity;
import lotr.common.util.LOTRUtil;
import lotr.common.util.UsernameHelper;
import lotr.common.world.map.CustomWaypoint;
import lotr.common.world.map.CustomWaypointStructureHandler;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class CPacketUpdateCustomWaypoint {
    private final int waypointId;
    private final String name;
    private final String lore;
    private final boolean isPublic;

    public CPacketUpdateCustomWaypoint(CustomWaypoint waypoint, String name, String lore, boolean isPublic) {
        this(waypoint.getCustomId(), name, lore, isPublic);
    }

    private CPacketUpdateCustomWaypoint(int waypointId, String name, String lore, boolean isPublic) {
        this.waypointId = waypointId;
        this.name = name;
        this.lore = lore;
        this.isPublic = isPublic;
    }

    public static void encode(CPacketUpdateCustomWaypoint packet, PacketBuffer buf) {
        buf.func_150787_b(packet.waypointId);
        buf.func_180714_a(packet.name);
        buf.func_180714_a(packet.lore);
        buf.writeBoolean(packet.isPublic);
    }

    public static CPacketUpdateCustomWaypoint decode(PacketBuffer buf) {
        int waypointId = buf.func_150792_a();
        String name = buf.func_150789_c(40);
        String lore = buf.func_150789_c(160);
        boolean isPublic = buf.readBoolean();
        return new CPacketUpdateCustomWaypoint(waypointId, name, lore, isPublic);
    }

    public static void handle(CPacketUpdateCustomWaypoint packet, Supplier<NetworkEvent.Context> context) {
        ServerPlayerEntity player = context.get().getSender();
        FastTravelDataModule ftData = LOTRLevelData.serverInstance().getData((PlayerEntity)player).getFastTravelData();
        CPacketUpdateCustomWaypoint.doUpdateCustomWaypoint(packet, player, ftData);
        context.get().setPacketHandled(true);
    }

    private static void doUpdateCustomWaypoint(CPacketUpdateCustomWaypoint packet, ServerPlayerEntity player, FastTravelDataModule ftData) {
        ServerWorld world = player.func_71121_q();
        int waypointId = packet.waypointId;
        CustomWaypoint waypoint = ftData.getCustomWaypointById(waypointId);
        if (waypoint == null) {
            LOTRLog.warn("Player %s tried to update a custom waypoint with nonexistent ID %d", UsernameHelper.getRawUsername((PlayerEntity)player), waypointId);
            return;
        }
        String waypointName = packet.name.trim();
        String waypointLore = packet.lore.trim();
        if (waypointName.isEmpty()) {
            LOTRLog.warn("Player %s tried to update a custom waypoint with a blank name", UsernameHelper.getRawUsername((PlayerEntity)player));
            return;
        }
        if (waypointName.length() > 40) {
            LOTRLog.warn("Player %s tried to update a custom waypoint with a name too long (%s)", UsernameHelper.getRawUsername((PlayerEntity)player), waypointName);
            return;
        }
        if (waypointLore.length() > 160) {
            LOTRLog.warn("Player %s tried to update a custom waypoint with lore too long (%s)", UsernameHelper.getRawUsername((PlayerEntity)player), waypointLore);
            return;
        }
        boolean isPublic = packet.isPublic;
        BlockPos waypointPos = waypoint.getPosition();
        Vector3d playerPos = player.func_213303_ch();
        CustomWaypointMarkerTileEntity marker = CustomWaypointStructureHandler.INSTANCE.getAdjacentWaypointMarker((World)world, waypointPos, null);
        if (marker == null) {
            LOTRLog.warn("Player %s tried to update a custom waypoint where no waypoint structure exists (player pos = %s, clicked pos = %s)", UsernameHelper.getRawUsername((PlayerEntity)player), playerPos.toString(), waypointPos.toString());
            return;
        }
        if (!marker.matchesWaypointReference(waypoint)) {
            LOTRLog.warn("Player %s tried to update a custom waypoint at a marker which doesn't match the target waypoint (player pos = %s, clicked pos = %s)", UsernameHelper.getRawUsername((PlayerEntity)player), playerPos.toString(), waypointPos.toString());
            return;
        }
        if (waypointPos.func_218138_a((IPosition)playerPos, false) >= 64.0) {
            LOTRLog.warn("Player %s tried to update a custom waypoint on a block too far away (player pos = %s, clicked pos = %s)", UsernameHelper.getRawUsername((PlayerEntity)player), playerPos.toString(), waypointPos.toString());
            return;
        }
        if (ftData.updateCustomWaypoint((World)world, waypoint, waypointName, waypointLore, isPublic)) {
            CustomWaypointStructureHandler.INSTANCE.updateWaypointStructure((PlayerEntity)player, waypoint);
            LOTRUtil.sendMessage((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("chat.lotr.cwp.update", new Object[]{waypointName}));
            RedBookItem.playCompleteWaypointActionSound((World)world, waypointPos);
        }
    }
}

