/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.network;

import java.util.function.Supplier;
import lotr.common.LOTRLog;
import lotr.common.LOTRMod;
import lotr.common.data.LOTRLevelData;
import lotr.common.data.LOTRPlayerData;
import lotr.common.fac.Faction;
import lotr.common.fac.FactionSettings;
import lotr.common.fac.FactionSettingsManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SPacketAlignment {
    private final Faction faction;
    private final float alignment;

    public SPacketAlignment(Faction faction, float alignment) {
        this.faction = faction;
        this.alignment = alignment;
    }

    public static void encode(SPacketAlignment packet, PacketBuffer buf) {
        buf.writeInt(packet.faction.getAssignedId());
        buf.writeFloat(packet.alignment);
    }

    public static SPacketAlignment decode(PacketBuffer buf) {
        int factionId;
        FactionSettings facSettings = FactionSettingsManager.clientInstance().getCurrentLoadedFactions();
        Faction faction = facSettings.getFactionByID(factionId = buf.readInt());
        if (faction == null) {
            LOTRLog.warn("Received nonexistent faction ID %d from server", factionId);
        }
        float alignment = buf.readFloat();
        return new SPacketAlignment(faction, alignment);
    }

    public static void handle(SPacketAlignment packet, Supplier<NetworkEvent.Context> context) {
        PlayerEntity player = LOTRMod.PROXY.getClientPlayer();
        LOTRPlayerData pd = LOTRLevelData.clientInstance().getData(player);
        Faction faction = packet.faction;
        float alignment = packet.alignment;
        if (faction != null) {
            pd.getAlignmentData().setAlignment(faction, alignment);
        }
        context.get().setPacketHandled(true);
    }
}

