/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.network;

import java.util.function.Supplier;
import lotr.common.LOTRLog;
import lotr.common.LOTRMod;
import lotr.common.data.FastTravelDataModule;
import lotr.common.data.LOTRLevelData;
import lotr.common.world.map.AdoptedCustomWaypoint;
import lotr.common.world.map.AdoptedCustomWaypointKey;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SPacketDeleteAdoptedCustomWaypoint {
    private final AdoptedCustomWaypointKey adoptedWaypointKey;

    public SPacketDeleteAdoptedCustomWaypoint(AdoptedCustomWaypoint wp) {
        this(wp.getAdoptedKey());
    }

    private SPacketDeleteAdoptedCustomWaypoint(AdoptedCustomWaypointKey key) {
        this.adoptedWaypointKey = key;
    }

    public static void encode(SPacketDeleteAdoptedCustomWaypoint packet, PacketBuffer buf) {
        packet.adoptedWaypointKey.write(buf);
    }

    public static SPacketDeleteAdoptedCustomWaypoint decode(PacketBuffer buf) {
        AdoptedCustomWaypointKey adoptedWaypointKey = AdoptedCustomWaypointKey.read(buf);
        return new SPacketDeleteAdoptedCustomWaypoint(adoptedWaypointKey);
    }

    public static void handle(SPacketDeleteAdoptedCustomWaypoint packet, Supplier<NetworkEvent.Context> context) {
        AdoptedCustomWaypointKey key;
        PlayerEntity player = LOTRMod.PROXY.getClientPlayer();
        FastTravelDataModule ftData = LOTRLevelData.clientInstance().getData(player).getFastTravelData();
        AdoptedCustomWaypoint waypoint = ftData.getAdoptedCustomWaypointByKey(key = packet.adoptedWaypointKey);
        if (waypoint != null) {
            ftData.removeAdoptedCustomWaypoint(player.field_70170_p, waypoint);
        } else {
            LOTRLog.warn("Received adopted custom waypoint deletion from server, but no adopted custom waypoint for (creator %s, ID %d) exists", key.getCreatedPlayer(), key.getWaypointId());
        }
        context.get().setPacketHandled(true);
    }
}

