/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.network;

import java.util.function.Supplier;
import lotr.common.LOTRLog;
import lotr.common.LOTRMod;
import lotr.common.data.LOTRLevelData;
import lotr.common.data.MapMarkerDataModule;
import lotr.common.world.map.MapMarker;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SPacketDeleteMapMarker {
    private final int markerId;

    private SPacketDeleteMapMarker(int markerId) {
        this.markerId = markerId;
    }

    public SPacketDeleteMapMarker(MapMarker marker) {
        this(marker.getId());
    }

    public static void encode(SPacketDeleteMapMarker packet, PacketBuffer buf) {
        buf.func_150787_b(packet.markerId);
    }

    public static SPacketDeleteMapMarker decode(PacketBuffer buf) {
        int markerId = buf.func_150792_a();
        return new SPacketDeleteMapMarker(markerId);
    }

    public static void handle(SPacketDeleteMapMarker packet, Supplier<NetworkEvent.Context> context) {
        int markerId;
        PlayerEntity player = LOTRMod.PROXY.getClientPlayer();
        MapMarkerDataModule markerData = LOTRLevelData.clientInstance().getData(player).getMapMarkerData();
        MapMarker marker = markerData.getMarkerById(markerId = packet.markerId);
        if (marker != null) {
            markerData.removeMarker(marker);
        } else {
            LOTRLog.warn("Received map marker deletion from server, but no marker for ID %d exists", markerId);
        }
        context.get().setPacketHandled(true);
    }
}

