/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.network;

import java.util.function.Supplier;
import lotr.common.LOTRMod;
import lotr.common.data.LOTRLevelData;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class SPacketLoginLOTR {
    private BlockPos middleEarthPortalPos;
    private int wpCooldownMax;
    private int wpCooldownMin;
    private boolean areasOfInfluence;
    private boolean hasMapFeatures;

    public void setMiddleEarthPortalPos(int x, int y, int z) {
        this.middleEarthPortalPos = new BlockPos(x, y, z);
    }

    public void setWaypointCooldownMaxMin(int max, int min) {
        this.wpCooldownMax = max;
        this.wpCooldownMin = min;
    }

    public void setAreasOfInfluence(boolean flag) {
        this.areasOfInfluence = flag;
    }

    public void setHasMapFeatures(boolean flag) {
        this.hasMapFeatures = flag;
    }

    public static void encode(SPacketLoginLOTR packet, PacketBuffer buf) {
        buf.func_179255_a(packet.middleEarthPortalPos);
        buf.writeInt(packet.wpCooldownMax);
        buf.writeInt(packet.wpCooldownMin);
        buf.writeBoolean(packet.areasOfInfluence);
        buf.writeBoolean(packet.hasMapFeatures);
    }

    public static SPacketLoginLOTR decode(PacketBuffer buf) {
        SPacketLoginLOTR packet = new SPacketLoginLOTR();
        packet.middleEarthPortalPos = buf.func_179259_c();
        packet.wpCooldownMax = buf.readInt();
        packet.wpCooldownMin = buf.readInt();
        packet.areasOfInfluence = buf.readBoolean();
        packet.hasMapFeatures = buf.readBoolean();
        return packet;
    }

    public static void handle(SPacketLoginLOTR packet, Supplier<NetworkEvent.Context> context) {
        World clientWorld = LOTRMod.PROXY.getClientWorld();
        LOTRLevelData levelData = LOTRLevelData.clientInstance();
        levelData.markMiddleEarthPortalLocation(clientWorld, packet.middleEarthPortalPos);
        levelData.setWaypointCooldown(clientWorld, packet.wpCooldownMax, packet.wpCooldownMin);
        levelData.clientsideThisServer_areasOfInfluence = packet.areasOfInfluence;
        levelData.clientsideThisServer_hasMapFeatures = packet.hasMapFeatures;
        context.get().setPacketHandled(true);
    }
}

