/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.network;

import java.util.function.Supplier;
import lotr.common.LOTRLog;
import lotr.common.LOTRMod;
import lotr.common.data.FastTravelDataModule;
import lotr.common.data.LOTRLevelData;
import lotr.common.world.map.CustomWaypoint;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SPacketOpenUpdateCustomWaypointScreen {
    private final int waypointId;

    public SPacketOpenUpdateCustomWaypointScreen(CustomWaypoint waypoint) {
        this(waypoint.getCustomId());
    }

    private SPacketOpenUpdateCustomWaypointScreen(int waypointId) {
        this.waypointId = waypointId;
    }

    public static void encode(SPacketOpenUpdateCustomWaypointScreen packet, PacketBuffer buf) {
        buf.func_150787_b(packet.waypointId);
    }

    public static SPacketOpenUpdateCustomWaypointScreen decode(PacketBuffer buf) {
        int waypointId = buf.func_150792_a();
        return new SPacketOpenUpdateCustomWaypointScreen(waypointId);
    }

    public static void handle(SPacketOpenUpdateCustomWaypointScreen packet, Supplier<NetworkEvent.Context> context) {
        int waypointId;
        PlayerEntity player = LOTRMod.PROXY.getClientPlayer();
        FastTravelDataModule ftData = LOTRLevelData.clientInstance().getData(player).getFastTravelData();
        CustomWaypoint waypoint = ftData.getCustomWaypointById(waypointId = packet.waypointId);
        if (waypoint != null) {
            LOTRMod.PROXY.displayUpdateCustomWaypointScreen(waypoint);
        } else {
            LOTRLog.warn("Server asked to open a custom waypoint editing screen, but no custom waypoint for ID %d exists", waypointId);
        }
        context.get().setPacketHandled(true);
    }
}

