/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.network;

import java.util.function.Supplier;
import lotr.common.LOTRLog;
import lotr.common.LOTRMod;
import lotr.common.data.FastTravelDataModule;
import lotr.common.data.LOTRLevelData;
import lotr.common.world.map.AdoptedCustomWaypoint;
import lotr.common.world.map.AdoptedCustomWaypointKey;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SPacketOpenViewAdoptedCustomWaypointScreen {
    private final AdoptedCustomWaypointKey waypointKey;
    private final String createdPlayerName;

    public SPacketOpenViewAdoptedCustomWaypointScreen(AdoptedCustomWaypoint wp, String playerName) {
        this(wp.getAdoptedKey(), playerName);
    }

    public SPacketOpenViewAdoptedCustomWaypointScreen(AdoptedCustomWaypointKey key, String playerName) {
        this.waypointKey = key;
        this.createdPlayerName = playerName;
    }

    public static void encode(SPacketOpenViewAdoptedCustomWaypointScreen packet, PacketBuffer buf) {
        packet.waypointKey.write(buf);
        buf.func_180714_a(packet.createdPlayerName);
    }

    public static SPacketOpenViewAdoptedCustomWaypointScreen decode(PacketBuffer buf) {
        AdoptedCustomWaypointKey waypoint = AdoptedCustomWaypointKey.read(buf);
        String createdPlayerName = buf.func_218666_n();
        return new SPacketOpenViewAdoptedCustomWaypointScreen(waypoint, createdPlayerName);
    }

    public static void handle(SPacketOpenViewAdoptedCustomWaypointScreen packet, Supplier<NetworkEvent.Context> context) {
        AdoptedCustomWaypointKey waypointKey;
        PlayerEntity player = LOTRMod.PROXY.getClientPlayer();
        FastTravelDataModule ftData = LOTRLevelData.clientInstance().getData(player).getFastTravelData();
        AdoptedCustomWaypoint waypoint = ftData.getAdoptedCustomWaypointByKey(waypointKey = packet.waypointKey);
        if (waypoint != null) {
            LOTRMod.PROXY.displayViewAdoptedCustomWaypointScreen(waypoint, packet.createdPlayerName);
        } else {
            LOTRLog.warn("Server asked to open an adopted custom waypoint view screen, but no adopted custom waypoint for (creator %s, ID %d) exists", waypointKey.getCreatedPlayer(), waypointKey.getWaypointId());
        }
        context.get().setPacketHandled(true);
    }
}

