/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import lotr.common.recipe.DrinkBrewingRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class DrinkBrewingRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<DrinkBrewingRecipe> {
    private final int defaultBrewingTime;

    public DrinkBrewingRecipeSerializer(int time) {
        this.defaultBrewingTime = time;
    }

    public DrinkBrewingRecipe read(ResourceLocation recipeId, JsonObject json) {
        ItemStack result;
        String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        NonNullList<Ingredient> ingList = DrinkBrewingRecipeSerializer.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
        if (ingList.isEmpty()) {
            throw new JsonParseException("No ingredients for drink brewing recipe");
        }
        if (!json.has("result")) {
            throw new JsonSyntaxException("Missing result, expected to find a string or object");
        }
        if (json.get("result").isJsonObject()) {
            result = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
        } else {
            String resultString = JSONUtils.func_151200_h((JsonObject)json, (String)"result");
            ResourceLocation resultId = new ResourceLocation(resultString);
            result = new ItemStack((IItemProvider)Registry.field_212630_s.func_241873_b(resultId).orElseThrow(() -> new IllegalStateException("Item: " + resultString + " does not exist")));
        }
        float xp = JSONUtils.func_151221_a((JsonObject)json, (String)"experience", (float)0.0f);
        int time = JSONUtils.func_151208_a((JsonObject)json, (String)"brewtime", (int)this.defaultBrewingTime);
        return new DrinkBrewingRecipe(recipeId, group, ingList, result, xp, time);
    }

    private static NonNullList<Ingredient> readIngredients(JsonArray array) {
        NonNullList list = NonNullList.func_191196_a();
        for (int i = 0; i < array.size(); ++i) {
            Ingredient ing = Ingredient.func_199802_a((JsonElement)array.get(i));
            if (ing.func_203189_d()) continue;
            list.add((Object)ing);
        }
        return list;
    }

    public DrinkBrewingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        String group = buffer.func_150789_c(Short.MAX_VALUE);
        int numIngs = buffer.func_150792_a();
        NonNullList ingList = NonNullList.func_191197_a((int)numIngs, (Object)Ingredient.field_193370_a);
        for (int i = 0; i < ingList.size(); ++i) {
            ingList.set(i, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
        }
        ItemStack result = buffer.func_150791_c();
        float xp = buffer.readFloat();
        int time = buffer.func_150792_a();
        return new DrinkBrewingRecipe(recipeId, group, (NonNullList<Ingredient>)ingList, result, xp, time);
    }

    public void write(PacketBuffer buffer, DrinkBrewingRecipe recipe) {
        buffer.func_180714_a(recipe.group);
        buffer.func_150787_b(recipe.ingredients.size());
        for (Ingredient ing : recipe.ingredients) {
            ing.func_199564_a(buffer);
        }
        buffer.func_150788_a(recipe.result);
        buffer.writeFloat(recipe.experience);
        buffer.func_150787_b(recipe.brewTime);
    }
}

