/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.recipe;

import com.google.gson.JsonObject;
import lotr.common.recipe.FactionTableType;
import lotr.common.recipe.LOTRRecipes;
import lotr.common.recipe.MultiTableType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class FactionShapelessRecipe
extends ShapelessRecipe {
    private IRecipeType tableType;

    public FactionShapelessRecipe(ResourceLocation idIn, String groupIn, ItemStack recipeOutputIn, NonNullList<Ingredient> recipeItemsIn) {
        super(idIn, groupIn, recipeOutputIn, recipeItemsIn);
    }

    public FactionShapelessRecipe setTableType(IRecipeType t) {
        this.tableType = t;
        return this;
    }

    public IRecipeType<?> func_222127_g() {
        return this.tableType;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)LOTRRecipes.FACTION_SHAPELESS.get();
    }

    public ItemStack func_222128_h() {
        if (this.tableType instanceof FactionTableType) {
            return ((FactionTableType)this.tableType).getIcon();
        }
        if (this.tableType instanceof MultiTableType) {
            return ((MultiTableType)this.tableType).getRandomFactionIcon();
        }
        return super.func_222128_h();
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<FactionShapelessRecipe> {
        private final ShapelessRecipe.Serializer internalSerializer = new ShapelessRecipe.Serializer();

        public FactionShapelessRecipe read(ResourceLocation recipeId, JsonObject json) {
            ShapelessRecipe recipe = this.internalSerializer.func_199425_a_(recipeId, json);
            IRecipeType tableType = LOTRRecipes.findRecipeTypeByName(JSONUtils.func_151219_a((JsonObject)json, (String)"table", (String)""));
            return new FactionShapelessRecipe(recipe.func_199560_c(), recipe.func_193358_e(), recipe.func_77571_b(), (NonNullList<Ingredient>)recipe.func_192400_c()).setTableType(tableType);
        }

        public FactionShapelessRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            ShapelessRecipe recipe = this.internalSerializer.func_199426_a_(recipeId, buffer);
            IRecipeType tableType = LOTRRecipes.findRecipeTypeByName(buffer.func_150789_c(Short.MAX_VALUE));
            return new FactionShapelessRecipe(recipe.func_199560_c(), recipe.func_193358_e(), recipe.func_77571_b(), (NonNullList<Ingredient>)recipe.func_192400_c()).setTableType(tableType);
        }

        public void write(PacketBuffer buffer, FactionShapelessRecipe recipe) {
            this.internalSerializer.func_199427_a_(buffer, (ShapelessRecipe)recipe);
            String tableType = LOTRRecipes.findRecipeTypeName(recipe.tableType);
            buffer.func_211400_a(tableType, Short.MAX_VALUE);
        }
    }
}

