/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.recipe;

import java.util.function.Supplier;
import lotr.common.init.LOTRBlocks;
import lotr.common.recipe.AbstractAlloyForgeRecipe;
import lotr.common.recipe.AlloyForgeRecipe;
import lotr.common.recipe.AlloyForgeRecipeSerializer;
import lotr.common.recipe.DrinkBrewingRecipe;
import lotr.common.recipe.DrinkBrewingRecipeSerializer;
import lotr.common.recipe.DwarvenForgeAlloyRecipe;
import lotr.common.recipe.DwarvenForgeRecipe;
import lotr.common.recipe.DynamicIngredient;
import lotr.common.recipe.ElvenForgeAlloyRecipe;
import lotr.common.recipe.ElvenForgeRecipe;
import lotr.common.recipe.FactionShapedRecipe;
import lotr.common.recipe.FactionShapelessRecipe;
import lotr.common.recipe.FactionTableType;
import lotr.common.recipe.HobbitOvenAlloyRecipe;
import lotr.common.recipe.HobbitOvenRecipe;
import lotr.common.recipe.MultiTableType;
import lotr.common.recipe.OrcForgeAlloyRecipe;
import lotr.common.recipe.OrcForgeRecipe;
import lotr.common.recipe.SmokingPipeColoringRecipe;
import lotr.common.recipe.UndamagedIngredient;
import lotr.common.recipe.VesselDrinkShapelessRecipe;
import net.minecraft.block.Block;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.CookingRecipeSerializer;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class LOTRRecipes {
    public static IIngredientSerializer<DynamicIngredient> DYNAMIC_INGREDIENT_SERIALIZER;
    public static IIngredientSerializer<UndamagedIngredient> UNDAMAGED_INGREDIENT_SERIALIZER;
    public static FactionTableType GONDOR_CRAFTING;
    public static FactionTableType MORDOR_CRAFTING;
    public static FactionTableType ROHAN_CRAFTING;
    public static FactionTableType DWARVEN_CRAFTING;
    public static FactionTableType LINDON_CRAFTING;
    public static FactionTableType RIVENDELL_CRAFTING;
    public static FactionTableType GALADHRIM_CRAFTING;
    public static FactionTableType WOOD_ELVEN_CRAFTING;
    public static FactionTableType HARAD_CRAFTING;
    public static FactionTableType UMBAR_CRAFTING;
    public static FactionTableType URUK_CRAFTING;
    public static FactionTableType HOBBIT_CRAFTING;
    public static FactionTableType BLUE_MOUNTAINS_CRAFTING;
    public static FactionTableType RANGER_CRAFTING;
    public static FactionTableType DOL_AMROTH_CRAFTING;
    public static FactionTableType ANGMAR_CRAFTING;
    public static FactionTableType DORWINION_CRAFTING;
    public static FactionTableType DALE_CRAFTING;
    public static FactionTableType LOSSOTH_CRAFTING;
    public static FactionTableType DUNLENDING_CRAFTING;
    public static MultiTableType ANY_DUNEDAIN;
    public static MultiTableType ANY_NUMENOREAN;
    public static MultiTableType ANY_HARAD;
    public static MultiTableType ANY_ELVEN;
    public static MultiTableType ANY_HIGH_ELVEN;
    public static MultiTableType ANY_DWARVEN;
    public static MultiTableType ANY_ORC;
    public static MultiTableType ANY_MORGUL;
    public static IRecipeType<AbstractAlloyForgeRecipe> ALLOY_FORGE;
    public static IRecipeType<AbstractCookingRecipe> DWARVEN_FORGE;
    public static IRecipeType<AbstractAlloyForgeRecipe> DWARVEN_FORGE_ALLOY;
    public static IRecipeType<AbstractCookingRecipe> ELVEN_FORGE;
    public static IRecipeType<AbstractAlloyForgeRecipe> ELVEN_FORGE_ALLOY;
    public static IRecipeType<AbstractCookingRecipe> ORC_FORGE;
    public static IRecipeType<AbstractAlloyForgeRecipe> ORC_FORGE_ALLOY;
    public static IRecipeType<AbstractCookingRecipe> HOBBIT_OVEN;
    public static IRecipeType<AbstractAlloyForgeRecipe> HOBBIT_OVEN_ALLOY;
    public static IRecipeType<DrinkBrewingRecipe> DRINK_BREWING;
    public static final DeferredRegister<IRecipeSerializer<?>> RECIPE_SERIALIZERS;
    public static final RegistryObject<IRecipeSerializer<FactionShapedRecipe>> FACTION_SHAPED;
    public static final RegistryObject<IRecipeSerializer<FactionShapelessRecipe>> FACTION_SHAPELESS;
    public static final RegistryObject<IRecipeSerializer<VesselDrinkShapelessRecipe>> VESSEL_DRINK_SHAPELESS;
    public static final RegistryObject<IRecipeSerializer<SmokingPipeColoringRecipe>> CRAFTING_SPECIAL_SMOKING_PIPE_COLORING;
    public static final RegistryObject<IRecipeSerializer<AbstractAlloyForgeRecipe>> ALLOY_SERIALIZER;
    public static final RegistryObject<IRecipeSerializer<AbstractCookingRecipe>> DWARVEN_FORGE_SERIALIZER;
    public static final RegistryObject<IRecipeSerializer<AbstractAlloyForgeRecipe>> DWARVEN_FORGE_ALLOY_SERIALIZER;
    public static final RegistryObject<IRecipeSerializer<AbstractCookingRecipe>> ELVEN_FORGE_SERIALIZER;
    public static final RegistryObject<IRecipeSerializer<AbstractAlloyForgeRecipe>> ELVEN_FORGE_ALLOY_SERIALIZER;
    public static final RegistryObject<IRecipeSerializer<AbstractCookingRecipe>> ORC_FORGE_SERIALIZER;
    public static final RegistryObject<IRecipeSerializer<AbstractAlloyForgeRecipe>> ORC_FORGE_ALLOY_SERIALIZER;
    public static final RegistryObject<IRecipeSerializer<AbstractCookingRecipe>> HOBBIT_OVEN_SERIALIZER;
    public static final RegistryObject<IRecipeSerializer<AbstractAlloyForgeRecipe>> HOBBIT_OVEN_ALLOY_SERIALIZER;
    public static final RegistryObject<IRecipeSerializer<DrinkBrewingRecipe>> DRINK_BREWING_SERIALIZER;

    public static void register() {
        DYNAMIC_INGREDIENT_SERIALIZER = CraftingHelper.register((ResourceLocation)new ResourceLocation("lotr", "dynamic_ingredient"), (IIngredientSerializer)new DynamicIngredient.Serializer());
        UNDAMAGED_INGREDIENT_SERIALIZER = CraftingHelper.register((ResourceLocation)new ResourceLocation("lotr", "undamaged_ingredient"), (IIngredientSerializer)new UndamagedIngredient.Serializer());
        GONDOR_CRAFTING = LOTRRecipes.registerFaction("gondor", LOTRBlocks.GONDOR_CRAFTING_TABLE);
        MORDOR_CRAFTING = LOTRRecipes.registerFaction("mordor", LOTRBlocks.MORDOR_CRAFTING_TABLE);
        ROHAN_CRAFTING = LOTRRecipes.registerFaction("rohan", LOTRBlocks.ROHAN_CRAFTING_TABLE);
        DWARVEN_CRAFTING = LOTRRecipes.registerFaction("dwarven", LOTRBlocks.DWARVEN_CRAFTING_TABLE);
        LINDON_CRAFTING = LOTRRecipes.registerFaction("lindon", LOTRBlocks.LINDON_CRAFTING_TABLE);
        RIVENDELL_CRAFTING = LOTRRecipes.registerFaction("rivendell", LOTRBlocks.RIVENDELL_CRAFTING_TABLE);
        GALADHRIM_CRAFTING = LOTRRecipes.registerFaction("galadhrim", LOTRBlocks.GALADHRIM_CRAFTING_TABLE);
        WOOD_ELVEN_CRAFTING = LOTRRecipes.registerFaction("wood_elven", LOTRBlocks.WOOD_ELVEN_CRAFTING_TABLE);
        HARAD_CRAFTING = LOTRRecipes.registerFaction("harad", LOTRBlocks.HARAD_CRAFTING_TABLE);
        UMBAR_CRAFTING = LOTRRecipes.registerFaction("umbar", LOTRBlocks.UMBAR_CRAFTING_TABLE);
        URUK_CRAFTING = LOTRRecipes.registerFaction("uruk", LOTRBlocks.URUK_CRAFTING_TABLE);
        HOBBIT_CRAFTING = LOTRRecipes.registerFaction("hobbit", LOTRBlocks.HOBBIT_CRAFTING_TABLE);
        BLUE_MOUNTAINS_CRAFTING = LOTRRecipes.registerFaction("blue_mountains", LOTRBlocks.BLUE_MOUNTAINS_CRAFTING_TABLE);
        RANGER_CRAFTING = LOTRRecipes.registerFaction("ranger", LOTRBlocks.RANGER_CRAFTING_TABLE);
        DOL_AMROTH_CRAFTING = LOTRRecipes.registerFaction("dol_amroth", LOTRBlocks.DOL_AMROTH_CRAFTING_TABLE);
        ANGMAR_CRAFTING = LOTRRecipes.registerFaction("angmar", LOTRBlocks.ANGMAR_CRAFTING_TABLE);
        DORWINION_CRAFTING = LOTRRecipes.registerFaction("dorwinion", LOTRBlocks.DORWINION_CRAFTING_TABLE);
        DALE_CRAFTING = LOTRRecipes.registerFaction("dale", LOTRBlocks.DALE_CRAFTING_TABLE);
        LOSSOTH_CRAFTING = LOTRRecipes.registerFaction("lossoth", LOTRBlocks.LOSSOTH_CRAFTING_TABLE);
        DUNLENDING_CRAFTING = LOTRRecipes.registerFaction("dunlending", LOTRBlocks.DUNLENDING_CRAFTING_TABLE);
        ANY_DUNEDAIN = LOTRRecipes.registerMulti("any_dunedain", GONDOR_CRAFTING, RANGER_CRAFTING, DOL_AMROTH_CRAFTING);
        ANY_NUMENOREAN = LOTRRecipes.registerMulti("any_numenorean", GONDOR_CRAFTING, UMBAR_CRAFTING, DOL_AMROTH_CRAFTING);
        ANY_HARAD = LOTRRecipes.registerMulti("any_harad", HARAD_CRAFTING, UMBAR_CRAFTING);
        ANY_ELVEN = LOTRRecipes.registerMulti("any_elven", LINDON_CRAFTING, RIVENDELL_CRAFTING, GALADHRIM_CRAFTING, WOOD_ELVEN_CRAFTING);
        ANY_HIGH_ELVEN = LOTRRecipes.registerMulti("any_high_elven", LINDON_CRAFTING, RIVENDELL_CRAFTING);
        ANY_DWARVEN = LOTRRecipes.registerMulti("any_dwarven", DWARVEN_CRAFTING, BLUE_MOUNTAINS_CRAFTING);
        ANY_ORC = LOTRRecipes.registerMulti("any_orc", MORDOR_CRAFTING, URUK_CRAFTING, ANGMAR_CRAFTING);
        ANY_MORGUL = LOTRRecipes.registerMulti("any_morgul", MORDOR_CRAFTING, ANGMAR_CRAFTING);
        "The above registry names are the 'table' in the recipe .json files".length();
        ALLOY_FORGE = LOTRRecipes.register("alloy_forge");
        DWARVEN_FORGE = LOTRRecipes.register("dwarven_forge");
        DWARVEN_FORGE_ALLOY = LOTRRecipes.register("dwarven_forge_alloy");
        ELVEN_FORGE = LOTRRecipes.register("elven_forge");
        ELVEN_FORGE_ALLOY = LOTRRecipes.register("elven_forge_alloy");
        ORC_FORGE = LOTRRecipes.register("orc_forge");
        ORC_FORGE_ALLOY = LOTRRecipes.register("orc_forge_alloy");
        HOBBIT_OVEN = LOTRRecipes.register("hobbit_oven");
        HOBBIT_OVEN_ALLOY = LOTRRecipes.register("hobbit_oven_alloy");
        DRINK_BREWING = LOTRRecipes.register("brewing");
        RECIPE_SERIALIZERS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    private static FactionTableType registerFaction(String s, Supplier<Block> blockSup) {
        ResourceLocation res = new ResourceLocation("lotr", s);
        return (FactionTableType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)res, (Object)new FactionTableType(res.toString(), blockSup));
    }

    private static MultiTableType registerMulti(String s, FactionTableType ... types) {
        ResourceLocation res = new ResourceLocation("lotr", s);
        return (MultiTableType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)res, (Object)new MultiTableType(res.toString(), types));
    }

    private static <T extends IRecipe<?>> IRecipeType<T> register(String key) {
        final ResourceLocation res = new ResourceLocation("lotr", key);
        return (IRecipeType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)res, (Object)new IRecipeType<T>(){

            public String toString() {
                return res.toString();
            }
        });
    }

    public static String findRecipeTypeName(IRecipeType type) {
        return Registry.field_218367_H.func_177774_c((Object)type).toString();
    }

    public static IRecipeType findRecipeTypeByName(String s) {
        return (IRecipeType)Registry.field_218367_H.func_82594_a(new ResourceLocation(s));
    }

    static {
        RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"lotr");
        FACTION_SHAPED = RECIPE_SERIALIZERS.register("faction_shaped", FactionShapedRecipe.Serializer::new);
        FACTION_SHAPELESS = RECIPE_SERIALIZERS.register("faction_shapeless", FactionShapelessRecipe.Serializer::new);
        VESSEL_DRINK_SHAPELESS = RECIPE_SERIALIZERS.register("vessel_drink_shapeless", VesselDrinkShapelessRecipe.Serializer::new);
        CRAFTING_SPECIAL_SMOKING_PIPE_COLORING = RECIPE_SERIALIZERS.register("crafting_special_smoking_pipe_coloring", () -> new SpecialRecipeSerializer(SmokingPipeColoringRecipe::new));
        ALLOY_SERIALIZER = RECIPE_SERIALIZERS.register("alloy_forge", () -> new AlloyForgeRecipeSerializer<AbstractAlloyForgeRecipe>(AlloyForgeRecipe::new, 200));
        DWARVEN_FORGE_SERIALIZER = RECIPE_SERIALIZERS.register("dwarven_forge", () -> new CookingRecipeSerializer(DwarvenForgeRecipe::new, 200));
        DWARVEN_FORGE_ALLOY_SERIALIZER = RECIPE_SERIALIZERS.register("dwarven_forge_alloy", () -> new AlloyForgeRecipeSerializer<AbstractAlloyForgeRecipe>(DwarvenForgeAlloyRecipe::new, 200));
        ELVEN_FORGE_SERIALIZER = RECIPE_SERIALIZERS.register("elven_forge", () -> new CookingRecipeSerializer(ElvenForgeRecipe::new, 200));
        ELVEN_FORGE_ALLOY_SERIALIZER = RECIPE_SERIALIZERS.register("elven_forge_alloy", () -> new AlloyForgeRecipeSerializer<AbstractAlloyForgeRecipe>(ElvenForgeAlloyRecipe::new, 200));
        ORC_FORGE_SERIALIZER = RECIPE_SERIALIZERS.register("orc_forge", () -> new CookingRecipeSerializer(OrcForgeRecipe::new, 200));
        ORC_FORGE_ALLOY_SERIALIZER = RECIPE_SERIALIZERS.register("orc_forge_alloy", () -> new AlloyForgeRecipeSerializer<AbstractAlloyForgeRecipe>(OrcForgeAlloyRecipe::new, 200));
        HOBBIT_OVEN_SERIALIZER = RECIPE_SERIALIZERS.register("hobbit_oven", () -> new CookingRecipeSerializer(HobbitOvenRecipe::new, 200));
        HOBBIT_OVEN_ALLOY_SERIALIZER = RECIPE_SERIALIZERS.register("hobbit_oven_alloy", () -> new AlloyForgeRecipeSerializer<AbstractAlloyForgeRecipe>(HobbitOvenAlloyRecipe::new, 200));
        DRINK_BREWING_SERIALIZER = RECIPE_SERIALIZERS.register("brewing", () -> new DrinkBrewingRecipeSerializer(12000));
    }
}

