/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.time;

import java.util.HashMap;
import java.util.Map;
import lotr.common.time.ShireReckoning;
import net.minecraft.util.text.ITextComponent;

public abstract class MiddleEarthCalendar<D extends AbstractDate> {
    public static final int SECOND_AGE_LENGTH = 3441;
    public static final int THIRD_AGE_LENGTH = 3021;
    public static final int SHIRE_RECKONING_OFFSET_FROM_THIRD_AGE = -1600;
    public static final int THIRD_AGE_CURRENT = ShireReckoning.START_DATE.year - -1600;
    public static int currentDay = 0;
    private Map<Integer, D> cachedDates = new HashMap<Integer, D>();

    public final D getCurrentDate() {
        return this.getDate(currentDay);
    }

    public final D getDate(int day) {
        AbstractDate date = (AbstractDate)this.cachedDates.get(day);
        if (date == null) {
            date = this.computeDateForCache(day);
            this.cachedDates.put(day, date);
        }
        return (D)date;
    }

    protected abstract D computeDateForCache(int var1);

    public final ITextComponent getCurrentDateAndYearLongform() {
        return ((AbstractDate)this.getCurrentDate()).getDateAndYearName(false);
    }

    public final ITextComponent getCurrentDateAndYearShortform() {
        return ((AbstractDate)this.getCurrentDate()).getDateAndYearName(true);
    }

    public static abstract class AbstractDate {
        protected abstract ITextComponent getDateAndYearName(boolean var1);

        protected abstract ITextComponent getDateName(boolean var1);

        protected abstract ITextComponent getYearName(boolean var1);
    }
}

