/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.time;

import java.awt.Color;

public enum Season {
    SPRING("spring", 0, new float[]{1.0f, 1.0f, 1.0f}),
    SUMMER("summer", 1, new float[]{1.15f, 1.15f, 0.9f}),
    AUTUMN("autumn", 2, new float[]{1.2f, 1.0f, 0.7f}),
    WINTER("winter", 3, new float[]{1.0f, 0.8f, 0.8f});

    public static Season[] allSeasons;
    private final String name;
    public final int seasonID;
    private final float[] grassRGB;

    private Season(String s, int i, float[] f) {
        this.name = s;
        this.seasonID = i;
        this.grassRGB = f;
    }

    public String codeName() {
        return this.name;
    }

    public int transformColor(int color) {
        float[] rgb = new Color(color).getRGBColorComponents(null);
        float r = rgb[0];
        float g = rgb[1];
        float b = rgb[2];
        r = Math.min(r * this.grassRGB[0], 1.0f);
        g = Math.min(g * this.grassRGB[1], 1.0f);
        b = Math.min(b * this.grassRGB[2], 1.0f);
        return new Color(r, g, b).getRGB();
    }

    static {
        allSeasons = new Season[]{SPRING, SUMMER, AUTUMN, WINTER};
    }
}

