/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.surface.MountainTerrainProvider;
import lotr.common.world.biome.surface.SurfaceNoiseMixer;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;

public class AngmarBiome
extends LOTRBiomeBase {
    public AngmarBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.2f).func_205420_b(0.6f).func_205414_c(0.2f).func_205417_d(0.3f), major);
    }

    protected AngmarBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
        this.biomeColors.setGrass(7896151).setSky(5654333).setClouds(0x3A3A3A).setFog(0x3A3A3A);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setSurfaceNoiseMixer(SurfaceNoiseMixer.createNoiseMixer(SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(1).scales(0.4, 0.07).threshold(0.25).state(Blocks.field_150348_b)));
    }

    @Override
    protected void addStoneVariants(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addCommonGranite(builder);
    }

    @Override
    protected void addOres(BiomeGenerationSettings.Builder builder) {
        super.addOres(builder);
        LOTRBiomeFeatures.addStoneOrcishOres(builder);
    }

    @Override
    protected void addBoulders(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addBoulders(builder, Blocks.field_150348_b.func_176223_P(), 1, 2, 6, 1);
    }

    @Override
    protected void addVegetation(BiomeGenerationSettings.Builder builder) {
        Object[] weightedTrees = new Object[]{LOTRBiomeFeatures.spruceThin(), 1000, LOTRBiomeFeatures.spruce(), 2000, LOTRBiomeFeatures.spruceDead(), 1000, LOTRBiomeFeatures.charred(), 1000, LOTRBiomeFeatures.fir(), 1000, LOTRBiomeFeatures.pine(), 2000};
        LOTRBiomeFeatures.addTrees(this, builder, 0, 0.25f, weightedTrees);
        LOTRBiomeFeatures.addTreesAboveTreeline(this, builder, 4, 0.1f, 80, weightedTrees);
        LOTRBiomeFeatures.addGrassWithoutPrettyTypes(this, builder, 4);
        LOTRBiomeFeatures.addDoubleGrassWithoutPrettyTypes(builder, 1);
    }

    @Override
    protected void addAnimals(MobSpawnInfo.Builder builder) {
        this.addWolves(builder, 2);
        this.addBears(builder, 1);
    }

    @Override
    protected void addStructures(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addCraftingMonument(builder, ((Block)LOTRBlocks.ANGMAR_CRAFTING_TABLE.get()).func_176223_P(), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.ANGMAR_BRICK.get()).func_176223_P(), 4).func_227407_a_(((Block)LOTRBlocks.MOSSY_ANGMAR_BRICK.get()).func_176223_P(), 1).func_227407_a_(((Block)LOTRBlocks.CRACKED_ANGMAR_BRICK.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.CRACKED_STONE_BRICK_WALL.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.ORC_TORCH.get()).func_176223_P(), 1));
    }

    public static class Mountains
    extends AngmarBiome {
        public Mountains(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.EXTREME_HILLS).func_205421_a(1.6f).func_205420_b(1.5f).func_205414_c(0.25f).func_205417_d(0.3f), major);
        }

        @Override
        protected void setupSurface(MiddleEarthSurfaceConfig config) {
            super.setupSurface(config);
            config.setMountainTerrain(MountainTerrainProvider.createMountainTerrain(MountainTerrainProvider.MountainLayer.layerBuilder().above(130).state(Blocks.field_196604_cC).topOnly(), MountainTerrainProvider.MountainLayer.layerBuilder().above(110).useStone()));
        }

        @Override
        protected void addStoneVariants(BiomeGenerationSettings.Builder builder) {
            super.addStoneVariants(builder);
            LOTRBiomeFeatures.addDeepDiorite(builder);
        }

        @Override
        protected void addAnimals(MobSpawnInfo.Builder builder) {
        }

        @Override
        public Biome getRiver(IWorld world) {
            return null;
        }
    }
}

