/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.ExtendedWeatherType;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import lotr.common.world.map.RoadBlockProvider;
import net.minecraft.block.Block;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;

public abstract class BaseMordorBiome
extends LOTRBiomeBase {
    protected BaseMordorBiome(Biome.Builder builder, int water, boolean major) {
        super(builder, water, major);
        this.biomeColors.setWater(water);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setFillerDepth(2.0);
        config.addSubSoilLayer(((Block)LOTRBlocks.MORDOR_DIRT.get()).func_176223_P(), 3);
        config.setUnderwater(((Block)LOTRBlocks.MORDOR_GRAVEL.get()).func_176223_P());
        config.addSubSoilLayer(((Block)LOTRBlocks.MORDOR_ROCK.get()).func_176223_P(), 1000);
    }

    @Override
    protected void addDirtGravel(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addMordorDirtGravel(builder);
    }

    @Override
    protected void addStoneVariants(BiomeGenerationSettings.Builder builder) {
    }

    @Override
    protected void addOres(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addMordorOres(builder);
    }

    @Override
    protected void addReeds(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addReedsWithDriedChance(builder, 1.0f);
    }

    @Override
    protected void addPumpkins(BiomeGenerationSettings.Builder builder) {
    }

    @Override
    protected void addAnimals(MobSpawnInfo.Builder builder) {
    }

    @Override
    protected void addStructures(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addCraftingMonument(builder, ((Block)LOTRBlocks.MORDOR_CRAFTING_TABLE.get()).func_176223_P(), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.MORDOR_BRICK.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.MORDOR_BRICK_WALL.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.ORC_TORCH.get()).func_176223_P(), 1));
    }

    @Override
    public boolean hasSkyFeatures() {
        return false;
    }

    @Override
    protected ExtendedWeatherType getBiomeExtendedWeather() {
        return ExtendedWeatherType.ASHFALL;
    }

    @Override
    public RoadBlockProvider getRoadBlockProvider() {
        return RoadBlockProvider.MORDOR_PATH;
    }
}

