/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.surface.MountainTerrainProvider;
import lotr.common.world.gen.feature.TreeCluster;
import lotr.common.world.map.RoadBlockProvider;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;

public class BlueMountainsBiome
extends LOTRBiomeBase {
    public BlueMountainsBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.EXTREME_HILLS).func_205421_a(1.0f).func_205420_b(2.2f).func_205414_c(0.22f).func_205417_d(0.8f), major);
    }

    protected BlueMountainsBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
        this.biomeColors.setSky(7506425);
    }

    protected boolean isFoothills() {
        return false;
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        if (!this.isFoothills()) {
            config.setMountainTerrain(MountainTerrainProvider.createMountainTerrain(MountainTerrainProvider.MountainLayer.layerBuilder().above(110).state(Blocks.field_196604_cC).topOnly(), MountainTerrainProvider.MountainLayer.layerBuilder().above(90).state(LOTRBlocks.BLUE_ROCK).excludeStone()));
        }
    }

    @Override
    protected void addStoneVariants(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addAndesite(builder);
        LOTRBiomeFeatures.addDeepDiorite(builder);
        LOTRBiomeFeatures.addBlueRockPatches(builder);
    }

    @Override
    protected void addOres(BiomeGenerationSettings.Builder builder) {
        super.addOres(builder);
        LOTRBiomeFeatures.addExtraCoal(builder, 8, 10, 128);
        LOTRBiomeFeatures.addExtraIron(builder, 4, 10, 96);
        LOTRBiomeFeatures.addGlowstoneOre(builder);
    }

    @Override
    protected void addCobwebs(BiomeGenerationSettings.Builder builder) {
    }

    @Override
    protected void addVegetation(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addTreesWithClusters(this, builder, 0, 0.4f, TreeCluster.of(10, 12), LOTRBiomeFeatures.oak(), 3000, LOTRBiomeFeatures.oakFancy(), 1000, LOTRBiomeFeatures.spruce(), 5000, LOTRBiomeFeatures.birch(), 4000, LOTRBiomeFeatures.pine(), 5000, LOTRBiomeFeatures.fir(), 5000);
        LOTRBiomeFeatures.addGrassWithoutPrettyTypes(this, builder, 6);
        LOTRBiomeFeatures.addDoubleGrassWithoutPrettyTypes(builder, 1);
        LOTRBiomeFeatures.addMountainsFlowers(builder, 1, LOTRBlocks.DWARFWORT.get(), 1);
    }

    @Override
    protected void addLiquidSprings(BiomeGenerationSettings.Builder builder) {
        if (!this.isFoothills()) {
            LOTRBiomeFeatures.addWaterLavaSpringsReducedAboveground(builder, 80, 0.15f);
        } else {
            super.addLiquidSprings(builder);
        }
    }

    @Override
    protected void addAnimals(MobSpawnInfo.Builder builder) {
        super.addAnimals(builder);
    }

    @Override
    protected void addStructures(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addCraftingMonument(builder, ((Block)LOTRBlocks.BLUE_MOUNTAINS_CRAFTING_TABLE.get()).func_176223_P(), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.BLUE_BRICK.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.BLUE_BRICK_WALL.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(Blocks.field_222432_lU.func_176223_P(), 1));
    }

    @Override
    public Biome getRiver(IWorld world) {
        return this.isFoothills() ? super.getRiver(world) : null;
    }

    @Override
    public RoadBlockProvider getRoadBlockProvider() {
        return RoadBlockProvider.DWARVEN;
    }

    public static class Foothills
    extends BlueMountainsBiome {
        public Foothills(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.EXTREME_HILLS).func_205421_a(0.5f).func_205420_b(0.9f).func_205414_c(0.5f).func_205417_d(0.8f), major);
        }

        @Override
        protected boolean isFoothills() {
            return true;
        }
    }
}

