/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.gen.feature.TreeCluster;
import lotr.common.world.map.RoadBlockProvider;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;

public class DaleBiome
extends LOTRBiomeBase {
    public DaleBiome(boolean major) {
        super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.1f).func_205420_b(0.4f).func_205414_c(0.6f).func_205417_d(0.7f), major);
    }

    protected DaleBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
    }

    @Override
    protected void addBoulders(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addBoulders(builder, Blocks.field_150348_b.func_176223_P(), 1, 3, 80, 3);
    }

    @Override
    protected void addVegetation(BiomeGenerationSettings.Builder builder) {
        Object[] weightedTrees = new Object[]{LOTRBiomeFeatures.oak(), 5000, LOTRBiomeFeatures.oakFancy(), 1000, LOTRBiomeFeatures.oakDead(), 500, LOTRBiomeFeatures.oakBees(), 50, LOTRBiomeFeatures.oakFancyBees(), 10, LOTRBiomeFeatures.spruce(), 2000, LOTRBiomeFeatures.spruceDead(), 500, LOTRBiomeFeatures.maple(), 500, LOTRBiomeFeatures.mapleBees(), 5, LOTRBiomeFeatures.pine(), 2000, LOTRBiomeFeatures.fir(), 2000, LOTRBiomeFeatures.apple(), 50, LOTRBiomeFeatures.pear(), 50, LOTRBiomeFeatures.appleBees(), 1, LOTRBiomeFeatures.pearBees(), 1};
        LOTRBiomeFeatures.addTreesWithClusters(this, builder, 0, 0.05f, TreeCluster.of(8, 16), weightedTrees);
        LOTRBiomeFeatures.addTreesAboveTreelineIncrease(this, builder, 2, 0.3f, 3, 82, weightedTrees);
        LOTRBiomeFeatures.addGrass(this, builder, 8);
        LOTRBiomeFeatures.addDoubleGrass(builder, 4);
        LOTRBiomeFeatures.addPlainsFlowers(builder, 2, new Object[0]);
        LOTRBiomeFeatures.addDefaultDoubleFlowers(builder, 1, new Object[0]);
    }

    @Override
    protected void addAnimals(MobSpawnInfo.Builder builder) {
        super.addAnimals(builder);
        this.addHorsesDonkeys(builder, 1);
    }

    @Override
    protected void addStructures(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addCraftingMonument(builder, ((Block)LOTRBlocks.DALE_CRAFTING_TABLE.get()).func_176223_P(), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.DALE_BRICK.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(Blocks.field_222459_lw.func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(Blocks.field_222432_lU.func_176223_P(), 1));
    }

    @Override
    public RoadBlockProvider getRoadBlockProvider() {
        return RoadBlockProvider.DALE;
    }

    public static class Northern
    extends DaleBiome {
        private static final float SNOWY_TEMP = 0.15f;

        public Northern(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.2f).func_205420_b(0.5f).func_205414_c(0.5f).func_205417_d(0.7f), major);
        }

        @Override
        protected void addVegetation(BiomeGenerationSettings.Builder builder) {
            Object[] weightedTrees = new Object[]{LOTRBiomeFeatures.beech(), 1000, LOTRBiomeFeatures.beechFancy(), 100, LOTRBiomeFeatures.beechDead(), 500, LOTRBiomeFeatures.beechBees(), 10, LOTRBiomeFeatures.beechFancyBees(), 1, LOTRBiomeFeatures.spruce(), 2000, LOTRBiomeFeatures.spruceDead(), 500, LOTRBiomeFeatures.maple(), 500, LOTRBiomeFeatures.mapleBees(), 5, LOTRBiomeFeatures.pine(), 2000, LOTRBiomeFeatures.fir(), 2000, LOTRBiomeFeatures.apple(), 50, LOTRBiomeFeatures.pear(), 50, LOTRBiomeFeatures.appleBees(), 1, LOTRBiomeFeatures.pearBees(), 1};
            LOTRBiomeFeatures.addTreesWithClusters(this, builder, 0, 0.05f, TreeCluster.of(8, 40), weightedTrees);
            LOTRBiomeFeatures.addTreesAboveTreelineIncrease(this, builder, 2, 0.3f, 2, 82, weightedTrees);
            LOTRBiomeFeatures.addGrass(this, builder, 6);
            LOTRBiomeFeatures.addDoubleGrass(builder, 2);
            LOTRBiomeFeatures.addBorealFlowers(builder, 2, new Object[0]);
        }

        @Override
        public float getTemperatureRaw(float defaultTemperatureAtPos, BlockPos pos) {
            return defaultTemperatureAtPos - this.getLocalSnowiness(pos) * (this.getActualBiome().func_242445_k() - 0.15f);
        }

        private float getLocalSnowiness(BlockPos pos) {
            int x = pos.func_177958_n();
            int z = pos.func_177952_p();
            double d1 = SNOW_VARIETY_NOISE.func_215464_a((double)x * 0.002, (double)z * 0.002, false);
            double d2 = SNOW_VARIETY_NOISE.func_215464_a((double)x * 0.05, (double)z * 0.05, false);
            double d3 = SNOW_VARIETY_NOISE.func_215464_a((double)x * 0.3, (double)z * 0.3, false);
            float biased = (float)Math.max((d1 *= 0.6) + (d2 *= 0.2) + (d3 *= 0.2), 0.0) + 0.5f;
            return MathHelper.func_76131_a((float)biased, (float)0.0f, (float)1.0f);
        }
    }
}

