/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.surface.SurfaceNoiseMixer;
import net.minecraft.block.Blocks;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;

public class DeadMarshesBiome
extends LOTRBiomeBase {
    private static final int DEAD_MARSHES_WATER_COLOR = 4014639;

    public DeadMarshesBiome(boolean major) {
        super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.SWAMP).func_205421_a(-0.24f).func_205420_b(0.0f).func_205414_c(0.4f).func_205417_d(1.0f), 4014639, major);
        this.biomeColors.setGrass(8024152).setFoliage(7041093).setSky(8684390).setClouds(7368024).setFog(6315334).setWater(4014639);
    }

    @Override
    public float getStrengthOfAddedDepthNoise() {
        return 0.15f;
    }

    @Override
    public float getBiomeScaleSignificanceForChunkGen() {
        return 1.0f;
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setMarsh(true);
        config.setSurfaceNoiseMixer(SurfaceNoiseMixer.createNoiseMixer(SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(1).scales(0.4, 0.07).threshold(0.15).state(Blocks.field_196660_k).topOnly()));
    }

    @Override
    protected void addBiomeSandSediments(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addQuagmire(builder, 1);
    }

    @Override
    protected void addVegetation(BiomeGenerationSettings.Builder builder) {
        Object[] weightedTrees = new Object[]{LOTRBiomeFeatures.oakDead(), 1000};
        LOTRBiomeFeatures.addTrees(this, builder, 0, 0.25f, weightedTrees);
        LOTRBiomeFeatures.addGrassWithFernsWithoutPrettyTypes(this, builder, 6);
        LOTRBiomeFeatures.addDoubleGrassWithFernsWithoutPrettyTypes(builder, 4);
        LOTRBiomeFeatures.addSwampFlowers(builder, 0, new Object[0]);
        LOTRBiomeFeatures.addDeadBushAtSurfaceChance(builder, 1);
        LOTRBiomeFeatures.addMoreMushroomsFreq(builder, 3);
        LOTRBiomeFeatures.addSwampSeagrass(builder);
    }

    @Override
    protected void addReeds(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addReedsWithDriedChance(builder, 1.0f);
        LOTRBiomeFeatures.addSwampRushes(builder);
    }

    @Override
    protected void addPumpkins(BiomeGenerationSettings.Builder builder) {
    }

    @Override
    protected void addAnimals(MobSpawnInfo.Builder builder) {
    }

    @Override
    public Biome getRiver(IWorld world) {
        return null;
    }
}

