/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBiomes;
import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import lotr.common.world.gen.feature.TreeCluster;
import lotr.common.world.map.RoadBlockProvider;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;

public class DorEnErnilBiome
extends LOTRBiomeBase {
    public DorEnErnilBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.04f).func_205420_b(0.28f).func_205414_c(0.9f).func_205417_d(0.9f), major);
    }

    protected DorEnErnilBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.addSubSoilLayer(((Block)LOTRBlocks.GONDOR_ROCK.get()).func_176223_P(), 8, 10);
    }

    @Override
    protected void addStoneVariants(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addGranite(builder);
        LOTRBiomeFeatures.addGondorRockPatches(builder);
    }

    @Override
    protected void addBiomeSandSediments(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addWhiteSandSediments(builder);
    }

    @Override
    protected void addBoulders(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addBoulders(builder, ((Block)LOTRBlocks.GONDOR_ROCK.get()).func_176223_P(), 1, 2, 200, 3);
    }

    protected final Object[] dorEnErnilTrees() {
        return new Object[]{LOTRBiomeFeatures.birch(), 2000, LOTRBiomeFeatures.birchFancy(), 2000, LOTRBiomeFeatures.birchBees(), 20, LOTRBiomeFeatures.birchFancyBees(), 20, LOTRBiomeFeatures.oak(), 800, LOTRBiomeFeatures.oakTall(), 800, LOTRBiomeFeatures.oakFancy(), 800, LOTRBiomeFeatures.oakBees(), 8, LOTRBiomeFeatures.oakTallBees(), 8, LOTRBiomeFeatures.oakFancyBees(), 8, LOTRBiomeFeatures.cedar(), 1000, LOTRBiomeFeatures.cypress(), 500, LOTRBiomeFeatures.apple(), 50, LOTRBiomeFeatures.pear(), 50, LOTRBiomeFeatures.appleBees(), 1, LOTRBiomeFeatures.pearBees(), 1};
    }

    @Override
    protected void addVegetation(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addTreesWithClusters(this, builder, 0, 0.03f, TreeCluster.of(10, 30), this.dorEnErnilTrees());
        LOTRBiomeFeatures.addGrass(this, builder, 8);
        LOTRBiomeFeatures.addDoubleGrass(builder, 4);
        LOTRBiomeFeatures.addPlainsFlowers(builder, 4, new Object[0]);
        LOTRBiomeFeatures.addAthelasChance(builder);
        LOTRBiomeFeatures.addWildPipeweedChance(builder, 24);
    }

    @Override
    protected void addReeds(BiomeGenerationSettings.Builder builder) {
        super.addReeds(builder);
        LOTRBiomeFeatures.addSugarCane(builder);
    }

    @Override
    protected void addAnimals(MobSpawnInfo.Builder builder) {
        super.addAnimals(builder);
        this.addHorsesDonkeys(builder, 6);
    }

    @Override
    protected void addStructures(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addCraftingMonument(builder, ((Block)LOTRBlocks.DOL_AMROTH_CRAFTING_TABLE.get()).func_176223_P(), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.DOL_AMROTH_BRICK.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.DOL_AMROTH_BRICK_WALL.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(Blocks.field_222432_lU.func_176223_P(), 1));
    }

    @Override
    public LOTRBiomeBase getShore() {
        return LOTRBiomes.WHITE_BEACH.getInitialisedBiomeWrapper();
    }

    @Override
    public RoadBlockProvider getRoadBlockProvider() {
        return RoadBlockProvider.DOL_AMROTH;
    }

    public static class Hills
    extends DorEnErnilBiome {
        public Hills(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.7f).func_205420_b(0.7f).func_205414_c(0.7f).func_205417_d(0.9f), major);
        }

        @Override
        protected void addStoneVariants(BiomeGenerationSettings.Builder builder) {
            super.addStoneVariants(builder);
            LOTRBiomeFeatures.addDiorite(builder);
        }

        @Override
        protected void addVegetation(BiomeGenerationSettings.Builder builder) {
            LOTRBiomeFeatures.addTreesWithClusters(this, builder, 0, 0.65f, TreeCluster.of(10, 10), this.dorEnErnilTrees());
            LOTRBiomeFeatures.addGrass(this, builder, 5);
            LOTRBiomeFeatures.addDoubleGrass(builder, 1);
            LOTRBiomeFeatures.addPlainsFlowers(builder, 2, new Object[0]);
            LOTRBiomeFeatures.addAthelasChance(builder);
            LOTRBiomeFeatures.addWildPipeweedChance(builder, 24);
        }

        @Override
        public Biome getRiver(IWorld world) {
            return null;
        }
    }
}

