/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.block.DripstoneBlock;
import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.LOTRBiomeWrapper;
import lotr.common.world.biome.LOTRGrassColorModifiers;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.surface.SurfaceNoiseMixer;
import lotr.common.world.gen.feature.TreeCluster;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;

public class ForochelBiome
extends LOTRBiomeBase {
    public ForochelBiome(boolean major) {
        super(new Biome.Builder().func_205415_a(Biome.RainType.SNOW).func_205419_a(Biome.Category.ICY).func_205421_a(0.1f).func_205420_b(0.2f).func_205414_c(0.1f).func_205417_d(0.3f), major);
        this.biomeColors.setSky(11783899);
    }

    @Override
    protected void setupBiomeAmbience(BiomeAmbience.Builder builder) {
        super.setupBiomeAmbience(builder);
        builder.func_242537_a(LOTRGrassColorModifiers.FOROCHEL);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setSurfaceNoiseMixer(SurfaceNoiseMixer.createNoiseMixer(SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(1).scales(0.3, 0.06).threshold(0.3).state(Blocks.field_196660_k).topOnly(), SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(2).scales(0.3, 0.02).threshold(0.35).state(Blocks.field_196604_cC).topOnly()));
    }

    @Override
    protected void addStoneVariants(BiomeGenerationSettings.Builder builder) {
        super.addStoneVariants(builder);
        LOTRBiomeFeatures.addPackedIceVeins(builder, 40);
    }

    @Override
    protected void addDripstones(BiomeGenerationSettings.Builder builder) {
        super.addDripstones(builder);
        LOTRBiomeFeatures.addDripstones(builder, (DripstoneBlock)LOTRBlocks.ICE_DRIPSTONE.get(), 2);
    }

    @Override
    protected void addBoulders(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addBoulders(builder, Blocks.field_150348_b.func_176223_P(), 1, 3, 80, 1);
        LOTRBiomeFeatures.addBoulders(builder, Blocks.field_150348_b.func_176223_P(), 1, 3, 80, 3);
    }

    @Override
    protected void addVegetation(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addTreesWithClusters(this, builder, 0, 0.04f, TreeCluster.of(8, 100), LOTRBiomeFeatures.spruce(), 600, LOTRBiomeFeatures.spruceThin(), 400, LOTRBiomeFeatures.spruceDead(), 2500, LOTRBiomeFeatures.pine(), 400, LOTRBiomeFeatures.fir(), 1000);
        LOTRBiomeFeatures.addGrassWithoutPrettyTypes(this, builder, 1);
        LOTRBiomeFeatures.addBorealFlowers(builder, 2, new Object[0]);
    }

    @Override
    protected void addAnimals(MobSpawnInfo.Builder builder) {
        this.addWolves(builder, 1);
        this.addDeer(builder, 1);
        this.addElk(builder, 2);
        this.addBears(builder, 2);
        this.addFoxes(builder, 2);
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200786_Z, 1, 1, 2));
    }

    @Override
    public boolean doesSnowGenerate(boolean defaultDoesSnowGenerate, IWorldReader world, BlockPos pos) {
        return defaultDoesSnowGenerate && (LOTRBiomeWrapper.isSnowBlockBelow(world, pos) || this.isForochelSnowy(pos));
    }

    private boolean isForochelSnowy(BlockPos pos) {
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        double d1 = SNOW_VARIETY_NOISE.func_215464_a((double)x * 0.002, (double)z * 0.002, false);
        double d2 = SNOW_VARIETY_NOISE.func_215464_a((double)x * 0.05, (double)z * 0.05, false);
        double d3 = SNOW_VARIETY_NOISE.func_215464_a((double)x * 0.3, (double)z * 0.3, false);
        return d1 + (d2 *= 0.3) + (d3 *= 0.3) > 0.62;
    }

    @Override
    protected void addStructures(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addCraftingMonument(builder, ((Block)LOTRBlocks.LOSSOTH_CRAFTING_TABLE.get()).func_176223_P(), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.SNOW_BRICK.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.LARCH_FENCE.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.BLUBBER_TORCH.get()).func_176223_P(), 1));
    }
}

