/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.block.DripstoneBlock;
import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.surface.MountainTerrainProvider;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;

public class ForodwaithBiome
extends LOTRBiomeBase {
    public ForodwaithBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.SNOW).func_205419_a(Biome.Category.ICY).func_205421_a(0.1f).func_205420_b(0.1f).func_205414_c(0.0f).func_205417_d(0.2f), major);
    }

    protected ForodwaithBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
        this.biomeColors.setSky(10069160);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setTop(Blocks.field_196604_cC.func_176223_P());
    }

    @Override
    protected void addStoneVariants(BiomeGenerationSettings.Builder builder) {
        super.addStoneVariants(builder);
        LOTRBiomeFeatures.addPackedIceVeins(builder, 40);
    }

    @Override
    protected void addDripstones(BiomeGenerationSettings.Builder builder) {
        super.addDripstones(builder);
        LOTRBiomeFeatures.addDripstones(builder, (DripstoneBlock)LOTRBlocks.ICE_DRIPSTONE.get(), 2);
    }

    @Override
    protected void addBoulders(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addBoulders(builder, Blocks.field_150348_b.func_176223_P(), 1, 2, 80, 2);
        LOTRBiomeFeatures.addBoulders(builder, Blocks.field_150348_b.func_176223_P(), 1, 2, 80, 5);
    }

    @Override
    protected void addVegetation(BiomeGenerationSettings.Builder builder) {
    }

    @Override
    protected void addLiquidSprings(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addLavaSprings(builder);
    }

    @Override
    protected void addAnimals(MobSpawnInfo.Builder builder) {
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200786_Z, 1, 1, 2));
    }

    public static class Mountains
    extends ForodwaithBiome {
        public Mountains(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.SNOW).func_205419_a(Biome.Category.ICY).func_205421_a(2.0f).func_205420_b(2.0f).func_205414_c(0.0f).func_205417_d(0.2f), major);
        }

        @Override
        protected void setupSurface(MiddleEarthSurfaceConfig config) {
            super.setupSurface(config);
            config.setMountainTerrain(MountainTerrainProvider.createMountainTerrain(MountainTerrainProvider.MountainLayer.layerBuilder().above(100).state(Blocks.field_196604_cC).topOnly(), MountainTerrainProvider.MountainLayer.layerBuilder().above(70).useStone()));
        }

        @Override
        public Biome getRiver(IWorld world) {
            return null;
        }
    }
}

