/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;

public class GladdenFieldsBiome
extends LOTRBiomeBase {
    public GladdenFieldsBiome(boolean major) {
        super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.SWAMP).func_205421_a(-0.22f).func_205420_b(0.0f).func_205414_c(0.6f).func_205417_d(1.2f), major);
    }

    @Override
    public float getStrengthOfAddedDepthNoise() {
        return 0.15f;
    }

    @Override
    public float getBiomeScaleSignificanceForChunkGen() {
        return 0.96f;
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setMarsh(true);
    }

    @Override
    protected void addBiomeSandSediments(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addQuagmire(builder, 1);
    }

    @Override
    protected void addVegetation(BiomeGenerationSettings.Builder builder) {
        Object[] weightedTrees = new Object[]{LOTRBiomeFeatures.oak(), 500, LOTRBiomeFeatures.oakFancy(), 100, LOTRBiomeFeatures.oakSwamp(), 1000, LOTRBiomeFeatures.oakShrub(), 4000, LOTRBiomeFeatures.birch(), 500, LOTRBiomeFeatures.birchFancy(), 100, LOTRBiomeFeatures.spruce(), 1000, LOTRBiomeFeatures.larch(), 500};
        LOTRBiomeFeatures.addTreesBelowTreeline(this, builder, 2, 0.5f, 63, weightedTrees);
        LOTRBiomeFeatures.addTreesAboveTreeline(this, builder, 3, 0.5f, 64, weightedTrees);
        LOTRBiomeFeatures.addGrassWithFernsWithoutPrettyTypes(this, builder, 8);
        LOTRBiomeFeatures.addDoubleGrassWithFernsWithoutPrettyTypes(builder, 8);
        LOTRBiomeFeatures.addSwampFlowers(builder, 2, new Object[0]);
        LOTRBiomeFeatures.addDefaultDoubleFlowers(builder, 7, LOTRBlocks.YELLOW_IRIS.get(), 40);
        LOTRBiomeFeatures.addMoreMushroomsFreq(builder, 3);
        LOTRBiomeFeatures.addWaterLiliesWithFlowers(builder, 5);
        LOTRBiomeFeatures.addSwampSeagrass(builder);
        LOTRBiomeFeatures.addFallenLogs(builder, 1);
    }

    @Override
    protected void addReeds(BiomeGenerationSettings.Builder builder) {
        super.addReeds(builder);
        LOTRBiomeFeatures.addMoreSwampReeds(builder);
        LOTRBiomeFeatures.addSwampRushes(builder);
    }

    @Override
    protected void addAnimals(MobSpawnInfo.Builder builder) {
    }

    @Override
    public Biome getRiver(IWorld world) {
        return null;
    }
}

