/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.BaseMordorBiome;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.surface.SurfaceNoiseMixer;
import net.minecraft.block.Block;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.ParticleEffectAmbience;

public class GorgorothBiome
extends BaseMordorBiome {
    private static final int GORGOROTH_WATER_COLOR = 2498845;

    public GorgorothBiome(boolean major) {
        super(new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.DESERT).func_205421_a(0.7f).func_205420_b(0.4f).func_205414_c(1.5f).func_205417_d(0.0f), 2498845, major);
        this.biomeColors.setGrass(5980459).setFoliage(5987138).setSky(0x663E33).setClouds(4924185).setFog(3154711);
    }

    @Override
    protected void setupBiomeAmbience(BiomeAmbience.Builder builder) {
        super.setupBiomeAmbience(builder);
        builder.func_235244_a_(new ParticleEffectAmbience((IParticleData)ParticleTypes.field_239813_am_, 0.025f));
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        super.setupSurface(config);
        config.setTop(((Block)LOTRBlocks.MORDOR_ROCK.get()).func_176223_P());
        config.setFiller(((Block)LOTRBlocks.MORDOR_ROCK.get()).func_176223_P());
        config.resetFillerDepthAndSubSoilLayers();
        config.addSubSoilLayer(((Block)LOTRBlocks.MORDOR_ROCK.get()).func_176223_P(), 1000);
        config.setRockyTerrain(false);
        config.setSurfaceNoiseMixer(SurfaceNoiseMixer.createNoiseMixer(SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(1).scales(0.4, 0.08).threshold(0.25).state(LOTRBlocks.MORDOR_DIRT), SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(2).scales(0.4, 0.08).threshold(0.4).state(LOTRBlocks.MORDOR_GRAVEL)));
    }

    @Override
    protected void addFeatures(BiomeGenerationSettings.Builder builder) {
        super.addFeatures(builder);
        LOTRBiomeFeatures.addMordorBasalt(builder, 1, 6);
    }

    @Override
    protected void addCarvers(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addCarversExtraCanyons(builder);
    }

    @Override
    protected void addBoulders(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addBoulders(builder, ((Block)LOTRBlocks.MORDOR_ROCK.get()).func_176223_P(), 2, 6, 30, 4);
    }

    @Override
    protected void addVegetation(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addTreesIncrease(this, builder, 0, 0.0125f, 7, LOTRBiomeFeatures.charred(), 1);
        LOTRBiomeFeatures.addMordorMoss(builder, 20);
        LOTRBiomeFeatures.addMordorGrass(builder, 2);
        LOTRBiomeFeatures.addMordorThorns(builder, 40);
        LOTRBiomeFeatures.addMorgulShrooms(builder, 32);
    }

    @Override
    protected void addLiquidSprings(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addWaterSprings(builder);
        LOTRBiomeFeatures.addLavaSprings(builder, 50);
    }
}

