/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.surface.MountainTerrainProvider;
import net.minecraft.block.Blocks;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;

public class GreyMountainsBiome
extends LOTRBiomeBase {
    public GreyMountainsBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.EXTREME_HILLS).func_205421_a(1.8f).func_205420_b(2.0f).func_205414_c(0.28f).func_205417_d(0.3f), major);
    }

    protected GreyMountainsBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
        this.biomeColors.setSky(10862798);
    }

    protected boolean isFoothills() {
        return false;
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        if (!this.isFoothills()) {
            config.setMountainTerrain(MountainTerrainProvider.createMountainTerrain(MountainTerrainProvider.MountainLayer.layerBuilder().above(150).state(Blocks.field_196604_cC).topOnly(), MountainTerrainProvider.MountainLayer.layerBuilder().above(110).useStone()));
        }
    }

    @Override
    protected void addStoneVariants(BiomeGenerationSettings.Builder builder) {
        super.addStoneVariants(builder);
        LOTRBiomeFeatures.addDeepDiorite(builder);
    }

    @Override
    protected void addOres(BiomeGenerationSettings.Builder builder) {
        super.addOres(builder);
    }

    @Override
    protected void addVegetation(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addTreesBelowTreeline(this, builder, 3, 0.1f, 100, LOTRBiomeFeatures.spruce(), 4000, LOTRBiomeFeatures.spruceThin(), 4000, LOTRBiomeFeatures.spruceMega(), 500, LOTRBiomeFeatures.spruceThinMega(), 100, LOTRBiomeFeatures.larch(), 5000, LOTRBiomeFeatures.fir(), 5000, LOTRBiomeFeatures.pine(), 5000);
        LOTRBiomeFeatures.addGrassWithoutPrettyTypes(this, builder, 2);
        LOTRBiomeFeatures.addDoubleGrassWithoutPrettyTypes(builder, 1);
        LOTRBiomeFeatures.addMountainsFlowers(builder, 1, new Object[0]);
    }

    @Override
    protected void addLiquidSprings(BiomeGenerationSettings.Builder builder) {
        if (!this.isFoothills()) {
            LOTRBiomeFeatures.addWaterLavaSpringsReducedAboveground(builder, 80, 0.15f);
        } else {
            super.addLiquidSprings(builder);
        }
    }

    @Override
    protected void addAnimals(MobSpawnInfo.Builder builder) {
    }

    @Override
    public Biome getRiver(IWorld world) {
        return this.isFoothills() ? super.getRiver(world) : null;
    }

    public static class Foothills
    extends GreyMountainsBiome {
        public Foothills(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.EXTREME_HILLS).func_205421_a(0.5f).func_205420_b(0.9f).func_205414_c(0.5f).func_205417_d(0.7f), major);
        }

        @Override
        protected boolean isFoothills() {
            return true;
        }
    }
}

