/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.world.biome.ExtendedWeatherType;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.surface.SurfaceNoiseMixer;
import lotr.common.world.gen.feature.TreeCluster;
import lotr.common.world.map.RoadBlockProvider;
import net.minecraft.block.Blocks;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;

public class HaradDesertBiome
extends LOTRBiomeBase {
    public HaradDesertBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.DESERT).func_205421_a(0.2f).func_205420_b(0.1f).func_205414_c(1.5f).func_205417_d(0.1f), major);
    }

    protected HaradDesertBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
        this.biomeColors.setCloudCoverage(0.2f);
        this.biomeColors.setFog(16180681);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setTop(Blocks.field_150354_m.func_176223_P());
        config.setFiller(Blocks.field_150354_m.func_176223_P());
    }

    @Override
    protected void addOres(BiomeGenerationSettings.Builder builder) {
        super.addOres(builder);
        LOTRBiomeFeatures.addLapisOre(builder);
    }

    @Override
    protected void addBoulders(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addBoulders(builder, Blocks.field_150348_b.func_176223_P(), 1, 3, 240, 3);
        LOTRBiomeFeatures.addBoulders(builder, Blocks.field_150322_A.func_176223_P(), 1, 3, 240, 3);
    }

    @Override
    protected void addVegetation(BiomeGenerationSettings.Builder builder) {
        Object[] weightedTrees = new Object[]{LOTRBiomeFeatures.oakDead(), 8000, LOTRBiomeFeatures.oakDesert(), 2000};
        LOTRBiomeFeatures.addTreesIncrease(this, builder, 0, 5.0E-4f, 1, weightedTrees);
        LOTRBiomeFeatures.addTreesIncrease(this, builder, 0, 5.0E-4f, 3, weightedTrees);
        LOTRBiomeFeatures.addGrassWithArid(this, builder, 1);
        LOTRBiomeFeatures.addHaradFlowers(builder, 0, new Object[0]);
        LOTRBiomeFeatures.addCactiAtSurfaceChance(builder, 50);
        LOTRBiomeFeatures.addDeadBushAtSurfaceChance(builder, 16);
    }

    @Override
    protected void addReeds(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addLessCommonReeds(builder);
        LOTRBiomeFeatures.addMoreCommonPapyrus(builder);
    }

    @Override
    protected void addAnimals(MobSpawnInfo.Builder builder) {
    }

    @Override
    protected ExtendedWeatherType getBiomeExtendedWeather() {
        return ExtendedWeatherType.SANDSTORM;
    }

    @Override
    public Biome getRiver(IWorld world) {
        return null;
    }

    @Override
    public RoadBlockProvider getRoadBlockProvider() {
        return RoadBlockProvider.HARAD.withRepair(0.5f);
    }

    public static class Hills
    extends HaradDesertBiome {
        public Hills(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.DESERT).func_205421_a(0.5f).func_205420_b(0.8f).func_205414_c(1.2f).func_205417_d(0.3f), major);
            this.biomeColors.setCloudCoverage(0.4f);
        }

        @Override
        protected void setupSurface(MiddleEarthSurfaceConfig config) {
            super.setupSurface(config);
            config.setSurfaceNoiseMixer(SurfaceNoiseMixer.createNoiseMixer(SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(1).scales(0.4, 0.09).threshold(0.1).state(Blocks.field_150322_A), SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(2).scales(0.4, 0.09).threshold(0.3).state(Blocks.field_150348_b)));
        }

        @Override
        protected void addVegetation(BiomeGenerationSettings.Builder builder) {
            Object[] weightedTrees = new Object[]{LOTRBiomeFeatures.oakDead(), 8000, LOTRBiomeFeatures.oakDesert(), 2000};
            LOTRBiomeFeatures.addTreesWithClusters(this, builder, 0, 0.01f, TreeCluster.of(6, 100), weightedTrees);
            LOTRBiomeFeatures.addGrassWithArid(this, builder, 1);
            LOTRBiomeFeatures.addHaradFlowers(builder, 0, new Object[0]);
            LOTRBiomeFeatures.addCactiAtSurfaceChance(builder, 200);
            LOTRBiomeFeatures.addDeadBushAtSurfaceChance(builder, 16);
        }

        @Override
        protected ExtendedWeatherType getBiomeExtendedWeather() {
            return ExtendedWeatherType.NONE;
        }
    }

    public static class HalfDesert
    extends HaradDesertBiome {
        public HalfDesert(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.DESERT).func_205421_a(0.2f).func_205420_b(0.1f).func_205414_c(1.5f).func_205417_d(0.3f), major);
            this.biomeColors.setCloudCoverage(0.6f);
        }

        @Override
        protected void setupSurface(MiddleEarthSurfaceConfig config) {
            super.setupSurface(config);
            config.setSurfaceNoiseMixer(SurfaceNoiseMixer.createNoiseMixer(SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(1).scales(0.3, 0.08).threshold(0.15).state(Blocks.field_196660_k).topOnly()));
        }

        @Override
        protected void addVegetation(BiomeGenerationSettings.Builder builder) {
            Object[] weightedTrees = new Object[]{LOTRBiomeFeatures.oakDead(), 5000, LOTRBiomeFeatures.oakDesert(), 5000};
            LOTRBiomeFeatures.addTreesWithClusters(this, builder, 0, 0.05f, TreeCluster.of(8, 100), weightedTrees);
            LOTRBiomeFeatures.addGrassWithArid(this, builder, 5);
            LOTRBiomeFeatures.addDoubleGrassWithArid(builder, 1);
            LOTRBiomeFeatures.addHaradFlowers(builder, 0, new Object[0]);
            LOTRBiomeFeatures.addCactiAtSurfaceChance(builder, 200);
            LOTRBiomeFeatures.addDeadBushAtSurfaceChance(builder, 16);
        }

        @Override
        public Biome getRiver(IWorld world) {
            return this.getNormalRiver(world);
        }
    }
}

