/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.surface.SurfaceNoiseMixer;
import lotr.common.world.map.RoadBlockProvider;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;

public class HarondorBiome
extends LOTRBiomeBase {
    public HarondorBiome(boolean major) {
        super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.2f).func_205420_b(0.3f).func_205414_c(1.0f).func_205417_d(0.6f), major);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setSurfaceNoiseMixer(SurfaceNoiseMixer.createNoiseMixer(SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(1).scales(0.4, 0.09).threshold(0.15).state(Blocks.field_196660_k).topOnly(), SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(2).scales(0.4, 0.09, 0.002).weights(1, 1, 2).threshold(0.35).state(Blocks.field_150354_m)));
    }

    @Override
    protected void addOres(BiomeGenerationSettings.Builder builder) {
        super.addOres(builder);
        LOTRBiomeFeatures.addLapisOre(builder);
    }

    @Override
    protected void addBoulders(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addBoulders(builder, Blocks.field_150348_b.func_176223_P(), 1, 3, 16, 4);
    }

    @Override
    protected void addVegetation(BiomeGenerationSettings.Builder builder) {
        Object[] weightedTrees = new Object[]{LOTRBiomeFeatures.oakDesert(), 10000, LOTRBiomeFeatures.oakDesertBees(), 10, LOTRBiomeFeatures.cedar(), 2500};
        LOTRBiomeFeatures.addTrees(this, builder, 0, 0.1f, weightedTrees);
        LOTRBiomeFeatures.addTreesIncrease(this, builder, 0, 0.0625f, 3, weightedTrees);
        LOTRBiomeFeatures.addTreesIncrease(this, builder, 0, 0.0625f, 7, weightedTrees);
        LOTRBiomeFeatures.addGrassWithArid(this, builder, 8);
        LOTRBiomeFeatures.addDoubleGrassWithArid(builder, 1);
        LOTRBiomeFeatures.addDeadBushes(builder, 1);
        LOTRBiomeFeatures.addPlainsFlowers(builder, 4, new Object[0]);
        LOTRBiomeFeatures.addCactiFreq(builder, 1);
    }

    @Override
    protected void addReeds(BiomeGenerationSettings.Builder builder) {
        super.addReeds(builder);
        LOTRBiomeFeatures.addSugarCane(builder);
    }

    @Override
    protected void addAnimals(MobSpawnInfo.Builder builder) {
        super.addAnimals(builder);
        this.addCaracals(builder, 1);
    }

    @Override
    public RoadBlockProvider getRoadBlockProvider() {
        return RoadBlockProvider.GONDOR.withRepair(0.6f);
    }
}

