/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import lotr.common.block.DripstoneBlock;
import lotr.common.block.ThreeLeafCloverBlock;
import lotr.common.compatibility.SnowRealMagicCompatibility;
import lotr.common.init.LOTRBlocks;
import lotr.common.util.LOTRUtil;
import lotr.common.world.biome.GeneratingTreesConfig;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.gen.carver.LOTRWorldCarvers;
import lotr.common.world.gen.feature.BoulderFeatureConfig;
import lotr.common.world.gen.feature.CobwebFeatureConfig;
import lotr.common.world.gen.feature.CraftingMonumentFeatureConfig;
import lotr.common.world.gen.feature.CrystalFeatureConfig;
import lotr.common.world.gen.feature.DripstoneFeatureConfig;
import lotr.common.world.gen.feature.FallenLogFeatureConfig;
import lotr.common.world.gen.feature.GrassPatchFeatureConfig;
import lotr.common.world.gen.feature.LOTRFeatures;
import lotr.common.world.gen.feature.LatitudeBasedFeatureConfig;
import lotr.common.world.gen.feature.MordorBasaltFeatureConfig;
import lotr.common.world.gen.feature.MordorMossFeatureConfig;
import lotr.common.world.gen.feature.ReedsFeatureConfig;
import lotr.common.world.gen.feature.TerrainSharpenFeatureConfig;
import lotr.common.world.gen.feature.TreeCluster;
import lotr.common.world.gen.feature.WeightedFeature;
import lotr.common.world.gen.feature.WeightedRandomFeatureConfig;
import lotr.common.world.gen.feature.WrappedTreeFeatureConfig;
import lotr.common.world.gen.placement.ByWaterConfig;
import lotr.common.world.gen.placement.TreeClustersConfig;
import lotr.common.world.gen.tree.AspenFoliagePlacer;
import lotr.common.world.gen.tree.BoughsFoliagePlacer;
import lotr.common.world.gen.tree.BoughsTrunkPlacer;
import lotr.common.world.gen.tree.CedarFoliagePlacer;
import lotr.common.world.gen.tree.CedarTrunkPlacer;
import lotr.common.world.gen.tree.ClusterFoliagePlacer;
import lotr.common.world.gen.tree.CypressFoliagePlacer;
import lotr.common.world.gen.tree.DeadTrunkPlacer;
import lotr.common.world.gen.tree.DesertFoliagePlacer;
import lotr.common.world.gen.tree.DesertTrunkPlacer;
import lotr.common.world.gen.tree.EmptyFoliagePlacer;
import lotr.common.world.gen.tree.FangornTrunkPlacer;
import lotr.common.world.gen.tree.FirFoliagePlacer;
import lotr.common.world.gen.tree.HollyFoliagePlacer;
import lotr.common.world.gen.tree.LOTRFoliagePlacers;
import lotr.common.world.gen.tree.LOTRPineFoliagePlacer;
import lotr.common.world.gen.tree.LOTRTreeDecorators;
import lotr.common.world.gen.tree.LOTRTrunkPlacers;
import lotr.common.world.gen.tree.LairelosseFoliagePlacer;
import lotr.common.world.gen.tree.MirkOakFoliagePlacer;
import lotr.common.world.gen.tree.MirkOakLeavesGrowthDecorator;
import lotr.common.world.gen.tree.MirkOakTrunkPlacer;
import lotr.common.world.gen.tree.MirkOakWebsDecorator;
import lotr.common.world.gen.tree.PineBranchDecorator;
import lotr.common.world.gen.tree.PineStripDecorator;
import lotr.common.world.gen.tree.ShirePineFoliagePlacer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SweetBerryBushBlock;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.ColumnBlockPlacer;
import net.minecraft.world.gen.blockplacer.DoublePlantBlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.BlockStateProvidingFeatureConfig;
import net.minecraft.world.gen.feature.BlockWithContextConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.FeatureSpreadConfig;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.LiquidsConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.SingleRandomFeature;
import net.minecraft.world.gen.feature.SphereReplaceConfig;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.feature.template.BlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.TagMatchRuleTest;
import net.minecraft.world.gen.foliageplacer.BlobFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.BushFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FancyFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.foliageplacer.SpruceFoliagePlacer;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.CaveEdgeConfig;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.DepthAverageConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraft.world.gen.placement.TopSolidWithNoiseConfig;
import net.minecraft.world.gen.treedecorator.BeehiveTreeDecorator;
import net.minecraft.world.gen.treedecorator.LeaveVineTreeDecorator;
import net.minecraft.world.gen.treedecorator.TrunkVineTreeDecorator;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.FancyTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.StraightTrunkPlacer;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class LOTRBiomeFeatures {
    public static RuleTest MORDOR_ROCK_FILLER;
    public static RuleTest SAND_FILLER;
    private static BlockState STONE;
    private static BlockState DIRT;
    private static BlockState COARSE_DIRT;
    private static BlockState GRAVEL;
    private static BlockState GRANITE;
    private static BlockState DIORITE;
    private static BlockState ANDESITE;
    private static BlockState PACKED_ICE;
    private static BlockState BLUE_ICE;
    private static BlockState GONDOR_ROCK;
    private static BlockState MORDOR_ROCK;
    private static BlockState ROHAN_ROCK;
    private static BlockState BLUE_ROCK;
    private static BlockState RED_ROCK;
    private static BlockState MORDOR_DIRT;
    private static BlockState MORDOR_GRAVEL;
    private static BlockState COAL_ORE;
    private static BlockState IRON_ORE;
    private static BlockState COPPER_ORE;
    private static BlockState TIN_ORE;
    private static BlockState GOLD_ORE;
    private static BlockState SILVER_ORE;
    private static BlockState SULFUR_ORE;
    private static BlockState NITER_ORE;
    private static BlockState SALT_ORE;
    private static BlockState LAPIS_ORE;
    private static BlockState MITHRIL_ORE;
    private static BlockState EDHELVIR_ORE;
    private static BlockState GLOWSTONE_ORE;
    private static BlockState DURNOR_ORE;
    private static BlockState MORGUL_IRON_ORE_MORDOR;
    private static BlockState MORGUL_IRON_ORE_STONE;
    private static BlockState GULDURIL_ORE_MORDOR;
    private static BlockState GULDURIL_ORE_STONE;
    private static BlockState EDHELVIR_CRYSTAL;
    private static BlockState GULDURIL_CRYSTAL;
    private static BlockState GLOWSTONE_CRYSTAL;
    private static BlockState COBWEB;
    private static BlockState WATER;
    private static BlockState LAVA;
    private static BlockState OAK_LOG;
    private static BlockState OAK_WOOD;
    private static BlockState OAK_STRIPPED_LOG;
    private static BlockState OAK_BRANCH;
    private static BlockState OAK_LEAVES;
    private static IPlantable OAK_SAPLING;
    public static BaseTreeFeatureConfig OAK_TREE_VINES;
    public static BaseTreeFeatureConfig OAK_TREE_BEES_VINES;
    public static BaseTreeFeatureConfig OAK_TREE_TALL;
    public static BaseTreeFeatureConfig OAK_TREE_TALL_BEES;
    public static BaseTreeFeatureConfig OAK_TREE_TALL_VINES;
    public static BaseTreeFeatureConfig OAK_TREE_TALL_BEES_VINES;
    public static WrappedTreeFeatureConfig OAK_DESERT;
    public static WrappedTreeFeatureConfig OAK_DESERT_BEES;
    public static WrappedTreeFeatureConfig OAK_DEAD;
    public static BaseTreeFeatureConfig OAK_FANGORN;
    public static BaseTreeFeatureConfig OAK_SHRUB;
    private static BlockState SPRUCE_LOG;
    private static BlockState SPRUCE_WOOD;
    private static BlockState SPRUCE_BRANCH;
    private static BlockState SPRUCE_LEAVES;
    private static IPlantable SPRUCE_SAPLING;
    public static WrappedTreeFeatureConfig SPRUCE_DEAD;
    public static BaseTreeFeatureConfig SPRUCE_SHRUB;
    private static BlockState BIRCH_LOG;
    private static BlockState BIRCH_WOOD;
    private static BlockState BIRCH_BRANCH;
    private static BlockState BIRCH_LEAVES;
    private static IPlantable BIRCH_SAPLING;
    public static BaseTreeFeatureConfig BIRCH_TREE_FANCY;
    public static BaseTreeFeatureConfig BIRCH_TREE_FANCY_BEES;
    public static BaseTreeFeatureConfig BIRCH_TREE_ALT;
    public static BaseTreeFeatureConfig BIRCH_TREE_ALT_BEES;
    public static WrappedTreeFeatureConfig BIRCH_DEAD;
    private static BlockState PINE_LOG;
    private static BlockState PINE_LOG_SLAB;
    private static BlockState PINE_LEAVES;
    private static IPlantable PINE_SAPLING;
    public static BaseTreeFeatureConfig PINE_TREE;
    public static BaseTreeFeatureConfig SHIRE_PINE_TREE;
    public static BaseTreeFeatureConfig PINE_SHRUB;
    private static BlockState MALLORN_LOG;
    private static BlockState MALLORN_WOOD;
    private static BlockState MALLORN_BRANCH;
    private static BlockState MALLORN_LEAVES;
    private static IPlantable MALLORN_SAPLING;
    public static BaseTreeFeatureConfig MALLORN_TREE;
    public static BaseTreeFeatureConfig MALLORN_TREE_BEES;
    public static BaseTreeFeatureConfig MALLORN_TREE_BOUGHS;
    private static BlockState MIRK_OAK_LOG;
    private static BlockState MIRK_OAK_WOOD;
    private static BlockState MIRK_OAK_BRANCH;
    private static BlockState MIRK_OAK_LEAVES;
    private static IPlantable MIRK_OAK_SAPLING;
    public static BaseTreeFeatureConfig MIRK_OAK_TREE;
    private static BlockState CHARRED_LOG;
    private static BlockState CHARRED_WOOD;
    private static BlockState CHARRED_BRANCH;
    public static WrappedTreeFeatureConfig CHARRED_TREE;
    private static BlockState APPLE_LOG;
    private static BlockState APPLE_LEAVES;
    private static BlockState APPLE_LEAVES_RED;
    private static BlockState APPLE_LEAVES_GREEN;
    private static BlockStateProvider APPLE_LEAVES_RED_POOL;
    private static BlockStateProvider APPLE_LEAVES_GREEN_POOL;
    private static BlockStateProvider APPLE_LEAVES_MIX_POOL;
    private static IPlantable APPLE_SAPLING;
    public static BaseTreeFeatureConfig APPLE_TREE_RED;
    public static BaseTreeFeatureConfig APPLE_TREE_RED_BEES;
    public static BaseTreeFeatureConfig APPLE_TREE_GREEN;
    public static BaseTreeFeatureConfig APPLE_TREE_GREEN_BEES;
    public static BaseTreeFeatureConfig APPLE_TREE_MIX;
    public static BaseTreeFeatureConfig APPLE_TREE_MIX_BEES;
    private static BlockState PEAR_LOG;
    private static BlockState PEAR_LEAVES;
    private static BlockState PEAR_LEAVES_FRUIT;
    private static BlockStateProvider PEAR_LEAVES_POOL;
    private static IPlantable PEAR_SAPLING;
    public static BaseTreeFeatureConfig PEAR_TREE;
    public static BaseTreeFeatureConfig PEAR_TREE_BEES;
    private static BlockState CHERRY_LOG;
    private static BlockState CHERRY_LEAVES;
    private static BlockState CHERRY_LEAVES_FRUIT;
    private static BlockStateProvider CHERRY_LEAVES_POOL;
    private static IPlantable CHERRY_SAPLING;
    public static BaseTreeFeatureConfig CHERRY_TREE;
    public static BaseTreeFeatureConfig CHERRY_TREE_BEES;
    private static BlockState LEBETHRON_LOG;
    private static BlockState LEBETHRON_LEAVES;
    private static IPlantable LEBETHRON_SAPLING;
    public static BaseTreeFeatureConfig LEBETHRON_TREE;
    public static BaseTreeFeatureConfig LEBETHRON_TREE_BEES;
    public static BaseTreeFeatureConfig LEBETHRON_TREE_FANCY;
    public static BaseTreeFeatureConfig LEBETHRON_TREE_FANCY_BEES;
    private static BlockState BEECH_LOG;
    private static BlockState BEECH_WOOD;
    private static BlockState BEECH_STRIPPED_LOG;
    private static BlockState BEECH_BRANCH;
    private static BlockState BEECH_LEAVES;
    private static IPlantable BEECH_SAPLING;
    public static BaseTreeFeatureConfig BEECH_TREE;
    public static BaseTreeFeatureConfig BEECH_TREE_BEES;
    public static BaseTreeFeatureConfig BEECH_TREE_FANCY;
    public static BaseTreeFeatureConfig BEECH_TREE_FANCY_BEES;
    public static BaseTreeFeatureConfig BEECH_FANGORN;
    public static WrappedTreeFeatureConfig BEECH_DEAD;
    private static BlockState MAPLE_LOG;
    private static BlockState MAPLE_LEAVES;
    private static IPlantable MAPLE_SAPLING;
    public static BaseTreeFeatureConfig MAPLE_TREE;
    public static BaseTreeFeatureConfig MAPLE_TREE_BEES;
    public static BaseTreeFeatureConfig MAPLE_TREE_FANCY;
    public static BaseTreeFeatureConfig MAPLE_TREE_FANCY_BEES;
    private static BlockState ASPEN_LOG;
    private static BlockState ASPEN_LEAVES;
    private static IPlantable ASPEN_SAPLING;
    public static BaseTreeFeatureConfig ASPEN_TREE;
    private static BlockState LAIRELOSSE_LOG;
    private static BlockState LAIRELOSSE_LEAVES;
    private static IPlantable LAIRELOSSE_SAPLING;
    public static BaseTreeFeatureConfig LAIRELOSSE_TREE;
    private static BlockState CEDAR_LOG;
    private static BlockState CEDAR_WOOD;
    private static BlockState CEDAR_BRANCH;
    private static BlockState CEDAR_LEAVES;
    private static IPlantable CEDAR_SAPLING;
    public static BaseTreeFeatureConfig CEDAR_TREE;
    public static BaseTreeFeatureConfig CEDAR_TREE_LARGE;
    private static BlockState FIR_LOG;
    private static BlockState FIR_LEAVES;
    private static IPlantable FIR_SAPLING;
    public static BaseTreeFeatureConfig FIR_TREE;
    private static BlockState LARCH_LOG;
    private static BlockState LARCH_LEAVES;
    private static IPlantable LARCH_SAPLING;
    public static BaseTreeFeatureConfig LARCH_TREE;
    private static BlockState HOLLY_LOG;
    private static BlockState HOLLY_LEAVES;
    private static IPlantable HOLLY_SAPLING;
    public static BaseTreeFeatureConfig HOLLY_TREE;
    public static BaseTreeFeatureConfig HOLLY_TREE_BEES;
    private static BlockState GREEN_OAK_LOG;
    private static BlockState GREEN_OAK_WOOD;
    private static BlockState GREEN_OAK_BRANCH;
    private static BlockState GREEN_OAK_LEAVES;
    private static IPlantable GREEN_OAK_SAPLING;
    private static BlockState RED_OAK_LEAVES;
    private static IPlantable RED_OAK_SAPLING;
    public static BaseTreeFeatureConfig GREEN_OAK_TREE;
    public static BaseTreeFeatureConfig GREEN_OAK_TREE_BEES;
    public static BaseTreeFeatureConfig RED_OAK_TREE;
    public static BaseTreeFeatureConfig RED_OAK_TREE_BEES;
    private static BlockState CYPRESS_LOG;
    private static BlockState CYPRESS_LEAVES;
    private static IPlantable CYPRESS_SAPLING;
    public static BaseTreeFeatureConfig CYPRESS_TREE;
    private static BlockState GRASS;
    private static BlockState FERN;
    private static BlockState SHORT_GRASS;
    private static BlockState WHEATGRASS;
    private static BlockState FLOWERY_GRASS;
    private static BlockState PURPLE_MOOR_GRASS;
    private static BlockState RED_MOOR_GRASS;
    private static BlockState THISTLE;
    private static BlockState NETTLES;
    private static BlockState FERNSPROUT;
    private static BlockState WILD_FLAX;
    private static BlockState ARID_GRASS;
    public static BlockClusterFeatureConfig GRASS_CONFIG;
    public static BlockClusterFeatureConfig FERN_CONFIG;
    public static BlockClusterFeatureConfig SHORT_GRASS_CONFIG;
    public static BlockClusterFeatureConfig WHEATGRASS_CONFIG;
    public static BlockClusterFeatureConfig FLOWERY_GRASS_CONFIG;
    public static BlockClusterFeatureConfig PURPLE_MOOR_GRASS_CONFIG;
    public static BlockClusterFeatureConfig RED_MOOR_GRASS_CONFIG;
    public static BlockClusterFeatureConfig THISTLE_CONFIG;
    public static BlockClusterFeatureConfig NETTLES_CONFIG;
    public static BlockClusterFeatureConfig FERNSPROUT_CONFIG;
    public static BlockClusterFeatureConfig WILD_FLAX_CONFIG;
    public static BlockClusterFeatureConfig ARID_GRASS_CONFIG;
    private static BlockState CLOVER;
    private static BlockState FOUR_LEAF_CLOVER;
    public static BlockClusterFeatureConfig CLOVER_CONFIG;
    public static BlockClusterFeatureConfig SHIRE_CLOVER_CONFIG;
    private static BlockState DOUBLE_GRASS;
    private static BlockState DOUBLE_FERN;
    private static BlockState DOUBLE_WHEATGRASS;
    private static BlockState DOUBLE_ARID_GRASS;
    public static BlockClusterFeatureConfig DOUBLE_GRASS_CONFIG;
    public static BlockClusterFeatureConfig DOUBLE_FERN_CONFIG;
    public static BlockClusterFeatureConfig DOUBLE_WHEATGRASS_CONFIG;
    public static BlockClusterFeatureConfig DOUBLE_ARID_GRASS_CONFIG;
    private static BlockState SIMBELMYNE;
    private static BlockState ATHELAS;
    private static BlockState WILD_PIPEWEED;
    public static BlockClusterFeatureConfig SIMBELMYNE_CONFIG;
    public static BlockClusterFeatureConfig ATHELAS_CONFIG;
    public static BlockClusterFeatureConfig WILD_PIPEWEED_CONFIG;
    private static BlockState LILAC;
    private static BlockState ROSE_BUSH;
    private static BlockState PEONY;
    private static BlockState SUNFLOWER;
    private static BlockState HIBISCUS;
    private static BlockState FLAME_OF_HARAD;
    public static BlockClusterFeatureConfig LILAC_CONFIG;
    public static BlockClusterFeatureConfig ROSE_BUSH_CONFIG;
    public static BlockClusterFeatureConfig PEONY_CONFIG;
    public static BlockClusterFeatureConfig SUNFLOWER_CONFIG;
    public static BlockClusterFeatureConfig HIBISCUS_CONFIG;
    public static BlockClusterFeatureConfig FLAME_OF_HARAD_CONFIG;
    private static BlockState DEAD_BUSH;
    private static BlockClusterFeatureConfig DEAD_BUSH_CONFIG;
    private static BlockState CACTUS;
    private static BlockClusterFeatureConfig CACTUS_CONFIG;
    private static BlockState SAND;
    private static BlockState RED_SAND;
    private static BlockState WHITE_SAND;
    private static BlockState CLAY;
    private static BlockState QUAGMIRE;
    private static BlockState GRASS_BLOCK;
    private static BlockState BROWN_MUSHROOM;
    private static BlockState RED_MUSHROOM;
    private static BlockState MIRK_SHROOM;
    private static BlockClusterFeatureConfig BROWN_MUSHROOM_CONFIG;
    private static BlockClusterFeatureConfig RED_MUSHROOM_CONFIG;
    private static BlockClusterFeatureConfig MIRK_SHROOM_CONFIG;
    private static BlockState SUGAR_CANE;
    private static BlockClusterFeatureConfig SUGAR_CANE_CONFIG;
    private static BlockState REEDS;
    private static BlockState DRIED_REEDS;
    private static Function<Float, ReedsFeatureConfig> REEDS_CONFIG_FOR_DRIED_CHANCE;
    private static final float DEFAULT_DRIED_REEDS_CHANCE = 0.1f;
    private static BlockState PAPYRUS;
    private static ReedsFeatureConfig PAPYRUS_CONFIG;
    private static BlockState RUSHES;
    public static BlockClusterFeatureConfig RUSHES_CONFIG;
    private static BlockState PUMPKIN;
    public static BlockClusterFeatureConfig PUMPKIN_PATCH_CONFIG;
    private static BlockState LILY_PAD;
    private static BlockClusterFeatureConfig LILY_PAD_CONFIG;
    private static BlockState WHITE_WATER_LILY;
    private static BlockState YELLOW_WATER_LILY;
    private static BlockState PURPLE_WATER_LILY;
    private static BlockState PINK_WATER_LILY;
    private static BlockClusterFeatureConfig LILY_PAD_WITH_FLOWERS_CONFIG;
    private static BlockClusterFeatureConfig LILY_PAD_WITH_RARE_FLOWERS_CONFIG;
    private static BlockState SPONGE;
    private static BlockClusterFeatureConfig SPONGE_CONFIG;
    public static BlockState SWEET_BERRY_BUSH;
    public static BlockClusterFeatureConfig SWEET_BERRY_BUSH_CONFIG;
    private static BlockState MORDOR_MOSS;
    public static MordorMossFeatureConfig MORDOR_MOSS_CONFIG;
    private static BlockState MORDOR_GRASS;
    public static BlockClusterFeatureConfig MORDOR_GRASS_CONFIG;
    private static BlockState MORDOR_THORN;
    public static BlockClusterFeatureConfig MORDOR_THORN_CONFIG;
    private static BlockState MORGUL_SHROOM;
    public static BlockClusterFeatureConfig MORGUL_SHROOM_CONFIG;
    private static BlockState MORGUL_FLOWER;
    public static BlockClusterFeatureConfig MORGUL_FLOWER_CONFIG;
    public static LiquidsConfig WATER_SPRING_CONFIG;
    public static LiquidsConfig LAVA_SPRING_CONFIG;

    private static BaseTreeFeatureConfig buildClassicTree(BlockState log, BlockStateProvider leavesPool, int baseHeight, int heightRandA, boolean bees, boolean vines) {
        ArrayList<Object> decorators = new ArrayList<Object>();
        if (bees) {
            decorators.add(Features.Placements.field_243992_c);
        }
        if (vines) {
            decorators.add(TrunkVineTreeDecorator.field_236879_b_);
            decorators.add(LeaveVineTreeDecorator.field_236871_b_);
        }
        return new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(log), leavesPool, (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 3), (AbstractTrunkPlacer)new StraightTrunkPlacer(baseHeight, heightRandA, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_236703_a_((List)ImmutableList.copyOf(decorators)).func_225568_b_();
    }

    private static BaseTreeFeatureConfig buildClassicTree(BlockState log, BlockState leaves, int baseHeight, int heightRandA) {
        return LOTRBiomeFeatures.buildClassicTree(log, (BlockStateProvider)new SimpleBlockStateProvider(leaves), baseHeight, heightRandA, false, false);
    }

    private static BaseTreeFeatureConfig buildClassicTree(BlockState log, BlockStateProvider leavesPool, int baseHeight, int heightRandA) {
        return LOTRBiomeFeatures.buildClassicTree(log, leavesPool, baseHeight, heightRandA, false, false);
    }

    private static BaseTreeFeatureConfig buildClassicTreeWithBees(BlockState log, BlockState leaves, int baseHeight, int heightRandA) {
        return LOTRBiomeFeatures.buildClassicTree(log, (BlockStateProvider)new SimpleBlockStateProvider(leaves), baseHeight, heightRandA, true, false);
    }

    private static BaseTreeFeatureConfig buildClassicTreeWithBees(BlockState log, BlockStateProvider leavesPool, int baseHeight, int heightRandA) {
        return LOTRBiomeFeatures.buildClassicTree(log, leavesPool, baseHeight, heightRandA, true, false);
    }

    private static BaseTreeFeatureConfig buildClassicTreeWithVines(BlockState log, BlockState leaves, int baseHeight, int heightRandA) {
        return LOTRBiomeFeatures.buildClassicTree(log, (BlockStateProvider)new SimpleBlockStateProvider(leaves), baseHeight, heightRandA, false, true);
    }

    private static BaseTreeFeatureConfig buildClassicTreeWithBeesAndVines(BlockState log, BlockState leaves, int baseHeight, int heightRandA) {
        return LOTRBiomeFeatures.buildClassicTree(log, (BlockStateProvider)new SimpleBlockStateProvider(leaves), baseHeight, heightRandA, true, true);
    }

    private static BaseTreeFeatureConfig buildFancyTree(BlockState log, BlockState leaves, boolean bees) {
        ArrayList<BeehiveTreeDecorator> decorators = new ArrayList<BeehiveTreeDecorator>();
        if (bees) {
            decorators.add(Features.Placements.field_243992_c);
        }
        return new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(log), (BlockStateProvider)new SimpleBlockStateProvider(leaves), (FoliagePlacer)new FancyFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)4), 4), (AbstractTrunkPlacer)new FancyTrunkPlacer(3, 11, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0, OptionalInt.of(4))).func_236700_a_().func_236702_a_(Heightmap.Type.MOTION_BLOCKING).func_236703_a_((List)ImmutableList.copyOf(decorators)).func_225568_b_();
    }

    private static BaseTreeFeatureConfig buildFancyTree(BlockState log, BlockState leaves) {
        return LOTRBiomeFeatures.buildFancyTree(log, leaves, false);
    }

    private static BaseTreeFeatureConfig buildFancyTreeWithBees(BlockState log, BlockState leaves) {
        return LOTRBiomeFeatures.buildFancyTree(log, leaves, true);
    }

    private static BaseTreeFeatureConfig buildFangornTree(BlockState log, BlockState wood, BlockState strippedLog, BlockState leaves) {
        return new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(log), (BlockStateProvider)new SimpleBlockStateProvider(leaves), (FoliagePlacer)new ClusterFoliagePlacer(FeatureSpread.func_242252_a((int)3), FeatureSpread.func_242252_a((int)0)), (AbstractTrunkPlacer)new FangornTrunkPlacer(20, 20, 0, wood, strippedLog), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_236703_a_((List)ImmutableList.of((Object)TrunkVineTreeDecorator.field_236879_b_, (Object)LeaveVineTreeDecorator.field_236871_b_)).func_225568_b_();
    }

    public static void setup(RegistryEvent.Register<Block> event) {
        if (event.getRegistry() != ForgeRegistries.BLOCKS) {
            return;
        }
        LOTRWorldCarvers.register();
        MORDOR_ROCK_FILLER = new BlockMatchRuleTest((Block)LOTRBlocks.MORDOR_ROCK.get());
        SAND_FILLER = new TagMatchRuleTest((ITag)BlockTags.field_203436_u);
        STONE = Blocks.field_150348_b.func_176223_P();
        DIRT = Blocks.field_150346_d.func_176223_P();
        COARSE_DIRT = Blocks.field_196660_k.func_176223_P();
        GRAVEL = Blocks.field_150351_n.func_176223_P();
        GRANITE = Blocks.field_196650_c.func_176223_P();
        DIORITE = Blocks.field_196654_e.func_176223_P();
        ANDESITE = Blocks.field_196656_g.func_176223_P();
        PACKED_ICE = Blocks.field_150403_cj.func_176223_P();
        BLUE_ICE = Blocks.field_205164_gk.func_176223_P();
        GONDOR_ROCK = ((Block)LOTRBlocks.GONDOR_ROCK.get()).func_176223_P();
        MORDOR_ROCK = ((Block)LOTRBlocks.MORDOR_ROCK.get()).func_176223_P();
        ROHAN_ROCK = ((Block)LOTRBlocks.ROHAN_ROCK.get()).func_176223_P();
        BLUE_ROCK = ((Block)LOTRBlocks.BLUE_ROCK.get()).func_176223_P();
        RED_ROCK = ((Block)LOTRBlocks.RED_ROCK.get()).func_176223_P();
        MORDOR_DIRT = ((Block)LOTRBlocks.MORDOR_DIRT.get()).func_176223_P();
        MORDOR_GRAVEL = ((Block)LOTRBlocks.MORDOR_GRAVEL.get()).func_176223_P();
        COAL_ORE = Blocks.field_150365_q.func_176223_P();
        IRON_ORE = Blocks.field_150366_p.func_176223_P();
        COPPER_ORE = ((Block)LOTRBlocks.COPPER_ORE.get()).func_176223_P();
        TIN_ORE = ((Block)LOTRBlocks.TIN_ORE.get()).func_176223_P();
        GOLD_ORE = Blocks.field_150352_o.func_176223_P();
        SILVER_ORE = ((Block)LOTRBlocks.SILVER_ORE.get()).func_176223_P();
        SULFUR_ORE = ((Block)LOTRBlocks.SULFUR_ORE.get()).func_176223_P();
        NITER_ORE = ((Block)LOTRBlocks.NITER_ORE.get()).func_176223_P();
        SALT_ORE = ((Block)LOTRBlocks.SALT_ORE.get()).func_176223_P();
        LAPIS_ORE = Blocks.field_150369_x.func_176223_P();
        MITHRIL_ORE = ((Block)LOTRBlocks.MITHRIL_ORE.get()).func_176223_P();
        EDHELVIR_ORE = ((Block)LOTRBlocks.EDHELVIR_ORE.get()).func_176223_P();
        GLOWSTONE_ORE = ((Block)LOTRBlocks.GLOWSTONE_ORE.get()).func_176223_P();
        DURNOR_ORE = ((Block)LOTRBlocks.DURNOR_ORE.get()).func_176223_P();
        MORGUL_IRON_ORE_MORDOR = ((Block)LOTRBlocks.MORGUL_IRON_ORE_MORDOR.get()).func_176223_P();
        MORGUL_IRON_ORE_STONE = ((Block)LOTRBlocks.MORGUL_IRON_ORE_STONE.get()).func_176223_P();
        GULDURIL_ORE_MORDOR = ((Block)LOTRBlocks.GULDURIL_ORE_MORDOR.get()).func_176223_P();
        GULDURIL_ORE_STONE = ((Block)LOTRBlocks.GULDURIL_ORE_STONE.get()).func_176223_P();
        EDHELVIR_CRYSTAL = ((Block)LOTRBlocks.EDHELVIR_CRYSTAL.get()).func_176223_P();
        GULDURIL_CRYSTAL = ((Block)LOTRBlocks.GULDURIL_CRYSTAL.get()).func_176223_P();
        GLOWSTONE_CRYSTAL = ((Block)LOTRBlocks.GLOWSTONE_CRYSTAL.get()).func_176223_P();
        COBWEB = Blocks.field_196553_aF.func_176223_P();
        WATER = Blocks.field_150355_j.func_176223_P();
        LAVA = Blocks.field_150353_l.func_176223_P();
        LOTRTrunkPlacers.register();
        LOTRFoliagePlacers.register();
        LOTRTreeDecorators.register();
        OAK_LOG = Blocks.field_196617_K.func_176223_P();
        OAK_WOOD = Blocks.field_196626_Q.func_176223_P();
        OAK_STRIPPED_LOG = Blocks.field_203204_R.func_176223_P();
        OAK_BRANCH = ((Block)LOTRBlocks.OAK_BRANCH.get()).func_176223_P();
        OAK_LEAVES = Blocks.field_196642_W.func_176223_P();
        OAK_SAPLING = (IPlantable)Blocks.field_196674_t;
        OAK_TREE_VINES = LOTRBiomeFeatures.buildClassicTreeWithVines(OAK_LOG, OAK_LEAVES, 4, 2);
        OAK_TREE_BEES_VINES = LOTRBiomeFeatures.buildClassicTreeWithBeesAndVines(OAK_LOG, OAK_LEAVES, 4, 2);
        OAK_TREE_TALL = LOTRBiomeFeatures.buildClassicTree(OAK_LOG, OAK_LEAVES, 6, 3);
        OAK_TREE_TALL_BEES = LOTRBiomeFeatures.buildClassicTree(OAK_LOG, OAK_LEAVES, 6, 3);
        OAK_TREE_TALL_VINES = LOTRBiomeFeatures.buildClassicTreeWithVines(OAK_LOG, OAK_LEAVES, 6, 3);
        OAK_TREE_TALL_BEES_VINES = LOTRBiomeFeatures.buildClassicTreeWithBeesAndVines(OAK_LOG, OAK_LEAVES, 6, 3);
        OAK_DESERT = new WrappedTreeFeatureConfig(new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(OAK_LOG), (BlockStateProvider)new SimpleBlockStateProvider(OAK_LEAVES), (FoliagePlacer)new DesertFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 2), (AbstractTrunkPlacer)new DesertTrunkPlacer(3, 2, 0, OAK_WOOD), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_(), WrappedTreeFeatureConfig.AlternativeTreeSoil.DESERT);
        OAK_DESERT_BEES = new WrappedTreeFeatureConfig(new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(OAK_LOG), (BlockStateProvider)new SimpleBlockStateProvider(OAK_LEAVES), (FoliagePlacer)new DesertFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 2), (AbstractTrunkPlacer)new DesertTrunkPlacer(3, 2, 0, OAK_WOOD), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_236703_a_((List)ImmutableList.of((Object)Features.Placements.field_243992_c)).func_225568_b_(), WrappedTreeFeatureConfig.AlternativeTreeSoil.DESERT);
        OAK_DEAD = new WrappedTreeFeatureConfig(new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(OAK_LOG), (BlockStateProvider)new SimpleBlockStateProvider(OAK_LEAVES), (FoliagePlacer)new EmptyFoliagePlacer(), (AbstractTrunkPlacer)new DeadTrunkPlacer(2, 3, 0, OAK_WOOD, OAK_BRANCH), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_225568_b_(), WrappedTreeFeatureConfig.AlternativeTreeSoil.DESERT);
        OAK_FANGORN = LOTRBiomeFeatures.buildFangornTree(OAK_LOG, OAK_WOOD, OAK_STRIPPED_LOG, OAK_LEAVES);
        OAK_SHRUB = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(OAK_LOG), (BlockStateProvider)new SimpleBlockStateProvider(OAK_LEAVES), (FoliagePlacer)new BushFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)1), 2), (AbstractTrunkPlacer)new StraightTrunkPlacer(1, 0, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0)).func_236702_a_(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES).func_225568_b_();
        SPRUCE_LOG = Blocks.field_196618_L.func_176223_P();
        SPRUCE_WOOD = Blocks.field_196629_R.func_176223_P();
        SPRUCE_BRANCH = ((Block)LOTRBlocks.SPRUCE_BRANCH.get()).func_176223_P();
        SPRUCE_LEAVES = Blocks.field_196645_X.func_176223_P();
        SPRUCE_SAPLING = (IPlantable)Blocks.field_196675_u;
        SPRUCE_DEAD = new WrappedTreeFeatureConfig(new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(SPRUCE_LOG), (BlockStateProvider)new SimpleBlockStateProvider(SPRUCE_LEAVES), (FoliagePlacer)new EmptyFoliagePlacer(), (AbstractTrunkPlacer)new DeadTrunkPlacer(2, 3, 0, SPRUCE_WOOD, SPRUCE_BRANCH), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_225568_b_(), WrappedTreeFeatureConfig.AlternativeTreeSoil.DESERT);
        SPRUCE_SHRUB = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(SPRUCE_LOG), (BlockStateProvider)new SimpleBlockStateProvider(SPRUCE_LEAVES), (FoliagePlacer)new BushFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)1), 2), (AbstractTrunkPlacer)new StraightTrunkPlacer(1, 0, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0)).func_236702_a_(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES).func_225568_b_();
        BIRCH_LOG = Blocks.field_196619_M.func_176223_P();
        BIRCH_WOOD = Blocks.field_196631_S.func_176223_P();
        BIRCH_BRANCH = ((Block)LOTRBlocks.BIRCH_BRANCH.get()).func_176223_P();
        BIRCH_LEAVES = Blocks.field_196647_Y.func_176223_P();
        BIRCH_SAPLING = (IPlantable)Blocks.field_196676_v;
        BIRCH_TREE_FANCY = LOTRBiomeFeatures.buildFancyTree(BIRCH_LOG, BIRCH_LEAVES);
        BIRCH_TREE_FANCY_BEES = LOTRBiomeFeatures.buildFancyTreeWithBees(BIRCH_LOG, BIRCH_LEAVES);
        BIRCH_TREE_ALT = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(BIRCH_LOG), (BlockStateProvider)new SimpleBlockStateProvider(BIRCH_LEAVES), (FoliagePlacer)new AspenFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242253_a((int)2, (int)2)), (AbstractTrunkPlacer)new StraightTrunkPlacer(8, 8, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_();
        BIRCH_TREE_ALT_BEES = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(BIRCH_LOG), (BlockStateProvider)new SimpleBlockStateProvider(BIRCH_LEAVES), (FoliagePlacer)new AspenFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242253_a((int)2, (int)2)), (AbstractTrunkPlacer)new StraightTrunkPlacer(8, 8, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_236703_a_((List)ImmutableList.of((Object)Features.Placements.field_243992_c)).func_225568_b_();
        BIRCH_DEAD = new WrappedTreeFeatureConfig(new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(BIRCH_LOG), (BlockStateProvider)new SimpleBlockStateProvider(BIRCH_LEAVES), (FoliagePlacer)new EmptyFoliagePlacer(), (AbstractTrunkPlacer)new DeadTrunkPlacer(2, 3, 0, BIRCH_WOOD, BIRCH_BRANCH), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_225568_b_(), WrappedTreeFeatureConfig.AlternativeTreeSoil.DESERT);
        PINE_LOG = ((Block)LOTRBlocks.PINE_LOG.get()).func_176223_P();
        PINE_LOG_SLAB = ((Block)LOTRBlocks.PINE_LOG_SLAB.get()).func_176223_P();
        PINE_LEAVES = ((Block)LOTRBlocks.PINE_LEAVES.get()).func_176223_P();
        PINE_SAPLING = (IPlantable)LOTRBlocks.PINE_SAPLING.get();
        WeightedBlockStateProvider pineBranchProvider = new WeightedBlockStateProvider().func_227407_a_(PINE_LOG, 1).func_227407_a_(PINE_LOG_SLAB, 2);
        PINE_TREE = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(PINE_LOG), (BlockStateProvider)new SimpleBlockStateProvider(PINE_LEAVES), (FoliagePlacer)new LOTRPineFoliagePlacer(FeatureSpread.func_242253_a((int)3, (int)0), FeatureSpread.func_242252_a((int)1), FeatureSpread.func_242253_a((int)6, (int)6)), (AbstractTrunkPlacer)new StraightTrunkPlacer(12, 12, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_236703_a_((List)ImmutableList.of((Object)((Object)new PineBranchDecorator((BlockStateProvider)pineBranchProvider, 0.33f)), (Object)((Object)new PineStripDecorator(0.1f, 0.3f, 0.7f)))).func_225568_b_();
        SHIRE_PINE_TREE = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(PINE_LOG), (BlockStateProvider)new SimpleBlockStateProvider(PINE_LEAVES), (FoliagePlacer)new ShirePineFoliagePlacer(FeatureSpread.func_242253_a((int)2, (int)1), FeatureSpread.func_242252_a((int)1), FeatureSpread.func_242253_a((int)6, (int)3)), (AbstractTrunkPlacer)new StraightTrunkPlacer(10, 10, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_236703_a_((List)ImmutableList.of((Object)((Object)new PineBranchDecorator((BlockStateProvider)pineBranchProvider, 0.33f)), (Object)((Object)new PineStripDecorator(0.1f, 0.3f, 0.7f)))).func_225568_b_();
        PINE_SHRUB = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(PINE_LOG), (BlockStateProvider)new SimpleBlockStateProvider(PINE_LEAVES), (FoliagePlacer)new BushFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)1), 2), (AbstractTrunkPlacer)new StraightTrunkPlacer(1, 0, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0)).func_236702_a_(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES).func_225568_b_();
        MALLORN_LOG = ((Block)LOTRBlocks.MALLORN_LOG.get()).func_176223_P();
        MALLORN_WOOD = ((Block)LOTRBlocks.MALLORN_WOOD.get()).func_176223_P();
        MALLORN_BRANCH = ((Block)LOTRBlocks.MALLORN_BRANCH.get()).func_176223_P();
        MALLORN_LEAVES = ((Block)LOTRBlocks.MALLORN_LEAVES.get()).func_176223_P();
        MALLORN_SAPLING = (IPlantable)LOTRBlocks.MALLORN_SAPLING.get();
        MALLORN_TREE = LOTRBiomeFeatures.buildClassicTree(MALLORN_LOG, MALLORN_LEAVES, 6, 3);
        MALLORN_TREE_BEES = LOTRBiomeFeatures.buildClassicTreeWithBees(MALLORN_LOG, MALLORN_LEAVES, 6, 3);
        MALLORN_TREE_BOUGHS = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(MALLORN_LOG), (BlockStateProvider)new SimpleBlockStateProvider(MALLORN_LEAVES), (FoliagePlacer)new BoughsFoliagePlacer(FeatureSpread.func_242252_a((int)4), FeatureSpread.func_242252_a((int)0), 3), (AbstractTrunkPlacer)new BoughsTrunkPlacer(10, 4, 0, MALLORN_WOOD, MALLORN_BRANCH), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_();
        MIRK_OAK_LOG = ((Block)LOTRBlocks.MIRK_OAK_LOG.get()).func_176223_P();
        MIRK_OAK_WOOD = ((Block)LOTRBlocks.MIRK_OAK_WOOD.get()).func_176223_P();
        MIRK_OAK_BRANCH = ((Block)LOTRBlocks.MIRK_OAK_BRANCH.get()).func_176223_P();
        MIRK_OAK_LEAVES = ((Block)LOTRBlocks.MIRK_OAK_LEAVES.get()).func_176223_P();
        MIRK_OAK_SAPLING = (IPlantable)LOTRBlocks.MIRK_OAK_SAPLING.get();
        MIRK_OAK_TREE = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(MIRK_OAK_LOG), (BlockStateProvider)new SimpleBlockStateProvider(MIRK_OAK_LEAVES), (FoliagePlacer)new MirkOakFoliagePlacer(FeatureSpread.func_242253_a((int)3, (int)1), FeatureSpread.func_242252_a((int)0), 3), (AbstractTrunkPlacer)new MirkOakTrunkPlacer(4, 5, 0, MIRK_OAK_WOOD, MIRK_OAK_BRANCH), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_236703_a_((List)ImmutableList.of((Object)((Object)new MirkOakLeavesGrowthDecorator()), (Object)((Object)new MirkOakWebsDecorator(true, 0.25f, 0.1f, 0.15f)), (Object)((Object)new MirkOakWebsDecorator(true, 0.05f, 0.35f, 0.2f)), (Object)new LeaveVineTreeDecorator())).func_225568_b_();
        CHARRED_LOG = ((Block)LOTRBlocks.CHARRED_LOG.get()).func_176223_P();
        CHARRED_WOOD = ((Block)LOTRBlocks.CHARRED_WOOD.get()).func_176223_P();
        CHARRED_BRANCH = ((Block)LOTRBlocks.CHARRED_BRANCH.get()).func_176223_P();
        CHARRED_TREE = new WrappedTreeFeatureConfig(new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(CHARRED_LOG), (BlockStateProvider)new SimpleBlockStateProvider(OAK_LEAVES), (FoliagePlacer)new EmptyFoliagePlacer(), (AbstractTrunkPlacer)new DeadTrunkPlacer(2, 3, 0, CHARRED_WOOD, CHARRED_BRANCH), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_225568_b_(), WrappedTreeFeatureConfig.AlternativeTreeSoil.CHARRED);
        APPLE_LOG = ((Block)LOTRBlocks.APPLE_LOG.get()).func_176223_P();
        APPLE_LEAVES = ((Block)LOTRBlocks.APPLE_LEAVES.get()).func_176223_P();
        APPLE_LEAVES_RED = ((Block)LOTRBlocks.APPLE_LEAVES_RED.get()).func_176223_P();
        APPLE_LEAVES_GREEN = ((Block)LOTRBlocks.APPLE_LEAVES_GREEN.get()).func_176223_P();
        APPLE_LEAVES_RED_POOL = new WeightedBlockStateProvider().func_227407_a_(APPLE_LEAVES, 15).func_227407_a_(APPLE_LEAVES_RED, 1);
        APPLE_LEAVES_GREEN_POOL = new WeightedBlockStateProvider().func_227407_a_(APPLE_LEAVES, 15).func_227407_a_(APPLE_LEAVES_GREEN, 1);
        APPLE_LEAVES_MIX_POOL = new WeightedBlockStateProvider().func_227407_a_(APPLE_LEAVES, 30).func_227407_a_(APPLE_LEAVES_RED, 1).func_227407_a_(APPLE_LEAVES_GREEN, 1);
        APPLE_SAPLING = (IPlantable)LOTRBlocks.APPLE_SAPLING.get();
        APPLE_TREE_RED = LOTRBiomeFeatures.buildClassicTree(APPLE_LOG, APPLE_LEAVES_RED_POOL, 4, 3);
        APPLE_TREE_RED_BEES = LOTRBiomeFeatures.buildClassicTreeWithBees(APPLE_LOG, APPLE_LEAVES_RED_POOL, 4, 3);
        APPLE_TREE_GREEN = LOTRBiomeFeatures.buildClassicTree(APPLE_LOG, APPLE_LEAVES_GREEN_POOL, 4, 3);
        APPLE_TREE_GREEN_BEES = LOTRBiomeFeatures.buildClassicTreeWithBees(APPLE_LOG, APPLE_LEAVES_GREEN_POOL, 4, 3);
        APPLE_TREE_MIX = LOTRBiomeFeatures.buildClassicTree(APPLE_LOG, APPLE_LEAVES_MIX_POOL, 4, 3);
        APPLE_TREE_MIX_BEES = LOTRBiomeFeatures.buildClassicTreeWithBees(APPLE_LOG, APPLE_LEAVES_MIX_POOL, 4, 3);
        PEAR_LOG = ((Block)LOTRBlocks.PEAR_LOG.get()).func_176223_P();
        PEAR_LEAVES = ((Block)LOTRBlocks.PEAR_LEAVES.get()).func_176223_P();
        PEAR_LEAVES_FRUIT = ((Block)LOTRBlocks.PEAR_LEAVES_FRUIT.get()).func_176223_P();
        PEAR_LEAVES_POOL = new WeightedBlockStateProvider().func_227407_a_(PEAR_LEAVES, 15).func_227407_a_(PEAR_LEAVES_FRUIT, 1);
        PEAR_SAPLING = (IPlantable)LOTRBlocks.PEAR_SAPLING.get();
        PEAR_TREE = LOTRBiomeFeatures.buildClassicTree(PEAR_LOG, PEAR_LEAVES_POOL, 4, 1);
        PEAR_TREE_BEES = LOTRBiomeFeatures.buildClassicTreeWithBees(PEAR_LOG, PEAR_LEAVES_POOL, 4, 1);
        CHERRY_LOG = ((Block)LOTRBlocks.CHERRY_LOG.get()).func_176223_P();
        CHERRY_LEAVES = ((Block)LOTRBlocks.CHERRY_LEAVES.get()).func_176223_P();
        CHERRY_LEAVES_FRUIT = ((Block)LOTRBlocks.CHERRY_LEAVES_FRUIT.get()).func_176223_P();
        CHERRY_LEAVES_POOL = new WeightedBlockStateProvider().func_227407_a_(CHERRY_LEAVES, 7).func_227407_a_(CHERRY_LEAVES_FRUIT, 1);
        CHERRY_SAPLING = (IPlantable)LOTRBlocks.CHERRY_SAPLING.get();
        CHERRY_TREE = LOTRBiomeFeatures.buildClassicTree(CHERRY_LOG, CHERRY_LEAVES_POOL, 4, 4);
        CHERRY_TREE_BEES = LOTRBiomeFeatures.buildClassicTreeWithBees(CHERRY_LOG, CHERRY_LEAVES_POOL, 4, 4);
        LEBETHRON_LOG = ((Block)LOTRBlocks.LEBETHRON_LOG.get()).func_176223_P();
        LEBETHRON_LEAVES = ((Block)LOTRBlocks.LEBETHRON_LEAVES.get()).func_176223_P();
        LEBETHRON_SAPLING = (IPlantable)LOTRBlocks.LEBETHRON_SAPLING.get();
        LEBETHRON_TREE = LOTRBiomeFeatures.buildClassicTree(LEBETHRON_LOG, LEBETHRON_LEAVES, 5, 4);
        LEBETHRON_TREE_BEES = LOTRBiomeFeatures.buildClassicTreeWithBees(LEBETHRON_LOG, LEBETHRON_LEAVES, 5, 4);
        LEBETHRON_TREE_FANCY = LOTRBiomeFeatures.buildFancyTree(LEBETHRON_LOG, LEBETHRON_LEAVES);
        LEBETHRON_TREE_FANCY_BEES = LOTRBiomeFeatures.buildFancyTreeWithBees(LEBETHRON_LOG, LEBETHRON_LEAVES);
        BEECH_LOG = ((Block)LOTRBlocks.BEECH_LOG.get()).func_176223_P();
        BEECH_WOOD = ((Block)LOTRBlocks.BEECH_WOOD.get()).func_176223_P();
        BEECH_STRIPPED_LOG = ((Block)LOTRBlocks.STRIPPED_BEECH_LOG.get()).func_176223_P();
        BEECH_BRANCH = ((Block)LOTRBlocks.BEECH_BRANCH.get()).func_176223_P();
        BEECH_LEAVES = ((Block)LOTRBlocks.BEECH_LEAVES.get()).func_176223_P();
        BEECH_SAPLING = (IPlantable)LOTRBlocks.BEECH_SAPLING.get();
        BEECH_TREE = LOTRBiomeFeatures.buildClassicTree(BEECH_LOG, BEECH_LEAVES, 5, 4);
        BEECH_TREE_BEES = LOTRBiomeFeatures.buildClassicTreeWithBees(BEECH_LOG, BEECH_LEAVES, 5, 4);
        BEECH_TREE_FANCY = LOTRBiomeFeatures.buildFancyTree(BEECH_LOG, BEECH_LEAVES);
        BEECH_TREE_FANCY_BEES = LOTRBiomeFeatures.buildFancyTreeWithBees(BEECH_LOG, BEECH_LEAVES);
        BEECH_FANGORN = LOTRBiomeFeatures.buildFangornTree(BEECH_LOG, BEECH_WOOD, BEECH_STRIPPED_LOG, BEECH_LEAVES);
        BEECH_DEAD = new WrappedTreeFeatureConfig(new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(BEECH_LOG), (BlockStateProvider)new SimpleBlockStateProvider(BEECH_LEAVES), (FoliagePlacer)new EmptyFoliagePlacer(), (AbstractTrunkPlacer)new DeadTrunkPlacer(2, 3, 0, BEECH_WOOD, BEECH_BRANCH), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_225568_b_(), WrappedTreeFeatureConfig.AlternativeTreeSoil.DESERT);
        MAPLE_LOG = ((Block)LOTRBlocks.MAPLE_LOG.get()).func_176223_P();
        MAPLE_LEAVES = ((Block)LOTRBlocks.MAPLE_LEAVES.get()).func_176223_P();
        MAPLE_SAPLING = (IPlantable)LOTRBlocks.MAPLE_SAPLING.get();
        MAPLE_TREE = LOTRBiomeFeatures.buildClassicTree(MAPLE_LOG, MAPLE_LEAVES, 4, 4);
        MAPLE_TREE_BEES = LOTRBiomeFeatures.buildClassicTreeWithBees(MAPLE_LOG, MAPLE_LEAVES, 4, 4);
        MAPLE_TREE_FANCY = LOTRBiomeFeatures.buildFancyTree(MAPLE_LOG, MAPLE_LEAVES);
        MAPLE_TREE_FANCY_BEES = LOTRBiomeFeatures.buildFancyTreeWithBees(MAPLE_LOG, MAPLE_LEAVES);
        ASPEN_LOG = ((Block)LOTRBlocks.ASPEN_LOG.get()).func_176223_P();
        ASPEN_LEAVES = ((Block)LOTRBlocks.ASPEN_LEAVES.get()).func_176223_P();
        ASPEN_SAPLING = (IPlantable)LOTRBlocks.ASPEN_SAPLING.get();
        ASPEN_TREE = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(ASPEN_LOG), (BlockStateProvider)new SimpleBlockStateProvider(ASPEN_LEAVES), (FoliagePlacer)new AspenFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242253_a((int)2, (int)2)), (AbstractTrunkPlacer)new StraightTrunkPlacer(8, 7, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_();
        LAIRELOSSE_LOG = ((Block)LOTRBlocks.LAIRELOSSE_LOG.get()).func_176223_P();
        LAIRELOSSE_LEAVES = ((Block)LOTRBlocks.LAIRELOSSE_LEAVES.get()).func_176223_P();
        LAIRELOSSE_SAPLING = (IPlantable)LOTRBlocks.LAIRELOSSE_SAPLING.get();
        LAIRELOSSE_TREE = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(LAIRELOSSE_LOG), (BlockStateProvider)new SimpleBlockStateProvider(LAIRELOSSE_LEAVES), (FoliagePlacer)new LairelosseFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)1), FeatureSpread.func_242253_a((int)1, (int)2)), (AbstractTrunkPlacer)new StraightTrunkPlacer(5, 3, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_();
        CEDAR_LOG = ((Block)LOTRBlocks.CEDAR_LOG.get()).func_176223_P();
        CEDAR_WOOD = ((Block)LOTRBlocks.CEDAR_WOOD.get()).func_176223_P();
        CEDAR_BRANCH = ((Block)LOTRBlocks.CEDAR_BRANCH.get()).func_176223_P();
        CEDAR_LEAVES = ((Block)LOTRBlocks.CEDAR_LEAVES.get()).func_176223_P();
        CEDAR_SAPLING = (IPlantable)LOTRBlocks.CEDAR_SAPLING.get();
        CEDAR_TREE = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(CEDAR_LOG), (BlockStateProvider)new SimpleBlockStateProvider(CEDAR_LEAVES), (FoliagePlacer)new CedarFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 3), (AbstractTrunkPlacer)new CedarTrunkPlacer(10, 6, 0, CEDAR_BRANCH), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_();
        CEDAR_TREE_LARGE = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(CEDAR_LOG), (BlockStateProvider)new SimpleBlockStateProvider(CEDAR_LEAVES), (FoliagePlacer)new CedarFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 3), (AbstractTrunkPlacer)new CedarTrunkPlacer(15, 15, 0, CEDAR_BRANCH), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_();
        FIR_LOG = ((Block)LOTRBlocks.FIR_LOG.get()).func_176223_P();
        FIR_LEAVES = ((Block)LOTRBlocks.FIR_LEAVES.get()).func_176223_P();
        FIR_SAPLING = (IPlantable)LOTRBlocks.FIR_SAPLING.get();
        FIR_TREE = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(FIR_LOG), (BlockStateProvider)new SimpleBlockStateProvider(FIR_LEAVES), (FoliagePlacer)new FirFoliagePlacer(FeatureSpread.func_242253_a((int)3, (int)0), FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242253_a((int)7, (int)4)), (AbstractTrunkPlacer)new StraightTrunkPlacer(6, 7, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_();
        LARCH_LOG = ((Block)LOTRBlocks.LARCH_LOG.get()).func_176223_P();
        LARCH_LEAVES = ((Block)LOTRBlocks.LARCH_LEAVES.get()).func_176223_P();
        LARCH_SAPLING = (IPlantable)LOTRBlocks.LARCH_SAPLING.get();
        LARCH_TREE = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(LARCH_LOG), (BlockStateProvider)new SimpleBlockStateProvider(LARCH_LEAVES), (FoliagePlacer)new SpruceFoliagePlacer(FeatureSpread.func_242253_a((int)2, (int)1), FeatureSpread.func_242253_a((int)0, (int)2), FeatureSpread.func_242253_a((int)2, (int)1)), (AbstractTrunkPlacer)new StraightTrunkPlacer(8, 8, 0), (AbstractFeatureSizeType)new TwoLayerFeature(2, 0, 2)).func_236700_a_().func_225568_b_();
        HOLLY_LOG = ((Block)LOTRBlocks.HOLLY_LOG.get()).func_176223_P();
        HOLLY_LEAVES = ((Block)LOTRBlocks.HOLLY_LEAVES.get()).func_176223_P();
        HOLLY_SAPLING = (IPlantable)LOTRBlocks.HOLLY_SAPLING.get();
        HOLLY_TREE = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(HOLLY_LOG), (BlockStateProvider)new SimpleBlockStateProvider(HOLLY_LEAVES), (FoliagePlacer)new HollyFoliagePlacer(FeatureSpread.func_242253_a((int)2, (int)0), FeatureSpread.func_242252_a((int)0), FeatureSpread.func_242253_a((int)1, (int)2)), (AbstractTrunkPlacer)new StraightTrunkPlacer(9, 5, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_();
        HOLLY_TREE_BEES = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(HOLLY_LOG), (BlockStateProvider)new SimpleBlockStateProvider(HOLLY_LEAVES), (FoliagePlacer)new HollyFoliagePlacer(FeatureSpread.func_242253_a((int)2, (int)0), FeatureSpread.func_242252_a((int)0), FeatureSpread.func_242253_a((int)1, (int)2)), (AbstractTrunkPlacer)new StraightTrunkPlacer(9, 5, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_236703_a_((List)ImmutableList.of((Object)Features.Placements.field_243992_c)).func_225568_b_();
        GREEN_OAK_LOG = ((Block)LOTRBlocks.GREEN_OAK_LOG.get()).func_176223_P();
        GREEN_OAK_WOOD = ((Block)LOTRBlocks.GREEN_OAK_WOOD.get()).func_176223_P();
        GREEN_OAK_BRANCH = ((Block)LOTRBlocks.GREEN_OAK_BRANCH.get()).func_176223_P();
        GREEN_OAK_LEAVES = ((Block)LOTRBlocks.GREEN_OAK_LEAVES.get()).func_176223_P();
        GREEN_OAK_SAPLING = (IPlantable)LOTRBlocks.GREEN_OAK_SAPLING.get();
        RED_OAK_LEAVES = ((Block)LOTRBlocks.RED_OAK_LEAVES.get()).func_176223_P();
        RED_OAK_SAPLING = (IPlantable)LOTRBlocks.RED_OAK_SAPLING.get();
        GREEN_OAK_TREE = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GREEN_OAK_LOG), (BlockStateProvider)new SimpleBlockStateProvider(GREEN_OAK_LEAVES), (FoliagePlacer)new MirkOakFoliagePlacer(FeatureSpread.func_242252_a((int)3), FeatureSpread.func_242252_a((int)0), 3), (AbstractTrunkPlacer)new MirkOakTrunkPlacer(4, 4, 0, GREEN_OAK_WOOD, GREEN_OAK_BRANCH), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_();
        GREEN_OAK_TREE_BEES = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GREEN_OAK_LOG), (BlockStateProvider)new SimpleBlockStateProvider(GREEN_OAK_LEAVES), (FoliagePlacer)new MirkOakFoliagePlacer(FeatureSpread.func_242252_a((int)3), FeatureSpread.func_242252_a((int)0), 3), (AbstractTrunkPlacer)new MirkOakTrunkPlacer(4, 4, 0, GREEN_OAK_WOOD, GREEN_OAK_BRANCH), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_236703_a_((List)ImmutableList.of((Object)Features.Placements.field_243992_c)).func_225568_b_();
        RED_OAK_TREE = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GREEN_OAK_LOG), (BlockStateProvider)new SimpleBlockStateProvider(RED_OAK_LEAVES), (FoliagePlacer)new MirkOakFoliagePlacer(FeatureSpread.func_242253_a((int)3, (int)1), FeatureSpread.func_242252_a((int)0), 3), (AbstractTrunkPlacer)new MirkOakTrunkPlacer(6, 3, 0, GREEN_OAK_WOOD, GREEN_OAK_BRANCH), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_();
        RED_OAK_TREE_BEES = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GREEN_OAK_LOG), (BlockStateProvider)new SimpleBlockStateProvider(RED_OAK_LEAVES), (FoliagePlacer)new MirkOakFoliagePlacer(FeatureSpread.func_242253_a((int)3, (int)1), FeatureSpread.func_242252_a((int)0), 3), (AbstractTrunkPlacer)new MirkOakTrunkPlacer(6, 3, 0, GREEN_OAK_WOOD, GREEN_OAK_BRANCH), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_236703_a_((List)ImmutableList.of((Object)Features.Placements.field_243992_c)).func_225568_b_();
        CYPRESS_LOG = ((Block)LOTRBlocks.CYPRESS_LOG.get()).func_176223_P();
        CYPRESS_LEAVES = ((Block)LOTRBlocks.CYPRESS_LEAVES.get()).func_176223_P();
        CYPRESS_SAPLING = (IPlantable)LOTRBlocks.CYPRESS_SAPLING.get();
        CYPRESS_TREE = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(CYPRESS_LOG), (BlockStateProvider)new SimpleBlockStateProvider(CYPRESS_LEAVES), (FoliagePlacer)new CypressFoliagePlacer(FeatureSpread.func_242252_a((int)1), FeatureSpread.func_242252_a((int)1), FeatureSpread.func_242253_a((int)3, (int)1)), (AbstractTrunkPlacer)new StraightTrunkPlacer(8, 5, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_();
        GRASS = Blocks.field_150349_c.func_176223_P();
        FERN = Blocks.field_196554_aH.func_176223_P();
        SHORT_GRASS = ((Block)LOTRBlocks.SHORT_GRASS.get()).func_176223_P();
        WHEATGRASS = ((Block)LOTRBlocks.WHEATGRASS.get()).func_176223_P();
        FLOWERY_GRASS = ((Block)LOTRBlocks.FLOWERY_GRASS.get()).func_176223_P();
        PURPLE_MOOR_GRASS = ((Block)LOTRBlocks.PURPLE_MOOR_GRASS.get()).func_176223_P();
        RED_MOOR_GRASS = ((Block)LOTRBlocks.RED_MOOR_GRASS.get()).func_176223_P();
        THISTLE = ((Block)LOTRBlocks.THISTLE.get()).func_176223_P();
        NETTLES = ((Block)LOTRBlocks.NETTLES.get()).func_176223_P();
        FERNSPROUT = ((Block)LOTRBlocks.FERNSPROUT.get()).func_176223_P();
        WILD_FLAX = ((Block)LOTRBlocks.WILD_FLAX.get()).func_176223_P();
        ARID_GRASS = ((Block)LOTRBlocks.ARID_GRASS.get()).func_176223_P();
        GRASS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GRASS), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
        FERN_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(FERN), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
        SHORT_GRASS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(SHORT_GRASS), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
        WHEATGRASS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(WHEATGRASS), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
        FLOWERY_GRASS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(FLOWERY_GRASS), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
        PURPLE_MOOR_GRASS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(PURPLE_MOOR_GRASS), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(100).func_227322_d_();
        RED_MOOR_GRASS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(RED_MOOR_GRASS), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(100).func_227322_d_();
        THISTLE_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(THISTLE), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
        NETTLES_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(NETTLES), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
        FERNSPROUT_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(FERNSPROUT), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
        WILD_FLAX_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(WILD_FLAX), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
        ARID_GRASS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(ARID_GRASS), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
        CLOVER = ((Block)LOTRBlocks.CLOVER.get()).func_176223_P();
        FOUR_LEAF_CLOVER = ((Block)LOTRBlocks.FOUR_LEAF_CLOVER.get()).func_176223_P();
        BlockState CLOVER_2 = (BlockState)CLOVER.func_206870_a((Property)ThreeLeafCloverBlock.NUM_CLOVERS, (Comparable)Integer.valueOf(2));
        BlockState CLOVER_3 = (BlockState)CLOVER.func_206870_a((Property)ThreeLeafCloverBlock.NUM_CLOVERS, (Comparable)Integer.valueOf(3));
        BlockState CLOVER_4 = (BlockState)CLOVER.func_206870_a((Property)ThreeLeafCloverBlock.NUM_CLOVERS, (Comparable)Integer.valueOf(4));
        CLOVER_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(CLOVER, 1250).func_227407_a_(CLOVER_2, 1250).func_227407_a_(CLOVER_3, 1250).func_227407_a_(CLOVER_4, 1250).func_227407_a_(FOUR_LEAF_CLOVER, 1), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
        SHIRE_CLOVER_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(CLOVER, 1250).func_227407_a_(CLOVER_2, 1250).func_227407_a_(CLOVER_3, 1250).func_227407_a_(CLOVER_4, 1250).func_227407_a_(FOUR_LEAF_CLOVER, 10), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
        DOUBLE_GRASS = Blocks.field_196804_gh.func_176223_P();
        DOUBLE_FERN = Blocks.field_196805_gi.func_176223_P();
        DOUBLE_WHEATGRASS = ((Block)LOTRBlocks.TALL_WHEATGRASS.get()).func_176223_P();
        DOUBLE_ARID_GRASS = ((Block)LOTRBlocks.TALL_ARID_GRASS.get()).func_176223_P();
        DOUBLE_GRASS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(DOUBLE_GRASS), (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
        DOUBLE_FERN_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(DOUBLE_FERN), (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
        DOUBLE_WHEATGRASS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(DOUBLE_WHEATGRASS), (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
        DOUBLE_ARID_GRASS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(DOUBLE_ARID_GRASS), (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
        SIMBELMYNE = ((Block)LOTRBlocks.SIMBELMYNE.get()).func_176223_P();
        ATHELAS = ((Block)LOTRBlocks.ATHELAS.get()).func_176223_P();
        WILD_PIPEWEED = ((Block)LOTRBlocks.WILD_PIPEWEED.get()).func_176223_P();
        SIMBELMYNE_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(SIMBELMYNE), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
        ATHELAS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(ATHELAS), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
        WILD_PIPEWEED_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(WILD_PIPEWEED), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
        LILAC = Blocks.field_196801_ge.func_176223_P();
        ROSE_BUSH = Blocks.field_196802_gf.func_176223_P();
        PEONY = Blocks.field_196803_gg.func_176223_P();
        SUNFLOWER = Blocks.field_196800_gd.func_176223_P();
        HIBISCUS = ((Block)LOTRBlocks.HIBISCUS.get()).func_176223_P();
        FLAME_OF_HARAD = ((Block)LOTRBlocks.FLAME_OF_HARAD.get()).func_176223_P();
        LILAC_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(LILAC), (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
        ROSE_BUSH_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(ROSE_BUSH), (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
        PEONY_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(PEONY), (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
        SUNFLOWER_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(SUNFLOWER), (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
        HIBISCUS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(HIBISCUS), (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
        FLAME_OF_HARAD_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(FLAME_OF_HARAD), (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
        DEAD_BUSH = Blocks.field_196555_aI.func_176223_P();
        DEAD_BUSH_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(DEAD_BUSH), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(4).func_227322_d_();
        CACTUS = Blocks.field_150434_aF.func_176223_P();
        CACTUS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(CACTUS), (BlockPlacer)new ColumnBlockPlacer(1, 2)).func_227315_a_(10).func_227317_b_().func_227322_d_();
        SAND = Blocks.field_150354_m.func_176223_P();
        RED_SAND = Blocks.field_196611_F.func_176223_P();
        WHITE_SAND = ((Block)LOTRBlocks.WHITE_SAND.get()).func_176223_P();
        CLAY = Blocks.field_150435_aG.func_176223_P();
        QUAGMIRE = ((Block)LOTRBlocks.QUAGMIRE.get()).func_176223_P();
        GRASS_BLOCK = Blocks.field_196658_i.func_176223_P();
        BROWN_MUSHROOM = Blocks.field_150338_P.func_176223_P();
        RED_MUSHROOM = Blocks.field_150337_Q.func_176223_P();
        MIRK_SHROOM = ((Block)LOTRBlocks.MIRK_SHROOM.get()).func_176223_P();
        BROWN_MUSHROOM_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(BROWN_MUSHROOM), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
        RED_MUSHROOM_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(RED_MUSHROOM), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
        MIRK_SHROOM_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(MIRK_SHROOM), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
        SUGAR_CANE = Blocks.field_196608_cF.func_176223_P();
        SUGAR_CANE_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(SUGAR_CANE), (BlockPlacer)new ColumnBlockPlacer(2, 2)).func_227315_a_(20).func_227318_b_(4).func_227321_c_(0).func_227323_d_(4).func_227317_b_().func_227320_c_().func_227322_d_();
        REEDS = ((Block)LOTRBlocks.REEDS.get()).func_176223_P();
        DRIED_REEDS = ((Block)LOTRBlocks.DRIED_REEDS.get()).func_176223_P();
        REEDS_CONFIG_FOR_DRIED_CHANCE = driedChance -> {
            float freshChance = 1.0f - driedChance.floatValue();
            int weight = 1000;
            WeightedBlockStateProvider blockProv = new WeightedBlockStateProvider().func_227407_a_(REEDS, (int)(freshChance * (float)weight)).func_227407_a_(DRIED_REEDS, (int)(driedChance.floatValue() * (float)weight));
            return new ReedsFeatureConfig((BlockStateProvider)blockProv, 32, 5, 2, 5, 0.75f);
        };
        PAPYRUS = ((Block)LOTRBlocks.PAPYRUS.get()).func_176223_P();
        PAPYRUS_CONFIG = new ReedsFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PAPYRUS), 32, 5, 2, 5, 0.75f);
        RUSHES = ((Block)LOTRBlocks.RUSHES.get()).func_176223_P();
        RUSHES_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(RUSHES), (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227314_a_().func_227322_d_();
        PUMPKIN = Blocks.field_150423_aK.func_176223_P();
        PUMPKIN_PATCH_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(PUMPKIN), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227316_a_((Set)ImmutableSet.of((Object)GRASS_BLOCK.func_177230_c())).func_227317_b_().func_227322_d_();
        LILY_PAD = Blocks.field_196651_dG.func_176223_P();
        LILY_PAD_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(LILY_PAD), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(10).func_227322_d_();
        WHITE_WATER_LILY = ((Block)LOTRBlocks.WHITE_WATER_LILY.get()).func_176223_P();
        YELLOW_WATER_LILY = ((Block)LOTRBlocks.YELLOW_WATER_LILY.get()).func_176223_P();
        PURPLE_WATER_LILY = ((Block)LOTRBlocks.PURPLE_WATER_LILY.get()).func_176223_P();
        PINK_WATER_LILY = ((Block)LOTRBlocks.PINK_WATER_LILY.get()).func_176223_P();
        LILY_PAD_WITH_FLOWERS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(LILY_PAD, 5).func_227407_a_(WHITE_WATER_LILY, 1).func_227407_a_(YELLOW_WATER_LILY, 1).func_227407_a_(PURPLE_WATER_LILY, 1).func_227407_a_(PINK_WATER_LILY, 1), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(10).func_227322_d_();
        LILY_PAD_WITH_RARE_FLOWERS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(LILY_PAD, 80).func_227407_a_(WHITE_WATER_LILY, 1).func_227407_a_(YELLOW_WATER_LILY, 1).func_227407_a_(PURPLE_WATER_LILY, 1).func_227407_a_(PINK_WATER_LILY, 1), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(10).func_227322_d_();
        SPONGE = Blocks.field_196577_ad.func_176223_P();
        SPONGE_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(SPONGE), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227316_a_((Set)ImmutableSet.of((Object)SAND.func_177230_c(), (Object)GRAVEL.func_177230_c())).func_227314_a_().func_227317_b_().func_227322_d_();
        SWEET_BERRY_BUSH = (BlockState)Blocks.field_222434_lW.func_176223_P().func_206870_a((Property)SweetBerryBushBlock.field_220125_a, (Comparable)Integer.valueOf(3));
        SWEET_BERRY_BUSH_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(SWEET_BERRY_BUSH), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227316_a_((Set)ImmutableSet.of((Object)GRASS_BLOCK.func_177230_c())).func_227317_b_().func_227322_d_();
        MORDOR_MOSS = ((Block)LOTRBlocks.MORDOR_MOSS.get()).func_176223_P();
        MORDOR_MOSS_CONFIG = new MordorMossFeatureConfig(MORDOR_MOSS, 32, 80);
        MORDOR_GRASS = ((Block)LOTRBlocks.MORDOR_GRASS.get()).func_176223_P();
        MORDOR_GRASS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(MORDOR_GRASS), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
        MORDOR_THORN = ((Block)LOTRBlocks.MORDOR_THORN.get()).func_176223_P();
        MORDOR_THORN_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(MORDOR_THORN), (BlockPlacer)new SimpleBlockPlacer()).func_227318_b_(6).func_227321_c_(2).func_227323_d_(6).func_227315_a_(160).func_227322_d_();
        MORGUL_SHROOM = ((Block)LOTRBlocks.MORGUL_SHROOM.get()).func_176223_P();
        MORGUL_SHROOM_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(MORGUL_SHROOM), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
        MORGUL_FLOWER = ((Block)LOTRBlocks.MORGUL_FLOWER.get()).func_176223_P();
        MORGUL_FLOWER_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(MORGUL_FLOWER), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
        ImmutableSet springStoneSet = ImmutableSet.of((Object)Blocks.field_150348_b, (Object)Blocks.field_196650_c, (Object)Blocks.field_196654_e, (Object)Blocks.field_196656_g, (Object)LOTRBlocks.GONDOR_ROCK.get(), (Object)LOTRBlocks.MORDOR_ROCK.get(), (Object[])new Block[]{(Block)LOTRBlocks.ROHAN_ROCK.get(), (Block)LOTRBlocks.BLUE_ROCK.get(), (Block)LOTRBlocks.RED_ROCK.get(), (Block)LOTRBlocks.CHALK.get(), (Block)LOTRBlocks.DIRTY_CHALK.get()});
        WATER_SPRING_CONFIG = new LiquidsConfig(Fluids.field_204546_a.func_207188_f(), true, 4, 1, (Set)springStoneSet);
        LAVA_SPRING_CONFIG = new LiquidsConfig(Fluids.field_204547_b.func_207188_f(), true, 4, 1, (Set)springStoneSet);
    }

    public static void addCarvers(BiomeGenerationSettings.Builder builder) {
        float caveChance = 0.14285715f;
        float canyonChance = 0.02f;
        LOTRBiomeFeatures.addCarvers(builder, caveChance, canyonChance);
    }

    public static void addCarversExtraCanyons(BiomeGenerationSettings.Builder builder) {
        float caveChance = 0.14285715f;
        float canyonChance = 0.2f;
        LOTRBiomeFeatures.addCarvers(builder, caveChance, canyonChance);
    }

    public static void addCarvers(BiomeGenerationSettings.Builder builder, float caveChance, float canyonChance) {
        builder.func_242512_a(GenerationStage.Carving.AIR, LOTRWorldCarvers.CAVE.func_242761_a((ICarverConfig)new ProbabilityConfig(caveChance)));
        builder.func_242512_a(GenerationStage.Carving.AIR, LOTRWorldCarvers.CANYON.func_242761_a((ICarverConfig)new ProbabilityConfig(canyonChance)));
    }

    public static void addSeaCarvers(BiomeGenerationSettings.Builder builder) {
        builder.func_242512_a(GenerationStage.Carving.AIR, LOTRWorldCarvers.CAVE.func_242761_a((ICarverConfig)new ProbabilityConfig(0.06666667f)));
        builder.func_242512_a(GenerationStage.Carving.AIR, LOTRWorldCarvers.CANYON.func_242761_a((ICarverConfig)new ProbabilityConfig(0.02f)));
        builder.func_242512_a(GenerationStage.Carving.LIQUID, LOTRWorldCarvers.UNDERWATER_CAVE.func_242761_a((ICarverConfig)new ProbabilityConfig(0.06666667f)));
        builder.func_242512_a(GenerationStage.Carving.LIQUID, LOTRWorldCarvers.UNDERWATER_CANYON.func_242761_a((ICarverConfig)new ProbabilityConfig(0.02f)));
    }

    public static void addDirtGravel(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, DIRT, 33)).func_242733_d(256)).func_242728_a()).func_242731_b(10));
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, GRAVEL, 33)).func_242733_d(256)).func_242728_a()).func_242731_b(8));
    }

    public static void addMordorDirtGravel(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(MORDOR_ROCK_FILLER, MORDOR_DIRT, 61)).func_242733_d(256)).func_242728_a()).func_242731_b(10));
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(MORDOR_ROCK_FILLER, MORDOR_GRAVEL, 33)).func_242733_d(256)).func_242728_a()).func_242731_b(10));
    }

    public static void addAndesite(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addStoneVariety(builder, ANDESITE, 10, 80);
    }

    public static void addDiorite(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addStoneVariety(builder, DIORITE, 5, 80);
    }

    public static void addDeepDiorite(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addStoneVariety(builder, DIORITE, 5, 32);
    }

    public static void addGranite(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addStoneVariety(builder, GRANITE, 5, 80);
    }

    public static void addCommonGranite(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addStoneVariety(builder, GRANITE, 12, 96);
    }

    private static void addStoneVariety(BiomeGenerationSettings.Builder builder, BlockState stone, int freq, int height) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, stone, 61)).func_242733_d(height)).func_242728_a()).func_242731_b(freq));
    }

    public static void addGondorRockPatches(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, GONDOR_ROCK, 61)).func_242733_d(80)).func_242728_a()).func_242731_b(4));
    }

    public static void addRohanRockPatches(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ROHAN_ROCK, 61)).func_242733_d(80)).func_242728_a()).func_242731_b(4));
    }

    public static void addBlueRockPatches(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, BLUE_ROCK, 61)).func_242733_d(96)).func_242728_a()).func_242731_b(6));
    }

    public static void addOres(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, COAL_ORE, 17)).func_242733_d(128)).func_242728_a()).func_242731_b(20));
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, IRON_ORE, 9)).func_242733_d(64)).func_242728_a()).func_242731_b(20));
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, COPPER_ORE, 9)).func_242733_d(128)).func_242728_a()).func_242731_b(16));
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, TIN_ORE, 9)).func_242733_d(128)).func_242728_a()).func_242731_b(16));
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, GOLD_ORE, 9)).func_242733_d(32)).func_242728_a()).func_242731_b(2));
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, SILVER_ORE, 9)).func_242733_d(32)).func_242728_a()).func_242731_b(3));
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, SULFUR_ORE, 9)).func_242733_d(64)).func_242728_a()).func_242731_b(2));
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, NITER_ORE, 9)).func_242733_d(64)).func_242728_a()).func_242731_b(2));
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, SALT_ORE, 13)).func_242733_d(64)).func_242728_a()).func_242731_b(2));
    }

    public static void addExtraCoal(BiomeGenerationSettings.Builder builder, int size, int freq, int height) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, COAL_ORE, size + 1)).func_242733_d(height)).func_242728_a()).func_242731_b(freq));
    }

    public static void addExtraIron(BiomeGenerationSettings.Builder builder, int size, int freq, int height) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, COAL_ORE, size + 1)).func_242733_d(height)).func_242728_a()).func_242731_b(freq));
    }

    public static void addExtraGold(BiomeGenerationSettings.Builder builder, int size, int freq, int height) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, GOLD_ORE, size + 1)).func_242733_d(height)).func_242728_a()).func_242731_b(freq));
    }

    public static void addExtraSilver(BiomeGenerationSettings.Builder builder, int size, int freq, int height) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, SILVER_ORE, size + 1)).func_242733_d(height)).func_242728_a()).func_242731_b(freq));
    }

    public static void addExtraSalt(BiomeGenerationSettings.Builder builder, int size, int freq, int height) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, SALT_ORE, size + 1)).func_242733_d(height)).func_242728_a()).func_242731_b(freq));
    }

    public static void addSaltInSand(BiomeGenerationSettings.Builder builder, int size, int freq, int minHeight, int maxHeight) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(SAND_FILLER, SALT_ORE, size + 1)).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(minHeight, minHeight, maxHeight))).func_242728_a()).func_242731_b(freq));
    }

    public static void addMordorOres(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(MORDOR_ROCK_FILLER, DURNOR_ORE, 13)).func_242733_d(64)).func_242728_a()).func_242731_b(20));
        LOTRBiomeFeatures.addMorgulIronOre(builder, true);
        LOTRBiomeFeatures.addGuldurilOre(builder, true);
    }

    public static void addStoneOrcishOres(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addMorgulIronOre(builder, false);
        LOTRBiomeFeatures.addGuldurilOre(builder, false);
    }

    public static void addMorgulIronOre(BiomeGenerationSettings.Builder builder, boolean mordor) {
        int oreFreq = 20;
        ConfiguredPlacement orePlacement = Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(0, 0, 64));
        OreFeatureConfig oreConfig = mordor ? new OreFeatureConfig(MORDOR_ROCK_FILLER, MORGUL_IRON_ORE_MORDOR, 9) : new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, MORGUL_IRON_ORE_STONE, 9);
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)oreConfig).func_227228_a_(orePlacement).func_242728_a()).func_242731_b(oreFreq));
    }

    public static void addGuldurilOre(BiomeGenerationSettings.Builder builder, boolean mordor) {
        int oreFreq = 4;
        int crystalFreq = 2;
        LOTRBiomeFeatures.addGuldurilOre(builder, mordor, oreFreq, crystalFreq, 32);
    }

    private static void addGuldurilOre(BiomeGenerationSettings.Builder builder, boolean mordor, int oreFreq, int crystalFreq, int topY) {
        ConfiguredPlacement orePlacement = Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(0, 0, topY));
        ConfiguredPlacement crystalPlacement = Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(0, 0, topY));
        OreFeatureConfig oreConfig = mordor ? new OreFeatureConfig(MORDOR_ROCK_FILLER, GULDURIL_ORE_MORDOR, 9) : new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, GULDURIL_ORE_STONE, 9);
        CrystalFeatureConfig crystalConfig = new CrystalFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(GULDURIL_CRYSTAL), 64, 6, 4, 6);
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)oreConfig).func_227228_a_(orePlacement).func_242728_a()).func_242731_b(oreFreq));
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)LOTRFeatures.CRYSTALS.func_225566_b_(crystalConfig).func_227228_a_(crystalPlacement).func_242728_a()).func_242731_b(crystalFreq));
    }

    public static void addExtraMordorGulduril(BiomeGenerationSettings.Builder builder) {
        int extraOreFreq = 10;
        int extraCrystalFreq = 1;
        LOTRBiomeFeatures.addGuldurilOre(builder, true, extraOreFreq, extraCrystalFreq, 60);
    }

    public static void addLapisOre(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, LAPIS_ORE, 7)).func_227228_a_(Placement.field_242910_o.func_227446_a_((IPlacementConfig)new DepthAverageConfig(16, 16))).func_242728_a());
    }

    public static void addMithrilOre(BiomeGenerationSettings.Builder builder, int invChance) {
        ConfiguredPlacement orePlacement = Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(0, 0, 16));
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, MITHRIL_ORE, 7)).func_227228_a_(orePlacement).func_242729_a(invChance));
    }

    public static void addEdhelvirOre(BiomeGenerationSettings.Builder builder) {
        int oreFreq = 4;
        int crystalFreq = 2;
        ConfiguredPlacement orePlacement = Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(0, 0, 48));
        ConfiguredPlacement crystalPlacement = Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(0, 0, 48));
        OreFeatureConfig oreConfig = new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, EDHELVIR_ORE, 7);
        CrystalFeatureConfig crystalConfig = new CrystalFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(EDHELVIR_CRYSTAL), 64, 6, 4, 6);
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)oreConfig).func_227228_a_(orePlacement).func_242728_a()).func_242731_b(oreFreq));
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)LOTRFeatures.CRYSTALS.func_225566_b_(crystalConfig).func_227228_a_(crystalPlacement).func_242728_a()).func_242731_b(crystalFreq));
    }

    public static void addGlowstoneOre(BiomeGenerationSettings.Builder builder) {
        int oreFreq = 6;
        int crystalFreq = 2;
        ConfiguredPlacement orePlacement = Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(0, 0, 48));
        ConfiguredPlacement crystalPlacement = Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(0, 0, 48));
        OreFeatureConfig oreConfig = new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, GLOWSTONE_ORE, 5);
        CrystalFeatureConfig crystalConfig = new CrystalFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(GLOWSTONE_CRYSTAL), 64, 6, 4, 6);
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)oreConfig).func_227228_a_(orePlacement).func_242728_a()).func_242731_b(oreFreq));
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)LOTRFeatures.CRYSTALS.func_225566_b_(crystalConfig).func_227228_a_(crystalPlacement).func_242728_a()).func_242731_b(crystalFreq));
    }

    public static void addPackedIceVeins(BiomeGenerationSettings.Builder builder, int freq) {
        int size = 16;
        int yMin = 32;
        int yMax = 256;
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, PACKED_ICE, size)).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(yMin, yMin, yMax))).func_242728_a()).func_242731_b(freq));
    }

    public static void addDripstones(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addDripstones(builder, null);
    }

    public static void addDripstones(BiomeGenerationSettings.Builder builder, DripstoneBlock block) {
        LOTRBiomeFeatures.addDripstones(builder, null, 3);
    }

    public static void addDripstones(BiomeGenerationSettings.Builder builder, DripstoneBlock block, int freq) {
        DripstoneFeatureConfig config = new DripstoneFeatureConfig(block == null ? null : block.func_176223_P(), 64, 8, 4, 8, 0.33f);
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, (ConfiguredFeature)((ConfiguredFeature)LOTRFeatures.DRIPSTONE.func_225566_b_(config).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(0, 0, 60))).func_242728_a()).func_242731_b(freq));
    }

    public static void addCobwebs(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addCobwebs(builder, 2, COBWEB);
    }

    public static void addCobwebs(BiomeGenerationSettings.Builder builder, int invChance, BlockState webBlock) {
        CobwebFeatureConfig config = new CobwebFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(webBlock), 64, 6, 4, 6);
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, (ConfiguredFeature)((ConfiguredFeature)LOTRFeatures.COBWEBS.func_225566_b_(config).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(0, 0, 60))).func_242728_a()).func_242729_a(invChance));
    }

    public static void addLakes(BiomeGenerationSettings.Builder builder) {
        int waterChance = 4;
        int lavaChance = 8;
        builder.func_242513_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, (ConfiguredFeature)((ConfiguredFeature)Feature.field_202289_ai.func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(WATER)).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(0, 0, 62))).func_242728_a()).func_242729_a(waterChance *= 2));
        builder.func_242513_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, (ConfiguredFeature)((ConfiguredFeature)Feature.field_202289_ai.func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(LAVA)).func_227228_a_(Placement.field_242908_m.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(8, 8, 62))).func_242728_a()).func_242729_a(lavaChance *= 2));
    }

    public static void addSandSediments(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addSandSediments(builder, SAND);
    }

    public static void addWhiteSandSediments(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addSandSediments(builder, WHITE_SAND);
    }

    public static void addSandSediments(BiomeGenerationSettings.Builder builder, BlockState sandBlock) {
        int freq = 3;
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202285_ae.func_225566_b_((IFeatureConfig)new SphereReplaceConfig(sandBlock, FeatureSpread.func_242253_a((int)2, (int)4), 2, (List)Lists.newArrayList((Object[])new BlockState[]{DIRT, COARSE_DIRT, GRASS_BLOCK}))).func_227228_a_(LOTRBiomeFeatures.placeTopSolidFreq(freq)));
    }

    public static void addClayGravelSediments(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202285_ae.func_225566_b_((IFeatureConfig)new SphereReplaceConfig(CLAY, FeatureSpread.func_242253_a((int)2, (int)1), 1, (List)Lists.newArrayList((Object[])new BlockState[]{DIRT, COARSE_DIRT, CLAY}))).func_227228_a_(LOTRBiomeFeatures.placeTopSolidFreq(1)));
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202285_ae.func_225566_b_((IFeatureConfig)new SphereReplaceConfig(GRAVEL, FeatureSpread.func_242253_a((int)2, (int)3), 2, (List)Lists.newArrayList((Object[])new BlockState[]{DIRT, COARSE_DIRT, GRASS_BLOCK}))).func_227228_a_(LOTRBiomeFeatures.placeTopSolidFreq(1)));
    }

    public static void addQuagmire(BiomeGenerationSettings.Builder builder, int freq) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202285_ae.func_225566_b_((IFeatureConfig)new SphereReplaceConfig(QUAGMIRE, FeatureSpread.func_242253_a((int)2, (int)2), 2, (List)Lists.newArrayList((Object[])new BlockState[]{DIRT, COARSE_DIRT, GRASS_BLOCK}))).func_227228_a_(LOTRBiomeFeatures.placeTopSolidFreq(freq)));
    }

    public static void addTrees(LOTRBiomeBase biome, BiomeGenerationSettings.Builder builder, int count, float extraChance, Object ... weightedTrees) {
        LOTRBiomeFeatures.addTreesFromGeneratingConfig(biome, builder, GeneratingTreesConfig.builder().weightedTrees(weightedTrees).clusterConfig(TreeClustersConfig.builder().count(count).extraChance(extraChance).build()).build());
    }

    public static void addTreesWithClusters(LOTRBiomeBase biome, BiomeGenerationSettings.Builder builder, int count, float extraChance, TreeCluster cluster, Object ... weightedTrees) {
        LOTRBiomeFeatures.addTreesFromGeneratingConfig(biome, builder, GeneratingTreesConfig.builder().weightedTrees(weightedTrees).clusterConfig(TreeClustersConfig.builder().count(count).extraChance(extraChance).cluster(cluster).build()).build());
    }

    public static void addTreesWithLatitudeConfig(LOTRBiomeBase biome, BiomeGenerationSettings.Builder builder, LatitudeBasedFeatureConfig.LatitudeConfiguration latitudeConfig, int count, float extraChance, Object ... weightedTrees) {
        LOTRBiomeFeatures.addTreesFromGeneratingConfig(biome, builder, GeneratingTreesConfig.builder().weightedTrees(weightedTrees).clusterConfig(TreeClustersConfig.builder().count(count).extraChance(extraChance).build()).latitudeConfig(latitudeConfig).build());
    }

    public static void addTreesIncrease(LOTRBiomeBase biome, BiomeGenerationSettings.Builder builder, int count, float extraChance, int extraCount, Object ... weightedTrees) {
        LOTRBiomeFeatures.addTreesFromGeneratingConfig(biome, builder, GeneratingTreesConfig.builder().weightedTrees(weightedTrees).clusterConfig(TreeClustersConfig.builder().count(count).extraChance(extraChance).extraCount(extraCount).build()).build());
    }

    public static void addTreesBelowTreeline(LOTRBiomeBase biome, BiomeGenerationSettings.Builder builder, int count, float extraChance, int treeline, Object ... weightedTrees) {
        LOTRBiomeFeatures.addTreesFromGeneratingConfig(biome, builder, GeneratingTreesConfig.builder().weightedTrees(weightedTrees).clusterConfig(TreeClustersConfig.builder().count(count).extraChance(extraChance).layerLimit(treeline, true).build()).build());
    }

    public static void addTreesBelowTreelineIncrease(LOTRBiomeBase biome, BiomeGenerationSettings.Builder builder, int count, float extraChance, int extraCount, int treeline, Object ... weightedTrees) {
        LOTRBiomeFeatures.addTreesFromGeneratingConfig(biome, builder, GeneratingTreesConfig.builder().weightedTrees(weightedTrees).clusterConfig(TreeClustersConfig.builder().count(count).extraChance(extraChance).extraCount(extraCount).layerLimit(treeline, true).build()).build());
    }

    public static void addTreesAboveTreeline(LOTRBiomeBase biome, BiomeGenerationSettings.Builder builder, int count, float extraChance, int treeline, Object ... weightedTrees) {
        LOTRBiomeFeatures.addTreesFromGeneratingConfig(biome, builder, GeneratingTreesConfig.builder().weightedTrees(weightedTrees).clusterConfig(TreeClustersConfig.builder().count(count).extraChance(extraChance).layerLimit(treeline, false).build()).build());
    }

    public static void addTreesAboveTreelineIncrease(LOTRBiomeBase biome, BiomeGenerationSettings.Builder builder, int count, float extraChance, int extraCount, int treeline, Object ... weightedTrees) {
        LOTRBiomeFeatures.addTreesFromGeneratingConfig(biome, builder, GeneratingTreesConfig.builder().weightedTrees(weightedTrees).clusterConfig(TreeClustersConfig.builder().count(count).extraChance(extraChance).extraCount(extraCount).layerLimit(treeline, false).build()).build());
    }

    public static void addTreesFromGeneratingConfig(LOTRBiomeBase biome, BiomeGenerationSettings.Builder builder, GeneratingTreesConfig config) {
        ConfiguredPlacement treePlacement = LOTRFeatures.TREE_CLUSTERS.func_227446_a_(config.clusterConfig);
        LOTRBiomeFeatures.addTreesWithPlacement(builder, treePlacement, config.latitudeConfig, config.weightedTrees);
        if (config.shouldUpdateBiomeTreeAmount()) {
            biome.updateBiomeTreeAmount(config.getTreeCountApproximation());
        }
        LOTRBiomeFeatures.addLeafBushesWithPlacement(builder, LOTRFeatures.TREE_CLUSTERS.func_227446_a_(config.makePlacementForLeafBushes()), config.latitudeConfig);
        LOTRBiomeFeatures.addFallenLeavesWithPlacement(builder, LOTRFeatures.TREE_CLUSTERS.func_227446_a_(config.makePlacementForFallenLeaves()), config.latitudeConfig);
    }

    private static void addTreesWithPlacement(BiomeGenerationSettings.Builder builder, ConfiguredPlacement<?> placement, LatitudeBasedFeatureConfig.LatitudeConfiguration latConfig, Object ... weightedTrees) {
        WeightedRandomFeatureConfig wrConfig = WeightedRandomFeatureConfig.fromEntries(weightedTrees);
        ConfiguredFeature randomTreeFeature = LOTRFeatures.WEIGHTED_RANDOM.func_225566_b_(wrConfig);
        if (latConfig == null) {
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, randomTreeFeature.func_227228_a_(placement));
        } else {
            LOTRBiomeFeatures.addLatitudeBased(builder, GenerationStage.Decoration.VEGETAL_DECORATION, randomTreeFeature, placement, latConfig);
        }
    }

    private static void addLeafBushesWithPlacement(BiomeGenerationSettings.Builder builder, ConfiguredPlacement<?> placement, LatitudeBasedFeatureConfig.LatitudeConfiguration latConfig) {
        ConfiguredFeature bushesFeature = LOTRFeatures.LEAF_BUSHES.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e);
        if (latConfig == null) {
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, bushesFeature.func_227228_a_(placement));
        } else {
            LOTRBiomeFeatures.addLatitudeBased(builder, GenerationStage.Decoration.VEGETAL_DECORATION, bushesFeature, placement, latConfig);
        }
    }

    private static void addFallenLeavesWithPlacement(BiomeGenerationSettings.Builder builder, ConfiguredPlacement<?> placement, LatitudeBasedFeatureConfig.LatitudeConfiguration latConfig) {
        ConfiguredFeature fallenLeavesFeature = LOTRFeatures.FALLEN_LEAVES.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e);
        if (latConfig == null) {
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, fallenLeavesFeature.func_227228_a_(placement));
        } else {
            LOTRBiomeFeatures.addLatitudeBased(builder, GenerationStage.Decoration.VEGETAL_DECORATION, fallenLeavesFeature, placement, latConfig);
        }
    }

    public static ConfiguredFeature snowWrapTree(ConfiguredFeature tree) {
        BaseTreeFeatureConfig treeConfig;
        IFeatureConfig config = tree.func_242767_c();
        if (config instanceof BaseTreeFeatureConfig) {
            treeConfig = (BaseTreeFeatureConfig)config;
        } else if (config instanceof WrappedTreeFeatureConfig) {
            treeConfig = ((WrappedTreeFeatureConfig)config).treeConfig;
        } else {
            throw new IllegalArgumentException("Cannot wrap a ConfiguredFeature " + tree + " in a snowy wrapped tree config");
        }
        return LOTRFeatures.WRAPPED_TREE.func_225566_b_(new WrappedTreeFeatureConfig(treeConfig, WrappedTreeFeatureConfig.AlternativeTreeSoil.SNOWY));
    }

    public static ConfiguredFeature oak() {
        return Features.field_243862_bH;
    }

    public static ConfiguredFeature oakBees() {
        return Features.field_243879_bY;
    }

    public static ConfiguredFeature oakVines() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)OAK_TREE_VINES);
    }

    public static ConfiguredFeature oakBeesVines() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)OAK_TREE_BEES_VINES);
    }

    public static ConfiguredFeature oakTall() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)OAK_TREE_TALL);
    }

    public static ConfiguredFeature oakTallBees() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)OAK_TREE_TALL_BEES);
    }

    public static ConfiguredFeature oakTallVines() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)OAK_TREE_TALL_VINES);
    }

    public static ConfiguredFeature oakTallBeesVines() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)OAK_TREE_TALL_BEES_VINES);
    }

    public static ConfiguredFeature oakFancy() {
        return Features.field_243869_bO;
    }

    public static ConfiguredFeature oakFancyBees() {
        return Features.field_243922_ce;
    }

    public static ConfiguredFeature oakSwamp() {
        return Features.field_243875_bU;
    }

    public static ConfiguredFeature oakDesert() {
        return LOTRFeatures.WRAPPED_TREE.func_225566_b_(OAK_DESERT);
    }

    public static ConfiguredFeature oakDesertBees() {
        return LOTRFeatures.WRAPPED_TREE.func_225566_b_(OAK_DESERT_BEES);
    }

    public static ConfiguredFeature oakDead() {
        return LOTRFeatures.WRAPPED_TREE.func_225566_b_(OAK_DEAD);
    }

    public static ConfiguredFeature oakFangorn() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)OAK_FANGORN);
    }

    public static ConfiguredFeature oakShrub() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)OAK_SHRUB);
    }

    public static ConfiguredFeature spruce() {
        return Features.field_243866_bL;
    }

    public static ConfiguredFeature spruceThin() {
        return Features.field_243867_bM;
    }

    public static ConfiguredFeature spruceMega() {
        return Features.field_243872_bR;
    }

    public static ConfiguredFeature spruceThinMega() {
        return Features.field_243873_bS;
    }

    public static ConfiguredFeature spruceDead() {
        return LOTRFeatures.WRAPPED_TREE.func_225566_b_(SPRUCE_DEAD);
    }

    public static ConfiguredFeature spruceShrub() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)SPRUCE_SHRUB);
    }

    public static ConfiguredFeature<WeightedRandomFeatureConfig<BaseTreeFeatureConfig>, ?> birch() {
        return LOTRFeatures.getWeightedRandom().func_225566_b_(WeightedRandomFeatureConfig.fromEntries(Features.field_243864_bJ, 1, Feature.field_236291_c_.func_225566_b_((IFeatureConfig)BIRCH_TREE_ALT), 2));
    }

    public static ConfiguredFeature<WeightedRandomFeatureConfig<BaseTreeFeatureConfig>, ?> birchBees() {
        return LOTRFeatures.getWeightedRandom().func_225566_b_(WeightedRandomFeatureConfig.fromEntries(Features.field_243919_cb, 1, Feature.field_236291_c_.func_225566_b_((IFeatureConfig)BIRCH_TREE_ALT_BEES), 2));
    }

    public static ConfiguredFeature birchFancy() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)BIRCH_TREE_FANCY);
    }

    public static ConfiguredFeature birchFancyBees() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)BIRCH_TREE_FANCY_BEES);
    }

    public static ConfiguredFeature birchDead() {
        return LOTRFeatures.WRAPPED_TREE.func_225566_b_(BIRCH_DEAD);
    }

    public static ConfiguredFeature jungle() {
        return Features.field_243868_bN;
    }

    public static ConfiguredFeature jungleMega() {
        return Features.field_243871_bQ;
    }

    public static ConfiguredFeature jungleBush() {
        return Features.field_243876_bV;
    }

    public static ConfiguredFeature acacia() {
        return Features.field_243865_bK;
    }

    public static ConfiguredFeature darkOak() {
        return Features.field_243863_bI;
    }

    public static ConfiguredFeature pine() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)PINE_TREE);
    }

    public static ConfiguredFeature shirePine() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)SHIRE_PINE_TREE);
    }

    public static ConfiguredFeature pineShrub() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)PINE_SHRUB);
    }

    public static ConfiguredFeature mallorn() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)MALLORN_TREE);
    }

    public static ConfiguredFeature mallornBees() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)MALLORN_TREE_BEES);
    }

    public static ConfiguredFeature mallornBoughs() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)MALLORN_TREE_BOUGHS);
    }

    public static ConfiguredFeature mirkOak() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)MIRK_OAK_TREE);
    }

    public static ConfiguredFeature charred() {
        return LOTRFeatures.WRAPPED_TREE.func_225566_b_(CHARRED_TREE);
    }

    public static ConfiguredFeature<WeightedRandomFeatureConfig<BaseTreeFeatureConfig>, ?> apple() {
        return LOTRFeatures.getWeightedRandom().func_225566_b_(WeightedRandomFeatureConfig.fromEntries(Feature.field_236291_c_.func_225566_b_((IFeatureConfig)APPLE_TREE_RED), 19, Feature.field_236291_c_.func_225566_b_((IFeatureConfig)APPLE_TREE_GREEN), 19, Feature.field_236291_c_.func_225566_b_((IFeatureConfig)APPLE_TREE_MIX), 2));
    }

    public static ConfiguredFeature<WeightedRandomFeatureConfig<BaseTreeFeatureConfig>, ?> appleBees() {
        return LOTRFeatures.getWeightedRandom().func_225566_b_(WeightedRandomFeatureConfig.fromEntries(Feature.field_236291_c_.func_225566_b_((IFeatureConfig)APPLE_TREE_RED_BEES), 19, Feature.field_236291_c_.func_225566_b_((IFeatureConfig)APPLE_TREE_GREEN_BEES), 19, Feature.field_236291_c_.func_225566_b_((IFeatureConfig)APPLE_TREE_MIX_BEES), 2));
    }

    public static ConfiguredFeature pear() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)PEAR_TREE);
    }

    public static ConfiguredFeature pearBees() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)PEAR_TREE_BEES);
    }

    public static ConfiguredFeature cherry() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)CHERRY_TREE);
    }

    public static ConfiguredFeature cherryBees() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)CHERRY_TREE_BEES);
    }

    public static ConfiguredFeature lebethron() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)LEBETHRON_TREE);
    }

    public static ConfiguredFeature lebethronBees() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)LEBETHRON_TREE_BEES);
    }

    public static ConfiguredFeature lebethronFancy() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)LEBETHRON_TREE_FANCY);
    }

    public static ConfiguredFeature lebethronFancyBees() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)LEBETHRON_TREE_FANCY_BEES);
    }

    public static ConfiguredFeature beech() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)BEECH_TREE);
    }

    public static ConfiguredFeature beechBees() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)BEECH_TREE_BEES);
    }

    public static ConfiguredFeature beechFancy() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)BEECH_TREE_FANCY);
    }

    public static ConfiguredFeature beechFancyBees() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)BEECH_TREE_FANCY_BEES);
    }

    public static ConfiguredFeature beechFangorn() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)BEECH_FANGORN);
    }

    public static ConfiguredFeature beechDead() {
        return LOTRFeatures.WRAPPED_TREE.func_225566_b_(BEECH_DEAD);
    }

    public static ConfiguredFeature maple() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)MAPLE_TREE);
    }

    public static ConfiguredFeature mapleBees() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)MAPLE_TREE_BEES);
    }

    public static ConfiguredFeature mapleFancy() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)MAPLE_TREE_FANCY);
    }

    public static ConfiguredFeature mapleFancyBees() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)MAPLE_TREE_FANCY_BEES);
    }

    public static ConfiguredFeature aspen() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)ASPEN_TREE);
    }

    public static ConfiguredFeature aspenLarge() {
        return LOTRBiomeFeatures.aspen();
    }

    public static ConfiguredFeature lairelosse() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)LAIRELOSSE_TREE);
    }

    public static ConfiguredFeature cedar() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)CEDAR_TREE);
    }

    public static ConfiguredFeature cedarLarge() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)CEDAR_TREE_LARGE);
    }

    public static ConfiguredFeature fir() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)FIR_TREE);
    }

    public static ConfiguredFeature larch() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)LARCH_TREE);
    }

    public static ConfiguredFeature holly() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)HOLLY_TREE);
    }

    public static ConfiguredFeature hollyBees() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)HOLLY_TREE_BEES);
    }

    public static ConfiguredFeature greenOak() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)GREEN_OAK_TREE);
    }

    public static ConfiguredFeature greenOakBees() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)GREEN_OAK_TREE_BEES);
    }

    public static ConfiguredFeature redOak() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)RED_OAK_TREE);
    }

    public static ConfiguredFeature redOakBees() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)RED_OAK_TREE_BEES);
    }

    public static ConfiguredFeature cypress() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)CYPRESS_TREE);
    }

    public static void addGrass(LOTRBiomeBase biome, BiomeGenerationSettings.Builder builder, int freq) {
        LOTRBiomeFeatures.addGrass(biome, builder, freq, new GrassTypesHolder().ferns(false).fernsprouts(false).clovers(true).extra4LeafClovers(false).prettyTypes(true).extraWheatgrass(false).moor(false).arid(false).thistles(true).nettles(true));
    }

    public static void addShireGrass(LOTRBiomeBase biome, BiomeGenerationSettings.Builder builder, int freq) {
        LOTRBiomeFeatures.addGrass(biome, builder, freq, new GrassTypesHolder().ferns(false).fernsprouts(false).clovers(true).extra4LeafClovers(true).prettyTypes(true).extraWheatgrass(false).moor(false).arid(false).thistles(true).nettles(true));
    }

    public static void addGrassWithFerns(LOTRBiomeBase biome, BiomeGenerationSettings.Builder builder, int freq) {
        LOTRBiomeFeatures.addGrass(biome, builder, freq, new GrassTypesHolder().ferns(true).fernsprouts(false).clovers(true).extra4LeafClovers(false).prettyTypes(true).extraWheatgrass(false).moor(false).arid(false).thistles(true).nettles(true));
    }

    public static void addShireGrassWithFerns(LOTRBiomeBase biome, BiomeGenerationSettings.Builder builder, int freq) {
        LOTRBiomeFeatures.addGrass(biome, builder, freq, new GrassTypesHolder().ferns(true).fernsprouts(false).clovers(true).extra4LeafClovers(true).prettyTypes(true).extraWheatgrass(false).moor(false).arid(false).thistles(true).nettles(true));
    }

    public static void addGrassWithFernsAndSprouts(LOTRBiomeBase biome, BiomeGenerationSettings.Builder builder, int freq) {
        LOTRBiomeFeatures.addGrass(biome, builder, freq, new GrassTypesHolder().ferns(true).fernsprouts(true).clovers(true).extra4LeafClovers(false).prettyTypes(true).extraWheatgrass(false).moor(false).arid(false).thistles(true).nettles(true));
    }

    public static void addGrassWithExtraWheatgrass(LOTRBiomeBase biome, BiomeGenerationSettings.Builder builder, int freq) {
        LOTRBiomeFeatures.addGrass(biome, builder, freq, new GrassTypesHolder().ferns(false).fernsprouts(false).clovers(true).extra4LeafClovers(false).prettyTypes(true).extraWheatgrass(true).moor(false).arid(false).thistles(true).nettles(true));
    }

    public static void addMoorsGrass(LOTRBiomeBase biome, BiomeGenerationSettings.Builder builder, int freq) {
        LOTRBiomeFeatures.addGrass(biome, builder, freq, new GrassTypesHolder().ferns(false).fernsprouts(false).clovers(true).extra4LeafClovers(false).prettyTypes(false).extraWheatgrass(false).moor(true).arid(false).thistles(true).nettles(true));
    }

    public static void addShireMoorsGrass(LOTRBiomeBase biome, BiomeGenerationSettings.Builder builder, int freq) {
        LOTRBiomeFeatures.addGrass(biome, builder, freq, new GrassTypesHolder().ferns(false).fernsprouts(false).clovers(true).extra4LeafClovers(true).prettyTypes(false).extraWheatgrass(false).moor(true).arid(false).thistles(true).nettles(true));
    }

    public static void addMoorsGrassWithFerns(LOTRBiomeBase biome, BiomeGenerationSettings.Builder builder, int freq) {
        LOTRBiomeFeatures.addGrass(biome, builder, freq, new GrassTypesHolder().ferns(true).fernsprouts(false).clovers(true).extra4LeafClovers(false).prettyTypes(false).extraWheatgrass(false).moor(true).arid(false).thistles(true).nettles(true));
    }

    public static void addGrassWithArid(LOTRBiomeBase biome, BiomeGenerationSettings.Builder builder, int freq) {
        LOTRBiomeFeatures.addGrass(biome, builder, freq, new GrassTypesHolder().ferns(false).fernsprouts(false).clovers(true).extra4LeafClovers(false).prettyTypes(true).extraWheatgrass(false).moor(false).arid(true).thistles(true).nettles(true));
    }

    public static void addGrassBasic(LOTRBiomeBase biome, BiomeGenerationSettings.Builder builder, int freq) {
        LOTRBiomeFeatures.addGrass(biome, builder, freq, new GrassTypesHolder().ferns(false).fernsprouts(false).clovers(false).extra4LeafClovers(false).prettyTypes(false).extraWheatgrass(false).moor(false).arid(false).thistles(false).nettles(false));
    }

    public static void addGrassWithoutPrettyTypes(LOTRBiomeBase biome, BiomeGenerationSettings.Builder builder, int freq) {
        LOTRBiomeFeatures.addGrass(biome, builder, freq, new GrassTypesHolder().ferns(false).fernsprouts(false).clovers(true).extra4LeafClovers(false).prettyTypes(false).extraWheatgrass(false).moor(false).arid(false).thistles(true).nettles(true));
    }

    public static void addGrassWithoutPrettyTypesWithoutThistles(LOTRBiomeBase biome, BiomeGenerationSettings.Builder builder, int freq) {
        LOTRBiomeFeatures.addGrass(biome, builder, freq, new GrassTypesHolder().ferns(false).fernsprouts(false).clovers(true).extra4LeafClovers(false).prettyTypes(false).extraWheatgrass(false).moor(false).arid(false).thistles(false).nettles(true));
    }

    public static void addGrassWithFernsWithoutPrettyTypes(LOTRBiomeBase biome, BiomeGenerationSettings.Builder builder, int freq) {
        LOTRBiomeFeatures.addGrass(biome, builder, freq, new GrassTypesHolder().ferns(true).fernsprouts(false).clovers(true).extra4LeafClovers(false).prettyTypes(false).extraWheatgrass(false).moor(false).arid(false).thistles(true).nettles(true));
    }

    public static void addGrass(LOTRBiomeBase biome, BiomeGenerationSettings.Builder builder, int freq, GrassTypesHolder types) {
        boolean ferns = types.ferns;
        boolean fernsprouts = types.fernsprouts;
        boolean clovers = types.clovers;
        boolean fourLeafClovers = types.extra4LeafClovers;
        boolean prettyTypes = types.prettyTypes;
        boolean extraWheatgrass = types.extraWheatgrass;
        boolean moor = types.moor;
        boolean arid = types.arid;
        boolean thistles = types.thistles;
        boolean nettles = types.nettles;
        ArrayList weightedGrassTypes = new ArrayList();
        weightedGrassTypes.add(WeightedFeature.make(Feature.field_227248_z_.func_225566_b_((IFeatureConfig)GRASS_CONFIG), 500));
        weightedGrassTypes.add(WeightedFeature.make(Feature.field_227248_z_.func_225566_b_((IFeatureConfig)SHORT_GRASS_CONFIG), 100));
        if (clovers) {
            weightedGrassTypes.add(WeightedFeature.make(Feature.field_227248_z_.func_225566_b_((IFeatureConfig)(fourLeafClovers ? SHIRE_CLOVER_CONFIG : CLOVER_CONFIG)), 250));
        }
        if (nettles) {
            weightedGrassTypes.add(WeightedFeature.make(Feature.field_227248_z_.func_225566_b_((IFeatureConfig)NETTLES_CONFIG), 10));
        }
        if (prettyTypes) {
            weightedGrassTypes.add(WeightedFeature.make(Feature.field_227248_z_.func_225566_b_((IFeatureConfig)WHEATGRASS_CONFIG), extraWheatgrass ? 800 : 100));
            weightedGrassTypes.add(WeightedFeature.make(Feature.field_227248_z_.func_225566_b_((IFeatureConfig)FLOWERY_GRASS_CONFIG), 65));
            boolean flax = true;
            if (flax) {
                weightedGrassTypes.add(WeightedFeature.make(Feature.field_227248_z_.func_225566_b_((IFeatureConfig)WILD_FLAX_CONFIG), 2));
            }
        }
        if (moor) {
            weightedGrassTypes.add(WeightedFeature.make(Feature.field_227248_z_.func_225566_b_((IFeatureConfig)PURPLE_MOOR_GRASS_CONFIG), 200));
            weightedGrassTypes.add(WeightedFeature.make(Feature.field_227248_z_.func_225566_b_((IFeatureConfig)RED_MOOR_GRASS_CONFIG), 120));
        }
        if (thistles) {
            weightedGrassTypes.add(WeightedFeature.make(Feature.field_227248_z_.func_225566_b_((IFeatureConfig)THISTLE_CONFIG), 5));
        }
        if (ferns) {
            weightedGrassTypes.add(WeightedFeature.make(Feature.field_227248_z_.func_225566_b_((IFeatureConfig)FERN_CONFIG), 500));
        }
        if (fernsprouts) {
            weightedGrassTypes.add(WeightedFeature.make(Feature.field_227248_z_.func_225566_b_((IFeatureConfig)FERNSPROUT_CONFIG), 500));
        }
        if (arid) {
            weightedGrassTypes.add(WeightedFeature.make(Feature.field_227248_z_.func_225566_b_((IFeatureConfig)ARID_GRASS_CONFIG), 550));
        }
        WeightedRandomFeatureConfig wrConfig = new WeightedRandomFeatureConfig(weightedGrassTypes);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, LOTRFeatures.getWeightedRandom().func_225566_b_(wrConfig).func_227228_a_(LOTRBiomeFeatures.placeHeightmapDoubleFreq(freq)));
        biome.setGrassBonemealGenerator(wrConfig);
    }

    public static void addDoubleGrass(BiomeGenerationSettings.Builder builder, int freq) {
        LOTRBiomeFeatures.addDoubleGrass(builder, freq, new GrassTypesHolder().ferns(false).prettyTypes(true).extraWheatgrass(false).arid(false));
    }

    public static void addDoubleGrassWithFerns(BiomeGenerationSettings.Builder builder, int freq) {
        LOTRBiomeFeatures.addDoubleGrass(builder, freq, new GrassTypesHolder().ferns(true).prettyTypes(true).extraWheatgrass(false).arid(false));
    }

    public static void addDoubleGrassWithExtraWheatgrass(BiomeGenerationSettings.Builder builder, int freq) {
        LOTRBiomeFeatures.addDoubleGrass(builder, freq, new GrassTypesHolder().ferns(false).prettyTypes(true).extraWheatgrass(true).arid(false));
    }

    public static void addMoorsDoubleGrass(BiomeGenerationSettings.Builder builder, int freq) {
        LOTRBiomeFeatures.addDoubleGrass(builder, freq, new GrassTypesHolder().ferns(false).prettyTypes(false).extraWheatgrass(false).arid(false));
    }

    public static void addMoorsDoubleGrassWithFerns(BiomeGenerationSettings.Builder builder, int freq) {
        LOTRBiomeFeatures.addDoubleGrass(builder, freq, new GrassTypesHolder().ferns(true).prettyTypes(false).extraWheatgrass(false).arid(false));
    }

    public static void addDoubleGrassWithArid(BiomeGenerationSettings.Builder builder, int freq) {
        LOTRBiomeFeatures.addDoubleGrass(builder, freq, new GrassTypesHolder().ferns(false).prettyTypes(true).extraWheatgrass(false).arid(true));
    }

    public static void addDoubleGrassWithoutPrettyTypes(BiomeGenerationSettings.Builder builder, int freq) {
        LOTRBiomeFeatures.addDoubleGrass(builder, freq, new GrassTypesHolder().ferns(false).prettyTypes(false).extraWheatgrass(false).arid(false));
    }

    public static void addDoubleGrassWithFernsWithoutPrettyTypes(BiomeGenerationSettings.Builder builder, int freq) {
        LOTRBiomeFeatures.addDoubleGrass(builder, freq, new GrassTypesHolder().ferns(true).prettyTypes(false).extraWheatgrass(false).arid(false));
    }

    public static void addDoubleGrass(BiomeGenerationSettings.Builder builder, int freq, GrassTypesHolder types) {
        boolean ferns = types.ferns;
        boolean prettyTypes = types.prettyTypes;
        boolean extraWheatgrass = types.extraWheatgrass;
        boolean arid = types.arid;
        ArrayList weightedGrassTypes = new ArrayList();
        weightedGrassTypes.add(WeightedFeature.make(Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DOUBLE_GRASS_CONFIG), 500));
        if (prettyTypes) {
            weightedGrassTypes.add(WeightedFeature.make(Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DOUBLE_WHEATGRASS_CONFIG), extraWheatgrass ? 800 : 100));
        }
        if (ferns) {
            weightedGrassTypes.add(WeightedFeature.make(Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DOUBLE_FERN_CONFIG), 500));
        }
        if (arid) {
            weightedGrassTypes.add(WeightedFeature.make(Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DOUBLE_ARID_GRASS_CONFIG), 550));
        }
        WeightedRandomFeatureConfig wrConfig = new WeightedRandomFeatureConfig(weightedGrassTypes);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)LOTRFeatures.getWeightedRandom().func_225566_b_(wrConfig).func_227228_a_(LOTRBiomeFeatures.placeFlowers()).func_242731_b(freq));
    }

    public static void addFlowers(BiomeGenerationSettings.Builder builder, int freq, Object ... weightedFlowers) {
        try {
            WeightedBlockStateProvider stateProvider = new WeightedBlockStateProvider();
            for (int i = 0; i < weightedFlowers.length; i += 2) {
                Object obj1 = weightedFlowers[i];
                BlockState state = obj1 instanceof BlockState ? (BlockState)obj1 : ((Block)obj1).func_176223_P();
                int weight = (Integer)weightedFlowers[i + 1];
                stateProvider.func_227407_a_(state, weight);
            }
            BlockClusterFeatureConfig flowerConfig = new BlockClusterFeatureConfig.Builder((BlockStateProvider)stateProvider, (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)Feature.field_227247_y_.func_225566_b_((IFeatureConfig)flowerConfig).func_227228_a_(LOTRBiomeFeatures.placeFlowers()).func_242731_b(freq));
        }
        catch (ArrayIndexOutOfBoundsException | ClassCastException e) {
            throw new IllegalArgumentException("Error adding biome flowers! A list of (blockstate1, weight1), (blockstate2, weight2)... is required", e);
        }
    }

    public static void addDefaultFlowers(BiomeGenerationSettings.Builder builder, int freq, Object ... extraFlowers) {
        Object[] defaultFlowers = new Object[]{Blocks.field_196606_bd, 1, Blocks.field_196605_bc, 2};
        LOTRBiomeFeatures.addFlowers(builder, freq, LOTRUtil.combineVarargs(defaultFlowers, extraFlowers));
    }

    public static void addPlainsFlowers(BiomeGenerationSettings.Builder builder, int freq, Object ... extraFlowers) {
        Object[] plainsFlowers = new Object[]{Blocks.field_196606_bd, 20, Blocks.field_196605_bc, 30, Blocks.field_196610_bg, 20, Blocks.field_196616_bl, 20, Blocks.field_222387_by, 5, Blocks.field_196613_bi, 3, Blocks.field_196612_bh, 3, Blocks.field_196615_bk, 3, Blocks.field_196614_bj, 3, LOTRBlocks.BLUEBELL.get(), 5, LOTRBlocks.MARIGOLD.get(), 10, LOTRBlocks.LAVENDER.get(), 5};
        LOTRBiomeFeatures.addFlowers(builder, freq, LOTRUtil.combineVarargs(plainsFlowers, extraFlowers));
    }

    public static void addForestFlowers(BiomeGenerationSettings.Builder builder, int freq, Object ... extraFlowers) {
        Object[] forestFlowers = new Object[]{Blocks.field_196606_bd, 10, Blocks.field_196605_bc, 20, Blocks.field_222383_bA, 2, LOTRBlocks.BLUEBELL.get(), 5, LOTRBlocks.MARIGOLD.get(), 10};
        LOTRBiomeFeatures.addFlowers(builder, freq, LOTRUtil.combineVarargs(forestFlowers, extraFlowers));
    }

    public static void addMountainsFlowers(BiomeGenerationSettings.Builder builder, int freq, Object ... extraFlowers) {
        Object[] mountainsFlowers = new Object[]{Blocks.field_196606_bd, 10, Blocks.field_196605_bc, 20, Blocks.field_196607_be, 10, LOTRBlocks.BLUEBELL.get(), 5};
        LOTRBiomeFeatures.addFlowers(builder, freq, LOTRUtil.combineVarargs(mountainsFlowers, extraFlowers));
    }

    public static void addBorealFlowers(BiomeGenerationSettings.Builder builder, int freq, Object ... extraFlowers) {
        Object[] borealFlowers = new Object[]{Blocks.field_196606_bd, 10, Blocks.field_196605_bc, 20, Blocks.field_196607_be, 10, LOTRBlocks.BLUEBELL.get(), 5};
        LOTRBiomeFeatures.addFlowers(builder, freq, LOTRUtil.combineVarargs(borealFlowers, extraFlowers));
    }

    public static void addSwampFlowers(BiomeGenerationSettings.Builder builder, int freq, Object ... extraFlowers) {
        LOTRBiomeFeatures.addDefaultFlowers(builder, freq, extraFlowers);
    }

    public static void addHaradFlowers(BiomeGenerationSettings.Builder builder, int freq, Object ... extraFlowers) {
        Object[] haradFlowers = new Object[]{LOTRBlocks.RED_SAND_GEM.get(), 5, LOTRBlocks.YELLOW_SAND_GEM.get(), 10, LOTRBlocks.HARAD_DAISY.get(), 5, LOTRBlocks.SOUTHBELL.get(), 5};
        LOTRBiomeFeatures.addFlowers(builder, freq, LOTRUtil.combineVarargs(haradFlowers, extraFlowers));
    }

    public static void addRhunPlainsFlowers(BiomeGenerationSettings.Builder builder, int freq, Object ... extraFlowers) {
        Object[] rhunFlowers = new Object[]{LOTRBlocks.MARIGOLD.get(), 10, LOTRBlocks.WHITE_CHRYSANTHEMUM.get(), 10, LOTRBlocks.YELLOW_CHRYSANTHEMUM.get(), 10, LOTRBlocks.PINK_CHRYSANTHEMUM.get(), 10, LOTRBlocks.RED_CHRYSANTHEMUM.get(), 10, LOTRBlocks.ORANGE_CHRYSANTHEMUM.get(), 10};
        LOTRBiomeFeatures.addPlainsFlowers(builder, freq, LOTRUtil.combineVarargs(rhunFlowers, extraFlowers));
    }

    public static void addRhunForestFlowers(BiomeGenerationSettings.Builder builder, int freq, Object ... extraFlowers) {
        Object[] rhunFlowers = new Object[]{LOTRBlocks.MARIGOLD.get(), 10, LOTRBlocks.WHITE_CHRYSANTHEMUM.get(), 10, LOTRBlocks.YELLOW_CHRYSANTHEMUM.get(), 10, LOTRBlocks.PINK_CHRYSANTHEMUM.get(), 10, LOTRBlocks.RED_CHRYSANTHEMUM.get(), 10, LOTRBlocks.ORANGE_CHRYSANTHEMUM.get(), 10};
        LOTRBiomeFeatures.addForestFlowers(builder, freq, LOTRUtil.combineVarargs(rhunFlowers, extraFlowers));
    }

    public static void addSimbelmyneChance(BiomeGenerationSettings.Builder builder, int chance) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)Feature.field_227247_y_.func_225566_b_((IFeatureConfig)SIMBELMYNE_CONFIG).func_227228_a_(LOTRBiomeFeatures.placeFlowers()).func_242729_a(chance));
    }

    public static void addDoubleFlowers(BiomeGenerationSettings.Builder builder, int freq, Object ... weightedFlowers) {
        try {
            ArrayList weightedDoubleFlowerFeatures = new ArrayList();
            for (int i = 0; i < weightedFlowers.length; i += 2) {
                Object obj1 = weightedFlowers[i];
                BlockState state = obj1 instanceof BlockState ? (BlockState)obj1 : ((Block)obj1).func_176223_P();
                int weight = (Integer)weightedFlowers[i + 1];
                BlockClusterFeatureConfig.Builder flowerConfigBuilder = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(state), (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(64).func_227317_b_();
                if (state.func_177230_c() instanceof IWaterLoggable) {
                    flowerConfigBuilder.func_227314_a_();
                }
                weightedDoubleFlowerFeatures.add(WeightedFeature.make(Feature.field_227248_z_.func_225566_b_((IFeatureConfig)flowerConfigBuilder.func_227322_d_()), weight));
            }
            ConfiguredFeature doubleFlowerFeature = LOTRFeatures.WEIGHTED_RANDOM.func_225566_b_(new WeightedRandomFeatureConfig(weightedDoubleFlowerFeatures));
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)doubleFlowerFeature.func_227228_a_(LOTRBiomeFeatures.placeFlowers()).func_242731_b(freq));
        }
        catch (ArrayIndexOutOfBoundsException | ClassCastException e) {
            throw new IllegalArgumentException("Error adding biome double flowers! A list of (blockstate1, weight1), (blockstate2, weight2)... is required", e);
        }
    }

    public static void addDefaultDoubleFlowers(BiomeGenerationSettings.Builder builder, int freq, Object ... extraFlowers) {
        Object[] defaultFlowers = new Object[]{Blocks.field_196801_ge, 10, Blocks.field_196802_gf, 10, Blocks.field_196803_gg, 10};
        LOTRBiomeFeatures.addDoubleFlowers(builder, freq, LOTRUtil.combineVarargs(defaultFlowers, extraFlowers));
    }

    public static void addHaradDoubleFlowers(BiomeGenerationSettings.Builder builder, int freq, Object ... extraFlowers) {
        Object[] haradFlowers = new Object[]{LOTRBlocks.HIBISCUS.get(), 10, LOTRBlocks.FLAME_OF_HARAD.get(), 2};
        LOTRBiomeFeatures.addDoubleFlowers(builder, freq, LOTRUtil.combineVarargs(haradFlowers, extraFlowers));
    }

    public static void addSunflowers(BiomeGenerationSettings.Builder builder, int chance) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)SUNFLOWER_CONFIG).func_227228_a_(LOTRBiomeFeatures.placeHeightmapChance(chance)));
    }

    public static void addAthelasChance(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addAthelasChance(builder, 30);
    }

    public static void addAthelasChance(BiomeGenerationSettings.Builder builder, int chance) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)ATHELAS_CONFIG).func_227228_a_(LOTRBiomeFeatures.placeHeightmapDoubleChance(chance)));
    }

    public static void addWildPipeweedChance(BiomeGenerationSettings.Builder builder, int chance) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)WILD_PIPEWEED_CONFIG).func_227228_a_(LOTRBiomeFeatures.placeHeightmapDoubleChance(chance)));
    }

    public static void addDeadBushes(BiomeGenerationSettings.Builder builder, int freq) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DEAD_BUSH_CONFIG).func_227228_a_(LOTRBiomeFeatures.placeHeightmapDoubleFreq(freq)));
    }

    public static void addDeadBushAtSurfaceChance(BiomeGenerationSettings.Builder builder, int chance) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DEAD_BUSH_CONFIG).func_227228_a_(LOTRBiomeFeatures.placeHeightmapChance(chance)));
    }

    public static void addCactiFreq(BiomeGenerationSettings.Builder builder, int freq) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)CACTUS_CONFIG).func_227228_a_(LOTRBiomeFeatures.placeHeightmapFreq(freq)));
    }

    public static void addCactiAtSurfaceChance(BiomeGenerationSettings.Builder builder, int chance) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)CACTUS_CONFIG).func_227228_a_(LOTRBiomeFeatures.placeHeightmapChance(chance)));
    }

    public static void addFallenLogs(BiomeGenerationSettings.Builder builder, int freq) {
        ConfiguredPlacement<?> logPlacement = LOTRBiomeFeatures.placeTopSolidFreq(freq);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, LOTRFeatures.FALLEN_LOG.func_225566_b_(new FallenLogFeatureConfig(false, false)).func_227228_a_(logPlacement));
    }

    public static void addFallenLogsBelowTreeline(BiomeGenerationSettings.Builder builder, int freq, int treeline) {
        ConfiguredPlacement logPlacement = LOTRFeatures.TREE_CLUSTERS.func_227446_a_(TreeClustersConfig.builder().count(freq).layerLimit(treeline, true).build());
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, LOTRFeatures.FALLEN_LOG.func_225566_b_(new FallenLogFeatureConfig(false, false)).func_227228_a_(logPlacement));
    }

    public static void addDriftwood(BiomeGenerationSettings.Builder builder, int chance) {
        ConfiguredPlacement<?> logPlacement = LOTRBiomeFeatures.placeTopSolidChance(chance);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, LOTRFeatures.FALLEN_LOG.func_225566_b_(new FallenLogFeatureConfig(true, true)).func_227228_a_(logPlacement));
    }

    public static void addSeagrass(BiomeGenerationSettings.Builder builder, int freq, float tallProb) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((ConfiguredFeature)Feature.field_203234_at.func_225566_b_((IFeatureConfig)new ProbabilityConfig(tallProb)).func_242731_b(freq)).func_227228_a_(LOTRBiomeFeatures.placeTopSolidFreq(1)));
    }

    public static void addSwampSeagrass(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addSeagrass(builder, 100, 0.4f);
    }

    public static void addExtraUnderwaterSeagrass(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_206922_aF.func_225566_b_((IFeatureConfig)new BlockWithContextConfig(Blocks.field_203198_aQ.func_176223_P(), (List)ImmutableList.of((Object)STONE), (List)ImmutableList.of((Object)WATER), (List)ImmutableList.of((Object)WATER))).func_227228_a_(Placement.field_215039_y.func_227446_a_((IPlacementConfig)new CaveEdgeConfig(GenerationStage.Carving.LIQUID, 0.1f))));
    }

    public static void addKelp(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((ConfiguredFeature)Feature.field_203235_au.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215036_v.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)).func_242728_a()).func_227228_a_(Placement.field_242901_e.func_227446_a_((IPlacementConfig)new TopSolidWithNoiseConfig(80, 80.0, 0.0))));
    }

    public static void addLatitudeBased(BiomeGenerationSettings.Builder builder, GenerationStage.Decoration genStage, ConfiguredFeature<?, ?> feature, ConfiguredPlacement<?> placement, LatitudeBasedFeatureConfig.LatitudeConfiguration latConfig) {
        LatitudeBasedFeatureConfig latFeatureConfig = new LatitudeBasedFeatureConfig(feature, latConfig);
        builder.func_242513_a(genStage, LOTRFeatures.LATITUDE_BASED.func_225566_b_(latFeatureConfig).func_227228_a_(placement));
    }

    public static void addCoral(BiomeGenerationSettings.Builder builder) {
        ConfiguredFeature coralTree = Feature.field_204621_ay.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e);
        ConfiguredFeature coralClaw = Feature.field_204619_aA.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e);
        ConfiguredFeature coralShroom = Feature.field_204622_az.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e);
        ConfiguredFeature coralRandomiser = Feature.field_204620_ao.func_225566_b_((IFeatureConfig)new SingleRandomFeature((List)ImmutableList.of(() -> coralTree, () -> coralClaw, () -> coralShroom)));
        int noiseToCount = 10;
        double noiseFactor = 400.0;
        ConfiguredPlacement placement = ((ConfiguredPlacement)Placement.field_215036_v.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e).func_242728_a()).func_227228_a_(Placement.field_242901_e.func_227446_a_((IPlacementConfig)new TopSolidWithNoiseConfig(noiseToCount, noiseFactor, 0.0)));
        LOTRBiomeFeatures.addLatitudeBased(builder, GenerationStage.Decoration.VEGETAL_DECORATION, coralRandomiser, placement, LatitudeBasedFeatureConfig.LatitudeConfiguration.of(LatitudeBasedFeatureConfig.LatitudeValuesType.CORAL));
    }

    public static void addSeaPickles(BiomeGenerationSettings.Builder builder) {
        ConfiguredFeature seaPickle = Feature.field_204914_aC.func_225566_b_((IFeatureConfig)new FeatureSpreadConfig(20));
        ConfiguredPlacement<?> placement = LOTRBiomeFeatures.placeTopSolidChance(16);
        LOTRBiomeFeatures.addLatitudeBased(builder, GenerationStage.Decoration.VEGETAL_DECORATION, seaPickle, placement, LatitudeBasedFeatureConfig.LatitudeConfiguration.of(LatitudeBasedFeatureConfig.LatitudeValuesType.CORAL));
    }

    public static void addSponges(BiomeGenerationSettings.Builder builder) {
        ConfiguredFeature sponge = LOTRFeatures.UNDERWATER_SPONGE.func_225566_b_((IFeatureConfig)SPONGE_CONFIG);
        ConfiguredPlacement<?> placement = LOTRBiomeFeatures.placeTopSolidChance(20);
        LOTRBiomeFeatures.addLatitudeBased(builder, GenerationStage.Decoration.VEGETAL_DECORATION, sponge, placement, LatitudeBasedFeatureConfig.LatitudeConfiguration.of(LatitudeBasedFeatureConfig.LatitudeValuesType.CORAL));
    }

    public static void addFreezeTopLayer(BiomeGenerationSettings.Builder builder) {
        Feature<NoFeatureConfig> freezeTopLayer = SnowRealMagicCompatibility.getFreezeTopLayerFeature();
        builder.func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, freezeTopLayer.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
    }

    public static void addIcebergs(BiomeGenerationSettings.Builder builder) {
        ConfiguredFeature iceberg = Feature.field_205172_ag.func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(PACKED_ICE));
        ConfiguredFeature blueIceberg = Feature.field_205172_ag.func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(BLUE_ICE));
        int icebergChance = 16;
        int blueIcebergChance = 200;
        ConfiguredPlacement icebergPlacement = (ConfiguredPlacement)Placement.field_215009_H.func_227446_a_((IPlacementConfig)NoPlacementConfig.field_236556_b_).func_242729_a(icebergChance);
        ConfiguredPlacement blueIcebergPlacement = (ConfiguredPlacement)Placement.field_215009_H.func_227446_a_((IPlacementConfig)NoPlacementConfig.field_236556_b_).func_242729_a(blueIcebergChance);
        LOTRBiomeFeatures.addLatitudeBased(builder, GenerationStage.Decoration.LOCAL_MODIFICATIONS, iceberg, icebergPlacement, LatitudeBasedFeatureConfig.LatitudeConfiguration.of(LatitudeBasedFeatureConfig.LatitudeValuesType.ICE));
        LOTRBiomeFeatures.addLatitudeBased(builder, GenerationStage.Decoration.LOCAL_MODIFICATIONS, blueIceberg, blueIcebergPlacement, LatitudeBasedFeatureConfig.LatitudeConfiguration.of(LatitudeBasedFeatureConfig.LatitudeValuesType.ICE));
    }

    public static void addBlueIcePatches(BiomeGenerationSettings.Builder builder) {
        ConfiguredFeature blueIce = Feature.field_205171_af.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e);
        int blueIceFreq = 19;
        ConfiguredPlacement blueIcePlacement = (ConfiguredPlacement)((ConfiguredPlacement)Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(30, 32, 64)).func_242728_a()).func_242732_c(blueIceFreq);
        LOTRBiomeFeatures.addLatitudeBased(builder, GenerationStage.Decoration.SURFACE_STRUCTURES, blueIce, blueIcePlacement, LatitudeBasedFeatureConfig.LatitudeConfiguration.of(LatitudeBasedFeatureConfig.LatitudeValuesType.ICE));
    }

    public static void addMushrooms(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)BROWN_MUSHROOM_CONFIG).func_227228_a_(LOTRBiomeFeatures.placeHeightmapDoubleChance(4)));
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)RED_MUSHROOM_CONFIG).func_227228_a_(LOTRBiomeFeatures.placeHeightmapDoubleChance(8)));
    }

    public static void addMoreMushroomsFreq(BiomeGenerationSettings.Builder builder, int freq) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)BROWN_MUSHROOM_CONFIG).func_227228_a_(LOTRBiomeFeatures.placeHeightmapDoubleFreq(freq * 2)));
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)RED_MUSHROOM_CONFIG).func_227228_a_(LOTRBiomeFeatures.placeHeightmapDoubleFreq(freq)));
    }

    public static void addMirkShroomsFreq(BiomeGenerationSettings.Builder builder, int freq) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)MIRK_SHROOM_CONFIG).func_227228_a_(LOTRBiomeFeatures.placeHeightmapDoubleFreq(freq)));
    }

    public static void addReeds(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addReedsWithDriedChance(builder, 0.1f);
    }

    public static void addReedsWithDriedChance(BiomeGenerationSettings.Builder builder, float driedChance) {
        LOTRBiomeFeatures.addReedsWithFreqAndDriedChance(builder, 10, driedChance);
    }

    public static void addLessCommonReeds(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addReedsWithFreqAndDriedChance(builder, 4, 0.1f);
    }

    public static void addReedsWithFreqAndDriedChance(BiomeGenerationSettings.Builder builder, int freq, float driedChance) {
        ReedsFeatureConfig config = REEDS_CONFIG_FOR_DRIED_CHANCE.apply(Float.valueOf(driedChance));
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, LOTRFeatures.REEDS.func_225566_b_(config).func_227228_a_(LOTRBiomeFeatures.placeHeightmapDoubleFreq(freq)));
    }

    public static void addMoreSwampReeds(BiomeGenerationSettings.Builder builder) {
        int freq = 1;
        ReedsFeatureConfig noDriedConfig = REEDS_CONFIG_FOR_DRIED_CHANCE.apply(Float.valueOf(0.0f));
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, LOTRFeatures.REEDS.func_225566_b_(noDriedConfig).func_227228_a_(LOTRBiomeFeatures.placeHeightmapFreq(freq)));
    }

    public static void addPapyrus(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addPapyrus(builder, 10);
    }

    public static void addMoreCommonPapyrus(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addPapyrus(builder, 20);
    }

    public static void addPapyrus(BiomeGenerationSettings.Builder builder, int freq) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, LOTRFeatures.REEDS.func_225566_b_(PAPYRUS_CONFIG).func_227228_a_(LOTRBiomeFeatures.placeHeightmapDoubleFreq(freq)));
    }

    public static void addSwampRushes(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addRushes(builder, 2);
    }

    public static void addRiverRushes(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addRushes(builder, 7);
    }

    public static void addRushes(BiomeGenerationSettings.Builder builder, int freq) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)RUSHES_CONFIG).func_227228_a_(LOTRBiomeFeatures.placeHeightmapFreq(freq)));
    }

    public static void addSugarCane(BiomeGenerationSettings.Builder builder) {
        int freq = 10;
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)SUGAR_CANE_CONFIG).func_227228_a_(LOTRBiomeFeatures.placeHeightmapDoubleFreq(freq)));
    }

    public static void addPumpkins(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)PUMPKIN_PATCH_CONFIG).func_227228_a_(LOTRBiomeFeatures.placeHeightmapDoubleChance(32)));
    }

    public static void addWaterLilies(BiomeGenerationSettings.Builder builder, int freq) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)LILY_PAD_CONFIG).func_227228_a_(LOTRBiomeFeatures.placeHeightmapDoubleFreq(freq)));
    }

    public static void addWaterLiliesWithFlowers(BiomeGenerationSettings.Builder builder, int freq) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)LILY_PAD_WITH_FLOWERS_CONFIG).func_227228_a_(LOTRBiomeFeatures.placeHeightmapDoubleFreq(freq)));
    }

    public static void addWaterLiliesWithRareFlowers(BiomeGenerationSettings.Builder builder, int freq) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)LILY_PAD_WITH_RARE_FLOWERS_CONFIG).func_227228_a_(LOTRBiomeFeatures.placeHeightmapDoubleFreq(freq)));
    }

    public static void addFoxBerryBushes(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addFoxBerryBushesChance(builder, 4);
    }

    public static void addSparseFoxBerryBushes(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addFoxBerryBushesChance(builder, 12);
    }

    public static void addFoxBerryBushesChance(BiomeGenerationSettings.Builder builder, int chance) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)SWEET_BERRY_BUSH_CONFIG).func_227228_a_(LOTRBiomeFeatures.placeHeightmapDoubleChance(chance)));
    }

    public static void addTundraBushes(BiomeGenerationSettings.Builder builder, int chance, BlockStateProvider blockProvider) {
        int tries = 16;
        LOTRBiomeFeatures.addTundraBushes(builder, chance, tries, blockProvider);
    }

    public static void addTundraBushes(BiomeGenerationSettings.Builder builder, int chance, int tries, BlockStateProvider blockProvider) {
        BlockClusterFeatureConfig config = new BlockClusterFeatureConfig.Builder(blockProvider, (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(tries).func_227316_a_((Set)ImmutableSet.of((Object)Blocks.field_196658_i, (Object)Blocks.field_196660_k, (Object)Blocks.field_150348_b, (Object)Blocks.field_196604_cC)).func_227317_b_().func_227322_d_();
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)config).func_227228_a_(LOTRBiomeFeatures.placeHeightmapChance(chance)));
    }

    public static void addTreeTorches(BiomeGenerationSettings.Builder builder, int freq, int yMin, int yMax, BlockState ... torches) {
        WeightedBlockStateProvider stateProvider = new WeightedBlockStateProvider();
        Arrays.asList(torches).stream().forEach(state -> {
            boolean weight = true;
            stateProvider.func_227407_a_(state, 1);
        });
        ConfiguredPlacement placement = (ConfiguredPlacement)((ConfiguredPlacement)Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(yMin, yMin, yMax)).func_242728_a()).func_242731_b(freq);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, LOTRFeatures.TREE_TORCHES.func_225566_b_((IFeatureConfig)new BlockStateProvidingFeatureConfig((BlockStateProvider)stateProvider)).func_227228_a_(placement));
    }

    public static void addMordorBasalt(BiomeGenerationSettings.Builder builder, int flatChance, int spikyChance) {
        ImmutableList surfaceBlocks = ImmutableList.of((Object)MORDOR_ROCK, (Object)MORDOR_DIRT, (Object)MORDOR_GRAVEL, (Object)STONE, (Object)DIRT, (Object)GRAVEL, (Object)Blocks.field_235337_cO_.func_176223_P());
        MordorBasaltFeatureConfig spikyConfig = new MordorBasaltFeatureConfig((List<BlockState>)surfaceBlocks, FeatureSpread.func_242253_a((int)3, (int)9), FeatureSpread.func_242253_a((int)1, (int)2), 0.6f, 0.95f, 0.15f, 0.35f, 0.2f);
        MordorBasaltFeatureConfig flatConfig = new MordorBasaltFeatureConfig((List<BlockState>)surfaceBlocks, FeatureSpread.func_242253_a((int)3, (int)9), FeatureSpread.func_242253_a((int)1, (int)2), 0.3f, 0.95f, 0.0f, 0.1f, 0.0f);
        builder.func_242513_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, LOTRFeatures.MORDOR_BASALT.func_225566_b_(spikyConfig).func_227228_a_(LOTRBiomeFeatures.placeHeightmapChance(spikyChance)));
        builder.func_242513_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, LOTRFeatures.MORDOR_BASALT.func_225566_b_(flatConfig).func_227228_a_(LOTRBiomeFeatures.placeHeightmapChance(flatChance)));
    }

    public static void addMordorMoss(BiomeGenerationSettings.Builder builder, int chance) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, LOTRFeatures.MORDOR_MOSS.func_225566_b_(MORDOR_MOSS_CONFIG).func_227228_a_(LOTRBiomeFeatures.placeHeightmapChance(chance)));
    }

    public static void addMordorGrass(BiomeGenerationSettings.Builder builder, int freq) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)MORDOR_GRASS_CONFIG).func_227228_a_(LOTRBiomeFeatures.placeHeightmapDoubleFreq(freq)));
    }

    public static void addMordorThorns(BiomeGenerationSettings.Builder builder, int chance) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)MORDOR_THORN_CONFIG).func_227228_a_(LOTRBiomeFeatures.placeHeightmapDoubleChance(chance)));
    }

    public static void addMorgulShrooms(BiomeGenerationSettings.Builder builder, int chance) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)MORGUL_SHROOM_CONFIG).func_227228_a_(LOTRBiomeFeatures.placeHeightmapDoubleChance(chance)));
    }

    public static void addExtraMorgulFlowersByWater(BiomeGenerationSettings.Builder builder, int freq) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)MORGUL_FLOWER_CONFIG).func_227228_a_(LOTRFeatures.BY_WATER.func_227446_a_(new ByWaterConfig(8, 20)).func_227228_a_(LOTRBiomeFeatures.placeHeightmapFreq(freq))));
    }

    public static void addWaterSprings(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addWaterSprings(builder, 50);
    }

    public static void addWaterSprings(BiomeGenerationSettings.Builder builder, int freq) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)((ConfiguredFeature)Feature.field_202295_ao.func_225566_b_((IFeatureConfig)WATER_SPRING_CONFIG).func_227228_a_(Placement.field_242908_m.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(8, 8, 256))).func_242728_a()).func_242731_b(freq));
    }

    public static void addLavaSprings(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addLavaSprings(builder, 20);
    }

    public static void addLavaSprings(BiomeGenerationSettings.Builder builder, int freq) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)((ConfiguredFeature)Feature.field_202295_ao.func_225566_b_((IFeatureConfig)LAVA_SPRING_CONFIG).func_227228_a_(Placement.field_242909_n.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(8, 16, 256))).func_242728_a()).func_242731_b(freq));
    }

    public static void addWaterLavaSprings(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addWaterSprings(builder);
        LOTRBiomeFeatures.addLavaSprings(builder);
    }

    public static void addWaterLavaSpringsReducedAboveground(BiomeGenerationSettings.Builder builder, int reducedAboveY, float aboveReductionFactor) {
        int defaultWater = 50;
        int defaultLava = 20;
        int height = 256;
        float belowFactor = (float)reducedAboveY / (float)height;
        float aboveFactor = (float)(height - reducedAboveY) / (float)height;
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)((ConfiguredFeature)Feature.field_202295_ao.func_225566_b_((IFeatureConfig)WATER_SPRING_CONFIG).func_227228_a_(Placement.field_242908_m.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(8, 8, reducedAboveY))).func_242728_a()).func_242731_b((int)((float)defaultWater * belowFactor)));
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)((ConfiguredFeature)Feature.field_202295_ao.func_225566_b_((IFeatureConfig)LAVA_SPRING_CONFIG).func_227228_a_(Placement.field_242909_n.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(8, 16, reducedAboveY))).func_242728_a()).func_242731_b((int)((float)defaultLava * belowFactor)));
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)((ConfiguredFeature)Feature.field_202295_ao.func_225566_b_((IFeatureConfig)WATER_SPRING_CONFIG).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(reducedAboveY, reducedAboveY, height))).func_242728_a()).func_242731_b((int)((float)defaultWater * (aboveFactor *= aboveReductionFactor))));
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)((ConfiguredFeature)Feature.field_202295_ao.func_225566_b_((IFeatureConfig)LAVA_SPRING_CONFIG).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(reducedAboveY, reducedAboveY, height))).func_242728_a()).func_242731_b((int)((float)defaultLava * aboveFactor)));
    }

    public static void addBoulders(BiomeGenerationSettings.Builder builder, BlockState block, int minWidth, int maxWidth, int chanceInChunk, int genAmount) {
        int heightCheck = 3;
        LOTRBiomeFeatures.addBoulders(builder, block, minWidth, maxWidth, chanceInChunk, genAmount, heightCheck);
    }

    public static void addBoulders(BiomeGenerationSettings.Builder builder, BlockState block, int minWidth, int maxWidth, int chanceInChunk, int genAmount, int heightCheck) {
        SimpleBlockStateProvider blockProv = new SimpleBlockStateProvider(block);
        BoulderFeatureConfig config = new BoulderFeatureConfig((BlockStateProvider)blockProv, minWidth, maxWidth, heightCheck);
        int baseCount = 0;
        float increaseChance = 1.0f / (float)chanceInChunk;
        int increaseAmount = genAmount;
        ConfiguredPlacement placement = ((ConfiguredPlacement)Placement.field_242904_h.func_227446_a_((IPlacementConfig)NoPlacementConfig.field_236556_b_).func_242728_a()).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(baseCount, increaseChance, increaseAmount)));
        builder.func_242513_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, LOTRFeatures.BOULDER.func_225566_b_(config).func_227228_a_(placement));
    }

    public static void addTerrainSharpener(BiomeGenerationSettings.Builder builder, List<BlockState> targets, int minHeight, int maxHeight, int freq) {
        TerrainSharpenFeatureConfig config = new TerrainSharpenFeatureConfig(targets, minHeight, maxHeight);
        ConfiguredPlacement<?> placement = LOTRBiomeFeatures.placeHeightmapFreq(freq);
        builder.func_242513_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, LOTRFeatures.TERRAIN_SHARPEN.func_225566_b_(config).func_227228_a_(placement));
    }

    public static void addGrassPatches(BiomeGenerationSettings.Builder builder, List<BlockState> targets, int rMin, int rMax, int depthMin, int depthMax, int freq) {
        GrassPatchFeatureConfig config = new GrassPatchFeatureConfig(targets, rMin, rMax, depthMin, depthMax);
        ConfiguredPlacement<?> placement = LOTRBiomeFeatures.placeHeightmapFreq(freq);
        builder.func_242513_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, LOTRFeatures.GRASS_PATCH.func_225566_b_(config).func_227228_a_(placement));
    }

    public static void addCraftingMonument(BiomeGenerationSettings.Builder builder, BlockState table, BlockStateProvider baseProvider, BlockStateProvider postProvider, BlockStateProvider torchProvider) {
        LOTRBiomeFeatures.addCraftingMonument(builder, 1, table, baseProvider, postProvider, torchProvider);
    }

    public static void addCraftingMonument(BiomeGenerationSettings.Builder builder, int relativeChance, BlockState table, BlockStateProvider baseProvider, BlockStateProvider postProvider, BlockStateProvider torchProvider) {
        CraftingMonumentFeatureConfig config = new CraftingMonumentFeatureConfig(table, baseProvider, postProvider, torchProvider);
        int chance = 512 * relativeChance;
        ConfiguredPlacement<?> placement = LOTRBiomeFeatures.placeHeightmapChance(chance);
        builder.func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, LOTRFeatures.CRAFTING_MONUMENT.func_225566_b_(config).func_227228_a_(placement));
    }

    private static ConfiguredPlacement<?> placeTopSolidFreq(int freq) {
        return (ConfiguredPlacement)((ConfiguredPlacement)Placement.field_215036_v.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e).func_242728_a()).func_242731_b(freq);
    }

    private static ConfiguredPlacement<?> placeTopSolidChance(int chance) {
        return (ConfiguredPlacement)((ConfiguredPlacement)Placement.field_215036_v.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e).func_242728_a()).func_242729_a(chance);
    }

    private static ConfiguredPlacement<?> placeHeightmapFreq(int freq) {
        return (ConfiguredPlacement)((ConfiguredPlacement)Placement.field_242904_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e).func_242728_a()).func_242731_b(freq);
    }

    private static ConfiguredPlacement<?> placeHeightmapChance(int chance) {
        return (ConfiguredPlacement)((ConfiguredPlacement)Placement.field_242904_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e).func_242728_a()).func_242729_a(chance);
    }

    private static ConfiguredPlacement<?> placeFlowers() {
        return (ConfiguredPlacement)Placement.field_242911_p.func_227446_a_((IPlacementConfig)NoPlacementConfig.field_236556_b_).func_227228_a_(Placement.field_242904_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)).func_242728_a();
    }

    private static ConfiguredPlacement<?> placeHeightmapDoubleFreq(int freq) {
        return (ConfiguredPlacement)((ConfiguredPlacement)Placement.field_242905_i.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e).func_242728_a()).func_242731_b(freq);
    }

    private static ConfiguredPlacement<?> placeHeightmapDoubleChance(int chance) {
        return (ConfiguredPlacement)((ConfiguredPlacement)Placement.field_242905_i.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e).func_242728_a()).func_242729_a(chance);
    }

    public static class GrassTypesHolder {
        public boolean ferns;
        public boolean fernsprouts;
        public boolean clovers;
        public boolean extra4LeafClovers;
        public boolean prettyTypes;
        public boolean extraWheatgrass;
        public boolean moor;
        public boolean arid;
        public boolean thistles;
        public boolean nettles;

        public GrassTypesHolder ferns(boolean flag) {
            this.ferns = flag;
            return this;
        }

        public GrassTypesHolder fernsprouts(boolean flag) {
            this.fernsprouts = flag;
            return this;
        }

        public GrassTypesHolder clovers(boolean flag) {
            this.clovers = flag;
            return this;
        }

        public GrassTypesHolder extra4LeafClovers(boolean flag) {
            this.extra4LeafClovers = flag;
            return this;
        }

        public GrassTypesHolder prettyTypes(boolean flag) {
            this.prettyTypes = flag;
            return this;
        }

        public GrassTypesHolder extraWheatgrass(boolean flag) {
            this.extraWheatgrass = flag;
            return this;
        }

        public GrassTypesHolder moor(boolean flag) {
            this.moor = flag;
            return this;
        }

        public GrassTypesHolder arid(boolean flag) {
            this.arid = flag;
            return this;
        }

        public GrassTypesHolder thistles(boolean flag) {
            this.thistles = flag;
            return this;
        }

        public GrassTypesHolder nettles(boolean flag) {
            this.nettles = flag;
            return this;
        }
    }
}

